/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.output;

import com.argo21.msg.division.output.FixTagUnionKeyBodyFooter;
import com.argo21.msg.division.output.FixTagUnionRecord;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.PropertiesConfiguration;

public class FixTagUnionProperties {
    private PropertiesConfiguration propConf = null;
    private int[] keyIndex = null;
    private int[] keyLength = null;
    private Map<String, FixTagUnionKeyBodyFooter> keyMap;
    private int minLength;

    public FixTagUnionProperties(PropertiesConfiguration propConf, String[] divKeys) {
        this.propConf = propConf;
        this.keyIndex = this.getIntArray(propConf, "output.fixtag.key.index");
        this.keyLength = this.getIntArray(propConf, "output.fixtag.key.length");
        this.keyMap = new HashMap<String, FixTagUnionKeyBodyFooter>();
        for (String divKey : divKeys) {
            this.keyMap.put(divKey, new FixTagUnionKeyBodyFooter(propConf.getStringArray("output.fixtag.key.bodystart." + divKey), propConf.getStringArray("output.fixtag.key.footerstart." + divKey)));
        }
        this.minLength = 0;
        for (int i = 0; i < this.keyIndex.length; ++i) {
            int tmpLength = this.keyIndex[i] + this.keyLength[i] - 1;
            if (this.minLength >= tmpLength) continue;
            this.minLength = tmpLength;
        }
    }

    private int[] getIntArray(PropertiesConfiguration propConf, String key) {
        String[] values = propConf.getStringArray(key);
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Integer.parseInt(values[i]);
        }
        return result;
    }

    public int[] getKeyIndex() {
        return this.keyIndex;
    }

    public int[] getKeyLength() {
        return this.keyLength;
    }

    public FixTagUnionKeyBodyFooter getKeyBodyFooter(String divKey) {
        return this.keyMap.get(divKey);
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getRecordLength(String[] keys) {
        StringBuffer sb = new StringBuffer();
        for (String key : keys) {
            sb.append(".");
            sb.append(key);
        }
        return this.propConf.getInt("output.fixtag.record.length" + sb.toString());
    }

    public boolean isBodyStart(String[] divKeys, FixTagUnionRecord target) {
        for (String key : divKeys) {
            Object[] targetKeys = target.getKey();
            if (!Arrays.equals(targetKeys, this.propConf.getStringArray("output.fixtag.key.bodystart." + key))) continue;
            return true;
        }
        return false;
    }

    public boolean isFooterStart(String[] divKeys, FixTagUnionRecord target) {
        for (String key : divKeys) {
            Object[] targetKeys = target.getKey();
            if (!Arrays.equals(targetKeys, this.propConf.getStringArray("output.fixtag.key.footerstart." + key))) continue;
            return true;
        }
        return false;
    }
}

