/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.output;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.output.FixTagUnionProperties;
import com.argo21.msg.division.output.FixTagUnionRecord;
import java.io.BufferedInputStream;
import java.io.IOException;

public class FixTagUnionReader {
    private BufferedInputStream bis;
    private FixTagUnionProperties uniProp;
    private String encoding;

    public FixTagUnionReader(BufferedInputStream bis, FixTagUnionProperties uniProp, String encoding) {
        this.bis = bis;
        this.uniProp = uniProp;
        this.encoding = encoding;
    }

    public int getNextRecord(FixTagUnionRecord result) throws BizTranException {
        try {
            int remainLength;
            byte[] remainRecord;
            int remainRecordLength;
            byte[] keyRecord = new byte[this.uniProp.getMinLength()];
            int keyRecordLength = this.bis.read(keyRecord);
            if (keyRecordLength == -1) {
                return -1;
            }
            int[] keyIndex = this.uniProp.getKeyIndex();
            int[] keyLength = this.uniProp.getKeyLength();
            String[] thisKey = new String[keyIndex.length];
            for (int j = 0; j < keyIndex.length; ++j) {
                byte[] key = new byte[keyLength[j]];
                System.arraycopy(keyRecord, keyIndex[j] - 1, key, 0, keyLength[j]);
                thisKey[j] = new String(key, this.encoding);
            }
            int recordLength = this.uniProp.getRecordLength(thisKey);
            if (recordLength != keyRecordLength + (remainRecordLength = this.bis.read(remainRecord = new byte[remainLength = recordLength - this.uniProp.getMinLength()]))) {
                String message = "\u30ec\u30b3\u30fc\u30c9\u9577\u304c\u4e0d\u6b63\u3067\u3059\u3000\u5206\u5272\u30ad\u30fc\uff1a";
                for (String key : thisKey) {
                    message = message + key + " ";
                }
                throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, message);
            }
            byte[] allRecord = new byte[recordLength];
            System.arraycopy(keyRecord, 0, allRecord, 0, keyRecord.length);
            System.arraycopy(remainRecord, 0, allRecord, keyRecord.length, remainRecord.length);
            result.setKey(thisKey);
            result.setRecord(allRecord);
            return recordLength;
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_DIVIDE_FAIL, (Throwable)e);
        }
    }
}

