/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.output;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.output.FixTagUnionProperties;
import com.argo21.msg.division.output.FixTagUnionReader;
import com.argo21.msg.division.output.FixTagUnionRecord;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import org.apache.commons.lang.time.StopWatch;

public class FixTagUnioner {
    private FixTagUnionProperties fixTagUniProp;
    private String[] divKeys = null;
    private String encoding;
    public static final long TIMEOUT_VALUE_WRITE = 300000L;

    public FixTagUnioner(FixTagUnionProperties fixTagUniProp, String[] divKeys, String encoding) {
        this.fixTagUniProp = fixTagUniProp;
        this.divKeys = divKeys;
        this.encoding = encoding == null ? System.getProperty("file.encoding") : encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void union(String outputFileName, File inputFolder, boolean postscriptFlag) throws BizTranException {
        Object[] divInputFiles = inputFolder.listFiles();
        Arrays.sort(divInputFiles);
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        AbstractInterruptibleChannel fc = null;
        FileLock lock = null;
        try {
            fos = new FileOutputStream(outputFileName, postscriptFlag);
            bos = new BufferedOutputStream(fos);
            fc = fos.getChannel();
            lock = ((FileChannel)fc).tryLock();
            StopWatch sw = new StopWatch();
            sw.start();
            while (lock == null) {
                if (sw.getTime() >= 300000L) {
                    if (fc != null) {
                        fc.close();
                        fc = null;
                    }
                    throw new IOException();
                }
                Thread.sleep(500L);
                lock = ((FileChannel)fc).tryLock();
            }
            for (int i = 0; i < divInputFiles.length; ++i) {
                boolean isHeader = true;
                boolean isBody = false;
                boolean isFooter = false;
                Object inputFile = divInputFiles[i];
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                try {
                    fis = new FileInputStream((File)inputFile);
                    bis = new BufferedInputStream(fis);
                    FixTagUnionReader reader = new FixTagUnionReader(bis, this.fixTagUniProp, this.encoding);
                    FixTagUnionRecord record = new FixTagUnionRecord();
                    while (reader.getNextRecord(record) != -1) {
                        if (this.fixTagUniProp.isBodyStart(this.divKeys, record)) {
                            isHeader = false;
                            isBody = true;
                        } else if (this.fixTagUniProp.isFooterStart(this.divKeys, record)) {
                            isBody = false;
                            isFooter = true;
                        }
                        if (isFooter && i == divInputFiles.length - 1) {
                            bos.write(record.getRecord());
                            continue;
                        }
                        if (isHeader && i == 0) {
                            bos.write(record.getRecord());
                            continue;
                        }
                        if (!isBody) continue;
                        bos.write(record.getRecord());
                    }
                    continue;
                }
                finally {
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_UNION_FAIL, e.getMessage());
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
                if (fos != null) {
                    fos.close();
                }
                if (lock != null) {
                    lock.release();
                }
                if (fc != null) {
                    fc.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

