/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.output;

import com.argo21.msg.division.XPathCreateor;
import com.argo21.msg.division.output.XmlUnionFileWriter;
import com.argo21.msg.division.output.XmlUnionProperties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUnionSAXHandler
extends DefaultHandler {
    private final int STATE_BEFORE_BODY = 1;
    private final int STATE_IN_BODY = 2;
    private final int STATE_AFTER_BODY = 3;
    private boolean isFirst = false;
    private boolean isLast = false;
    private XmlUnionProperties propConf = null;
    private String[] divKeys;
    private String encoding = null;
    private boolean indentFlag;
    private boolean charactersExistFlag;
    private boolean headerOutputFlag;
    private boolean bodyExistFlag;
    private StringBuffer headerBuffer;
    private StringBuffer bodyBuffer;
    private StringBuffer footerBuffer;
    private int state;
    private XPathCreateor xPath;
    private XmlUnionFileWriter fw;

    public XmlUnionSAXHandler(String outputFileName, XmlUnionProperties propConf, String[] divKeys, boolean isFirst, boolean isLast, boolean indentFlag, String encoding) {
        this.isFirst = isFirst;
        this.isLast = isLast;
        this.propConf = propConf;
        this.divKeys = divKeys;
        this.indentFlag = indentFlag;
        this.encoding = encoding;
        this.xPath = new XPathCreateor();
        this.charactersExistFlag = false;
        this.headerOutputFlag = false;
        this.bodyExistFlag = false;
        this.fw = new XmlUnionFileWriter(outputFileName, encoding);
    }

    @Override
    public void startDocument() throws SAXException {
        String enc = this.encoding != null ? this.encoding : System.getProperty("file.encoding");
        this.headerBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"" + enc + "\"?>");
        this.bodyBuffer = new StringBuffer();
        this.footerBuffer = new StringBuffer();
        this.state = 1;
        if (!this.indentFlag) {
            this.headerBuffer.append("\r\n");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String divKey = this.propConf.getTargetUnionKey(this.divKeys, qName, this.xPath.toString());
        if (divKey != null) {
            this.state = 2;
            this.bodyExistFlag = true;
            if (this.isFirst && !this.headerOutputFlag) {
                this.fw.write(this.headerBuffer.toString(), false);
                this.headerOutputFlag = true;
                this.headerBuffer = new StringBuffer();
            }
        }
        switch (this.state) {
            case 1: {
                this.writeStartTag(this.headerBuffer, qName, attributes);
                break;
            }
            case 2: {
                this.writeStartTag(this.bodyBuffer, qName, attributes);
                break;
            }
            case 3: {
                this.writeStartTag(this.footerBuffer, qName, attributes);
            }
        }
        this.xPath.addLeaf(qName);
        this.charactersExistFlag = false;
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        String value = new String(ch, offset, length);
        if ("&".equals(value)) {
            value = "&amp;";
        } else if ("<".equals(value)) {
            value = "&lt;";
        } else if (">".equals(value)) {
            value = "&gt;";
        } else if ("\"".equals(value)) {
            value = "&quot;";
        } else if ("'".equals(value)) {
            value = "&apos;";
        }
        switch (this.state) {
            case 1: {
                this.headerBuffer.append(value);
                break;
            }
            case 2: {
                this.bodyBuffer.append(value);
                break;
            }
            case 3: {
                this.footerBuffer.append(value);
            }
        }
        this.charactersExistFlag = true;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.xPath.removeLeaf();
        switch (this.state) {
            case 1: {
                this.writeEndTag(this.headerBuffer, qName);
                break;
            }
            case 2: {
                this.writeEndTag(this.bodyBuffer, qName);
                if (this.bodyBuffer.length() < 0x500000) break;
                this.fw.write(this.bodyBuffer.toString(), true);
                this.bodyBuffer = new StringBuffer();
                break;
            }
            case 3: {
                this.writeEndTag(this.footerBuffer, qName);
            }
        }
        String divKey = this.propConf.getTargetUnionKey(this.divKeys, qName, this.xPath.toString());
        if (divKey != null) {
            this.state = 3;
            if (this.bodyBuffer.length() > 0) {
                this.fw.write(this.bodyBuffer.toString(), true);
            }
            this.bodyBuffer = new StringBuffer();
        }
        this.charactersExistFlag = false;
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.bodyExistFlag && this.isFirst && !this.headerOutputFlag) {
            this.fw.write(this.headerBuffer.toString(), false);
            this.headerOutputFlag = true;
        }
        if (this.isLast) {
            this.fw.write(this.footerBuffer.toString(), true);
            if (this.indentFlag) {
                this.fw.write(System.getProperty("line.separator"), true);
            }
        }
        this.footerBuffer = new StringBuffer();
    }

    private void writeStartTag(StringBuffer buf, String tagName, Attributes attributes) {
        if (this.indentFlag) {
            this.writeIndent(buf);
        }
        buf.append("<");
        buf.append(tagName);
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                buf.append(" ");
                buf.append(attributes.getQName(i));
                buf.append("=\"");
                buf.append(attributes.getValue(i));
                buf.append("\"");
            }
        }
        buf.append(">");
    }

    private void writeEndTag(StringBuffer buf, String tagName) {
        if (this.indentFlag && !this.charactersExistFlag) {
            this.writeIndent(buf);
        }
        buf.append("</");
        buf.append(tagName);
        buf.append(">");
    }

    private void writeIndent(StringBuffer buf) {
        buf.append(System.getProperty("line.separator"));
        int length = this.xPath.getLength();
        for (int i = 0; i < length; ++i) {
            buf.append("    ");
        }
    }
}

