/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.division.output;

import com.argo21.common.log.AppMessage;
import com.argo21.common.log.BizTranException;
import com.argo21.msg.division.output.XmlUnionProperties;
import com.argo21.msg.division.output.XmlUnionSAXHandler;
import java.io.File;
import java.util.Arrays;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUnioner {
    private XmlUnionProperties xmlUniProp;
    private String[] divKeys = null;
    private String encoding = null;

    public XmlUnioner(XmlUnionProperties xmlUniProp, String[] divKeys, String encoding) {
        this.xmlUniProp = xmlUniProp;
        this.divKeys = divKeys;
        this.encoding = encoding;
    }

    public void union(String outputFileName, File inputFolder, boolean indentFlag) throws BizTranException {
        Object[] divInputFiles = inputFolder.listFiles();
        Arrays.sort(divInputFiles);
        try {
            for (int i = 0; i < divInputFiles.length; ++i) {
                boolean isFirst = false;
                if (i == 0) {
                    isFirst = true;
                }
                boolean isLast = false;
                if (i == divInputFiles.length - 1) {
                    isLast = true;
                }
                SAXParserFactory spfactory = SAXParserFactory.newInstance();
                SAXParser parser = spfactory.newSAXParser();
                parser.parse((File)divInputFiles[i], (DefaultHandler)new XmlUnionSAXHandler(outputFileName, this.xmlUniProp, this.divKeys, isFirst, isLast, indentFlag, this.encoding));
            }
        }
        catch (Exception e) {
            throw new BizTranException(AppMessage.IO_DIVIDEPROP_UNION_FAIL, (Throwable)e);
        }
    }
}

