/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.util.Properties;
import com.argo21.msg.MessageException;

public class FixMetaData
extends DataTypeDecl {
    public static int JUSTIFIED_RIGHT = 1;
    public static int JUSTIFIED_LEFT = 2;
    public static final int NORMAL = 0;
    public static final int REPEAT = 1;
    int rec_type = 0;
    public int reclength = 0;
    public String condition = null;
    public int repeat = 0;
    public String skip = null;
    public int start = 0;
    public int justified = JUSTIFIED_LEFT;
    public int allsize = 0;
    private Object formatPattern = null;

    public FixMetaData() {
    }

    public FixMetaData(int type, int size, int start, String value) {
        this(value, type, size, start, JUSTIFIED_LEFT, ' ', null);
    }

    public FixMetaData(int rec_type, int reclength, String condition) {
        this.rec_type = rec_type;
        this.reclength = reclength;
        this.condition = condition;
    }

    public FixMetaData(String value, int type, int length, int start, int justified, char space, String format) {
        super(type, length, space, null, format, value);
        this.start = start;
        this.justified = justified;
    }

    public FixMetaData(Properties properties) throws MessageException {
        super(properties);
        String s = properties.getValue("rec_type");
        if (s != null) {
            this.rec_type = s.equalsIgnoreCase("normal") ? 0 : (s.equalsIgnoreCase("repeat") ? 1 : 0);
        }
        if ((s = properties.getValue("lrecl")) != null) {
            this.reclength = Integer.parseInt(s);
        }
        if ((s = properties.getValue("condition")) != null) {
            this.condition = s;
        }
        if ((s = properties.getValue("repeat")) != null) {
            this.repeat = Integer.parseInt(s);
        }
        if ((s = properties.getValue("skip")) != null) {
            this.skip = s;
        }
        if ((s = properties.getValue("start")) != null) {
            this.start = Integer.parseInt(s);
        }
        if ((s = properties.getValue("justified")) != null) {
            this.justified = s.equals("right") ? JUSTIFIED_RIGHT : JUSTIFIED_LEFT;
        }
        if ((s = properties.getValue("fillchar")) != null) {
            if (s.equalsIgnoreCase("zero")) {
                this.fillchar = (char)48;
            } else if (s.equalsIgnoreCase("half-space")) {
                this.fillchar = (char)32;
            } else if (s.equalsIgnoreCase("full-space")) {
                this.fillchar = (char)12288;
            } else if (s.equalsIgnoreCase("change-space")) {
                this.fillchar = (char)42;
            }
        }
    }

    @Override
    public Object clone() {
        return new FixMetaData(this.value, this.type, this.size, this.start, this.justified, this.fillchar, this.format);
    }

    @Override
    public String getXML(String attr) {
        int n;
        StringBuffer sb = new StringBuffer();
        if ((attr = attr.trim()).startsWith("r")) {
            sb.append("rec_type=\"");
            if (this.rec_type == 0) {
                sb.append("normal");
            } else if (this.rec_type == 1) {
                sb.append("repeat");
            }
            sb.append("\" ");
            sb.append("lrecl=\"");
            sb.append(this.reclength);
            sb.append("\" ");
            if (this.rec_type == 0) {
                sb.append("condition=\"");
                if (this.condition == null) {
                    sb.append("");
                } else {
                    sb.append(this.condition);
                }
                sb.append("\" ");
            } else if (this.rec_type == 1) {
                sb.append("repeat=\"");
                sb.append(String.valueOf(this.repeat));
                sb.append("\" ");
                sb.append("skip=\"");
                if (this.skip != null) {
                    sb.append(this.skip);
                }
                sb.append("\" ");
            }
        }
        if (attr.startsWith("f")) {
            sb.append("type=\"");
            sb.append(XData.getTypeName(this.type));
            sb.append("\" ");
            sb.append("size=\"");
            sb.append(this.size);
            sb.append("\" ");
            sb.append("start=\"");
            sb.append(this.start);
            sb.append("\" ");
            sb.append("justified=\"");
            if (this.justified == JUSTIFIED_RIGHT) {
                sb.append("right");
            } else {
                sb.append("left");
            }
            sb.append("\" ");
            sb.append("fillchar=\"");
            if (this.fillchar == '0') {
                sb.append("zero");
            } else if (this.fillchar == ' ') {
                sb.append("half-space");
            } else if (this.fillchar == '\u3000') {
                sb.append("full-space");
            } else if (this.fillchar == '*') {
                sb.append("change-space");
            } else {
                this.fillchar = (char)32;
                sb.append("half-space");
            }
            sb.append("\" ");
            if (this.format != null) {
                sb.append("format=\"");
                sb.append(this.format);
                sb.append("\" ");
            }
        }
        if ((n = sb.length()) > 0) {
            sb.setCharAt(n - 1, '>');
            sb.insert(0, "<DATA " + attr + " ");
        }
        if (this.value != null) {
            sb.append(this.value);
        }
        sb.append("</DATA>");
        return sb.toString();
    }

    private String delFillChar(String value, boolean before) {
        int n = value.length();
        if (before) {
            int first = 0;
            if (first < n && value.charAt(first) == this.fillchar) {
                ++first;
            }
            return value.substring(first);
        }
        int last2 = n - 1;
        if (last2 >= 0 && value.charAt(last2) == this.fillchar) {
            --last2;
        }
        return value.substring(last2);
    }

    protected String resize(String value) {
        StringBuffer sb = new StringBuffer();
        if (this.size > 0 && value.length() > this.size) {
            sb.append(value.substring(0, this.size));
        } else {
            sb.append(value);
        }
        int filnum = this.size - sb.length();
        if (this.justified == JUSTIFIED_RIGHT) {
            for (int i = 0; i < filnum; ++i) {
                sb.insert(i, this.fillchar);
            }
        } else {
            for (int i = 0; i < filnum; ++i) {
                sb.insert(sb.length() - i, this.fillchar);
            }
        }
        return sb.toString();
    }

    public static void main(String[] args) throws XDataException {
        char c = '0';
        FixMetaData fix = new FixMetaData("000.00", 3, 10, 0, JUSTIFIED_RIGHT, c, "##.##");
        String s = fix.formatValue("125.55");
        System.out.println('\"' + s + '\"');
        String s1 = fix.getXML("field=\"AAA\"");
        System.out.println(s1);
        FixMetaData fix1 = new FixMetaData(0, 128, "id1=12");
        fix1.rec_type = 0;
        s = fix1.getXML("record=\"BBB\"");
        System.out.println(s);
        FixMetaData fix2 = new FixMetaData();
        fix2.rec_type = 1;
        fix2.reclength = 128;
        fix2.repeat = 3;
        fix2.skip = "allspaces";
        s = fix2.getXML("record=\"CCC\"");
        System.out.println(s);
    }
}

