/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.io.Debug;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.util.BizTranCache;
import com.argo21.common.util.BizTranCacheNodeSet;
import com.argo21.common.util.EncodeConverter;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.parser.IXmlParser;
import com.argo21.jxp.parser.XmlParser;
import com.argo21.jxp.xpath.DTDXPathSurpport;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageException;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.fix.FixMetaData;
import com.argo21.msg.fix.FixSchema;
import com.argo21.msg.fix.RecordCondition;
import com.argo21.msg.fix.RecordDecl;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FixMsg
extends BaseMessage {
    public static final String MSGTYPE = "FIX";
    private static final String EXTTYPE = "txt";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_SID1 = "id1_start";
    public static final String PROPERTY_EID1 = "id1_size";
    public static final String PROPERTY_SID2 = "id2_start";
    public static final String PROPERTY_EID2 = "id2_size";
    public static final String PROPERTY_SID3 = "id3_start";
    public static final String PROPERTY_EID3 = "id3_size";
    public static final String PROPERTY_BLOCKLENGTH = "blocklength";
    private boolean isChanged = false;
    private boolean isFile = true;
    private String s_id1 = "0";
    private String e_id1 = "0";
    private String s_id2 = "0";
    private String e_id2 = "0";
    private String s_id3 = "0";
    private String e_id3 = "0";
    private String[] ID = new String[3];
    private int blocklength = 0;
    protected FixSchema schema = null;
    protected Document document = null;
    protected XPathParser xpathParser = null;
    protected XPathSurpport xpathSurpport;
    private boolean initialized = false;
    private long lastModifies = 0L;
    private boolean debug = false;
    public static final int ID_MAX = 3;
    private int[][] idPos;
    int position = 0;
    RecordDecl errorRecord = null;
    ArrayList list;

    @Override
    public String getMsgType() {
        return MSGTYPE;
    }

    @Override
    public boolean isReady() {
        return this.document != null;
    }

    @Override
    public long getLastModifies() {
        return this.lastModifies;
    }

    @Override
    public FileFilter getDocumentFileFilter() {
        return new FileFilterEx(new String[]{"fix", EXTTYPE}, "FIX Files");
    }

    @Override
    public Properties getDefaultProperties() {
        Properties ps = super.getDefaultProperties();
        ps.append(PROPERTY_FILE, "TEXT");
        return ps;
    }

    @Override
    public Properties getProperties() {
        Properties ps = super.getProperties();
        String s = this.isFile ? "TEXT" : "BINARY";
        ps.append(PROPERTY_FILE, s);
        if (this.s_id1 != null) {
            ps.append(PROPERTY_SID1, this.s_id1);
        }
        if (this.e_id1 != null) {
            ps.append(PROPERTY_EID1, this.e_id1);
        }
        if (this.s_id2 != null) {
            ps.append(PROPERTY_SID2, this.s_id2);
        }
        if (this.e_id2 != null) {
            ps.append(PROPERTY_EID2, this.e_id2);
        }
        if (this.s_id3 != null) {
            ps.append(PROPERTY_SID3, this.s_id3);
        }
        if (this.e_id3 != null) {
            ps.append(PROPERTY_EID3, this.e_id3);
        }
        if (this.blocklength != 0) {
            s = String.valueOf(this.blocklength);
            ps.append(PROPERTY_BLOCKLENGTH, s);
        }
        return ps;
    }

    @Override
    public void setProperties(Properties properties) throws MessageException {
        int i;
        super.setProperties(properties);
        String s = properties.getValue(PROPERTY_FILE, "TEXT");
        if (s.equalsIgnoreCase("TEXT")) {
            this.isFile = true;
        } else if (s.equalsIgnoreCase("BINARY")) {
            this.isFile = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_FILE, s}, null);
        }
        this.s_id1 = s = properties.getValue(PROPERTY_SID1, null);
        this.e_id1 = s = properties.getValue(PROPERTY_EID1, null);
        this.s_id2 = s = properties.getValue(PROPERTY_SID2, null);
        this.e_id2 = s = properties.getValue(PROPERTY_EID2, null);
        this.s_id3 = s = properties.getValue(PROPERTY_SID3, null);
        this.e_id3 = s = properties.getValue(PROPERTY_EID3, null);
        s = properties.getValue(PROPERTY_BLOCKLENGTH, "0");
        this.blocklength = i = Integer.parseInt(s);
        this.initialized = false;
    }

    @Override
    public Object getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Object schema) throws MessageException {
        if (schema instanceof FixSchema) {
            this.schema = (FixSchema)schema;
            this.initialized = false;
        } else {
            this.schema = null;
            MessageException.error("CANT_CAST_SCHEMA", new Object[]{schema.getClass().getName(), this.getMsgType()}, null);
        }
    }

    @Override
    public void readSchema(Reader in) throws MessageException {
        try {
            XReader reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
            FixSchema schema = new FixSchema(this.getMsgName());
            schema.parseSchemaDecl(reader);
            this.schema = schema;
            if (this.encoding == null) {
                this.encoding = schema.getEncoding();
            }
            this.initialized = false;
        }
        catch (Exception e) {
            this.schema = null;
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public void writeSchema(Writer out) throws MessageException {
        try {
            this.schema.write(out);
        }
        catch (Exception e) {
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document instanceof Document) {
            this.document = (Document)document;
            this.lastModifies = System.currentTimeMillis();
        } else {
            this.document = null;
            this.error("CANT_CAST_DOM", new Object[]{document.getClass().getName(), this.getMsgType()});
        }
    }

    @Override
    public void read(Reader in) throws MessageException {
    }

    @Override
    public void read(InputStream in) throws SAXException {
        this.position = 0;
        try {
            if (this.document != null) {
                this.document = null;
                this.lastModifies = System.currentTimeMillis();
            }
            if (this.getMsgName() != null) {
                int b;
                this.list = new ArrayList();
                IXmlParser parser = XmlParser.getXmlParser();
                this.document = parser.createXmlDocument();
                DeclNodeList nodes = this.schema.getAllDeclNode();
                RecordDecl rec = null;
                DeclNode node = this.schema.getRootElement();
                if (node == null) {
                    int n = nodes.size();
                    for (int i = 0; i < n && (node = nodes.elementAt(i)).getNodeType() != 45; ++i) {
                    }
                    MessageException.error("CANT_READ_ROOT", new Object[0], null);
                }
                MyPushbackInputStream pin = new MyPushbackInputStream(in);
                if (node.getNodeType() == 45) {
                    rec = (RecordDecl)node;
                    this.idPos = this.getIdPosition();
                    if (this.idPos != null) {
                        this.position = 0;
                        FixMetaData fixmeta = (FixMetaData)rec.getDataTypeDecl();
                        this.processRecordDecl(rec, pin, this.document, this.document);
                    } else {
                        MessageException.error("INVALID_ID_DEF", new Object[0], null);
                    }
                }
                if ((b = pin.read()) >= 0) {
                    ((PushbackInputStream)pin).unread(b);
                    this.document = null;
                    String errorRecName = "";
                    if (this.errorRecord != null) {
                        errorRecName = this.errorRecord.getNodeName();
                    }
                    if (this.list != null) {
                        String recParseName = "";
                        String nextParseName = "";
                        int countRep = 1;
                        boolean isEndRep = true;
                        int listCount = this.list.size();
                        for (int g = 0; g < listCount; ++g) {
                            isEndRep = true;
                            countRep = 1;
                            recParseName = (String)this.list.get(g);
                            while (isEndRep) {
                                if (g < listCount - 1) {
                                    nextParseName = (String)this.list.get(g + 1);
                                    if (recParseName.equals(nextParseName)) {
                                        ++countRep;
                                        ++g;
                                        continue;
                                    }
                                    isEndRep = false;
                                    continue;
                                }
                                isEndRep = false;
                            }
                            if (countRep == 1) {
                                Debug.println(MessageException.getMessage("PARSE_REC_TRUE", recParseName));
                                continue;
                            }
                            Debug.println(MessageException.getMessage("PARSE_REC_TRUE", recParseName + "[" + countRep + "]"));
                        }
                    }
                    Debug.println(MessageException.getMessage("CANT_READ_BYTE", String.valueOf(this.position)));
                    MessageException.error("CANT_PARSE_RECORD", errorRecName, null);
                }
            }
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    private int[][] getIdPosition() {
        try {
            int[][] idPos = new int[3][2];
            if (this.s_id1 == null || this.e_id1 == null) {
                idPos[1][0] = 0;
                idPos[1][1] = 0;
            } else {
                idPos[0][0] = Integer.parseInt(this.s_id1);
                idPos[0][1] = Integer.parseInt(this.e_id1);
            }
            if (this.s_id2 == null || this.e_id2 == null) {
                idPos[1][0] = 0;
                idPos[1][1] = 0;
            } else {
                idPos[1][0] = Integer.parseInt(this.s_id2);
                idPos[1][1] = Integer.parseInt(this.e_id2);
            }
            if (this.s_id3 == null || this.e_id3 == null) {
                idPos[2][0] = 0;
                idPos[2][1] = 0;
            } else {
                idPos[2][0] = Integer.parseInt(this.s_id3);
                idPos[2][1] = Integer.parseInt(this.e_id3);
            }
            return idPos;
        }
        catch (Exception me) {
            System.out.println(me);
            return null;
        }
    }

    private boolean checkCondition(String conditions, byte[] record) throws MessageException, UnsupportedEncodingException {
        boolean bool = false;
        int start = 0;
        int size = 0;
        boolean length = false;
        String[] recValue = new String[3];
        for (int j = 0; j < 3; ++j) {
            if (this.idPos[j][0] < 0 || this.idPos[j][1] < 1) continue;
            start = this.idPos[j][0];
            size = this.idPos[j][1];
            if (1 > size || start < 0) continue;
            if (this.encoding != null) {
                String s = MIME2Java.convert(this.encoding);
                recValue[j] = new String(record, start - 1, size, s);
                continue;
            }
            recValue[j] = new String(record, start - 1, size);
        }
        RecordCondition rcon = new RecordCondition();
        rcon.parseConditions(conditions);
        if (recValue != null) {
            bool = rcon.evalute(recValue);
        }
        return bool;
    }

    private void processRecordDecl(RecordDecl rec, PushbackInputStream pin, Node parentNode, Document doc) throws SAXException, IOException {
        try {
            int b;
            boolean hasAppeared = false;
            String recName = rec.getNodeName();
            FixMetaData fixmeta = (FixMetaData)rec.getDataTypeDecl();
            while ((b = pin.read()) != -1) {
                pin.unread(b);
                Vector repeatChildren = null;
                int childLength = 0;
                String name2 = "";
                DeclNode currentNode = null;
                if (1 == fixmeta.rec_type) {
                    int back;
                    repeatChildren = rec.getChildNames();
                    childLength = repeatChildren.size();
                    byte[] repeatRec = new byte[fixmeta.reclength];
                    String skipStr = fixmeta.skip;
                    if (skipStr != null) {
                        if (skipStr.length() >= fixmeta.reclength) {
                            skipStr = skipStr.substring(0, fixmeta.reclength);
                        } else if (skipStr.length() == 0) {
                            skipStr = " ";
                        }
                    } else {
                        skipStr = " ";
                    }
                    for (int g = 0; g < fixmeta.repeat && (back = pin.read(repeatRec)) >= 0; ++g) {
                        String repeatStr;
                        if (this.encoding != null) {
                            String s = MIME2Java.convert(this.encoding);
                            repeatStr = new String(repeatRec, 0, back, s);
                        } else {
                            repeatStr = new String(repeatRec, 0, back);
                        }
                        String checkStr = repeatStr.substring(0, skipStr.length());
                        int chk = checkStr.compareTo(skipStr);
                        if (checkStr.equals(skipStr)) {
                            this.position += fixmeta.reclength;
                            continue;
                        }
                        Element elem = doc.createElement(recName);
                        parentNode.appendChild(elem);
                        if (this.debug) {
                            System.out.print("<" + recName + ">");
                        }
                        this.list.add(recName);
                        pin.unread(repeatRec, 0, back);
                        for (int h = 0; h < childLength; ++h) {
                            int type;
                            name2 = (String)repeatChildren.elementAt(h);
                            currentNode = this.schema.getFieldDecl(name2, rec);
                            if (currentNode == null || (type = currentNode.getNodeType()) != 43) continue;
                            this.processFieldDecl((FieldDecl)currentNode, pin, elem, doc);
                        }
                        if (!this.debug) continue;
                        System.out.println("</" + recName + ">");
                    }
                } else {
                    byte[] record;
                    int back;
                    String _condition = fixmeta.condition;
                    boolean con = false;
                    if (fixmeta.reclength == 0 || _condition.equalsIgnoreCase("true")) {
                        con = true;
                    } else if (_condition.length() >= 0 && fixmeta.reclength >= 1 && (back = pin.read(record = new byte[fixmeta.reclength])) >= 0) {
                        con = this.checkCondition(fixmeta.condition, record);
                        pin.unread(record, 0, back);
                    }
                    char occurrenceCount = rec.getOccurrence();
                    if (con) {
                        hasAppeared = true;
                        this.errorRecord = rec;
                        Element elem = doc.createElement(recName);
                        parentNode.appendChild(elem);
                        this.list.add(recName);
                        Vector childrenNames = rec.getChildNames();
                        int child_count = childrenNames.size();
                        int node_type = -1;
                        for (int h = 0; h < child_count; ++h) {
                            name2 = (String)childrenNames.elementAt(h);
                            currentNode = this.schema.getFieldDecl(name2, rec);
                            if (currentNode != null) {
                                node_type = currentNode.getNodeType();
                                if (node_type != 43) continue;
                                this.processFieldDecl((FieldDecl)currentNode, pin, elem, doc);
                                continue;
                            }
                            currentNode = this.schema.getRecordDecl(name2);
                            if (currentNode == null || (node_type = currentNode.getNodeType()) != 45) continue;
                            this.processRecordDecl((RecordDecl)currentNode, pin, elem, doc);
                        }
                    }
                    if (!(rec.getParentDecl() == null || occurrenceCount == '\u0000' && !hasAppeared || occurrenceCount == '\u0000' || occurrenceCount == '?' || occurrenceCount == '+' && !hasAppeared) && (occurrenceCount != '+' && occurrenceCount != '*' || con)) continue;
                }
                break;
            }
        }
        catch (UnsupportedEncodingException enc) {
            this.error("INVALID_ENCODING", this.encoding);
        }
    }

    private void processFieldDecl(FieldDecl field, InputStream in, Node parentNode, Document doc) throws SAXException, IOException {
        byte[] checkByte;
        String value;
        String fieldName = field.getNodeName();
        FixMetaData fieldData = (FixMetaData)field.getDataTypeDecl();
        int start = fieldData.start;
        int size = fieldData.size;
        byte[] recByte = new byte[size];
        int len = in.read(recByte);
        if (len < 0) {
            return;
        }
        if (this.encoding != null) {
            String s = MIME2Java.convert(this.encoding);
            value = new String(recByte, 0, len, s);
        } else {
            value = new String(recByte, 0, len);
        }
        if (this.encoding != null) {
            String s = MIME2Java.convert(this.encoding);
            checkByte = value.getBytes(s);
        } else {
            checkByte = value.getBytes();
        }
        int checkLen = checkByte.length;
        if (checkLen != recByte.length) {
            Debug.println(MessageException.getMessage("CANT_READ_BYTE", String.valueOf(this.position)));
            this.error("CANT_PARSE_FIELD", new String[0]);
        }
        for (int i = 0; i < checkLen; ++i) {
            if (checkByte[i] == recByte[i]) continue;
            Debug.println(MessageException.getMessage("CANT_READ_BYTE", String.valueOf(this.position)));
            this.error("CANT_PARSE_FIELD", new String[0]);
        }
        Element elem = doc.createElement(fieldName);
        parentNode.appendChild(elem);
        elem.appendChild(doc.createTextNode(value));
        if (this.debug) {
            System.out.println("    <" + fieldName + ">" + XmlParser.toXmlText(value) + "</" + fieldName + ">");
        }
        this.position += len;
    }

    @Override
    public void submit() throws SAXException {
        if (this.direction.equals("INPUT")) {
            return;
        }
        if (!this.isStreamIO()) {
            URL documentURL = this.getDocumentURL();
            this.write(documentURL, false);
        }
    }

    @Override
    public void write(OutputStream out) throws SAXException {
        try {
            BufferedOutputStream bout = new BufferedOutputStream(out);
            if (this.document != null) {
                Node node = this.document.getFirstChild();
                if (node != null) {
                    String s = MIME2Java.convert(this.encoding);
                    this.writeField(new FieldWriter(bout, s), node);
                } else {
                    System.out.println("node isn't there.");
                }
            }
            bout.flush();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void write(Writer out) throws SAXException {
        try {
            BufferedWriter bw = new BufferedWriter(out);
            if (this.document != null) {
                Node node = this.document.getFirstChild();
                if (node != null) {
                    String s = MIME2Java.convert(this.encoding);
                    this.writeField(new FieldWriter(bw, s), node);
                } else {
                    System.out.println("node isn't there.");
                }
            }
            bw.flush();
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void writeField(FieldWriter fw, Node node) throws IOException, SAXException {
        try {
            String parentNodeName = node.getNodeName();
            RecordDecl parent = this.schema.getRecordDecl(parentNodeName);
            NodeList nodelist = node.getChildNodes();
            block6: for (int i = 0; i < nodelist.getLength(); ++i) {
                Node currentNode = nodelist.item(i);
                DeclNode schemaNode = this.getSchemaNode(parent, currentNode);
                if (schemaNode == null) continue;
                switch (schemaNode.getNodeType()) {
                    case 43: {
                        String nodeType = schemaNode.getNodeTypeName();
                        String nodeValue = XmlParser.getElementText(currentNode);
                        if (nodeValue.equals("\n") || nodeValue.equals("\r") || nodeValue.equals("\r\n")) {
                            fw.writeSpace();
                            continue block6;
                        }
                        fw.writeFieldValue((FieldDecl)schemaNode, nodeValue.trim());
                        continue block6;
                    }
                    case 45: {
                        this.writeField(fw, currentNode);
                        FixMetaData recMeta = (FixMetaData)schemaNode.getDataTypeDecl();
                        if (1 != recMeta.rec_type) continue block6;
                        int repeat = recMeta.repeat;
                        String skip = recMeta.skip;
                        int count2 = 1;
                        DeclNode schemaNode1 = schemaNode;
                        while (i + count2 < nodelist.getLength() && (schemaNode = this.getSchemaNode(parent, currentNode = nodelist.item(i + count2))) == schemaNode1) {
                            if (count2 < repeat) {
                                this.writeField(fw, currentNode);
                            } else if (count2 == repeat) {
                                String nodeName = currentNode.getNodeName();
                                Debug.println(MessageException.getMessage("REPEAT_ERROR", nodeName));
                            }
                            ++count2;
                        }
                        if (count2 < repeat) {
                            if (skip == null || skip.length() <= 0) {
                                skip = " ";
                            }
                            for (int c = count2; c < repeat; ++c) {
                                fw.writeSkipRecord(skip, recMeta.reclength);
                            }
                        }
                        i += count2 - 1;
                        continue block6;
                    }
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            this.error("INVALID_ENCODING", this.encoding);
        }
    }

    private DeclNode getSchemaNode(DeclNode parent, Node node) {
        short domType = node.getNodeType();
        String nodeName = node.getNodeName();
        if (domType == 1) {
            DeclNode schemaNode = this.schema.getFieldDecl(nodeName, parent);
            if (schemaNode == null) {
                schemaNode = this.schema.getRecordDecl(nodeName);
            }
            return schemaNode;
        }
        return null;
    }

    @Override
    public void close() throws MessageException {
        this.document = null;
    }

    @Override
    public void clearDocument() {
        if (this.direction != "INPUT" && this.document != null) {
            Element node = this.document.getDocumentElement();
            this.document.removeChild(node);
            this.lastModifies = System.currentTimeMillis();
        }
    }

    @Override
    public boolean init() throws SAXException {
        try {
            if (this.schema == null) {
                if (this.name != null) {
                    MessageException.error("CANT_INIT_MSG", new String[]{this.name}, null);
                } else {
                    MessageException.error("CANT_INIT_MSG", new String[]{""}, null);
                }
            }
            this.schema.resolveHierarchy();
            if (this.direction == "INPUT") {
                if (!this.isStreamIO()) {
                    URL documentURL = this.getDocumentURL();
                    this.read(documentURL);
                }
                DTDDocument dtd = this.schema.transferToDTD(this.schema);
                this.xpathSurpport = new DTDXPathSurpport(dtd, this.document);
                this.xpathSurpport.setExtendable(true);
            } else {
                IXmlParser parser = XmlParser.getXmlParser();
                this.document = parser.createXmlDocument();
                this.lastModifies = System.currentTimeMillis();
                DTDDocument dtd = this.schema.transferToDTD(this.schema);
                this.xpathSurpport = new DTDXPathSurpport(dtd, this.document);
                this.xpathSurpport.setExtendable(true);
                this.isChanged = true;
            }
        }
        catch (Exception e) {
            this.error(e);
        }
        this.initialized = true;
        return true;
    }

    @Override
    public ExtOperand parseOperand(Operand orient, VariableReference variables, XReader in) throws SAXException {
        if (!this.initialized && !this.init()) {
            this.error("CANT_INIT_MSG", this.name);
        }
        if (this.xpathSurpport.getVariableReference() != variables) {
            this.xpathSurpport.setVariableReference(variables);
        }
        if (this.xpathParser == null) {
            this.xpathParser = new XPathParser();
        }
        XPath xpath = this.xpathParser.parse(in);
        XPathOperand op = new XPathOperand(orient, xpath);
        String s = orient.getReference();
        s = s + "/" + xpath.getNodePathString();
        op.setReference(s);
        return op;
    }

    public String toString() {
        Properties ps = this.getProperties();
        return ps.toString(",");
    }

    @Override
    public String getExtension() {
        return EXTTYPE;
    }

    class FieldWriter {
        OutputStream out = null;
        Writer wr = null;
        String encoding = null;

        public FieldWriter(OutputStream out, String encoding) {
            this.out = out;
            this.encoding = encoding;
        }

        public FieldWriter(Writer wr, String encoding) {
            this.wr = wr;
            this.encoding = encoding;
        }

        public void writeSpace() throws IOException {
            if (this.wr != null) {
                this.wr.write(FixMsg.this.eol);
            } else if (this.encoding != null) {
                this.out.write(FixMsg.this.eol.getBytes(this.encoding));
            } else {
                this.out.write(FixMsg.this.eol.getBytes());
            }
        }

        public void writeFieldValue(FieldDecl fieldNode, String nodeValue) throws IOException, SAXException {
            FixMetaData fixData = (FixMetaData)fieldNode.getDataTypeDecl();
            int size = fixData.size;
            byte[] byteValue = this.encoding != null ? nodeValue.getBytes(this.encoding) : nodeValue.getBytes();
            byte[] buff = null;
            if (this.wr != null) {
                if (byteValue.length == size) {
                    this.wr.write(nodeValue);
                } else {
                    buff = this.changeFieldValue(fieldNode, byteValue);
                    if (buff != null) {
                        String valueField = this.encoding != null ? new String(buff, this.encoding) : new String(buff);
                        this.wr.write(valueField);
                    }
                }
            } else {
                buff = this.changeFieldValue(fieldNode, byteValue);
                if (buff != null) {
                    this.out.write(buff);
                }
            }
        }

        private byte[] changeFieldValue(FieldDecl fieldNode, byte[] byteValue) throws IOException, SAXException {
            String strValue;
            byte[] fillByte;
            FixMetaData fixData = (FixMetaData)fieldNode.getDataTypeDecl();
            char fillCh = fixData.fillchar;
            int size = fixData.size;
            if (size <= 0) {
                return null;
            }
            String fillChStr = String.valueOf(fillCh);
            if (this.encoding != null) {
                fillByte = fillChStr.getBytes(this.encoding);
                strValue = new String(byteValue, this.encoding);
            } else {
                fillByte = fillChStr.getBytes();
                strValue = new String(byteValue);
            }
            if ("*".equals(fillChStr)) {
                fillByte = !this.checkFullSize(strValue) ? (this.encoding != null ? " ".getBytes(this.encoding) : " ".getBytes()) : (this.encoding != null ? "\u3000".getBytes(this.encoding) : "\u3000".getBytes());
            }
            byte[] buff = new byte[size];
            int length = byteValue.length;
            if (size == length) {
                return byteValue;
            }
            if (size > length) {
                if (fixData.justified == FixMetaData.JUSTIFIED_LEFT) {
                    System.arraycopy(byteValue, 0, buff, 0, length);
                    for (int h = byteValue.length; h < size; ++h) {
                        if (fillByte.length == 1) {
                            buff[h] = fillByte[0];
                            continue;
                        }
                        if (fillByte.length != 2) continue;
                        buff[h] = fillByte[0];
                        if (++h >= size) {
                            FixMsg.this.warning("CANT_FULL_SAPCE", new Object[]{fieldNode.getParentDecl().getNodeName(), fieldNode.getNodeName()});
                            buff[h - 1] = " ".getBytes(this.encoding)[0];
                            break;
                        }
                        buff[h] = fillByte[1];
                    }
                } else if (fixData.justified == FixMetaData.JUSTIFIED_RIGHT) {
                    System.arraycopy(byteValue, 0, buff, size - length, length);
                    for (int h = size - byteValue.length - 1; h >= 0; --h) {
                        if (fillByte.length == 1) {
                            buff[h] = fillByte[0];
                            continue;
                        }
                        if (fillByte.length != 2) continue;
                        buff[h] = fillByte[1];
                        if (--h < 0) {
                            FixMsg.this.warning("CANT_FULL_SPACE", new Object[]{fieldNode.getParentDecl().getNodeName(), fieldNode.getNodeName()});
                            break;
                        }
                        buff[h] = fillByte[0];
                    }
                }
                return buff;
            }
            if (fixData.justified == FixMetaData.JUSTIFIED_LEFT) {
                System.arraycopy(byteValue, 0, buff, 0, size);
                FixMsg.this.warning("CANT_CHANGE_FIELD", new Object[]{fieldNode.getParentDecl().getNodeName(), fieldNode.getNodeName()});
            } else if (fixData.justified == FixMetaData.JUSTIFIED_RIGHT) {
                System.arraycopy(byteValue, length - size, buff, 0, size);
                FixMsg.this.warning("CANT_CHANGE_FIELD", new Object[]{fieldNode.getParentDecl().getNodeName(), fieldNode.getNodeName()});
            }
            return buff;
        }

        private boolean checkFullSize(String str) {
            byte[] bytes;
            String value = str;
            value = "SHIFT_JIS".equalsIgnoreCase(this.encoding) ? EncodeConverter.unicodeToSjis(str) : ("EUC-JP".equals(this.encoding) ? EncodeConverter.unicodeToEuc(str) : str);
            if (this.encoding != null) {
                try {
                    bytes = value.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException e) {
                    bytes = value.getBytes();
                }
            } else {
                bytes = value.getBytes();
            }
            int beams = value.length() * 2;
            StringBuffer sb = new StringBuffer(value);
            for (int i = 0; i < value.length(); ++i) {
                if ('\n' != sb.charAt(i)) continue;
                beams -= 2;
            }
            return beams == bytes.length;
        }

        public void writeSkipRecord(String fill, int size) throws IOException {
            byte[] fillByte = this.encoding != null ? fill.getBytes(this.encoding) : fill.getBytes();
            byte[] buff = null;
            if (this.wr != null) {
                if (fillByte.length == size) {
                    this.wr.write(fill);
                } else {
                    buff = this.changeSkipRecord(fillByte, size);
                    if (buff != null) {
                        String valueField = this.encoding != null ? new String(buff, this.encoding) : new String(buff);
                        this.wr.write(valueField);
                    }
                }
            } else {
                buff = this.changeSkipRecord(fillByte, size);
                if (buff != null) {
                    this.out.write(buff);
                }
            }
        }

        private byte[] changeSkipRecord(byte[] fillByte, int size) throws UnsupportedEncodingException {
            byte[] buff = new byte[size];
            int fillLength = fillByte.length;
            if (size < fillLength) {
                System.arraycopy(fillByte, 0, buff, 0, size);
            } else {
                for (int k = 0; k < size; k += fillLength) {
                    if (k + fillLength >= size) {
                        System.arraycopy(fillByte, 0, buff, k, size - k);
                        break;
                    }
                    System.arraycopy(fillByte, 0, buff, k, fillLength);
                }
            }
            return buff;
        }
    }

    class MyPushbackInputStream
    extends PushbackInputStream {
        public MyPushbackInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void unread(int b) throws IOException {
            if (this.pos == 0) {
                byte[] newBuf = new byte[this.buf.length + 1];
                System.arraycopy(this.buf, 0, newBuf, 1, this.buf.length);
                newBuf[0] = (byte)b;
                this.buf = newBuf;
            } else {
                this.buf[--this.pos] = (byte)b;
            }
        }

        @Override
        public void unread(byte[] b, int off, int len) throws IOException {
            if (len > this.pos) {
                byte[] newBuf = new byte[this.buf.length + (len - this.pos)];
                System.arraycopy(this.buf, this.pos, newBuf, len, this.buf.length - this.pos);
                System.arraycopy(b, off, newBuf, 0, len);
                this.buf = newBuf;
                this.pos = 0;
            } else {
                this.pos -= len;
                System.arraycopy(b, off, this.buf, this.pos, len);
            }
        }
    }

    class XPathOperand
    extends ExtOperand {
        XPathOperand(Operand orient, Object expression) {
            super(orient, expression);
        }

        @Override
        public String getEncoding() {
            return FixMsg.this.encoding;
        }

        private XData selectData(XData ref) throws XDataException {
            XPath xpath = (XPath)this.expression;
            BizTranCacheNodeSet cNodeSet = BizTranCache.getNode(xpath.getNodePathString(FixMsg.this.xpathSurpport), FixMsg.this.name);
            Node cNode = cNodeSet.getNode();
            try {
                if (ref.isObject()) {
                    Object obj = ref.objectValue();
                    if (obj instanceof FixMsg) {
                        XNodeSet xns;
                        if (cNode != null) {
                            xns = new XNodeSet(cNode);
                        } else {
                            Document doc = ((FixMsg)obj).document;
                            xns = new XNodeSet(doc);
                        }
                        return xpath.eval(xns, FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof Node) {
                        return xpath.eval(new XNodeSet((Node)obj), FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof NodeList) {
                        return xpath.eval(new XNodeSet((NodeList)obj), FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XNode) {
                        return xpath.eval((XNode)obj, FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XNodeSet) {
                        return xpath.eval((XNodeSet)obj, FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XData) {
                        XData.error("CANT_TO_NODE", ((XData)obj).getPrimitiveTypeName());
                    } else {
                        XData.error("CANT_TO_NODE", obj.getClass().getName());
                    }
                } else {
                    if (ref instanceof XNode) {
                        return xpath.eval((XNode)ref, FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (ref instanceof XNodeSet) {
                        return xpath.eval((XNodeSet)ref, FixMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    XData.error("CANT_TO_NODE", ref.getPrimitiveTypeName());
                }
            }
            catch (XDataException e) {
                throw e;
            }
            catch (Exception e) {
                XData.error(e, true);
            }
            return null;
        }

        @Override
        protected XData getData(XData ref) throws XDataException {
            FixMsg.this.xpathSurpport.setExtendable(false);
            return this.selectData(ref);
        }

        @Override
        protected void setData(XData ref, XData data) throws XDataException {
            FixMsg.this.xpathSurpport.setExtendable(FixMsg.this.getDirection() != "INPUT");
            FixMsg.this.xpathSurpport.setDefaultNumber(data.size());
            XData target = this.selectData(ref);
            int type = data.getPrimitiveType();
            int n = target.size();
            XDataMultipleException exception = null;
            if (data.isInteger()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.longValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isFloat()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.doubleValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isBoolean()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.booleanValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isDate()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.dateValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.stringValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            }
            FixMsg.this.lastModifies = System.currentTimeMillis();
            if (exception != null) {
                throw exception;
            }
        }
    }
}

