/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.io.Debug;
import com.argo21.common.io.XReader;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.DeclNodeListImpl;
import com.argo21.msg.MessageException;
import com.argo21.msg.csv.CsvSchema;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.fix.FixMetaData;
import com.argo21.msg.fix.RecordDecl;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.xml.sax.Locator;

public class FixSchema
extends CsvSchema {
    public static final int FIX_DECL = 44;
    public static final int RECORD_DECL = 45;
    public static final String RECORD_STRING = "record";
    protected DeclNodeListImpl nodes = new DeclNodeListImpl(20);
    protected Hashtable recordDecls = new Hashtable(11);
    protected Document doc = null;
    protected String url = null;
    protected Properties properties = new Properties();
    private XReader docReader = null;
    private RecordDecl rootElement = null;
    private RecordDecl parentRec = null;
    private RecordDecl parentRepeatRec = null;

    public FixSchema() {
    }

    public FixSchema(String name2) {
        super(name2);
    }

    @Override
    public int getNodeType() {
        return 44;
    }

    @Override
    public String getNodeTypeName() {
        return "FixSchema";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean parseSchemaDecl(XReader in) throws MessageException {
        try {
            do {
                in.peekWhitespace();
                if (in.isEOF()) return true;
            } while (this.parseComment(in) || this.parseRecordDecl(in) || this.parseFieldDecl(in) || this.parseDataDecl(in));
            if (!in.isChar(']')) return true;
            return true;
        }
        catch (DTDException dTDException) {
            return true;
        }
        catch (IOException io) {
            throw new MessageException(null, in, io);
        }
    }

    protected boolean parseRecordDecl(XReader in) throws IOException, MessageException, DTDException {
        if (!in.peek("<!RECORD")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            MessageException.error("INVALID_CHAR", String.valueOf(in.getc()), (Locator)in);
        }
        RecordDecl recDecl = new RecordDecl(this, in);
        DeclNodeList all_list = this.getAllDeclNode();
        int n = all_list.size();
        String recname = recDecl.getNodeName();
        for (int i = 0; i < n; ++i) {
            RecordDecl record;
            Vector childname;
            DeclNode node = all_list.elementAt(i);
            int nodetype = node.getNodeType();
            if (nodetype != 45 || !(childname = (record = (RecordDecl)node).getChildNames()).contains(recname)) continue;
            char occurrence = record.getSubElementOccurrence(recname);
            recDecl.setOccurrence(occurrence);
        }
        this.appendChild(recDecl);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            MessageException.error("NEED_CHAR", ">", (Locator)in);
        }
        return true;
    }

    @Override
    protected boolean parseFieldDecl(XReader in) throws IOException, MessageException {
        if (!in.peek("<!FIELD")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            MessageException.error("INVAILD_CHAR", String.valueOf(in.getc()), (Locator)in);
        }
        in.peekWhitespace();
        String name2 = in.peekXmlName();
        if (this.name != null) {
            in.peekWhitespace();
            if (!in.isChar('>')) {
                MessageException.error("NEED_CHAR", ">", (Locator)in);
            }
        } else {
            MessageException.error("NEED_NAME_AFTER", "<!FIELD ", (Locator)in);
        }
        FieldDecl decl = new FieldDecl((DeclNode)this, name2);
        this.appendChild(decl);
        in.peekWhitespace();
        if (!in.peekc('>')) {
            MessageException.error("NEED_CHAR", ">", (Locator)in);
        }
        return true;
    }

    @Override
    protected boolean parseDataDecl(XReader in) throws MessageException {
        Properties properties = new Properties();
        if (!in.peek("<DATA")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            MessageException.error("INVALID_CHAR", String.valueOf(in.getc()), (Locator)in);
        }
        boolean hasEnded = false;
        while (!in.isEOF()) {
            if (in.isChar('\\')) {
                in.getc();
                if (in.isChar('>')) {
                    in.getc();
                    hasEnded = true;
                    break;
                }
                MessageException.error("NEED_CHAR", ">", (Locator)in);
            }
            if (in.isChar('>')) {
                in.getc();
                break;
            }
            String propertyname = in.peekName();
            if (propertyname == null) {
                MessageException.error("INVALID_CHAR", String.valueOf(in.getc()), (Locator)in);
            }
            in.peekWhitespace();
            if (!in.peekc('=')) {
                MessageException.error("NEED_CHAR", "=", (Locator)in);
            }
            in.peekWhitespace();
            String propertyvalue = in.peekQuotedString();
            if (propertyvalue == null) {
                MessageException.error("INVALID_PARAM", propertyname, (Locator)in);
            }
            properties.append(propertyname, propertyvalue);
            in.peekWhitespace();
        }
        if (!hasEnded) {
            in.peekWhitespace();
            String s = in.readStringTo("</DATA>", false);
            properties.append("value", Properties.parseSpecialChar(s));
        }
        FixMetaData fixData = new FixMetaData(properties);
        String element = properties.getValue(RECORD_STRING);
        if (element != null) {
            RecordDecl recDecl = this.getRecordDecl(element);
            if (recDecl != null) {
                recDecl.setDataTypeDecl(fixData);
                if (fixData.rec_type == 0) {
                    this.parentRec = recDecl;
                } else {
                    this.parentRepeatRec = recDecl;
                }
            } else {
                Debug.println("\u3053\u306eRecord\u540d\u306f\u4e0d\u6b63\u3067\u3059\uff1a " + element);
            }
        }
        if ((element = properties.getValue("field")) != null) {
            FieldDecl fielddecl = this.getFieldDecl(element, this.parentRec);
            if (fielddecl != null) {
                fielddecl.setDataTypeDecl(fixData);
            } else if (fielddecl == null) {
                fielddecl = this.getFieldDecl(element, this.parentRepeatRec);
                if (fielddecl != null) {
                    fielddecl.setDataTypeDecl(fixData);
                } else {
                    Debug.println("\u3053\u306eField\u540d\u306f\u4e0d\u6b63\u3067\u3059\uff1a " + element);
                }
            }
        }
        properties = null;
        return true;
    }

    @Override
    public void appendChild(DeclNode newChild) {
        int type = newChild.getNodeType();
        String s = newChild.getNodeName();
        if (type == 45) {
            RecordDecl record = (RecordDecl)this.recordDecls.get(s);
            if (record != null) {
                System.out.println("\u30ec\u30b3\u30fc\u30c9\u540d\u91cd\u8907");
            } else {
                this.recordDecls.put(s, newChild);
                this.nodes.addElement(newChild);
            }
        } else if (type == 43) {
            DeclNode parent = null;
            int n = this.nodes.size();
            for (int i = 0; i < n; ++i) {
                Vector child;
                DeclNode node = this.nodes.elementAt(i);
                if (node.getNodeType() != 45 || !(child = ((RecordDecl)node).getChildNames()).contains(s)) continue;
                parent = node;
                ((FieldDecl)newChild).setParentDecl(parent);
            }
            if (parent != null) {
                String name2 = parent.getNodeName();
                this.fieldDecls.put(name2 + "_" + s, newChild);
            }
            this.nodes.addElement(newChild);
        } else {
            this.nodes.addElement(newChild);
        }
    }

    public RecordDecl[] getRecordDecls() {
        int n = this.nodes.size();
        RecordDecl[] rec = new RecordDecl[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 45) continue;
            rec[k++] = (RecordDecl)node;
        }
        return rec;
    }

    public RecordDecl getRecordDecl(String name2) {
        Object decl = this.recordDecls.get(name2);
        if (decl != null) {
            return (RecordDecl)decl;
        }
        return null;
    }

    public FieldDecl getFieldDecl(String name2, DeclNode parent) {
        if (parent == null) {
            return null;
        }
        String p_name = parent.getNodeName();
        Object decl = this.fieldDecls.get(p_name + "_" + name2);
        if (decl != null) {
            return (FieldDecl)decl;
        }
        decl = this.fieldDecls.get(name2);
        if (decl != null) {
            return (FieldDecl)decl;
        }
        return null;
    }

    public DeclNode getElementDecl(String name2) {
        return null;
    }

    @Override
    public void write(Writer out) throws IOException {
        DeclNode node;
        int i;
        int n = this.nodes.size();
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            out.write(node.toString());
            out.write(eol);
        }
        for (i = 0; i < n; ++i) {
            String s;
            String attr;
            FixMetaData fd;
            node = this.nodes.elementAt(i);
            int type = node.getNodeType();
            if (type == 45) {
                fd = (FixMetaData)node.getDataTypeDecl();
                if (fd == null) {
                    fd = new FixMetaData();
                }
                RecordDecl rec = (RecordDecl)node;
                attr = "record=\"" + rec.getNodeName() + "\"";
                s = fd.getXML(attr);
                if (s == null) continue;
                out.write(s);
                out.write(eol);
                continue;
            }
            if (type != 43) continue;
            fd = (FixMetaData)node.getDataTypeDecl();
            if (fd == null) {
                fd = new FixMetaData();
            }
            FieldDecl field = (FieldDecl)node;
            attr = "field=\"" + field.getNodeName() + "\"";
            s = fd.getXML(attr);
            if (s == null) continue;
            out.write(s);
            out.write(eol);
        }
    }

    public DTDDocument transferToDTD(FixSchema schema) throws DTDException {
        DeclNode node;
        int i;
        StringBuffer sb = new StringBuffer();
        int n = this.nodes.size();
        boolean isRoot = true;
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            if (node.getNodeType() == 45) {
                StringBuffer sb1 = new StringBuffer();
                RecordDecl record = (RecordDecl)node;
                sb1.append(record.toString());
                sb1.replace(2, 8, "ELEMENT");
                sb1.append(eol);
                sb.append(sb1);
                continue;
            }
            if (node.getNodeType() != 43) continue;
            StringBuffer sb2 = new StringBuffer();
            FieldDecl field = (FieldDecl)node;
            sb2.append(field.toString());
            sb2.replace(2, 7, "ELEMENT");
            int m = sb2.length();
            sb2 = sb2.deleteCharAt(m - 1);
            sb2.append(' ');
            sb2.append("(#PCDATA)>");
            sb2.append(eol);
            sb.append(sb2);
        }
        for (i = 0; i < n; ++i) {
            node = this.nodes.elementAt(i);
            if (node.getNodeType() != 43) continue;
            FieldDecl field = (FieldDecl)node;
            FixMetaData dtData = (FixMetaData)field.getDataTypeDecl();
            String attr = "field=\"" + field.getNodeName() + "\"";
            String str = dtData.getXML(attr);
            StringBuffer sb3 = new StringBuffer();
            sb3.append(str);
            int fie = str.indexOf("field");
            sb3.replace(fie, fie + 5, "element");
            str = sb3.toString();
            int si = str.indexOf("size");
            int si1 = str.indexOf("\"", si);
            int si2 = str.indexOf("\"", si1 + 1);
            sb3.delete(si, si2 + 2);
            str = sb3.toString();
            int start = str.indexOf("start");
            int start1 = str.indexOf("\"", start);
            int start2 = str.indexOf("\"", start1 + 1);
            sb3.delete(start, start2 + 2);
            str = sb3.toString();
            int jus = str.indexOf("justified");
            int jus1 = str.indexOf("\"", jus);
            int jus2 = str.indexOf("\"", jus1 + 1);
            sb3.delete(jus, jus2 + 2);
            str = sb3.toString();
            int fil = str.indexOf("fillchar");
            int fil1 = str.indexOf("\"", fil);
            int fil2 = str.indexOf("\"", fil1 + 1);
            sb3.delete(fil, fil2 + 1);
            sb3.append(eol);
            sb.append(sb3);
        }
        String s = sb.toString();
        XReader dr = XReader.createReader(s.toCharArray(), null);
        DTDDocument dtd = new DTDDocument(this.name);
        dtd.parseDTDDecl(dr);
        return dtd;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public DeclNode getFirstChild() {
        if (this.nodes.size() <= 0) {
            return null;
        }
        return this.nodes.elementAt(0);
    }

    public DeclNode getLastChild() {
        if (this.nodes.size() <= 0) {
            return null;
        }
        return this.nodes.elementAt(this.nodes.size() - 1);
    }

    public DeclNodeList getSubRecordDecls(String record) {
        RecordDecl recdecl = (RecordDecl)this.recordDecls.get(record);
        if (recdecl == null) {
            return null;
        }
        return recdecl.getSubElementDecls();
    }

    @Override
    public String getNodeName() {
        String s = this.properties.getValue("name");
        if (s != null) {
            return s;
        }
        if (this.name != null) {
            return this.name;
        }
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 45) continue;
            return node.getNodeName();
        }
        return null;
    }

    public String getAbsolutePath(String[] names, char split) {
        int n = names.length;
        if (n < 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        DeclNode parentDecl = null;
        RecordDecl parentRecord = null;
        for (int i = 0; i < n; ++i) {
            String name2 = names[i];
            char c = '\u0000';
            parentDecl = this.getRecordDecl(name2);
            if (parentDecl != null) {
                sb.append(split);
                sb.append(name2);
                c = ((RecordDecl)parentDecl).getOccurrence();
                if (c != '\u0000') {
                    sb.append('[');
                    sb.append(c);
                    sb.append(']');
                }
                parentRecord = (RecordDecl)parentDecl;
                continue;
            }
            parentDecl = this.getFieldDecl(name2, parentRecord);
            if (parentDecl == null) break;
            sb.append(split);
            sb.append(name2);
        }
        return sb.toString();
    }

    public void resolveHierarchy() {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() == 45) {
                DeclNodeList list = ((RecordDecl)node).getSubElementDecls();
                int n1 = list.size();
                for (int j = 0; j < n1; ++j) {
                    DeclNode node1 = list.elementAt(j);
                    if (node1.getNodeType() == 45) {
                        RecordDecl rec = (RecordDecl)node1;
                        rec.addParentDecl(node);
                        continue;
                    }
                    if (node1.getNodeType() != 43) continue;
                    FieldDecl field = (FieldDecl)node1;
                    field.setParentDecl(node);
                    this.calculateStartPosition(field);
                }
                continue;
            }
            if (node.getNodeType() != 43) continue;
        }
        this.rootElement = null;
        if (this.name != null) {
            this.rootElement = (RecordDecl)this.recordDecls.get(this.name);
            if (this.rootElement != null) {
                this.rootElement.parent = null;
                return;
            }
            RecordDecl i = (RecordDecl)this.recordDecls.get(this.name);
        }
        RecordDecl first = null;
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            if (node.getNodeType() != 45 || node.getParentDecl() != null || first != null) continue;
            first = (RecordDecl)node;
            break;
        }
        if (first != null) {
            this.rootElement = first;
            this.rootElement.parent = null;
        } else {
            this.rootElement = null;
        }
    }

    public void calculateStartPosition(FieldDecl fieldDecl) {
        DeclNode parent = fieldDecl.getParentDecl();
        this.calculateStartPosition(fieldDecl, parent);
    }

    public void calculateStartPosition(FieldDecl fieldDecl, DeclNode parent) {
        String name2;
        if (fieldDecl == null || parent == null) {
            return;
        }
        if (parent.getNodeType() != 45) {
            return;
        }
        RecordDecl parentRecord = (RecordDecl)parent;
        Vector child = parentRecord.getChildNames();
        int c_count = child.size();
        int current_position = 0;
        RecordDecl childRecord = null;
        FieldDecl childField = null;
        FixMetaData chi_data = null;
        for (int i = 0; i < c_count && !(name2 = (String)child.elementAt(i)).equals(fieldDecl.getNodeName()); ++i) {
            childRecord = this.getRecordDecl(name2);
            if (childRecord != null) {
                chi_data = (FixMetaData)childRecord.getDataTypeDecl();
                if (chi_data == null) {
                    String s = MessageException.getMessage("INVALID_DATADECL");
                    Debug.println(childRecord.getNodeName() + s);
                    chi_data = new FixMetaData();
                }
                if (chi_data.rec_type == 1) {
                    int rlec = chi_data.reclength;
                    int repeat = chi_data.repeat;
                    current_position += rlec * repeat;
                }
            }
            if ((childField = this.getFieldDecl(name2, parent)) == null) continue;
            chi_data = (FixMetaData)childField.getDataTypeDecl();
            if (chi_data == null) {
                String s1 = MessageException.getMessage("INVALID_DATADECL");
                Debug.println(childField.getNodeName() + s1);
                chi_data = new FixMetaData();
            }
            current_position += chi_data.size;
        }
        FixMetaData currentData = (FixMetaData)fieldDecl.getDataTypeDecl();
        if (currentData == null) {
            String s = MessageException.getMessage("INVALID_DATADECL");
            Debug.println(fieldDecl.getNodeName() + s);
            currentData = new FixMetaData();
        }
        currentData.start = current_position + 1;
        currentData.allsize = currentData.start + currentData.size - 1;
    }

    public String getEncoding() {
        return this.properties.getValue("encoding");
    }

    public DeclNode getRootElement() {
        return this.rootElement;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties ps) {
        this.properties = ps;
    }

    public void putProperty(String name2, String value) {
        this.properties.repleace(name2, value);
    }

    public void putProperties(String name2, String value) {
        this.properties.repleace(name2, value);
    }

    public Document getOwnerDocument() {
        return this.doc;
    }

    public boolean hasChildNodes() {
        return this.nodes.size() > 0;
    }

    public void insertBefore(DeclNode newChild, DeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return;
        }
        this.insertBefore(newChild, index);
    }

    public void insertBefore(DeclNode newChild, int index) {
        if (index < 0) {
            return;
        }
        int type = newChild.getNodeType();
        if (type == 45) {
            String s = newChild.getNodeName();
            RecordDecl recdecl = (RecordDecl)this.recordDecls.get(s);
            this.recordDecls.put(s, newChild);
            this.nodes.insertElementAt(newChild, index);
        } else if (type == 43) {
            String s = newChild.getNodeName();
            FieldDecl fileddecl = (FieldDecl)this.fieldDecls.get(s);
            this.fieldDecls.put(s, newChild);
            this.nodes.insertElementAt(newChild, index);
        }
    }

    public void removeChild(DeclNode refChild) {
        int type = refChild.getNodeType();
        String s = refChild.getNodeName();
        if (type == 45) {
            this.recordDecls.remove(s);
            this.nodes.removeElement(refChild);
        } else if (type == 43) {
            this.fieldDecls.remove(s);
            this.nodes.removeElement(refChild);
        }
    }

    public String toString() {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            this.write(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public DeclNode getPreviousChild(DeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return null;
        }
        if (--index >= 0) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    public DeclNode getNextChild(DeclNode refChild) {
        int index = this.nodes.indexOf(refChild);
        if (index < 0) {
            return null;
        }
        if (++index < this.nodes.size()) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    @Override
    public DeclNodeList getAllDeclNode() {
        return this.nodes;
    }

    public Vector getAllDeclName() {
        int n = this.nodes.size();
        Vector<String> names = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            DeclNode decl = this.nodes.elementAt(i);
            names.addElement(decl.getNodeName());
        }
        return names;
    }

    public static void main(String[] args) {
        try {
            FixSchema schema = new FixSchema("MSG1");
            StringBuffer sb = new StringBuffer();
            sb.append("<!RECORD \u958b\u59cb\u5236\u5fa1\u6587 (field1,field2,\u30d8\u30c3\u30c0\u30fc*,\u7d42\u4e86\u5236\u5fa1\u96fb\u6587)>");
            sb.append(eol);
            sb.append("<!FIELD field1>");
            sb.append(eol);
            sb.append("<!FIELD field2>");
            sb.append(eol);
            sb.append("<!RECORD \u30d8\u30c3\u30c0\u30fc (\u30ec\u30b3\u30fc\u30c9\u533a\u5206,\u30c7\u30fc\u30bf\u533a\u5206,\u30c7\u30fc\u30bf\u65e5\u4ed8,\u4f1d\u7968\u30d8\u30c3\u30c0\u30fc+,\u5e97\u8217\u30a8\u30f3\u30c0\u30fc?,SPA_REC)>");
            sb.append(eol);
            sb.append("<!FIELD \u30ec\u30b3\u30fc\u30c9\u533a\u5206>");
            sb.append(eol);
            sb.append("<!FIELD \u30c7\u30fc\u30bf\u533a\u5206>");
            sb.append(eol);
            sb.append("<!FIELD \u30c7\u30fc\u30bf\u65e5\u4ed8>");
            sb.append(eol);
            sb.append("<!RECORD \u4f1d\u7968\u30d8\u30c3\u30c0\u30fc (\u30ec\u30b3\u30fc\u30c9\u533a\u5206,\u30c7\u30fc\u30bf\u533a\u5206,\u793e\u540d\u79f0)>");
            sb.append(eol);
            sb.append("<!FIELD \u30ec\u30b3\u30fc\u30c9\u533a\u5206>");
            sb.append(eol);
            sb.append("<!FIELD \u30c7\u30fc\u30bf\u533a\u5206>");
            sb.append(eol);
            sb.append("<!FIELD \u793e\u540d\u79f0>");
            sb.append(eol);
            sb.append("<!RECORD \u5e97\u8217\u30a8\u30f3\u30c0\u30fc (\u6700\u7d42\u884c\u533a\u5206)>");
            sb.append(eol);
            sb.append("<!FIELD \u6700\u7d42\u884c\u533a\u5206>");
            sb.append(eol);
            sb.append("<!RECORD \u7d42\u4e86\u5236\u5fa1\u96fb\u6587 (field3,field4)>");
            sb.append(eol);
            sb.append("<!FIELD field3>");
            sb.append(eol);
            sb.append("<!FIELD field4>");
            sb.append(eol);
            String s = sb.toString();
            XReader rd = XReader.createReader(s.toCharArray(), null);
            schema.parseSchemaDecl(rd);
            StringWriter sw = new StringWriter();
            schema.write(sw);
            System.out.println(sw.toString());
            DTDDocument dtd = schema.transferToDTD(schema);
            String s1 = dtd.toString();
            System.out.println(s1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
    }
}

