/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.gui.ImageLoader;
import com.argo21.common.io.Debug;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.CommentDecl;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.fix.FixDeclNodeData;
import com.argo21.msg.fix.FixDeclPanel;
import com.argo21.msg.fix.FixFieldDeclNodeData;
import com.argo21.msg.fix.FixFieldDeclPanel;
import com.argo21.msg.fix.FixMetaData;
import com.argo21.msg.fix.FixSchema;
import com.argo21.msg.fix.RecordDecl;
import com.argo21.msg.fix.RecordDeclNodeData;
import com.argo21.msg.fix.RecordDeclPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class FixSchemaEditor
extends DTDEditorPanel
implements SchemaEditor {
    public static final String CMD_NEW_RECORD = "RECORD";
    public static final String CMD_NEW_SUBRECORD = "SUB_RECORD";
    public static final String CMD_NEW_FIELD = "FIELD";
    static final String CMD_IMPORT_SCHEMA = "CMD_IMPORT";
    public static final int CAN_NEW_RECORD = 512;
    public static final int CAN_NEW_SUBRECORD = 128;
    public static final int CAN_NEW_FIELD = 256;
    private static final int MSG_SELECT_STATUS = 544;
    private static final int RECORD_SELECT_STATUS = 3488;
    private static final int FIELD_SELECT_STATUS = 3360;
    static String[] toolBarNames = new String[]{"RECORD", "SUB_RECORD", "FIELD", "COMMENT", "-", "NODECOPY", "REMOVE", "TOUP", "TODOWN"};
    static String[][] editMenus = new String[][]{{"RECORD", "E", null, null}, {"SUB_RECORD", "G", null, null}, {"FIELD", "F", null, null}, {"COMMENT", "M", null, null}, {"-", null, null, null}, {"NODECOPY", "C", null, "2:155"}, {"REMOVE", "D", null, String.valueOf(127)}, {"-", null, null, null}, {"FINDNODE", "F", null, "2:70"}, {"REFINDNODE", "R", null, String.valueOf(114)}, {"-", null, null, null}, {"TOUP", "U", null, null}, {"TODOWN", "W", null, null}, {"-", null, null, null}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    private Properties ps;
    private FixSchema schema;
    private Hashtable fieldData = new Hashtable(20);
    private SchemaEditor.NameChangedListener nameChangedListener = null;
    private SchemaEditor.ExceptionListener exceptionListener = null;
    private String defaultFilePath = null;
    private RecordDeclNodeData last_record = null;
    private FixFieldDeclNodeData last_field = null;
    private boolean hasRepeatRecord = false;
    private boolean hasField = false;

    public FixSchemaEditor() {
        super(null, true, false);
        this.registActionEx();
    }

    @Override
    public String getMsgType() {
        return "FIX";
    }

    @Override
    public String getMsgName() {
        return this.ps.getValue("name");
    }

    @Override
    public void close() {
        this.nameChangedListener = null;
        this.exceptionListener = null;
    }

    @Override
    protected void registContentsEditorPanel() {
        ContentsEditPanel panel = new FixDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(44, panel);
        panel = new RecordDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(45, panel);
        panel = new FixFieldDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(43, panel);
        String s = FixSchemaEditor.getPackageName(DTDEditorPanel.class) + ".";
        this.setContentsEditPanel(8, s + "CommentDeclPanel");
    }

    @Override
    protected void resetEditStatus() {
        DefaultMutableTreeNode selNode;
        if (this.status != 0) {
            this.status = 0;
            this.hasSetActionStatus = false;
        }
        if ((selNode = this.getSelectedTreeNode()) == null) {
            return;
        }
        if (!this.getContentsViewVisible()) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        int type = select.getNodeType();
        switch (type) {
            case 44: {
                this.status = 544;
                break;
            }
            case 45: {
                FixMetaData fmDecl = (FixMetaData)select.getDataTypeDecl();
                if (fmDecl.rec_type == 0) {
                    this.status = 3488;
                    break;
                }
                if (fmDecl.rec_type == 1) {
                    this.status = 3360;
                    break;
                }
            }
            case 43: {
                this.status = 3360;
                break;
            }
            default: {
                this.status = 3360;
            }
        }
        if (parent != null) {
            if (parent.getFirstChild() != selNode) {
                this.status |= 0x1000;
            }
            if (parent.getLastChild() != selNode) {
                this.status |= 0x2000;
            }
        }
        this.status |= 0x4000;
        this.status = !this.searchText.equals("") ? (this.status |= 0x8000) : (this.status ^= 0x8000);
        ((Action)this.actions.get(CMD_NEW_RECORD)).setEnabled((this.status & 0x200) != 0);
        ((Action)this.actions.get(CMD_NEW_SUBRECORD)).setEnabled((this.status & 0x80) != 0);
        ((Action)this.actions.get(CMD_NEW_FIELD)).setEnabled((this.status & 0x100) != 0);
        ((Action)this.actions.get("COMMENT")).setEnabled((this.status & 0x20) != 0);
        ((Action)this.actions.get("NODECOPY")).setEnabled((this.status & 0x400) != 0);
        ((Action)this.actions.get("REMOVE")).setEnabled((this.status & 0x800) != 0);
        ((Action)this.actions.get("TOUP")).setEnabled((this.status & 0x1000) != 0);
        ((Action)this.actions.get("TODOWN")).setEnabled((this.status & 0x2000) != 0);
        ((Action)this.actions.get("FINDNODE")).setEnabled((this.status & 0x4000) != 0);
        ((Action)this.actions.get("REFINDNODE")).setEnabled((this.status & 0x8000) != 0);
        this.hasSetActionStatus = true;
        if (this.toolBar != null) {
            this.setToolbarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void setToolbarStatus() {
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.toolBar.getComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    void setMenuStatus() {
        int n = this.menu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.menu.getMenuComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    @Override
    public void setNameChangedListener(SchemaEditor.NameChangedListener listener) {
        this.nameChangedListener = listener;
    }

    @Override
    public void setExceptionListener(SchemaEditor.ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    @Override
    public void setDefaultFilePath(String path) {
        this.defaultFilePath = path;
    }

    protected Frame getOwnerFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    @Override
    public void copyDeclNode() {
        DefaultMutableTreeNode parentnode;
        DeclNodeData parent_select;
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        if (selNode == this.treeModel.getRoot()) {
            return;
        }
        DeclNodeData selData = (DeclNodeData)selNode.getUserObject();
        DefaultMutableTreeNode node = null;
        if (selData.getNodeType() == 45) {
            return;
        }
        if (selData.getNodeType() == 43) {
            node = this.cloneFieldNode(selNode);
            if (node == null) {
                return;
            }
        } else {
            super.copyDeclNode();
            return;
        }
        String basename = selData.getNodeType() == 45 ? selData.getNodeName() + "_New_Field_" : ((parent_select = (DeclNodeData)(parentnode = (DefaultMutableTreeNode)selNode.getParent()).getUserObject()).getNodeType() == 45 ? parent_select.getNodeName() + "_New_Field_" : "New_Field_");
        int index = 1;
        int n = this.defaultNodes.size();
        String name2 = null;
        while (true) {
            name2 = basename + String.valueOf(index);
            boolean has = false;
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)this.defaultNodes.elementAt(i);
                DeclNodeData data1 = (DeclNodeData)node1.getUserObject();
                if (!data1.getNodeName().equals(name2)) continue;
                has = true;
                break;
            }
            if (!has) break;
            ++index;
        }
        DeclNodeData f_data = (DeclNodeData)node.getUserObject();
        f_data.setNodeName(name2);
        this.addToDefaultNode(node);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        int pos = this.treeModel.getIndexOfChild(parent, selNode);
        this.treeModel.insertNodeInto(node, parent, pos + 1);
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    DefaultMutableTreeNode cloneFieldNode(DefaultMutableTreeNode node) {
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        if (data.getNodeType() != 43) {
            return null;
        }
        FixFieldDeclNodeData f_data = (FixFieldDeclNodeData)data;
        FixFieldDeclNodeData f_data1 = (FixFieldDeclNodeData)f_data.clone();
        DefaultMutableTreeNode node1 = new DefaultMutableTreeNode(f_data1);
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            DeclNodeData c_data = (DeclNodeData)child.getUserObject();
            if (c_data.getNodeType() != 43) continue;
            node1.add(this.cloneFieldNode(child));
        }
        return node1;
    }

    public void addNewRecordDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        int type = select.getNodeType();
        DefaultMutableTreeNode node = null;
        if (type == 44) {
            boolean hasRootRecord = false;
            for (int i = 0; i < selNode.getChildCount(); ++i) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)selNode.getChildAt(i);
                DeclNodeData childData = (DeclNodeData)childNode.getUserObject();
                if (childData.getNodeType() != 45) continue;
                hasRootRecord = true;
                break;
            }
            if (!hasRootRecord) {
                String basename = "New_Record_";
                String name2 = this.getNewDefaultNodeName(basename);
                node = new DefaultMutableTreeNode(new RecordDeclNodeData(name2));
                this.addToDefaultNode(node);
                selNode.add(node);
                this.treeModel.nodeStructureChanged(selNode);
                this.setSelectedTreeNode(node);
                this.changeContents();
                return;
            }
        }
        if (node != null) {
            this.addToDefaultNode(node);
            this.setSelectedTreeNode(node);
        }
        this.changeContents();
    }

    public void addNewSubRecordDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        FixMetaData fmDecl = (FixMetaData)select.getDataTypeDecl();
        if (fmDecl.rec_type == 1) {
            return;
        }
        String basename = "New_Record_";
        String name2 = this.getNewDefaultNodeName(basename);
        int type = select.getNodeType();
        DefaultMutableTreeNode node = null;
        if (type == 45) {
            int k = selNode.getChildCount();
            node = new DefaultMutableTreeNode(new RecordDeclNodeData(name2));
            if (k == 0) {
                this.treeModel.insertNodeInto(node, selNode, selNode.getChildCount());
            } else {
                DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)selNode.getLastChild();
                int pos = this.treeModel.getIndexOfChild(selNode, node1);
                this.treeModel.insertNodeInto(node, selNode, pos + 1);
            }
        }
        if (node != null) {
            this.addToDefaultNode(node);
            this.setSelectedTreeNode(node);
        }
        this.changeContents();
    }

    public void addNewFieldDeclNode() {
        String basename;
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode parentnode = null;
        if (select.getNodeType() == 45) {
            basename = select.getNodeName() + "_New_Field_";
            parentnode = selNode;
        } else {
            parentnode = (DefaultMutableTreeNode)selNode.getParent();
            DeclNodeData parent_select = (DeclNodeData)parentnode.getUserObject();
            basename = parent_select.getNodeType() == 45 ? parent_select.getNodeName() + "_New_Field_" : "New_Field_";
        }
        String name2 = this.getNewDefaultNodeName(basename);
        int type = select.getNodeType();
        FixMetaData dt = new FixMetaData();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new FixFieldDeclNodeData(name2, dt));
        this.addToDefaultNode(node);
        if (type == 45) {
            this.treeModel.insertNodeInto(node, selNode, selNode.getChildCount());
        } else {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
            int pos = this.treeModel.getIndexOfChild(parent, selNode);
            this.treeModel.insertNodeInto(node, parent, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    @Override
    protected String getNewDefaultNodeName(String basename) {
        int index = 1;
        while (true) {
            boolean has = false;
            String name2 = basename + String.valueOf(index);
            DefaultMutableTreeNode root = this.getRoot();
            Enumeration<TreeNode> nodes = root.preorderEnumeration();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
                DeclNodeData data = (DeclNodeData)node.getUserObject();
                int type = data.getNodeType();
                if (type != 45 && type != 43 || !data.getNodeName().equals(name2)) continue;
                has = true;
                break;
            }
            if (!has) {
                return name2;
            }
            ++index;
        }
    }

    @Override
    public boolean hasNameWithoutSelect(String name2) {
        DefaultMutableTreeNode root = this.getRoot();
        Enumeration<TreeNode> nodes = root.preorderEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            int type = data.getNodeType();
            if (type != 45 && type != 43 || !data.getNodeName().equals(name2)) continue;
            return true;
        }
        return false;
    }

    protected void registActionEx() {
        AbstractAction a = new AbstractAction(CMD_NEW_RECORD, ImageLoader.load("record.gif", CMD_NEW_RECORD)){

            @Override
            public void actionPerformed(ActionEvent e) {
                FixSchemaEditor.this.addNewRecordDeclNode();
            }
        };
        String s = MessageException.getMessage("CMD_NEW_RECORD");
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_NEW_RECORD, a);
        a = new AbstractAction(CMD_NEW_SUBRECORD, ImageLoader.load("subrecord.gif", CMD_NEW_SUBRECORD)){

            @Override
            public void actionPerformed(ActionEvent e) {
                FixSchemaEditor.this.addNewSubRecordDeclNode();
            }
        };
        s = MessageException.getMessage("CMD_NEW_SUBRECORD");
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_NEW_SUBRECORD, a);
        a = new AbstractAction(CMD_NEW_FIELD, ImageLoader.load("field.gif", CMD_NEW_FIELD)){

            @Override
            public void actionPerformed(ActionEvent e) {
                FixSchemaEditor.this.addNewFieldDeclNode();
            }
        };
        s = MessageException.getMessage("CMD_NEW_FIELD");
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_NEW_FIELD, a);
    }

    @Override
    public Component getEditorPanel() {
        return this;
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
            this.setToolbarStatus();
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(editMenus);
            this.menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    FixSchemaEditor.this.setMenuStatus();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.setMenuStatus();
        }
        return this.menu;
    }

    @Override
    public Component getPopMenuComponent() {
        return this.tree;
    }

    @Override
    public Properties getProperties() throws MessageException {
        try {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            FixDeclNodeData rootdata = (FixDeclNodeData)root.getUserObject();
            return rootdata.getProperties();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    private void addSubRecord(DefaultMutableTreeNode treeNode, Vector child, FixSchema schema) throws MessageException {
        this.hasField = false;
        this.hasRepeatRecord = false;
        if (treeNode == null && schema == null) {
            return;
        }
        DefaultMutableTreeNode childTreeNode = null;
        DeclNodeData data = null;
        Vector recorddecl = new Vector();
        DeclNodeData parent_data = (DeclNodeData)treeNode.getUserObject();
        String parent_name = parent_data.getNodeName();
        int n = child.size();
        if (n < 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            String name2 = (String)child.elementAt(i);
            RecordDecl record = schema.getRecordDecl(name2);
            if (record != null) {
                data = new RecordDeclNodeData(record);
                this.last_record = data;
                FixMetaData dt = (FixMetaData)record.getDataTypeDecl();
                if (dt == null) {
                    dt = new FixMetaData();
                }
                ((RecordDeclNodeData)data).setDataTypeDecl(dt);
                ((RecordDeclNodeData)data).setOccurrence(record.getOccurrence());
                childTreeNode = new DefaultMutableTreeNode(data);
                treeNode.add(childTreeNode);
                if (dt.rec_type == 1) {
                    this.hasRepeatRecord = true;
                }
                Vector<Cloneable> v = new Vector<Cloneable>();
                v.addElement(childTreeNode);
                v.addElement(record.childrenNames);
                recorddecl.addElement(v);
                continue;
            }
            RecordDecl parent = schema.getRecordDecl(parent_name);
            FieldDecl field = schema.getFieldDecl(name2, parent);
            if (field == null) continue;
            data = new FixFieldDeclNodeData(field);
            this.last_field = (FixFieldDeclNodeData)data;
            FixMetaData dt = (FixMetaData)field.getDataTypeDecl();
            if (dt == null) {
                dt = new FixMetaData();
                this.fieldData.put(name2, dt);
            }
            ((FixFieldDeclNodeData)data).setDataTypeDecl(dt);
            childTreeNode = new DefaultMutableTreeNode(data);
            treeNode.add(childTreeNode);
            this.hasField = true;
        }
        if (this.hasField) {
            this.checkSize(treeNode);
        }
        DeclNodeData data1 = (DeclNodeData)treeNode.getUserObject();
        DataTypeDecl dtData = data1.getDataTypeDecl();
        FixMetaData metaData = (FixMetaData)dtData;
        String condition = metaData.condition;
        if (metaData.rec_type == 0 && (condition == null || condition.equals("") || condition.length() == 0)) {
            String s = MessageException.getMessage("INVALID_CONDITION");
            Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + parent_name + ">" + s);
        }
        int m = recorddecl.size();
        for (int i = 0; i < m; ++i) {
            Vector v1 = new Vector();
            v1 = (Vector)recorddecl.elementAt(i);
            this.addSubRecord((DefaultMutableTreeNode)v1.elementAt(0), (Vector)v1.elementAt(1), schema);
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        this.treeModel.nodeStructureChanged(root);
        this.changeContents();
        this.hasField = false;
    }

    @Override
    public void load(Properties params, Properties ps, Object fixschema) throws MessageException {
        this.schema = (FixSchema)fixschema;
        this.ps = ps.cloneProperties();
        DeclNodeList nodes = this.schema.getAllDeclNode();
        if (nodes.size() != 0) {
            String name2 = ps.getValue("name");
            String direction = ps.getValue("direction");
            if (direction.equals("INPUT")) {
                String ids = ps.getValue("id1_start");
                String ide = ps.getValue("id1_size");
                if (ids == null || ide == null || ids.equals("") || ide.equals("") || ids.length() == 0 || ide.length() == 0) {
                    String s = MessageException.getMessage("NEED_ID");
                    Debug.println("<MSG\u540d\uff1a " + name2 + ">" + s);
                }
            }
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        Object rootName = null;
        root.removeAllChildren();
        this.defaultNodes.removeAllElements();
        if (this.schema == null) {
            this.treeModel.nodeStructureChanged(root);
            this.tree.expandRow(0);
            this.tree.setSelectionRow(0);
            this.dtdChanged = false;
            return;
        }
        FixDeclNodeData rootdata = new FixDeclNodeData(ps);
        root.setUserObject(rootdata);
        this.schema.resolveHierarchy();
        RecordDecl rootElement = (RecordDecl)this.schema.getRootElement();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = nodes.elementAt(i);
            int nodetype = node.getNodeType();
            DefaultMutableTreeNode treeNode = null;
            switch (nodetype) {
                case 45: {
                    RecordDecl record = (RecordDecl)node;
                    DeclNode parent = record.getParentDecl();
                    if (parent != null) break;
                    DeclNodeData userdata = new RecordDeclNodeData(record);
                    DataTypeDecl dt = record.getDataTypeDecl();
                    if (dt == null) {
                        FixMetaData meta = new FixMetaData();
                        dt = meta;
                    }
                    ((RecordDeclNodeData)userdata).setDataTypeDecl(dt);
                    ((RecordDeclNodeData)userdata).setOccurrence(record.getOccurrence());
                    treeNode = new DefaultMutableTreeNode(userdata);
                    if (treeNode != null) {
                        root.add(treeNode);
                    }
                    this.addSubRecord(treeNode, record.childrenNames, this.schema);
                    break;
                }
                case 8: {
                    DeclNodeData userdata;
                    String s = ((CommentDecl)node).getComment();
                    if (s == null) {
                        s = "";
                    }
                    if ((treeNode = new DefaultMutableTreeNode(userdata = new DeclNodeData(8, "COMMENT", s))) == null) break;
                    root.add(treeNode);
                }
            }
            this.treeModel.nodeStructureChanged(root);
        }
        this.tree.setModel(this.treeModel);
        this.tree.expandRow(0);
        this.tree.setSelectionRow(0);
        this.setStructViewVisible(true);
        this.setContentsViewVisible(true);
        this.dtdChanged = false;
        this.resetEditStatus();
    }

    @Override
    public Object getSchema() throws MessageException {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        FixDeclNodeData rootdata = (FixDeclNodeData)root.getUserObject();
        this.schema = new FixSchema();
        Properties ps = rootdata.getProperties();
        int i = root.getChildCount();
        if (i > 0) {
            String name2 = ps.getValue("name");
            String direction = ps.getValue("direction");
            if (direction.equals("INPUT")) {
                String ids = ps.getValue("id1_start");
                String ide = ps.getValue("id1_size");
                if (ids == null || ide == null || ids.equals("") || ide.equals("") || ids.length() == 0 || ide.length() == 0) {
                    String s = MessageException.getMessage("NEED_ID");
                    Debug.println("<MSG\u540d\uff1a " + name2 + ">" + s);
                }
            }
        }
        this.schema.setProperties(ps);
        DefaultMutableTreeNode rootNode = null;
        int count2 = root.getChildCount();
        block4: for (i = 0; i < count2; ++i) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)root.getChildAt(i);
            DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
            int nodetype = userobj.getNodeType();
            switch (nodetype) {
                case 45: {
                    if (rootNode != null) continue block4;
                    rootNode = currentNode;
                    this.createDeclNode(this.schema, rootNode);
                    continue block4;
                }
                case 8: {
                    CommentDeclNode declnode = new CommentDeclNode(this.schema, (String)userobj.getNodeValue());
                    this.schema.appendChild(declnode);
                }
            }
        }
        return this.schema;
    }

    private void createDeclNode(FixSchema schema, DefaultMutableTreeNode treenode) throws MessageException {
        this.hasRepeatRecord = false;
        this.hasField = false;
        FixFieldDeclNodeData last_field1 = null;
        boolean hasField1 = false;
        DeclNodeData userobj = (DeclNodeData)treenode.getUserObject();
        int n = treenode.getChildCount();
        String nodename = userobj.getNodeName();
        DefaultMutableTreeNode currentNode = null;
        DeclNodeData userobj1 = null;
        DeclNode declnode = null;
        Vector<String[]> v = new Vector<String[]>();
        Vector fc = new Vector();
        for (int i = 0; i < n; ++i) {
            currentNode = (DefaultMutableTreeNode)treenode.getChildAt(i);
            userobj1 = (DeclNodeData)currentNode.getUserObject();
            int type = userobj1.getNodeType();
            String[] ps = new String[2];
            switch (type) {
                case 45: {
                    RecordDeclNodeData r_data = (RecordDeclNodeData)userobj1;
                    ps[0] = r_data.getNodeName();
                    ps[1] = String.valueOf((char)r_data.getOccurrence());
                    break;
                }
                case 43: {
                    FixFieldDeclNodeData f_data = (FixFieldDeclNodeData)userobj1;
                    ps[0] = f_data.getNodeName();
                    ps[1] = String.valueOf('\u0000');
                }
            }
            v.addElement(ps);
        }
        RecordDecl rootRec = new RecordDecl((DeclNode)schema, nodename, v);
        RecordDeclNodeData recordobj = (RecordDeclNodeData)userobj;
        FixMetaData dtData = (FixMetaData)recordobj.getDataTypeDecl();
        rootRec.setDataTypeDecl(dtData);
        rootRec.setOccurrence((char)recordobj.getOccurrence());
        schema.appendChild(rootRec);
        if (dtData != null) {
            String condition = dtData.condition;
            if (dtData.rec_type == 0 && (condition == null || condition.equals("") || condition.length() == 0)) {
                String s = MessageException.getMessage("INVALID_CONDITION");
                Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + nodename + ">" + s);
            }
        }
        block10: for (int i = 0; i < n; ++i) {
            currentNode = (DefaultMutableTreeNode)treenode.getChildAt(i);
            userobj1 = (DeclNodeData)currentNode.getUserObject();
            int type = userobj1.getNodeType();
            String[] ps = new String[2];
            FixMetaData metadata = null;
            switch (type) {
                case 45: {
                    RecordDeclNodeData r_data;
                    this.last_record = r_data = (RecordDeclNodeData)userobj1;
                    ps[0] = r_data.getNodeName();
                    ps[1] = String.valueOf((char)r_data.getOccurrence());
                    metadata = (FixMetaData)r_data.getDataTypeDecl();
                    if (metadata == null) {
                        metadata = new FixMetaData();
                    }
                    this.createDeclNode(schema, currentNode);
                    if (metadata.rec_type != 1) continue block10;
                    this.hasRepeatRecord = true;
                    continue block10;
                }
                case 43: {
                    FixFieldDeclNodeData f_data;
                    this.last_field = f_data = (FixFieldDeclNodeData)userobj1;
                    last_field1 = f_data;
                    declnode = new FieldDecl((DeclNode)schema, f_data.getNodeName());
                    metadata = (FixMetaData)f_data.getDataTypeDecl();
                    if (dtData == null) {
                        metadata = new FixMetaData();
                    }
                    ((FieldDecl)declnode).setDataTypeDecl(metadata);
                    schema.appendChild(declnode);
                    schema.calculateStartPosition((FieldDecl)declnode, rootRec);
                    this.hasField = true;
                    hasField1 = true;
                    continue block10;
                }
                case 8: {
                    declnode = new CommentDeclNode(schema, (String)userobj.getNodeValue());
                    schema.appendChild(declnode);
                }
            }
        }
        this.last_field = last_field1;
        this.hasField = hasField1;
        if (this.hasField) {
            this.checkSize(treenode);
        }
    }

    protected void checkSize(DefaultMutableTreeNode node) throws MessageException {
        String s;
        String name2;
        RecordDeclNodeData r_lastdata;
        FixMetaData fix_Data;
        DataTypeDecl dtData = null;
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        if (data.getNodeType() != 45) {
            return;
        }
        dtData = data.getDataTypeDecl();
        if (dtData == null) {
            return;
        }
        FixMetaData last_field_data = (FixMetaData)this.last_field.getDataTypeDecl();
        if (last_field_data == null) {
            return;
        }
        DefaultMutableTreeNode lastChild = (DefaultMutableTreeNode)node.getLastChild();
        DefaultMutableTreeNode lastChild1 = lastChild.getPreviousSibling();
        DeclNodeData lastdata = (DeclNodeData)lastChild.getUserObject();
        int last_type = lastdata.getNodeType();
        DeclNodeData lastdata1 = null;
        int last_type1 = 0;
        if (lastChild1 != null) {
            lastdata1 = (DeclNodeData)lastChild1.getUserObject();
            last_type1 = lastdata1.getNodeType();
        }
        FixMetaData fix_dtData = (FixMetaData)dtData;
        int all_field = 0;
        if (last_type == 43) {
            FixFieldDeclNodeData f_lastdata = (FixFieldDeclNodeData)lastdata;
            FixMetaData meta = (FixMetaData)f_lastdata.getDataTypeDecl();
            if (meta != null) {
                all_field = meta.allsize;
            }
        } else if (last_type == 45 && (fix_Data = (FixMetaData)(r_lastdata = (RecordDeclNodeData)lastdata).getDataTypeDecl()) != null && this.last_field != null) {
            if (fix_Data.rec_type == 1) {
                int recl = fix_Data.reclength;
                int repeat = fix_Data.repeat;
                all_field = recl * repeat + last_field_data.allsize;
            } else if (fix_Data.rec_type == 0) {
                if (this.hasRepeatRecord && lastChild != null) {
                    if (last_type1 == 45) {
                        RecordDeclNodeData r_lastdata1 = (RecordDeclNodeData)lastdata1;
                        FixMetaData repeat_data = (FixMetaData)r_lastdata1.getDataTypeDecl();
                        if (repeat_data.rec_type == 1) {
                            int recl = repeat_data.reclength;
                            int repeat = repeat_data.repeat;
                            all_field = recl * repeat + last_field_data.allsize;
                        } else {
                            all_field = last_field_data.allsize;
                        }
                    } else {
                        all_field = last_field_data.allsize;
                    }
                } else {
                    all_field = last_field_data.allsize;
                }
            }
        }
        if (all_field > fix_dtData.reclength) {
            name2 = data.getNodeName();
            s = MessageException.getMessage("INVALID_FIELDSIZE");
            Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + name2 + ">" + s);
        } else if (all_field < fix_dtData.reclength) {
            name2 = data.getNodeName();
            s = MessageException.getMessage("INVALID_FIELDSIZE_S");
            Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + name2 + ">" + s);
        }
    }

    boolean msgNameChanged(String oldName, String newName) {
        if (this.nameChangedListener != null) {
            return this.nameChangedListener.nameChanged(oldName, newName);
        }
        return true;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = MessageException.msgCatalog.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            menuItem.setFont(font);
            if (items[i][3] == null) continue;
            try {
                String sk = items[i][3];
                int k = sk.indexOf(":");
                if (k >= 0) {
                    int mask = Integer.parseInt(sk.substring(0, k));
                    int keyid = Integer.parseInt(sk.substring(k + 1));
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    continue;
                }
                int keyid = Integer.parseInt(sk);
                menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return menu;
    }
}

