/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.io.Debug;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.vdtd.DTDDeclNodeData;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaViewer;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.fix.FixDeclNodeData;
import com.argo21.msg.fix.FixFieldDeclNodeData;
import com.argo21.msg.fix.FixMetaData;
import com.argo21.msg.fix.FixSchema;
import com.argo21.msg.fix.RecordDecl;
import com.argo21.msg.fix.RecordDeclNodeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;

public class FixSchemaViewer
extends JTree
implements SchemaViewer {
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    private Font defaultFont;
    private FixSchema schema = null;
    private DefaultTreeModel treeModel = null;
    boolean selectChanged = false;
    String msgname;
    private RecordDeclNodeData last_record = null;
    private FixFieldDeclNodeData last_field = null;
    private boolean hasRepeatRecord = false;
    private boolean hasField = false;

    public FixSchemaViewer(FixSchema schema) throws SAXException {
        this();
        this.load(null, schema);
    }

    public FixSchemaViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception e) {
            this.defaultFont = this.getFont();
        }
        FixDeclNodeData rootdata = new FixDeclNodeData("DEFAULT-ROOT");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        this.setCellRenderer(new MyTreeCellRenderer());
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this);
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Component getDragComponent() {
        return this;
    }

    @Override
    public String getSelectedText() {
        return this.getAbsolutePathOfSelect();
    }

    @Override
    public boolean dragStart(Component source, int x, int y) {
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return true;
    }

    @Override
    public boolean dragOver(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDrop(path);
    }

    @Override
    public boolean drop(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDrop(path);
    }

    boolean canDrop(TreePath path) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        if (userobj.getNodeType() == 45) {
            return false;
        }
        if (userobj.getNodeType() == 43) {
            FixFieldDeclNodeData decl = (FixFieldDeclNodeData)userobj;
            return true;
        }
        return true;
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public String getMsgType() {
        return "FIX";
    }

    public void setSchema(FixSchema schema) {
        boolean hasField = false;
        this.schema = schema;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Object rootName = null;
        root.removeAllChildren();
        if (schema != null) {
            schema.resolveHierarchy();
            RecordDecl record = (RecordDecl)schema.getRootElement();
            if (record != null) {
                RecordDeclNodeData rootdata = new RecordDeclNodeData(record);
                DynamicTreeNode treeNode = new DynamicTreeNode(rootdata);
                this.treeModel = new DefaultTreeModel(treeNode);
                this.setModel(this.treeModel);
                root = (DefaultMutableTreeNode)this.treeModel.getRoot();
                this.treeModel.nodeChanged(root);
                this.invalidate();
                FixMetaData meta = (FixMetaData)((DeclNodeData)rootdata).getDataTypeDecl();
                if (meta.reclength != 0) {
                    hasField = true;
                }
            }
            if (record == null) {
                DeclNodeList nodes = schema.getAllDeclNode();
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                }
            }
        } else {
            this.treeModel.nodeStructureChanged(root);
            this.setSelectionRow(0);
            return;
        }
        this.treeModel.nodeStructureChanged(root);
        Hashtable elemTab = new Hashtable();
        try {
            this.expandAllSubNode(root, elemTab, hasField);
        }
        catch (MessageException me) {
            Debug.println(me.toString());
        }
        this.setSelectionRow(0);
    }

    @Override
    public void load(Properties ps, Object schema) throws SAXException {
        String direction;
        this.msgname = ps.getValue("name");
        DeclNodeList nodes = ((FixSchema)schema).getAllDeclNode();
        if (nodes.size() > 0 && (direction = ps.getValue("direction")).equals("INPUT")) {
            String ids = ps.getValue("id1_start");
            String ide = ps.getValue("id1_size");
            if (ids == null || ide == null || ids.equals("") || ide.equals("") || ids.length() == 0 || ide.length() == 0) {
                String s = MessageException.getMessage("NEED_ID");
                Debug.println("<MSG\u540d\uff1a " + this.msgname + ">" + s);
            }
        }
        this.setSchema((FixSchema)schema);
    }

    public String getAbsolutePathOfSelect() {
        if (this.schema == null) {
            return null;
        }
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        int n = sel.getPathCount();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            DeclNodeData userobj = (DeclNodeData)node.getUserObject();
            names[i] = userobj.getNodeName();
        }
        return this.msgname + this.schema.getAbsolutePath(names, '/');
    }

    public void treeNodeSelected(TreeSelectionEvent e) {
        this.selectChanged = true;
    }

    public TreePath getSelectedPath() {
        return this.getSelectionPath();
    }

    public String[] getSelectedPathNames() {
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return new String[0];
        }
        int n = sel.getPathCount();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            DeclNodeData userobj = (DeclNodeData)node.getUserObject();
            names[i] = userobj.getNodeName();
        }
        return names;
    }

    public DeclNode getSelectedNodeDecl() {
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)sel.getLastPathComponent();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)currentNode.getParent();
        DeclNodeData parentData = (DeclNodeData)parentNode.getUserObject();
        String parent_name = parentData.getNodeName();
        RecordDecl parentnode = this.schema.getRecordDecl(parent_name);
        DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        String name2 = userobj.getNodeName();
        Object declnode = null;
        switch (nodetype) {
            case 45: {
                return this.schema.getRecordDecl(name2);
            }
            case 43: {
                return this.schema.getFieldDecl(name2, parentnode);
            }
        }
        return null;
    }

    private void expandAllSubNode(DefaultMutableTreeNode node, Hashtable elemTab) throws MessageException {
        this.expandAllSubNode(node, elemTab, true);
    }

    private void expandAllSubNode(DefaultMutableTreeNode node, Hashtable elemTab, boolean Field2) throws MessageException {
        this.expandPath(new TreePath(node.getPath()));
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        DataTypeDecl dtData = data.getDataTypeDecl();
        if (dtData == null) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
            if (parent == null) {
                return;
            }
            MessageException.error(data.getNodeName() + "INVALID_DATADECL", new Object[0], null);
        }
        int type = data.getNodeType();
        if (data.getNodeType() == 45) {
            String name2;
            if (Field2) {
                this.checkSize(node);
            }
            if (!elemTab.containsKey(name2 = data.getNodeName())) {
                elemTab.put(name2, data);
                int n = node.getChildCount();
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandAllSubNode(sub, elemTab);
                }
                elemTab.remove(name2);
            }
            FixMetaData metaData = (FixMetaData)dtData;
            String condition = metaData.condition;
            if (metaData.rec_type == 0 && (condition == null || condition.equals("") || condition.length() == 0)) {
                String s = MessageException.getMessage("INVALID_CONDITION");
                Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + data.getNodeName() + ">" + s);
            }
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    public FixDeclNodeData getRootData() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        return (FixDeclNodeData)root.getUserObject();
    }

    public void setRootData(DTDDeclNodeData data) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        root.setUserObject(data);
        this.treeModel.nodeChanged(root);
    }

    protected void checkSize(DefaultMutableTreeNode node) throws MessageException {
        String s;
        RecordDeclNodeData r_lastdata;
        FixMetaData fix_Data;
        DataTypeDecl dtData = null;
        DeclNodeData data = (DeclNodeData)node.getUserObject();
        if (data.getNodeType() != 45) {
            return;
        }
        dtData = data.getDataTypeDecl();
        if (dtData == null) {
            MessageException.error("INVALID_DATADECL", new Object[0], null);
        }
        FixMetaData last_field_data = null;
        if (this.last_field == null) {
            return;
        }
        last_field_data = (FixMetaData)this.last_field.getDataTypeDecl();
        DefaultMutableTreeNode lastChild = (DefaultMutableTreeNode)node.getLastChild();
        DefaultMutableTreeNode lastChild1 = lastChild.getPreviousSibling();
        DeclNodeData lastdata = (DeclNodeData)lastChild.getUserObject();
        int last_type = lastdata.getNodeType();
        DeclNodeData lastdata1 = null;
        int last_type1 = 0;
        if (lastChild1 != null) {
            lastdata1 = (DeclNodeData)lastChild1.getUserObject();
            last_type1 = lastdata1.getNodeType();
        }
        FixMetaData fix_dtData = (FixMetaData)dtData;
        int all_field = 0;
        if (last_type == 43) {
            FixFieldDeclNodeData f_lastdata = (FixFieldDeclNodeData)lastdata;
            FixMetaData meta = (FixMetaData)f_lastdata.getDataTypeDecl();
            all_field = meta.allsize;
        } else if (last_type == 45 && (fix_Data = (FixMetaData)(r_lastdata = (RecordDeclNodeData)lastdata).getDataTypeDecl()) != null && this.last_field != null) {
            if (fix_Data.rec_type == 1) {
                int recl = fix_Data.reclength;
                int repeat = fix_Data.repeat;
                all_field = recl * repeat + last_field_data.allsize;
            } else if (fix_Data.rec_type == 0) {
                if (this.hasRepeatRecord && lastChild != null) {
                    if (last_type1 == 45) {
                        RecordDeclNodeData r_lastdata1 = (RecordDeclNodeData)lastdata1;
                        FixMetaData repeat_data = (FixMetaData)r_lastdata1.getDataTypeDecl();
                        if (repeat_data.rec_type == 1) {
                            int recl = repeat_data.reclength;
                            int repeat = repeat_data.repeat;
                            all_field = recl * repeat + last_field_data.allsize;
                        } else {
                            all_field = last_field_data.allsize;
                        }
                    } else {
                        all_field = last_field_data.allsize;
                    }
                } else {
                    all_field = last_field_data.allsize;
                }
            }
        }
        String name2 = data.getNodeName();
        if (all_field > fix_dtData.reclength) {
            s = MessageException.getMessage("INVALID_FIELDSIZE");
            Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + name2 + ">" + s);
        } else if (all_field < fix_dtData.reclength) {
            s = MessageException.getMessage("INVALID_FIELDSIZE_S");
            Debug.println("<\u30ec\u30b3\u30fc\u30c9\u540d\uff1a " + name2 + ">" + s);
        }
    }

    void addSubNodesTo(DefaultMutableTreeNode parent) {
        this.hasField = false;
        DeclNodeData data = (DeclNodeData)parent.getUserObject();
        DataTypeDecl dtData = data.getDataTypeDecl();
        int type = data.getNodeType();
        String name2 = data.getNodeName();
        if (type == 45) {
            RecordDecl decl = this.schema.getRecordDecl(name2);
            if (name2 == null) {
                return;
            }
            DeclNodeList list = decl.getSubElementDecls();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                DataTypeDecl dt;
                DeclNodeData data1;
                DeclNode node = list.item(i);
                int type1 = node.getNodeType();
                if (type1 == 45) {
                    data1 = new RecordDeclNodeData((RecordDecl)list.item(i));
                    parent.add(new DynamicTreeNode(data1));
                    this.last_record = data1;
                    dt = (FixMetaData)data1.getDataTypeDecl();
                    if (dt == null || dt.rec_type != 1) continue;
                    this.hasRepeatRecord = true;
                    continue;
                }
                if (type1 != 43) continue;
                data1 = new FixFieldDeclNodeData((FieldDecl)list.item(i));
                parent.add(new DynamicTreeNode(data1));
                this.last_field = (FixFieldDeclNodeData)data1;
                dt = data1.getDataTypeDecl();
                this.hasField = true;
            }
        }
    }

    DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    void setSelectedTreeNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    class DynamicTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasLoaded;

        public DynamicTreeNode(Object obj) {
            super(obj);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            if (!this.hasLoaded) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.hasLoaded = true;
            FixSchemaViewer.this.addSubNodesTo(this);
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof DeclNodeData) {
                this.setIcon(((DeclNodeData)userObject).getImageIcon());
            }
            this.setFont(FixSchemaViewer.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

