/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.DeclNodeListImpl;
import com.argo21.msg.MessageException;
import com.argo21.msg.csv.FieldDecl;
import com.argo21.msg.fix.FixSchema;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Locator;

public class RecordDecl
implements DeclNode {
    public static final String PROPERTY_RECTYPE = "rec_type";
    public static final String PROPERTY_OCCURRENCE = "occurrence";
    public static final String PROPERTY_LENGTH = "lrecl";
    public static final String PROPERTY_CONDITION = "condition";
    public static final String PROPERTY_REPEAT = "repeat";
    public static final String PROPERTY_SKIP = "skip";
    String name;
    int rec_type = 0;
    char occurrence;
    int reclength;
    String condition = null;
    int repeat = 0;
    String skip = null;
    DeclNode owner = null;
    Vector childrenNames = new Vector();
    Vector children = new Vector();
    String[] decl = new String[2];
    Properties ps;
    DeclNode parent = null;
    DataTypeDecl dtData = null;
    private XReader in = null;

    public RecordDecl(DeclNode owner, String name2, Vector children) {
        this.owner = owner;
        this.name = name2;
        this.children = children;
        int n = children.size();
        for (int i = 0; i < n; ++i) {
            String[] s = new String[2];
            s = (String[])children.elementAt(i);
            if (this.childrenNames.contains(s[0])) continue;
            this.childrenNames.addElement(s[0]);
        }
    }

    protected RecordDecl(DeclNode owner, String name2, char[] contentspec) throws MessageException {
        this.owner = owner;
        this.name = name2;
        this.in = XReader.createReader(contentspec, null);
        this.parseDeclContent();
        this.in = null;
    }

    protected RecordDecl(DeclNode owner, XReader in) throws IOException, MessageException {
        this.owner = owner;
        this.in = in;
        in.peekWhitespace();
        this.name = in.peekXmlName();
        if (this.name != null) {
            if (!in.peekWhitespace()) {
                MessageException.error("NEED_CHAR", ">", (Locator)in);
            }
            this.parseDeclContent();
        } else {
            MessageException.error("NEED_NAME_AFTER", "<!RECORD ", (Locator)in);
        }
        this.in = null;
    }

    public Properties getProperties() {
        String s = String.valueOf(this.rec_type);
        this.ps.append(PROPERTY_RECTYPE, s);
        s = String.valueOf(this.occurrence);
        this.ps.append(PROPERTY_OCCURRENCE, s);
        s = String.valueOf(this.reclength);
        this.ps.append(PROPERTY_LENGTH, s);
        this.ps.append(PROPERTY_CONDITION, this.condition);
        s = String.valueOf(this.repeat);
        this.ps.append(PROPERTY_REPEAT, s);
        this.ps.append(PROPERTY_SKIP, this.skip);
        return this.ps;
    }

    public String getName() {
        return this.name;
    }

    public char getOccurrence() {
        return this.occurrence;
    }

    public void setOccurrence(char occurrence) {
        this.occurrence = occurrence;
    }

    @Override
    public int getNodeType() {
        return 45;
    }

    @Override
    public String getNodeTypeName() {
        return "Record";
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return this.dtData;
    }

    @Override
    public DeclNode getParentDecl() {
        if (this.parent == null) {
            return null;
        }
        return this.parent;
    }

    public boolean hasSubElementDecl() {
        return true;
    }

    public boolean hasSubElementDecls() {
        int n = this.children.size();
        return n > 0;
    }

    public DeclNode getSubElementDecl(String name2) {
        if (this.owner == null) {
            return null;
        }
        int n = this.childrenNames.size();
        for (int i = 0; i < n; ++i) {
            String[] child = (String[])this.children.get(i);
            RecordDecl rec = ((FixSchema)this.owner).getRecordDecl(child[0]);
            if (rec != null) {
                return rec;
            }
            FieldDecl field = ((FixSchema)this.owner).getFieldDecl(child[0], this);
            if (field == null) continue;
            return field;
        }
        return null;
    }

    public DeclNodeList getSubElementDecls() {
        int n = this.childrenNames.size();
        DeclNodeListImpl list = new DeclNodeListImpl(n);
        for (int i = 0; i < n; ++i) {
            String child = (String)this.childrenNames.elementAt(i);
            RecordDecl rec = ((FixSchema)this.owner).getRecordDecl(child);
            if (rec != null) {
                list.addElement(rec);
                continue;
            }
            FieldDecl field = ((FixSchema)this.owner).getFieldDecl(child, this);
            if (field == null) continue;
            list.addElement(field);
        }
        return list;
    }

    public char getSubElementOccurrence(String childname) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            String[] decl = new String[2];
            decl = (String[])this.children.elementAt(i);
            if (!decl[0].equalsIgnoreCase(childname)) continue;
            if (decl[1].equals("*")) {
                return '*';
            }
            if (decl[1].equals("+")) {
                return '+';
            }
            if (decl[1].equals("?")) {
                return '?';
            }
            return '\u0000';
        }
        return '\u0000';
    }

    public void addParentDecl(DeclNode rec) {
        this.parent = rec;
    }

    public boolean insertChild(String tagname, String refname) {
        return true;
    }

    public boolean removeChild(String tagname) {
        return true;
    }

    public boolean containsTag(String name2) {
        if (this.children == null) {
            return false;
        }
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            RecordDecl record;
            String rec = (String)this.childrenNames.elementAt(i);
            if (rec.equalsIgnoreCase(name2)) {
                return true;
            }
            DeclNode node = this.getSubElementDecl(rec);
            if (!(node instanceof RecordDecl) || !(record = (RecordDecl)node).containsTag(name2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DeclNode getOwner() {
        return this.owner;
    }

    public void setDataTypeDecl(DataTypeDecl dtDecl) {
        this.dtData = dtDecl;
    }

    private boolean parseDeclContent() throws MessageException {
        if (!this.in.peekc('(')) {
            return false;
        }
        this.in.peekWhitespace();
        Vector v = new Vector();
        v = this.parseCp(this.in);
        this.addSubElement(v);
        this.in.peekWhitespace();
        if (this.in.isChar(')')) {
            this.in.skip(1);
            return true;
        }
        if (this.in.isChar(',')) {
            while (this.in.peekc(',')) {
                this.in.peekWhitespace();
                v = new Vector();
                v = this.parseCp(this.in);
                this.addSubElement(v);
                this.in.peekWhitespace();
            }
        } else if (this.in.isChar('|')) {
            while (this.in.peekc('|')) {
                this.in.peekWhitespace();
                v = new Vector();
                v = this.parseCp(this.in);
                this.addSubElement(v);
                this.in.peekWhitespace();
            }
        } else {
            return false;
        }
        return this.in.peekc(')');
    }

    protected Vector parseCp(XReader in) throws MessageException {
        Vector<String> dec = new Vector<String>(2);
        if (!in.isChar('(')) {
            String tag = in.peekXmlName();
            if (tag == null) {
                return null;
            }
            if (this.childrenNames.contains(tag)) {
                MessageException.error("DOUBLE_NAME", tag, (Locator)in);
            }
            dec.addElement(tag);
            this.childrenNames.addElement(tag);
            char temp = this.getFrequency(in);
            String occurrence = String.valueOf(temp);
            dec.addElement(occurrence);
        }
        return dec;
    }

    private char getFrequency(XReader in) {
        char c = in.getc();
        if (c == '?' || c == '+' || c == '*') {
            return c;
        }
        in.ungetc();
        return '\u0000';
    }

    private void addSubElement(Vector v) {
        this.decl = new String[2];
        this.decl[0] = (String)v.get(0);
        if (v.get(1) != null) {
            this.decl[1] = (String)v.get(1);
        }
        if (!this.children.contains(this.decl)) {
            this.children.addElement(this.decl);
        }
        if (!this.childrenNames.contains(this.decl[0])) {
            this.childrenNames.addElement(this.decl[0]);
        }
    }

    public String toString() {
        return this.getXML();
    }

    public String getXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<!RECORD ");
        sb.append(this.name);
        sb.append(' ');
        this.makeDeclContent(sb);
        sb.append('>');
        String s = sb.toString();
        return s;
    }

    protected void makeDeclContent(StringBuffer sb) {
        int n = this.children.size();
        if (n <= 0) {
            return;
        }
        sb.append('(');
        for (int i = 0; i < n; ++i) {
            this.decl = (String[])this.children.elementAt(i);
            sb.append(this.decl[0]);
            if (this.decl[1].equals("*") | this.decl[1].equals("+") | this.decl[1].equals("?")) {
                sb.append(this.decl[1]);
            }
            if (i >= n - 1) continue;
            sb.append(',');
        }
        sb.append(')');
    }

    public Vector getChildNames() {
        return this.childrenNames;
    }

    public int getType() {
        return 0;
    }

    public static void main(String[] args) {
        try {
            String s = "(field1)";
            String s1 = "(field1,field2,field3,field4)";
            char[] c = s.toCharArray();
            char[] c1 = s1.toCharArray();
            RecordDecl rec = new RecordDecl(null, "AAA", c);
            RecordDecl rec1 = new RecordDecl(null, "BBB", c1);
            System.out.println(rec.toString());
            System.out.println(rec1.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

