/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.fix;

import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import com.argo21.msg.MessageException;
import com.argo21.msg.fix.FixMetaData;
import com.argo21.msg.fix.FixSchema;
import com.argo21.msg.fix.RecordDecl;
import com.argo21.msg.fix.RecordDeclNodeData;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.tree.DefaultMutableTreeNode;

public class RecordDeclPanel
extends ContentsEditPanel {
    protected TextFieldEx nameField;
    protected ResultPanel result;
    protected JRadioButton[] rectypeOption = new JRadioButton[2];
    protected ButtonGroup bg;
    protected TextFieldEx reclField;
    protected TextFieldEx conditionField;
    protected TextFieldEx repeatField;
    protected TextFieldEx skipField;
    protected JLabel skipLabel;
    protected JRadioButton[] occurrenceOption = new JRadioButton[4];
    protected ButtonGroup group;
    protected FixMetaData dtDecl;
    protected JPanel propertyPanel;

    @Override
    public void init(DTDEditorPanel parentPanel) {
        super.init(parentPanel);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridy = 0;
        gc.gridx = 0;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 1;
        JPanel tp = new JPanel();
        tp.setLayout(new GridBagLayout());
        tp.setOpaque(true);
        tp.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("RECORD_DECL")));
        JLabel label = new JLabel(ContentsEditPanel.getMessage("LAB_NAME"));
        tp.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameField = new TextFieldEx(10){

            @Override
            public boolean valueChanged(Object source, String value) {
                RecordDeclPanel.this.nameChanged(value.trim());
                return true;
            }
        };
        tp.add((Component)this.nameField, c);
        this.add((Component)tp, gc);
        ++gc.gridy;
        this.propertyPanel = new JPanel();
        this.propertyPanel.setLayout(new GridBagLayout());
        this.propertyPanel.setOpaque(true);
        this.propertyPanel.setBorder(BorderFactory.createTitledBorder(ContentsEditPanel.getMessage("TL_PROPERTY")));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        label = new JLabel(MessageException.getMessage(""));
        ++c.gridx;
        c.weightx = 1.0;
        JPanel rd = new JPanel();
        rd.setLayout(new GridLayout(1, 2));
        this.rectypeOption[0] = new JRadioButton(MessageException.getMessage("LAB_RECTYPE_NORMAL"), true);
        this.rectypeOption[1] = new JRadioButton(MessageException.getMessage("LAB_RECTYPE_REPEAT"));
        rd.add(this.rectypeOption[0]);
        this.rectypeOption[0].setFont(this.getDefaultFont());
        rd.add(this.rectypeOption[1]);
        this.rectypeOption[1].setFont(this.getDefaultFont());
        this.bg = new ButtonGroup();
        this.bg.add(this.rectypeOption[0]);
        this.bg.add(this.rectypeOption[1]);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordDeclPanel.this.typeChanged((JRadioButton)e.getSource());
            }
        };
        this.rectypeOption[0].addActionListener(al);
        this.rectypeOption[1].addActionListener(al);
        this.propertyPanel.add((Component)rd, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(MessageException.getMessage("LAB_LRECL"));
        this.propertyPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.reclField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                RecordDeclPanel.this.lreclChanged(value);
                return true;
            }
        };
        this.propertyPanel.add((Component)this.reclField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(MessageException.getMessage("LAB_CONDITION"));
        this.propertyPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.conditionField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                RecordDeclPanel.this.conditionChanged(value);
                return true;
            }
        };
        this.propertyPanel.add((Component)this.conditionField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(MessageException.getMessage("LAB_REPEAT"));
        this.propertyPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.repeatField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                RecordDeclPanel.this.repeatChanged(value);
                return true;
            }
        };
        this.propertyPanel.add((Component)this.repeatField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        label = new JLabel(MessageException.getMessage("LAB_SKIP"));
        this.propertyPanel.add((Component)label, c);
        ++c.gridx;
        c.weightx = 1.0;
        JPanel sk = new JPanel();
        sk.setLayout(new GridLayout(1, 2));
        this.skipField = new TextFieldEx(){

            @Override
            public boolean valueChanged(Object source, String value) {
                RecordDeclPanel.this.skipChanged(value);
                return true;
            }
        };
        sk.add(this.skipField);
        this.skipLabel = new JLabel();
        sk.add(this.skipLabel);
        this.propertyPanel.add((Component)sk, c);
        this.add((Component)this.propertyPanel, gc);
        ++gc.gridy;
        tp = new JPanel();
        tp.setBorder(BorderFactory.createTitledBorder(RecordDeclPanel.getMessage("TL_APP_NUM")));
        tp.setLayout(new BoxLayout(tp, 1));
        this.group = new ButtonGroup();
        this.occurrenceOption[0] = new JRadioButton(RecordDeclPanel.getMessage("LAB_JUSTONE"));
        tp.add(this.occurrenceOption[0]);
        this.occurrenceOption[1] = new JRadioButton(RecordDeclPanel.getMessage("LAB_ONEMORE"));
        tp.add(this.occurrenceOption[1]);
        this.occurrenceOption[2] = new JRadioButton(RecordDeclPanel.getMessage("LAB_ZEROONE"));
        tp.add(this.occurrenceOption[2]);
        this.occurrenceOption[3] = new JRadioButton(RecordDeclPanel.getMessage("LAB_ZEROMORE"));
        tp.add(this.occurrenceOption[3]);
        al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordDeclPanel.this.occurrenceChanged((JRadioButton)e.getSource());
            }
        };
        for (int i = 0; i < 4; ++i) {
            this.group.add(this.occurrenceOption[i]);
            this.occurrenceOption[i].setFont(this.getDefaultFont());
            this.occurrenceOption[i].addActionListener(al);
        }
        this.add((Component)tp, gc);
        ++gc.gridy;
        gc.gridwidth = 0;
        gc.gridheight = 0;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        this.result = new ResultPanel(parentPanel);
        this.add((Component)this.result, gc);
    }

    void nameChanged(String value) {
        RecordDeclNodeData data = (RecordDeclNodeData)this.node.getUserObject();
        String s = data.getNodeName();
        if (!s.equals(value)) {
            if (!XmlNames.isName(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, RecordDeclPanel.getMessage("INVALID_NAME", value));
                this.nameField.setText(s);
                return;
            }
            if (this.parentPanel.hasNameWithoutSelect(value)) {
                JOptionPane.showMessageDialog(this.parentPanel, ContentsEditPanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                this.nameField.setText(s);
                return;
            }
            this.nameChangedTo(value);
            this.viewResult();
        }
    }

    void typeChanged(JRadioButton type) {
        if (!type.isSelected()) {
            return;
        }
        RecordDeclNodeData recdata = (RecordDeclNodeData)this.node.getUserObject();
        if (type == this.rectypeOption[0]) {
            this.dtDecl.rec_type = 0;
            this.conditionField.setEnabled(true);
            this.repeatField.setEnabled(false);
            this.skipField.setEnabled(false);
            this.skipLabel.setVisible(false);
            this.occurrenceOption[0].setEnabled(true);
            this.occurrenceOption[0].setSelected(true);
            this.occurrenceOption[1].setEnabled(true);
            this.occurrenceOption[2].setEnabled(true);
            this.occurrenceOption[3].setEnabled(true);
            recdata.setOccurrence(0);
        } else {
            this.dtDecl.rec_type = 1;
            this.conditionField.setEnabled(false);
            this.repeatField.setEnabled(true);
            this.skipField.setEnabled(true);
            this.skipLabel.setText("");
            this.skipLabel.setVisible(true);
            this.occurrenceOption[0].setEnabled(false);
            this.occurrenceOption[1].setEnabled(false);
            this.occurrenceOption[2].setEnabled(false);
            this.occurrenceOption[3].setEnabled(false);
            this.occurrenceOption[3].setSelected(true);
            recdata.setOccurrence(42);
        }
        this.setDataTypeDecl();
    }

    void conditionChanged(String value) {
        if (value.length() == 0) {
            value = "";
        }
        if (value != this.dtDecl.condition) {
            this.dtDecl.condition = value;
            this.setDataTypeDecl();
        }
    }

    void lreclChanged(String value) {
        int size = -1;
        if (value.length() == 0) {
            size = 0;
        } else {
            try {
                size = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (size < 0) {
            JOptionPane.showMessageDialog(this.parentPanel, RecordDeclPanel.getMessage("INVALID_LRECL"));
            this.reclField.setText(String.valueOf(this.dtDecl.reclength));
            return;
        }
        if (size != this.dtDecl.reclength) {
            this.dtDecl.reclength = size;
            this.setDataTypeDecl();
        }
    }

    void repeatChanged(String value) {
        int size = -1;
        if (value.length() == 0) {
            size = 0;
        } else {
            try {
                size = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (size <= 0) {
            JOptionPane.showMessageDialog(this.parentPanel, MessageException.getMessage("INVALID_REPEAT"));
            this.repeatField.setText(String.valueOf(this.dtDecl.repeat));
            return;
        }
        if (size != this.dtDecl.repeat) {
            this.dtDecl.repeat = size;
            this.setDataTypeDecl();
        }
    }

    void skipChanged(String value) {
        if (value == null) {
            return;
        }
        if (value.length() == 0) {
            value = "";
        }
        if (value != this.dtDecl.skip) {
            this.dtDecl.skip = value;
            this.setDataTypeDecl();
            this.checkSkipField(value);
        }
    }

    void checkSkipField(String value) {
        char c;
        int size = value.length();
        String space = "";
        if (size == 0) {
            return;
        }
        int i = 0;
        if (i < size && (c = value.charAt(i)) == ' ') {
            space = "\u7a7a\u767d";
        }
        this.skipLabel.setText("\u3000" + space + size + "\u6587\u5b57\u6307\u5b9a");
    }

    void occurrenceChanged(JRadioButton occurrenceopt) {
        RecordDeclNodeData data;
        int oldoccurrence;
        if (!occurrenceopt.isSelected()) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.node.getParent();
        DefaultMutableTreeNode p_parent = (DefaultMutableTreeNode)parent.getParent();
        int occurrence = p_parent == null ? 0 : (occurrenceopt == this.occurrenceOption[1] ? 43 : (occurrenceopt == this.occurrenceOption[2] ? 63 : (occurrenceopt == this.occurrenceOption[3] ? 42 : 0)));
        if (occurrence == (oldoccurrence = (data = (RecordDeclNodeData)this.node.getUserObject()).getOccurrence())) {
            return;
        }
        data.setOccurrence(occurrence);
        this.nodeChanged();
        this.viewResult();
    }

    private RecordDecl createRecordDecl(FixSchema schema, DefaultMutableTreeNode treenode) {
        DeclNodeData userobj = (DeclNodeData)treenode.getUserObject();
        String nodename = userobj.getNodeName();
        int type = userobj.getNodeType();
        if (type != 45) {
            return null;
        }
        int n = treenode.getChildCount();
        Vector<String[]> children = new Vector<String[]>();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode subnode = (DefaultMutableTreeNode)treenode.getChildAt(i);
            DeclNodeData userobj1 = (DeclNodeData)subnode.getUserObject();
            String s = userobj1.getNodeName();
            int type1 = userobj1.getNodeType();
            String[] child = new String[2];
            child[0] = s;
            if (type1 == 45) {
                RecordDeclNodeData data = (RecordDeclNodeData)userobj1;
                int occurrence = data.getOccurrence();
                child[1] = String.valueOf((char)occurrence);
            } else {
                child[1] = String.valueOf('\u0000');
            }
            children.addElement(child);
        }
        RecordDecl record = new RecordDecl((DeclNode)schema, nodename, children);
        RecordDeclNodeData recorddata = (RecordDeclNodeData)userobj;
        record.setOccurrence((char)recorddata.getOccurrence());
        this.dtDecl = (FixMetaData)userobj.getDataTypeDecl();
        if (this.dtDecl == null) {
            this.dtDecl = new FixMetaData();
        }
        record.setDataTypeDecl(this.dtDecl);
        return record;
    }

    void setDataTypeDecl() {
        DeclNodeData data = (DeclNodeData)this.node.getUserObject();
        data.setDataTypeDecl(this.dtDecl);
        this.contentsChanged();
        this.viewResult();
    }

    void viewResult() {
        String rs1;
        RecordDeclNodeData data = (RecordDeclNodeData)this.node.getUserObject();
        RecordDecl declnode = this.createRecordDecl(null, this.node);
        String rs = declnode == null ? "" : declnode.toString();
        String att = "record=\"" + data.getNodeName() + "\"";
        String string2 = rs1 = this.dtDecl == null ? "" : this.dtDecl.getXML(att);
        if (rs1 != null) {
            rs = rs + "\n---------\n" + rs1;
        }
        this.result.viewResult(rs);
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.node = node;
        RecordDeclNodeData data = (RecordDeclNodeData)node.getUserObject();
        this.nameField.setText(data.getNodeName());
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        DefaultMutableTreeNode p_parent = (DefaultMutableTreeNode)parent.getParent();
        this.dtDecl = (FixMetaData)data.getDataTypeDecl();
        if (this.dtDecl == null) {
            this.dtDecl = new FixMetaData();
        }
        this.reclField.setText(String.valueOf(this.dtDecl.reclength));
        int rectype = this.dtDecl.rec_type;
        if (p_parent == null) {
            this.rectypeOption[0].setSelected(true);
            this.rectypeOption[0].setEnabled(false);
            this.rectypeOption[1].setEnabled(false);
            this.occurrenceOption[0].setSelected(true);
            this.occurrenceOption[0].setEnabled(false);
            this.occurrenceOption[1].setEnabled(false);
            this.occurrenceOption[2].setEnabled(false);
            this.occurrenceOption[3].setEnabled(false);
        } else {
            this.rectypeOption[0].setEnabled(true);
            this.rectypeOption[1].setEnabled(true);
            this.occurrenceOption[0].setEnabled(true);
            this.occurrenceOption[1].setEnabled(true);
            this.occurrenceOption[2].setEnabled(true);
            this.occurrenceOption[3].setEnabled(true);
        }
        if (rectype == 0) {
            this.rectypeOption[0].setSelected(true);
            this.conditionField.setEnabled(true);
            this.repeatField.setEnabled(false);
            this.skipField.setEnabled(false);
            this.skipLabel.setVisible(false);
            this.occurrenceOption[0].setEnabled(true);
            this.occurrenceOption[1].setEnabled(true);
            this.occurrenceOption[2].setEnabled(true);
            this.occurrenceOption[3].setEnabled(true);
        } else if (rectype == 1) {
            this.rectypeOption[1].setSelected(true);
            this.conditionField.setEnabled(false);
            this.repeatField.setEnabled(true);
            this.skipField.setEnabled(true);
            this.skipLabel.setVisible(true);
            this.occurrenceOption[0].setEnabled(false);
            this.occurrenceOption[1].setEnabled(false);
            this.occurrenceOption[2].setEnabled(false);
            this.occurrenceOption[3].setEnabled(false);
        }
        this.conditionField.setText(this.dtDecl.condition);
        this.repeatField.setText(String.valueOf(this.dtDecl.repeat));
        this.skipField.setText(this.dtDecl.skip);
        if (this.dtDecl.skip != null) {
            this.checkSkipField(this.dtDecl.skip);
        }
        if (p_parent == null) {
            data.setOccurrence(0);
            this.occurrenceOption[0].setSelected(true);
            this.occurrenceOption[1].setEnabled(false);
            this.occurrenceOption[2].setEnabled(false);
            this.occurrenceOption[3].setEnabled(false);
        } else {
            int occurrence = data.getOccurrence();
            if (occurrence == 0) {
                this.occurrenceOption[0].setSelected(true);
            } else if (occurrence == 43) {
                this.occurrenceOption[1].setSelected(true);
            } else if (occurrence == 63) {
                this.occurrenceOption[2].setSelected(true);
            } else if (occurrence == 42) {
                this.occurrenceOption[3].setSelected(true);
            }
        }
        this.viewResult();
    }

    static boolean isName(String s) {
        if (s == null) {
            return false;
        }
        int n = s.length();
        if (n < 1) {
            return false;
        }
        char c = s.charAt(0);
        if (!Character.isLetter(c)) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') continue;
            return false;
        }
        return true;
    }
}

