/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.io.Debug;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.msg.CacheTable;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.TableDocument;
import com.argo21.msg.rdb.RdbSchema;
import com.argo21.msg.rdb.RdbTransaction;
import com.argo21.msg.rdb.TableDecl;
import com.argo21.msg.rdb.TableSetDocument;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class RdbConnector {
    private Connection con = null;
    private static Vector drivers = new Vector();

    public static void registerDriver(Driver driver) throws SQLException {
        DriverManager.registerDriver(driver);
        drivers.addElement(driver);
    }

    public RdbConnector(String connect, String user, String password) throws MessageException {
        Exception lastErr = null;
        try {
            this.con = DriverManager.getConnection(connect, user, password);
        }
        catch (Exception e) {
            lastErr = e;
        }
        int size = drivers.size();
        for (int i = 0; i < size; ++i) {
            Object o = drivers.elementAt(i);
            if (!(o instanceof Driver)) continue;
            Driver driver = (Driver)o;
            try {
                boolean b = driver.acceptsURL(connect);
                if (!b) continue;
                Properties ps = new Properties();
                if (user != null) {
                    ps.setProperty("user", user);
                }
                if (password != null) {
                    ps.setProperty("password", password);
                }
                this.con = driver.connect(connect, ps);
                lastErr = null;
                return;
            }
            catch (Exception e) {
                lastErr = e;
            }
        }
        if (lastErr != null) {
            if (this.con != null) {
                try {
                    this.con.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MessageException.error("CANT_CONN_RDB", new Object[]{connect, lastErr.getMessage()}, null);
        }
    }

    public void close() {
        try {
            if (this.con != null) {
                this.con.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.con = null;
    }

    public ResultSet getDatabaseTables(String[] types) throws SQLException {
        DatabaseMetaData meta = this.con.getMetaData();
        try {
            return meta.getTables(null, null, "%", types);
        }
        catch (SQLException ex) {
            return meta.getTables("", "", "%", types);
        }
    }

    public ResultSet getDatabaseTableColumns(String schema, String table) throws SQLException {
        DatabaseMetaData meta = this.con.getMetaData();
        ResultSet rs = null;
        try {
            rs = meta.getColumns(null, schema, table, "%");
        }
        catch (SQLException ex) {
            rs = meta.getColumns("", schema, table, "%");
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getResultSet(String sql) throws MessageException {
        Statement stmt = null;
        ResultSet res = null;
        try {
            stmt = this.con.createStatement();
            res = stmt.executeQuery(sql);
        }
        catch (SQLException ex) {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                res = null;
            }
            MessageException.error("RDB_ACCESS_ERR", new Object[]{sql, ex.getMessage() + ":" + ex.getSQLState()}, null);
        }
        finally {
            this.printWarnings();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldMataData[] getTableMataData(String sql) throws MessageException {
        ResultSet rs = null;
        try {
            Statement stmt = this.con.createStatement();
            rs = stmt.executeQuery(sql);
            FieldMataData[] fieldMataData = this.getTableMataData(rs);
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            FieldMataData[] fieldMataDataArray = fieldMataData;
            return fieldMataDataArray;
        }
        catch (SQLException ex) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            MessageException.error("RDB_ACCESS_ERR", new Object[]{sql, ex.getMessage() + ":" + ex.getSQLState()}, null);
        }
        finally {
            this.printWarnings();
        }
        return null;
    }

    private FieldMataData[] getTableMataData(ResultSet rs) throws SQLException {
        ResultSetMetaData metadata = rs.getMetaData();
        int n = metadata.getColumnCount();
        FieldMataData[] fieldMataData = new FieldMataData[n];
        for (int i = 1; i <= n; ++i) {
            String fdName = metadata.getColumnName(i);
            int fdType = metadata.getColumnType(i);
            int fdSize = 0;
            if (fdType == 2 || fdType == 3) {
                fdSize = metadata.getPrecision(i);
                int decimal = metadata.getScale(i);
                fdType = decimal > 0 ? (fdSize >= 7 ? 8 : 7) : (fdSize >= 10 ? -5 : 4);
                if (fdSize == 0) {
                    fdType = 8;
                }
            } else {
                fdSize = metadata.getColumnDisplaySize(i);
            }
            boolean nullAble = metadata.isNullable(i) == 1;
            String fdValue = null;
            int type = FieldMataData.SqlType2XDataType(fdType);
            if (XData.isNumber(type) || type == 7) {
                fdSize = 0;
            }
            fieldMataData[i - 1] = new FieldMataData(fdName, type, fdType, fdSize, nullAble, fdValue);
        }
        return fieldMataData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldMataData[] getTableMataData(TableDecl tbdecl) throws MessageException {
        String sql = null;
        if ((tbdecl = tbdecl.repleaceParameters()).getType() == TableDecl.SELECT) {
            sql = tbdecl.getSQL();
            if (sql == null || sql.trim().length() == 0) {
                return new FieldMataData[0];
            }
        } else {
            String table = tbdecl.getRdbTable();
            if (table == null || table.length() == 0) {
                return new FieldMataData[0];
            }
            String[] fs = tbdecl.getFields();
            String[] ids = tbdecl.getIDs();
            if (fs == null || fs.length == 0) {
                sql = "SELECT * FROM " + table + " WHERE (1>2)";
            } else {
                int j;
                int n1 = fs.length;
                StringBuffer sb = new StringBuffer("SELECT ");
                boolean has = false;
                for (j = 0; j < n1; ++j) {
                    if (has) {
                        sb.append(',');
                    }
                    sb.append(fs[j]);
                    has = true;
                }
                n1 = ids == null ? 0 : ids.length;
                for (j = 0; j < n1; ++j) {
                    if (RdbConnector.constantsString(ids[j], fs)) continue;
                    if (has) {
                        sb.append(',');
                    }
                    sb.append(ids[j]);
                    has = true;
                }
                sb.append(" FROM ");
                sb.append(table);
                sb.append(" WHERE (1>2)");
                sql = sb.toString();
            }
        }
        ResultSet res = null;
        Statement stmt = null;
        try {
            stmt = this.con.createStatement();
            res = stmt.executeQuery(sql);
        }
        catch (SQLException ex) {
            int k2;
            if (tbdecl.getType() != TableDecl.SELECT && (k2 = sql.lastIndexOf("WHERE")) > 0) {
                sql = sql.substring(0, k2);
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception k2) {
                    // empty catch block
                }
                res = null;
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception k2) {
                    // empty catch block
                }
                stmt = null;
            }
            MessageException.error("RDB_ACCESS_ERR", new Object[]{sql, ex.getMessage()}, null);
        }
        FieldMataData[] meta = null;
        try {
            meta = this.getTableMataData(res);
        }
        catch (SQLException e) {
            MessageException.error("RDB_ACCESS_ERR", new Object[]{sql, e.getMessage()}, null);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromRdb(RdbSchema schema, TableSetDocument document) throws MessageException, XDataException {
        XDataMultipleException exception = null;
        TableDecl[] tbdecls = schema.getTableDecls();
        int n = tbdecls.length;
        for (int i = 0; i < n; ++i) {
            TableDecl tbdecl = tbdecls[i].repleaceParameters();
            if (tbdecl.getType() == TableDecl.SELECT) {
                String sql = tbdecl.getSQL();
                ResultSet res = this.getResultSet(sql);
                FieldMataData[] meta = null;
                try {
                    meta = this.getTableMataData(res);
                }
                catch (SQLException e) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        res = null;
                    }
                    MessageException.error("RDB_ACCESS_ERR", new Object[]{sql, e.getMessage()}, null);
                }
                CacheTable tab = new CacheTable(meta, 64, document);
                document.putTable(tbdecl.getNodeName(), tab);
                try {
                    tab.copyFromResultSet(res);
                    continue;
                }
                catch (SQLException e) {
                    MessageException.error("RDB_ACCESS_ERR", new Object[]{sql, e.getMessage()}, null);
                    continue;
                }
                catch (XDataMultipleException e) {
                    XDataException[] es = e.getExceptions();
                    if (exception != null) {
                        int len = es.length;
                        for (int k = 0; k < len; ++k) {
                            exception.addException(es[k]);
                        }
                        continue;
                    }
                    exception = e;
                    continue;
                }
                catch (XDataException e) {
                    if (exception != null) {
                        exception.addException(e);
                        continue;
                    }
                    exception = new XDataMultipleException(e);
                    continue;
                }
                finally {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            FieldMataData[] meta = this.getTableMataData(tbdecl);
            document.putTable(tbdecl.getNodeName(), new CacheTable(meta, 64, document));
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String nativeSQL(String sql) {
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException ex) {
            return sql;
        }
    }

    public Hashtable saveToRdb(RdbSchema schema, TableSetDocument document, int transactionMode) throws Exception {
        RdbTransaction rdbUpdate = new RdbTransaction(this.con, transactionMode);
        TableDecl[] tableDecls = schema.getTableDecls();
        int n = tableDecls.length;
        try {
            for (int i = 0; i < n; ++i) {
                String[] ids;
                TableDecl tableDecl = tableDecls[i].repleaceParameters();
                TableDocument table = document.getTable(tableDecl.getNodeName());
                int type = tableDecl.getType();
                if (type == TableDecl.INSERT) {
                    rdbUpdate.execInsert(tableDecl, table);
                    continue;
                }
                if (type == TableDecl.UPDATE) {
                    ids = tableDecl.getIDs();
                    if (ids == null || ids.length == 0) continue;
                    rdbUpdate.execUpdate(tableDecl, table);
                    continue;
                }
                if (type != TableDecl.OVERWRITE) continue;
                ids = tableDecl.getIDs();
                if (ids != null && ids.length != 0) {
                    rdbUpdate.execOverWrite(tableDecl, table);
                    continue;
                }
                rdbUpdate.execInsert(tableDecl, table);
            }
            try {
                rdbUpdate.commit();
            }
            catch (Exception e) {
                Debug.println(e.getMessage());
            }
            Hashtable e = rdbUpdate.getErrorRecord();
            return e;
        }
        catch (Exception e) {
            try {
                if (transactionMode == 1) {
                    rdbUpdate.rollback();
                } else if (transactionMode == 2) {
                    rdbUpdate.commit();
                }
            }
            catch (Exception e1) {
                Debug.println(e.getMessage());
            }
            throw e;
        }
        finally {
            rdbUpdate.close();
            this.printWarnings();
        }
    }

    public Hashtable saveToRdb1(RdbSchema schema, TableSetDocument document, int transactionMode) throws Exception {
        RdbTransaction rdbUpdate = new RdbTransaction(this.con, transactionMode);
        Statement stmt = null;
        stmt = this.con.createStatement();
        TableDecl[] tableDecls = schema.getTableDecls();
        int n = tableDecls.length;
        try {
            for (int i = 0; i < n; ++i) {
                String[] ids;
                TableDecl tableDecl = tableDecls[i];
                TableDocument table = document.getTable(tableDecl.getNodeName());
                int type = tableDecl.getType();
                if (type == TableDecl.INSERT) {
                    rdbUpdate.execInsert1(tableDecl, table, stmt);
                    continue;
                }
                if (type == TableDecl.UPDATE) {
                    ids = tableDecl.getIDs();
                    if (ids == null || ids.length == 0) continue;
                    rdbUpdate.execUpdate1(tableDecl, table, stmt);
                    continue;
                }
                if (type != TableDecl.OVERWRITE) continue;
                ids = tableDecl.getIDs();
                if (ids != null && ids.length != 0) {
                    rdbUpdate.execOverWrite1(tableDecl, table, stmt);
                    continue;
                }
                rdbUpdate.execInsert1(tableDecl, table, stmt);
            }
            try {
                rdbUpdate.commit();
            }
            catch (Exception e) {
                Debug.println(e.getMessage());
            }
            Hashtable e = rdbUpdate.getErrorRecord();
            return e;
        }
        catch (SQLException e) {
            try {
                if (transactionMode == 1) {
                    rdbUpdate.rollback();
                } else if (transactionMode == 2) {
                    rdbUpdate.commit();
                }
            }
            catch (Exception e1) {
                Debug.println(e.getMessage());
            }
            throw e;
        }
        finally {
            rdbUpdate.close();
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            this.printWarnings();
        }
    }

    public static String getStatementParameter(TableDocument table, int row, int col) {
        StringBuffer sb;
        block28: {
            FieldMataData[] fms = table.getFieldMataData();
            sb = new StringBuffer();
            if (table.getColType(col) == 6) {
                int p;
                char quote = '\'';
                int sp = 0;
                sb.append(quote);
                String data = table.stringValue(row, col);
                if (data == null) {
                    data = "";
                }
                while ((p = data.indexOf(quote, sp)) != -1) {
                    sb.append(data.substring(sp, p + 1));
                    sb.append(quote);
                    sp = p + 1;
                }
                sb.append(data.substring(sp));
                sb.append(quote);
            } else if (table.getColType(col) == 5) {
                try {
                    if (table.booleanValue(row, col)) {
                        sb.append(-1);
                        break block28;
                    }
                    sb.append(0);
                }
                catch (XDataException ex) {
                    sb.append(table.stringValue(row, col));
                }
            } else if (table.getColType(col) == 7) {
                try {
                    java.util.Date date = table.dateValue(row, col);
                    if (date != null) {
                        if (fms[col].sqlType == 91) {
                            sb.append("{d '");
                            if (date instanceof Date) {
                                sb.append(date.toString());
                            } else {
                                sb.append(new Date(date.getTime()).toString());
                            }
                            sb.append("'}");
                        } else if (fms[col].sqlType == 92) {
                            sb.append("{t '");
                            if (date instanceof Time) {
                                sb.append(date.toString());
                            } else {
                                sb.append(new Time(date.getTime()).toString());
                            }
                            sb.append("'}");
                        } else if (fms[col].sqlType == 93) {
                            sb.append("{ts '");
                            if (date instanceof Timestamp) {
                                sb.append(date.toString());
                            } else {
                                sb.append(new Timestamp(date.getTime() / 1000L * 1000L).toString());
                            }
                            sb.append("'}");
                        } else {
                            sb.append(table.stringValue(row, col));
                        }
                        break block28;
                    }
                    sb.append("NULL");
                }
                catch (XDataException ex) {
                    sb.append(table.stringValue(row, col));
                }
            } else if (table.stringValue(row, col) == null) {
                sb.append("NULL");
            } else {
                sb.append(table.stringValue(row, col));
            }
        }
        return sb.toString();
    }

    private void printWarnings() {
        try {
            for (SQLWarning w = this.con.getWarnings(); w != null; w = w.getNextWarning()) {
                String message = w.getMessage();
                String state = w.getSQLState();
                Debug.print(MessageException.getMessage("WARNING"));
                Debug.print(" :");
                Debug.print(message);
                if (state != null) {
                    Debug.print(" :");
                    Debug.print(state);
                }
                Debug.println();
            }
            this.con.clearWarnings();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static boolean constantsString(String s, String[] ss) {
        if (ss == null) {
            return false;
        }
        for (int i = 0; i < ss.length; ++i) {
            if (!s.equals(ss[i])) continue;
            return true;
        }
        return false;
    }
}

