/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.msg.DocumentViewer;
import com.argo21.msg.MessageException;
import com.argo21.msg.TableDocument;
import com.argo21.msg.rdb.TableSetDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.xml.sax.SAXException;

public class RdbDocumentViewer
extends JTabbedPane
implements DocumentViewer {
    private TableSetDocument tableSet = null;
    private String msgname = null;
    private Hashtable myTables = new Hashtable();

    public RdbDocumentViewer() {
        super(3);
    }

    @Override
    public String getMsgType() {
        return "RDB";
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document == null) {
            this.initializeTable();
            return;
        }
        if (document instanceof TableSetDocument) {
            String tableName;
            if (this.tableSet == document) {
                this.reView();
                return;
            }
            this.removeAll();
            this.myTables.clear();
            this.tableSet = (TableSetDocument)document;
            int n = this.tableSet.size();
            for (int i = 0; i < n && this.tableSet.getTable(tableName = this.tableSet.getTableName(i)) != null; ++i) {
                MyTable rdbTable = new MyTable();
                rdbTable.setDocument(this.tableSet.getTable(i));
                JScrollPane scrollPane = new JScrollPane(rdbTable){

                    @Override
                    public boolean isOpaque() {
                        return true;
                    }
                };
                scrollPane.setBackground(Color.white);
                this.addTab(tableName, scrollPane);
                this.setOpaque(true);
                this.myTables.put(tableName, rdbTable);
            }
        } else {
            this.tableSet = null;
            MessageException.error("CANT_VIEW_DOC", new Object[]{document.getClass().getName(), this.getMsgType()}, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.tableSet;
    }

    @Override
    public void reView() {
        Enumeration elems = this.myTables.elements();
        while (elems.hasMoreElements()) {
            MyTable rdbTable = (MyTable)elems.nextElement();
            rdbTable.revalidate();
            rdbTable.setTableCellRenderer(false);
            rdbTable.repaint();
        }
    }

    private void initializeTable() {
        this.tableSet = null;
        this.removeAll();
        this.add("No Document", new JPanel());
    }

    private Dimension getParentPaneSize() {
        try {
            JScrollPane parentPane = (JScrollPane)this.getParent().getParent();
            parentPane.setVerticalScrollBarPolicy(21);
            parentPane.setHorizontalScrollBarPolicy(31);
            return parentPane.getSize();
        }
        catch (Exception e) {
            return null;
        }
    }

    static class MyTable
    extends JTable {
        private TableDocument tableDoc = null;
        private MyTableModel tableModel = null;
        private Font defaultFont = null;
        private Color defaultBackgroundColor = null;
        private String msgname = null;
        private FontMetrics fm = null;

        public MyTable() {
            try {
                this.defaultFont = new Font("Dialog", 0, 12);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.defaultBackgroundColor = this.getBackground();
            this.fm = this.getFontMetrics(this.defaultFont);
            this.getTableHeader().setReorderingAllowed(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() != 501) {
                return;
            }
            for (Container c = this.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof RdbDocumentViewer)) continue;
                Component c1 = e.getComponent();
                Point p1 = c.getLocationOnScreen();
                Point p2 = c1.getLocationOnScreen();
                Point p = e.getPoint();
                p.translate(p2.x - p1.x, p2.y - p1.y);
                MouseEvent e1 = new MouseEvent(c, e.getID(), e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
                c.dispatchEvent(e1);
                break;
            }
        }

        public void setDocument(TableDocument tableDoc) throws SAXException {
            if (tableDoc == null) {
                return;
            }
            this.tableDoc = tableDoc;
            this.tableModel = new MyTableModel();
            if (tableDoc.getRows() == 0 || tableDoc.getCols() == 0) {
                this.setModel(this.tableModel);
                this.setTableCellRenderer(true);
                this.setAutoResizeMode(0);
                return;
            }
            this.setModel(this.tableModel);
            this.setTableCellRenderer(true);
            this.setAutoResizeMode(0);
        }

        void setTableCellRenderer(boolean set) {
            DefaultTableColumnModel cmodel = (DefaultTableColumnModel)this.getColumnModel();
            int columnNum = cmodel.getColumnCount();
            for (int i = 0; i < columnNum; ++i) {
                TableColumn column = cmodel.getColumn(i);
                column.setPreferredWidth(this.calculateColumnWidth(i) + 20);
                this.sizeColumnsToFit(-1);
                if (!set) continue;
                column.setCellRenderer(new MyTableCellRenderer());
            }
        }

        private int calculateColumnWidth(int indexColumn) {
            int stringWidth;
            int columnWidth = 0;
            String s = String.valueOf(this.tableModel.getColumnName(indexColumn));
            columnWidth = stringWidth = this.fm.charsWidth(s.toCharArray(), 0, s.length());
            int rows = this.tableModel.getRowCount();
            if (rows > 2) {
                rows = 2;
            }
            for (int j = 0; j < rows; ++j) {
                s = String.valueOf(this.tableModel.getValueAt(j, indexColumn));
                stringWidth = this.fm.charsWidth(s.toCharArray(), 0, s.length());
                if (stringWidth <= columnWidth) continue;
                columnWidth = stringWidth;
            }
            return columnWidth;
        }

        class MyTableCellRenderer
        extends DefaultTableCellRenderer {
            MyTableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasForcus, int row, int column) {
                if (MyTable.this.defaultFont != null) {
                    this.setFont(MyTable.this.defaultFont);
                }
                this.setForeground(new Color(102, 102, 153));
                if (isSelected) {
                    this.setBackground(SystemColor.scrollbar);
                } else {
                    this.setBackground(MyTable.this.defaultBackgroundColor);
                }
                this.setValue(value);
                if (MyTable.this.tableDoc != null) {
                    switch (MyTable.this.tableDoc.getColType(column)) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            this.setHorizontalAlignment(4);
                            break;
                        }
                        default: {
                            this.setHorizontalAlignment(2);
                            break;
                        }
                    }
                } else {
                    this.setHorizontalAlignment(2);
                }
                return this;
            }
        }

        class MyTableModel
        extends AbstractTableModel {
            @Override
            public int getColumnCount() {
                try {
                    return MyTable.this.tableDoc.getCols();
                }
                catch (Exception e) {
                    return 1;
                }
            }

            @Override
            public int getRowCount() {
                try {
                    return MyTable.this.tableDoc.getRows();
                }
                catch (Exception e) {
                    return 1;
                }
            }

            @Override
            public Object getValueAt(int row, int col) {
                try {
                    return MyTable.this.tableDoc.formatValue(row, col);
                }
                catch (Exception e) {
                    return "No Document";
                }
            }

            @Override
            public String getColumnName(int column) {
                try {
                    return MyTable.this.tableDoc.getColName(column);
                }
                catch (Exception e) {
                    return "";
                }
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        }
    }
}

