/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.io.Debug;
import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.ObjectDeclaration;
import com.argo21.common.lang.ObjectManager;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.lang.XObject;
import com.argo21.common.lang.XString;
import com.argo21.common.lang.XStringSet;
import com.argo21.common.util.Properties;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.CacheTable;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.TableDocument;
import com.argo21.msg.csv.TableColDataSet;
import com.argo21.msg.rdb.RdbConnector;
import com.argo21.msg.rdb.RdbSchema;
import com.argo21.msg.rdb.RdbTransactionException;
import com.argo21.msg.rdb.TableDecl;
import com.argo21.msg.rdb.TableSetDocument;
import com.argo21.msg.rdb.XPathForRdbParser;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.xml.sax.SAXException;

public class RdbMsg
extends BaseMessage {
    public static final String MSGTYPE = "RDB";
    private static final String EXTTYPE = "rdb";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PWD = "pwd";
    public static final String PROPERTY_TRANSACTION = "error";
    private boolean isChanged = false;
    protected String connect;
    protected String user;
    protected String pwd;
    protected int transaction = 0;
    public static final int TRANSACTION_DEFAULT = 0;
    public static final int TRANSACTION_ROLLBACK = 1;
    public static final int TRANSACTION_STOP = 2;
    public static final int TRANSACTION_SKIP = 3;
    protected RdbSchema schema = null;
    protected TableSetDocument document = null;
    protected XPathParser xpathParser = null;
    protected XPathSurpport xpathSurpport;
    private boolean initialized = false;
    private long lastModifies = 0L;
    private RdbConnector rdbConnector = null;
    private Hashtable errorRecords = null;
    public static final int METHOD_MAP = 256;
    protected Hashtable mapCode = new Hashtable(10);
    private String keyname = null;
    private String tablename = null;

    public static void registObject() {
        Class<RdbMsg> cls = RdbMsg.class;
        if (ObjectManager.isRegisted(cls)) {
            return;
        }
        ObjectDeclaration od = ObjectManager.createObjectDeclaration(cls, "RdbMsg");
        Method md = null;
        try {
            md = cls.getMethod("invoke", String.class, XData[].class);
        }
        catch (Exception e) {
            return;
        }
        od.addMethodDeclaration("map", md, String.valueOf(256), XData.class, 4);
    }

    public XData invoke(String id2, XData[] parameters) throws XDataException, NoSuchMethodException {
        int idd = -1;
        try {
            idd = Integer.parseInt(id2);
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
        switch (idd) {
            case 256: {
                int type1 = parameters[0].getType();
                int type2 = parameters[1].getType();
                int type3 = parameters[2].getType();
                int type4 = parameters[3].getType();
                if (type1 == 6 && type3 == 6 && type4 == 6) {
                    if (type2 == 274 || type2 == 6 || type2 == 262) {
                        String f1 = ((XString)parameters[0]).stringValue();
                        String f2 = ((XString)parameters[2]).stringValue();
                        String f3 = ((XString)parameters[3]).stringValue();
                        return this.map(f1, parameters[1], f2, f3);
                    }
                    XData.error("INVALID_PARAMETER", new Object[]{"map", "2"}, true);
                    break;
                }
                if (type1 != 6) {
                    XData.error("INVALID_PARAMETER", new Object[]{"map", "1"}, true);
                    break;
                }
                if (type3 != 6) {
                    XData.error("INVALID_PARAMETER", new Object[]{"map", "3"}, true);
                    break;
                }
                XData.error("INVALID_PARAMETER", new Object[]{"map", "4"}, true);
            }
        }
        throw new NoSuchMethodException();
    }

    private XData map(String table, XData src, String field1, String field2) throws XDataException, NoSuchMethodException {
        try {
            int type;
            if (!this.initialized && !this.init()) {
                String s = MessageException.msgCatalog.getMessage("CANT_INIT_MSG", new Object[]{this.name});
                Debug.println(s);
                throw new NoSuchMethodException();
            }
            TableDocument tableDocument = this.document.getTable(table);
            if (tableDocument == null) {
                String s = MessageException.msgCatalog.getMessage("INVALID_TABLENAME", new Object[]{"<" + table + ">"});
                Debug.println(s);
                throw new NoSuchMethodException();
            }
            int index1 = tableDocument.getColIndex(field1);
            int index2 = tableDocument.getColIndex(field2);
            if (index1 == -1 || index2 == -1) {
                String errField = null;
                errField = index1 == -1 ? field1 : field2;
                String s = MessageException.msgCatalog.getMessage("INVALID_FIELDNAME", new Object[]{"<" + errField + ">"});
                Debug.println(s);
                throw new NoSuchMethodException();
            }
            int cols = tableDocument.getCols();
            int rows = tableDocument.getRows();
            if (!field1.equalsIgnoreCase(this.keyname) && !table.equalsIgnoreCase(this.tablename)) {
                this.mapCode.clear();
                this.keyname = field1;
                this.tablename = table;
                for (int i = 0; i < rows; ++i) {
                    String value1 = tableDocument.stringValue(i, index1);
                    if (this.mapCode.containsKey(value1)) {
                        XData.error("DOUBLE_FIELD", new String[]{field1, value1});
                        continue;
                    }
                    String[] values = new String[cols];
                    for (int j = 0; j < cols; ++j) {
                        values[j] = tableDocument.stringValue(i, j);
                    }
                    if (value1 != null && values != null) {
                        this.mapCode.put(value1, values);
                    }
                    if (value1 == null || values != null) continue;
                    this.mapCode.put(value1, new String[cols]);
                }
            }
            FieldMataData[] fieldMataData = new FieldMataData[2];
            FieldMataData[] fieldMataData1 = tableDocument.getFieldMataData();
            Object dtDecl1 = null;
            Object dtDecl2 = null;
            if (fieldMataData1 != null) {
                int length = fieldMataData1.length;
                for (int j = 0; j < length; ++j) {
                    FieldMataData fmd2;
                    if (field1.equalsIgnoreCase(fieldMataData1[j].name)) {
                        FieldMataData fmd1;
                        fieldMataData[0] = fmd1 = new FieldMataData(field1, (DataTypeDecl)fieldMataData1[j].clone());
                    }
                    if (!field2.equalsIgnoreCase(fieldMataData1[j].name)) continue;
                    fieldMataData[1] = fmd2 = new FieldMataData(field2, (DataTypeDecl)fieldMataData1[j].clone());
                }
            }
            if ((type = src.getType()) == 274) {
                TableColDataSet dataset;
                TableDocument doc;
                int index3;
                XNodeSet code = (XNodeSet)src;
                String codename = code.getNodeName();
                DataTypeDecl dtDecl = null;
                if (src instanceof TableColDataSet && (index3 = (doc = (dataset = (TableColDataSet)src).getOwnerDocument()).getColIndex(codename)) != -1) {
                    FieldMataData[] mata = doc.getFieldMataData();
                    dtDecl = (DataTypeDecl)mata[index3].clone();
                }
                if (dtDecl != null && dtDecl.type != fieldMataData[0].type) {
                    String s = MessageException.msgCatalog.getMessage("INVALID_DATATYPE", new Object[]{"<" + codename + ">", "<" + field1 + ">"});
                    Debug.println(s);
                    throw new NoSuchMethodException();
                }
                String codeSt = null;
                int size = code.size();
                FieldMataData fmd3 = new FieldMataData(null, (DataTypeDecl)fieldMataData[1].clone());
                FieldMataData[] fms = new FieldMataData[]{fmd3};
                CacheTable resultDocument = new CacheTable(fms, 1);
                for (int i = 0; i < size; ++i) {
                    codeSt = code.stringValue(i);
                    String[] data = new String[1];
                    if (this.mapCode.containsKey(codeSt)) {
                        String[] d = new String[cols];
                        d = (String[])this.mapCode.get(codeSt);
                        data[0] = d[index2];
                        resultDocument.appendRow(data);
                        continue;
                    }
                    data[0] = codeSt;
                    resultDocument.appendRow(data);
                }
                TableColDataSet tableSet = new TableColDataSet(resultDocument, 0);
                XNodeSet nodeset = new XNodeSet(tableSet);
                nodeset.setTypeDecl(fms[0]);
                return nodeset;
            }
            if (type == 262) {
                XStringSet code = (XStringSet)src;
                String codeSt = null;
                int size = code.size();
                XStringSet stringset = new XStringSet(size);
                for (int i = 0; i < size; ++i) {
                    String data = null;
                    codeSt = code.stringValue(i);
                    if (this.mapCode.containsKey(codeSt)) {
                        String[] d = new String[cols];
                        d = (String[])this.mapCode.get(codeSt);
                        stringset.append(d[index2]);
                        continue;
                    }
                    data = codeSt;
                    stringset.append(data);
                }
                return stringset;
            }
            if (type == 6) {
                XString code = (XString)src;
                String data = code.stringValue();
                String data1 = null;
                if (this.mapCode.containsKey(data)) {
                    String[] d = new String[cols];
                    d = (String[])this.mapCode.get(code);
                    data1 = d[index2];
                } else {
                    data1 = data;
                }
                XString string2 = new XString(data1);
                return string2;
            }
            throw new NoSuchMethodException();
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
    }

    public RdbConnector getRdbConnector() throws MessageException {
        if (this.rdbConnector == null) {
            this.rdbConnector = new RdbConnector(this.connect, this.user, this.pwd);
        }
        return this.rdbConnector;
    }

    @Override
    public URL getDocumentURL() {
        return null;
    }

    @Override
    public String getMsgType() {
        return MSGTYPE;
    }

    @Override
    public boolean isReady() {
        return this.document != null;
    }

    @Override
    public long getLastModifies() {
        return this.lastModifies;
    }

    @Override
    public boolean isStreamIO() {
        return false;
    }

    @Override
    public Properties getDefaultProperties() {
        Properties ps = new Properties();
        ps.append("name", "New" + this.getMsgType() + "_Msg");
        ps.append("type", this.getMsgType());
        ps.append("direction", "INPUT");
        ps.append("connect", "jdbc:xxx:xxx");
        return ps;
    }

    @Override
    public FileFilter getDocumentFileFilter() {
        return new FileFilterEx(new String[]{"sql"}, "SQL  Files");
    }

    @Override
    public Properties getProperties() {
        Properties ps = super.getProperties();
        ps.append("connect", this.connect);
        if (this.user != null) {
            ps.append(PROPERTY_USER, this.user);
        }
        if (this.pwd != null) {
            ps.append(PROPERTY_PWD, this.pwd);
        }
        switch (this.transaction) {
            case 1: {
                ps.append(PROPERTY_TRANSACTION, "rollback");
                break;
            }
            case 2: {
                ps.append(PROPERTY_TRANSACTION, "stop");
                break;
            }
            case 3: {
                ps.append(PROPERTY_TRANSACTION, "skip");
                break;
            }
        }
        return ps;
    }

    @Override
    public void setProperties(Properties properties) throws MessageException {
        super.setProperties(properties);
        this.connect = properties.getValue("connect");
        if (this.connect == null) {
            MessageException.error("INVALID_PARAM", new Object[]{"connect", "null"}, null);
        }
        this.user = properties.getValue(PROPERTY_USER);
        this.pwd = properties.getValue(PROPERTY_PWD);
        String s = properties.getValue(PROPERTY_TRANSACTION);
        if (s == null) {
            this.transaction = 0;
        } else if (s.equalsIgnoreCase("rollback")) {
            this.transaction = 1;
        } else if (s.equalsIgnoreCase("stop")) {
            this.transaction = 2;
        } else if (s.equalsIgnoreCase("skip")) {
            this.transaction = 3;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_TRANSACTION, s}, null);
        }
        this.initialized = false;
    }

    @Override
    public Object getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(Object schema) throws MessageException {
        if (schema instanceof RdbSchema) {
            this.schema = (RdbSchema)schema;
            this.initialized = false;
        } else {
            this.schema = null;
            MessageException.error("CANT_CAST_SCHEMA", new Object[]{schema.getClass().getName(), this.getMsgType()}, null);
        }
    }

    @Override
    public void readSchema(Reader in) throws MessageException {
        try {
            XReader reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
            RdbSchema schema = new RdbSchema(this.getMsgName(), this.params);
            schema.setProperties(this.getProperties());
            schema.parseSchemaDecl(reader);
            this.schema = schema;
            this.initialized = false;
        }
        catch (Exception e) {
            this.schema = null;
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public void writeSchema(Writer out) throws MessageException {
        try {
            this.schema.write(out);
        }
        catch (Exception e) {
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document instanceof TableSetDocument) {
            this.document = (TableSetDocument)document;
            this.lastModifies = System.currentTimeMillis();
        } else {
            this.document = null;
            this.error("CANT_CAST_DOM", new Object[]{document.getClass().getName(), this.getMsgType()});
        }
    }

    public void read() throws MessageException {
    }

    @Override
    public void read(InputStream in) throws SAXException {
        Reader rd = null;
        try {
            String encoding = this.getMsgEncoding();
            rd = encoding != null ? XReader.createReader(in, encoding) : new InputStreamReader(in, "JISAutoDetect");
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
        this.read(rd);
    }

    @Override
    public void read(Reader in) {
    }

    @Override
    public void submit() throws SAXException {
        if (this.direction.equals("INPUT")) {
            return;
        }
        if (this.rdbConnector != null) {
            try {
                String rdb_write_style;
                this.errorRecords = null;
                if (this.transaction == 0) {
                    this.transaction = 1;
                }
                this.errorRecords = (rdb_write_style = System.getProperty("rdb.write.style", "1")).equals("1") ? this.rdbConnector.saveToRdb(this.schema, this.document, this.transaction) : this.rdbConnector.saveToRdb1(this.schema, this.document, this.transaction);
            }
            catch (RdbTransactionException e) {
                this.errorRecords = new Hashtable();
                int[] i = new int[]{e.getErrorRecord()};
                this.errorRecords.put(e.getTableName(), i);
                Exception e1 = e.getException();
                if (e1 != null) {
                    this.error(e1);
                } else {
                    this.error(e);
                }
            }
            catch (Exception e) {
                this.error(e);
            }
            this.isChanged = false;
        }
    }

    @Override
    public void write(OutputStream out) throws SAXException {
        OutputStreamWriter writer = null;
        if (this.encoding == null) {
            writer = new OutputStreamWriter(out);
        } else {
            String s = MIME2Java.convert(this.encoding);
            try {
                writer = new OutputStreamWriter(out, s);
            }
            catch (UnsupportedEncodingException e) {
                this.error("INVALID_ENCODING", this.encoding);
            }
        }
        this.write(writer);
    }

    @Override
    public void write(Writer out) throws SAXException {
        if (this.document == null) {
            return;
        }
        try {
            this.makeSqlStatement(out);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void close() throws MessageException {
        this.document = null;
        if (this.rdbConnector != null) {
            try {
                this.rdbConnector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rdbConnector = null;
    }

    @Override
    public void clearDocument() {
        if (this.direction != "INPUT" && this.document != null) {
            TableDocument[] docs = this.document.getTables();
            int n = docs.length;
            for (int i = 0; i < n; ++i) {
                docs[i].reset();
            }
            this.isChanged = true;
            this.lastModifies = System.currentTimeMillis();
        }
    }

    @Override
    public boolean init() throws SAXException {
        if (this.schema == null) {
            MessageException.error("CANT_INIT_MSG", new Object[0], null);
        }
        this.rdbConnector = new RdbConnector(this.connect, this.user, this.pwd);
        this.document = new TableSetDocument();
        try {
            this.rdbConnector.readFromRdb(this.schema, this.document);
        }
        catch (XDataException e) {
            this.fatal(e);
        }
        if (this.direction == "INPUT") {
            this.xpathSurpport = new DefaultXPathSurpport();
            this.xpathSurpport.setExtendable(false);
        } else {
            this.xpathSurpport = new DefaultXPathSurpport();
            this.xpathSurpport.setExtendable(true);
            this.isChanged = true;
            this.lastModifies = System.currentTimeMillis();
        }
        this.initialized = true;
        return true;
    }

    @Override
    public ExtOperand parseOperand(Operand orient, VariableReference variables, XReader in) throws SAXException {
        String s;
        if (!this.initialized && !this.init()) {
            this.error("CANT_INIT_MSG", this.name);
        }
        if (this.xpathSurpport.getVariableReference() != variables) {
            this.xpathSurpport.setVariableReference(variables);
        }
        if (this.xpathParser == null) {
            s = orient.getReference();
            this.xpathParser = new XPathForRdbParser();
        }
        s = orient.getReference();
        XPath xpath = this.xpathParser.parse(in, s);
        XPathOperand op = new XPathOperand(orient, xpath);
        s = s + "/" + xpath.getNodePathString();
        op.setReference(s);
        return op;
    }

    private void makeSqlStatement(Writer out) throws IOException {
        for (TableDecl tableDecl : this.schema.getTableDecls()) {
            TableDocument table;
            String[] ids;
            int type = tableDecl.getType();
            if (type == TableDecl.INSERT) {
                TableDocument table2 = this.document.getTable(tableDecl.getNodeName());
                this.makeInsertStatement(tableDecl, table2, out);
                continue;
            }
            if (type == TableDecl.UPDATE) {
                ids = tableDecl.getIDs();
                if (ids == null || ids.length == 0) continue;
                table = this.document.getTable(tableDecl.getNodeName());
                this.makeUpdateStatement(tableDecl, table, out);
                continue;
            }
            if (type != TableDecl.OVERWRITE) continue;
            ids = tableDecl.getIDs();
            if (ids != null && ids.length != 0) {
                table = this.document.getTable(tableDecl.getNodeName());
                this.makeOverWriteStatement(tableDecl, table, out);
                continue;
            }
            table = this.document.getTable(tableDecl.getNodeName());
            this.makeInsertStatement(tableDecl, table, out);
        }
    }

    private void makeInsertStatement(TableDecl tableDecl, TableDocument table, Writer out) throws IOException {
        String tbName = tableDecl.getRdbTable();
        String[] fds = tableDecl.getFields();
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tbName);
        sb.append(' ');
        boolean has = false;
        FieldMataData[] fms = table.getFieldMataData();
        if (fms != null && fms.length > 0) {
            sb.append('(');
            for (int i = 0; i < fms.length; ++i) {
                int type = fms[i].getType();
                if (type == 0) continue;
                if (has) {
                    sb.append(',');
                }
                sb.append(fms[i].name);
                has = true;
            }
            sb.append(')');
        }
        sb.append(" VALUES ");
        String baseSql = sb.toString();
        int rows = table.getRows();
        int cols = table.getCols() - 1;
        for (int i = 0; i < rows; ++i) {
            sb = new StringBuffer(baseSql);
            sb.append('(');
            for (int j = 0; j <= cols; ++j) {
                int type1;
                int type = table.getColType(j);
                if (type == 0) continue;
                sb.append(RdbConnector.getStatementParameter(table, i, j));
                if (j >= cols || (type1 = table.getColType(j + 1)) == 0) continue;
                sb.append(',');
            }
            sb.append(')');
            if (this.rdbConnector != null) {
                out.write(this.rdbConnector.nativeSQL(sb.toString()));
            } else {
                out.write(sb.toString());
            }
            out.write(this.eol);
            out.flush();
        }
    }

    private void makeUpdateStatement(TableDecl tableDecl, TableDocument table, Writer out) throws IOException {
        String tbName = tableDecl.getRdbTable();
        String[] ids = tableDecl.getIDs();
        FieldMataData[] fd = table.getFieldMataData();
        String baseSql = "UPDATE " + tbName + " SET ";
        int rows = table.getRows();
        int cols = table.getCols() - 1;
        for (int i = 0; i < rows; ++i) {
            StringBuffer sb = new StringBuffer(baseSql);
            boolean has = false;
            for (int j = 0; j <= cols; ++j) {
                if (RdbMsg.constantsString(fd[j].name, ids)) continue;
                String data = table.stringValue(i, j);
                if (table.getColType(j) == 0) continue;
                if (has) {
                    sb.append(" , ");
                }
                sb.append(fd[j].name);
                sb.append(" = ");
                sb.append(RdbConnector.getStatementParameter(table, i, j));
                has = true;
            }
            sb.append(" WHERE ");
            has = false;
            for (int k = 0; k < ids.length; ++k) {
                String data;
                int j = table.getColIndex(ids[k]);
                if (j < 0 || (data = table.stringValue(i, j)) == null || data.equalsIgnoreCase("")) continue;
                if (has) {
                    sb.append(" AND ");
                }
                sb.append(ids[k]);
                sb.append(" = ");
                sb.append(RdbConnector.getStatementParameter(table, i, j));
                has = true;
            }
            if (this.rdbConnector != null) {
                out.write(this.rdbConnector.nativeSQL(sb.toString()));
            } else {
                out.write(sb.toString());
            }
            out.write(this.eol);
            out.flush();
        }
    }

    private void makeOverWriteStatement(TableDecl tableDecl, TableDocument table, Writer out) throws IOException {
        String tbName = tableDecl.getRdbTable();
        String[] ids = tableDecl.getIDs();
        FieldMataData[] fd = table.getFieldMataData();
        String[] fds = tableDecl.getFields();
        StringBuffer sb = new StringBuffer("    INSERT INTO ");
        sb.append(tbName);
        sb.append(' ');
        boolean has = false;
        if (fd != null && fd.length > 0) {
            sb.append('(');
            for (int i = 0; i < fd.length; ++i) {
                int type = fd[i].getType();
                if (type == 0) continue;
                if (has) {
                    sb.append(',');
                }
                sb.append(fd[i].name);
                has = true;
            }
            sb.append(')');
        }
        sb.append(" VALUES (");
        String baseInsert = sb.toString();
        String baseUpdate = "    UPDATE " + tbName + " SET ";
        int rows = table.getRows();
        int cols = table.getCols() - 1;
        for (int i = 0; i < rows; ++i) {
            String data;
            int j;
            sb = new StringBuffer(" WHERE ");
            has = false;
            for (int k = 0; k < ids.length; ++k) {
                j = table.getColIndex(ids[k]);
                if (j < 0 || (data = table.stringValue(i, j)) == null || data.equalsIgnoreCase("")) continue;
                if (has) {
                    sb.append(" AND ");
                }
                sb.append(ids[k]);
                sb.append(" = ");
                sb.append(RdbConnector.getStatementParameter(table, i, j));
                has = true;
            }
            String condition = sb.toString();
            sb = new StringBuffer("IF (SELECT COUNT(*) FROM ");
            sb.append(tbName);
            sb.append(condition);
            sb.append(") >0 ");
            if (this.rdbConnector != null) {
                out.write(this.rdbConnector.nativeSQL(sb.toString()));
            } else {
                out.write(sb.toString());
            }
            out.write(this.eol);
            sb = new StringBuffer(baseUpdate);
            has = false;
            for (j = 0; j <= cols; ++j) {
                if (RdbMsg.constantsString(fd[j].name, ids)) continue;
                data = table.stringValue(i, j);
                if (table.getColType(j) == 0) continue;
                if (has) {
                    sb.append(" , ");
                }
                sb.append(fd[j].name);
                sb.append(" = ");
                sb.append(RdbConnector.getStatementParameter(table, i, j));
                has = true;
            }
            sb.append(condition);
            if (this.rdbConnector != null) {
                out.write(this.rdbConnector.nativeSQL(sb.toString()));
            } else {
                out.write(sb.toString());
            }
            out.write(this.eol);
            out.write("ELSE");
            out.write(this.eol);
            sb = new StringBuffer(baseInsert);
            for (j = 0; j <= cols; ++j) {
                int type1;
                int type = table.getColType(j);
                if (type == 0) continue;
                sb.append(RdbConnector.getStatementParameter(table, i, j));
                if (j >= cols || (type1 = table.getColType(j + 1)) == 0) continue;
                sb.append(',');
            }
            sb.append(')');
            if (this.rdbConnector != null) {
                out.write(this.rdbConnector.nativeSQL(sb.toString()));
            } else {
                out.write(sb.toString());
            }
            out.write(this.eol);
            out.flush();
        }
    }

    public int[] getErrorRecords(String tableName) {
        int[] ers;
        if (this.errorRecords != null && (ers = (int[])this.errorRecords.get(tableName)) != null) {
            return ers;
        }
        return new int[0];
    }

    static boolean constantsString(String s, String[] ss) {
        if (ss == null) {
            return false;
        }
        for (int i = 0; i < ss.length; ++i) {
            if (!s.equals(ss[i])) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Properties ps = this.getProperties();
        return ps.toString(",");
    }

    public static void main(String[] args) {
        try {
            FileReader rd = new FileReader("map3.txt");
            XReader in = XReader.createReader(rd);
            Properties ps = new Properties();
            ps.append("name", "MSG2");
            ps.append("type", MSGTYPE);
            ps.append("direction", "INPUT");
            ps.append("encoding", "SHIFT_JIS");
            ps.append("connect", "jdbc:odbc:Order");
            RdbMsg msg = new RdbMsg();
            msg.setProperties(ps);
            msg.readSchema(in);
            msg.init();
            OutputStreamWriter wr = new OutputStreamWriter(System.out);
            msg.write(wr);
            ((Writer)wr).flush();
            rd.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public String getExtension() {
        return EXTTYPE;
    }

    class XPathOperand
    extends ExtOperand {
        XPathOperand(Operand orient, Object expression) {
            super(orient, expression);
        }

        @Override
        public String getEncoding() {
            return RdbMsg.this.encoding;
        }

        private XData selectData(XData ref) throws XDataException {
            XPath xpath = (XPath)this.expression;
            Object res = null;
            try {
                if (ref instanceof XNode) {
                    return xpath.eval(ref, RdbMsg.this.xpathSurpport);
                }
                if (ref.isObject()) {
                    Object obj = ref.objectValue();
                    if (obj instanceof RdbMsg) {
                        TableSetDocument doc = ((RdbMsg)obj).document;
                        return xpath.eval(new XObject(doc), RdbMsg.this.xpathSurpport);
                    }
                    if (obj instanceof TableDocument) {
                        return xpath.eval(ref, RdbMsg.this.xpathSurpport);
                    }
                    if (obj instanceof TableSetDocument) {
                        return xpath.eval(ref, RdbMsg.this.xpathSurpport);
                    }
                    if (obj instanceof XData) {
                        Object[] param = new Object[]{((XData)obj).getPrimitiveTypeName(), TableDocument.class.getName()};
                        XData.error("CANT_TO_TYPE", param, true);
                    } else {
                        Object[] param = new Object[]{obj.getClass().getName(), TableDocument.class.getName()};
                        XData.error("CANT_TO_TYPE", param, true);
                    }
                } else {
                    Object[] param = new Object[]{ref.getPrimitiveTypeName(), TableDocument.class.getName()};
                    XData.error("CANT_TO_TYPE", param, true);
                }
            }
            catch (XDataException e) {
                throw e;
            }
            catch (Exception e) {
                XData.error(e, true);
            }
            return null;
        }

        @Override
        protected XData getData(XData ref) throws XDataException {
            RdbMsg.this.xpathSurpport.setExtendable(false);
            return this.selectData(ref);
        }

        @Override
        protected void setData(XData ref, XData data) throws XDataException {
            RdbMsg.this.xpathSurpport.setDefaultNumber(data.size());
            RdbMsg.this.xpathSurpport.setExtendable(RdbMsg.this.getDirection() != "INPUT");
            XData target = this.selectData(ref);
            int type = data.getPrimitiveType();
            int n = target.size();
            XDataMultipleException exception = null;
            switch (type) {
                case 1: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.intValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.longValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.floatValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.doubleValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.booleanValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.dateValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < n; ++i) {
                        try {
                            target.setValue(i, data.stringValue(i));
                            continue;
                        }
                        catch (XDataException e) {
                            if (exception != null) {
                                exception.addException(e);
                                continue;
                            }
                            exception = new XDataMultipleException(e);
                        }
                    }
                }
            }
            RdbMsg.this.lastModifies = System.currentTimeMillis();
            RdbMsg.this.isChanged = true;
            if (exception != null) {
                throw exception;
            }
        }
    }
}

