/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.io.XReader;
import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.DeclNodeListImpl;
import com.argo21.jxp.dtd.SchemaDecl;
import com.argo21.msg.MessageException;
import com.argo21.msg.rdb.TableDecl;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Locator;

public class RdbSchema
implements DeclNode,
SchemaDecl {
    public static final int FIELD_DECL = 43;
    public static final int RDB_DECL = 44;
    public static final int TABLE_DECL = 45;
    protected DeclNodeListImpl nodes = new DeclNodeListImpl(10);
    protected Hashtable tableDecls = new Hashtable(7);
    protected Properties ps;
    protected Properties params;
    protected String name;
    static String eol;

    public RdbSchema() {
        this(null, null);
    }

    public RdbSchema(String name2) {
        this(name2, null);
    }

    public RdbSchema(String name2, Properties params) {
        this.name = name2;
        this.params = params;
    }

    public void setProperties(Properties ps) {
        this.ps = ps;
    }

    public Properties getParameters() {
        return this.params;
    }

    @Override
    public int getNodeType() {
        return 44;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public DeclNode getParentDecl() {
        return null;
    }

    @Override
    public DeclNode getOwner() {
        return null;
    }

    @Override
    public DeclNodeList getAllDeclNode() {
        return this.nodes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean parseSchemaDecl(XReader in) throws MessageException {
        try {
            do {
                in.peekWhitespace();
                if (in.isEOF()) return true;
            } while (this.parseComment(in) || this.parseTableDecl(in));
            if (!in.isChar(']')) return true;
            return true;
        }
        catch (IOException e) {
            throw new MessageException(null, in, e);
        }
    }

    protected boolean parseComment(XReader in) throws IOException, MessageException {
        if (!in.peek("<!--")) {
            return false;
        }
        String s1 = in.readStringTo("-->", false);
        if (s1 != null) {
            CommentDeclNode decl = new CommentDeclNode(this, s1);
            this.nodes.addElement(decl);
        } else {
            MessageException.error("NEED_CHAR", "-->", (Locator)in);
        }
        return true;
    }

    protected boolean parseTableDecl(XReader in) throws MessageException {
        String direction;
        String cmd;
        String nodename;
        if (!in.peek("<!TABLE")) {
            return false;
        }
        if (!in.peekWhitespace()) {
            MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
        }
        if ((nodename = RdbSchema.maybeGetName(in)) == null || !in.peekWhitespace()) {
            MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
        }
        if (!in.peekc('(')) {
            MessageException.error("NEED_CHAR", "(", (Locator)in);
        }
        if ((cmd = RdbSchema.maybeGetName(in)) == null || !in.peekWhitespace()) {
            MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
        }
        TableDecl tbDecl = null;
        String string2 = direction = this.ps == null ? "INPUT" : this.ps.getValue("direction", "INPUT");
        if (cmd.equalsIgnoreCase("SELECT")) {
            char c;
            if (!direction.equals("INPUT")) {
                MessageException.error("INV_SQL_OUT", "INSERT,UPDATE,OVERWRITE", (Locator)in);
            }
            StringBuffer sb = new StringBuffer("SELECT ");
            int k = 0;
            while ((c = in.getc()) != '\u0000') {
                if (c == '(') {
                    ++k;
                } else if (c == ')') {
                    if (k == 0) break;
                    --k;
                }
                sb.append(c);
            }
            tbDecl = new TableDecl(this, nodename, sb.toString(), this.params);
        } else {
            String tableName;
            if (direction.equals("INPUT")) {
                MessageException.error("INV_SQL_IN", "SELECT", (Locator)in);
            }
            int type = 0;
            if (cmd.equalsIgnoreCase("INSERT")) {
                type = TableDecl.INSERT;
            } else if (cmd.equalsIgnoreCase("UPDATE")) {
                type = TableDecl.UPDATE;
            } else if (cmd.equalsIgnoreCase("OVERWRITE")) {
                type = TableDecl.OVERWRITE;
            } else {
                MessageException.error("INVAILD_CHAR", cmd, (Locator)in);
            }
            Vector fields = RdbSchema.parseFieldList(in);
            in.peekWhitespace();
            if (!in.peekIgnoreCase("TO")) {
                MessageException.error("NEED_CHAR", "TO", (Locator)in);
            }
            if (!in.peekWhitespace()) {
                MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
            }
            if ((tableName = RdbSchema.maybeGetNameOrParameter(in)) == null) {
                MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
            }
            if (in.peekc('.')) {
                String tn = RdbSchema.maybeGetNameOrParameter(in);
                if (tn == null) {
                    MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
                }
                tableName = tableName + "." + tn;
            }
            Vector ids = null;
            if (type != TableDecl.INSERT) {
                in.peekWhitespace();
                if (in.peekIgnoreCase("BY") && in.peekWhitespace()) {
                    ids = RdbSchema.parseIDList(in);
                }
            }
            tbDecl = new TableDecl(this, nodename, type, tableName, fields, ids, this.params);
            in.peekWhitespace();
            if (!in.peekc(')')) {
                MessageException.error("NEED_CHAR", ")", (Locator)in);
            }
        }
        in.peekWhitespace();
        if (!in.peekc('>')) {
            MessageException.error("NEED_CHAR", ">", (Locator)in);
        }
        this.appendChild(tbDecl);
        return true;
    }

    static Vector parseFieldList(XReader in) throws MessageException {
        Vector<String> list = new Vector<String>();
        if (in.peekc('*')) {
            return list;
        }
        while (!in.isEOF()) {
            String field = RdbSchema.maybeGetNameOrParameter(in);
            if (field == null) {
                MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
            }
            if (list.contains(field)) {
                MessageException.error("DOUBLE_NAME", field, (Locator)in);
            }
            list.addElement(field);
            in.peekWhitespace();
            if (!in.peekc(',')) break;
            in.peekWhitespace();
        }
        return list;
    }

    static Vector parseIDList(XReader in) throws MessageException {
        Vector<String> list = new Vector<String>();
        while (!in.isEOF()) {
            String field = RdbSchema.maybeGetNameOrParameter(in);
            if (field == null) {
                MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
            }
            if (list.contains(field)) {
                MessageException.error("DOUBLE_NAME", field, (Locator)in);
            }
            list.addElement(field);
            in.peekWhitespace();
            if (!in.peekc(',')) break;
            in.peekWhitespace();
        }
        return list;
    }

    public void appendChild(DeclNode newChild) {
        int type = newChild.getNodeType();
        if (type == 43 || type == 45) {
            this.tableDecls.put(newChild.getNodeName(), newChild);
            this.nodes.addElement(newChild);
        } else {
            this.nodes.addElement(newChild);
        }
    }

    public TableDecl[] getTableDecls() {
        int n = this.nodes.size();
        TableDecl[] res = new TableDecl[n];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            DeclNode obj = this.nodes.elementAt(i);
            if (!(obj instanceof TableDecl)) continue;
            res[k++] = (TableDecl)obj;
        }
        if (k < n) {
            TableDecl[] res1 = new TableDecl[k];
            System.arraycopy(res, 0, res1, 0, k);
            return res1;
        }
        return res;
    }

    public TableDecl getTableDecl(String name2) {
        Object decl = this.tableDecls.get(name2);
        if (decl != null) {
            return (TableDecl)decl;
        }
        return null;
    }

    public void write(Writer out) throws IOException {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = this.nodes.elementAt(i);
            out.write(node.toString());
            out.write(eol);
        }
    }

    public static String maybeGetNameOrParameter(XReader in) {
        if (in.peekc('%')) {
            String s = RdbSchema.maybeGetName(in);
            if (s == null) {
                in.ungetc();
                return null;
            }
            if (in.peekc('%')) {
                return "%" + s + "%";
            }
            in.back(s.length() + 1);
            return null;
        }
        return RdbSchema.maybeGetName(in);
    }

    public static String maybeGetName(XReader in) {
        char c = in.getc();
        if (!Character.isLetter(c) && c != '_') {
            in.ungetc();
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(c);
        while ((c = in.getc()) != '\u0000') {
            if (!Character.isLetterOrDigit(c) && c != '_') {
                in.ungetc();
                break;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            FileReader rd = new FileReader("map3.txt");
            XReader in = XReader.createReader(rd);
            RdbSchema cs = new RdbSchema("WWW");
            cs.parseSchemaDecl(in);
            StringWriter sw = new StringWriter();
            cs.write(sw);
            System.out.println(sw.toString());
            boolean bl = false;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    @Override
    public String getNodeTypeName() {
        return "RDBSchema";
    }

    static {
        String temp;
        try {
            temp = System.getProperty("line.separator", "\n");
        }
        catch (SecurityException e) {
            temp = "\n";
        }
        eol = temp;
    }
}

