/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.gui.CheckBoxList;
import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.PasswordFieldEx;
import com.argo21.common.gui.TextAreaEx;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.io.Debug;
import com.argo21.common.io.XReader;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.CommentDecl;
import com.argo21.jxp.dtd.CommentDeclNode;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.ResultPanel;
import com.argo21.map.MappingException;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.csv.CsvSchemaEditor;
import com.argo21.msg.rdb.RdbConnector;
import com.argo21.msg.rdb.RdbSchema;
import com.argo21.msg.rdb.TableDecl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.xml.sax.Locator;

public class RdbSchemaEditor
extends DTDEditorPanel
implements SchemaEditor {
    public static final String CMD_NEW_TABLE = "TABLE";
    public static final int CAN_NEW_TABLE = 256;
    public static final Border defBorder = BorderFactory.createEtchedBorder();
    static String[] toolBarNames = new String[]{"TABLE", "COMMENT", "-", "NODECOPY", "REMOVE", "TOUP", "TODOWN"};
    static String[][] editMenus = new String[][]{{"TABLE", "T", null, null}, {"COMMENT", "M", null, null}, {"-", null, null}, {"NODECOPY", "C", null, "2:155"}, {"REMOVE", "D", null, String.valueOf(127)}, {"-", null, null}, {"FINDNODE", "F", null, "2:70"}, {"REFINDNODE", "R", null, String.valueOf(114)}, {"-", null, null}, {"TOUP", "U", null, null}, {"TODOWN", "W", null, null}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    private Properties ps;
    Properties params;
    private RdbSchema rdbSchema;
    private SchemaEditor.NameChangedListener nameChangedListener = null;
    private SchemaEditor.ExceptionListener exceptionListener = null;
    private RdbConnector connect = null;
    private String defaultFilePath = null;
    private Vector tables = null;

    @Override
    public String getMsgType() {
        return "RDB";
    }

    @Override
    public String getMsgName() {
        return this.ps.getValue("name");
    }

    @Override
    public void close() {
        this.nameChangedListener = null;
        this.exceptionListener = null;
        if (this.connect != null) {
            this.connect.close();
            this.connect = null;
        }
    }

    public RdbSchemaEditor() {
        super(null, true, false);
        this.registActionEx();
    }

    @Override
    protected void registContentsEditorPanel() {
        ContentsEditPanel panel = new RdbDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(44, panel);
        panel = new TableDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(45, panel);
        panel = new TableFieldDeclPanel();
        panel.init(this);
        this.setContentsEditPanel(43, panel);
        String s = RdbSchemaEditor.getPackageName(DTDEditorPanel.class) + ".";
        this.setContentsEditPanel(8, s + "CommentDeclPanel");
        this.setContentsEditPanel(32, s + "DataTypeDeclPanel");
    }

    @Override
    protected void resetEditStatus() {
        DefaultMutableTreeNode selNode;
        if (this.status != 0) {
            this.status = 0;
            this.hasSetActionStatus = false;
        }
        if ((selNode = this.getSelectedTreeNode()) == null) {
            return;
        }
        if (!this.getContentsViewVisible()) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)selNode.getParent();
        int type = select.getNodeType();
        if (type != 43) {
            this.status = 288;
        }
        if (type == 45 || type == 8) {
            this.status = this.status | 0x400 | 0x800;
        }
        if (parent != null && type != 43) {
            if (parent.getFirstChild() != selNode) {
                this.status |= 0x1000;
            }
            if (parent.getLastChild() != selNode) {
                this.status |= 0x2000;
            }
        }
        this.status |= 0x4000;
        this.status = !this.searchText.equals("") ? (this.status |= 0x8000) : (this.status ^= 0x8000);
        ((Action)this.actions.get(CMD_NEW_TABLE)).setEnabled((this.status & 0x100) != 0);
        ((Action)this.actions.get("COMMENT")).setEnabled((this.status & 0x20) != 0);
        ((Action)this.actions.get("NODECOPY")).setEnabled((this.status & 0x400) != 0);
        ((Action)this.actions.get("REMOVE")).setEnabled((this.status & 0x800) != 0);
        ((Action)this.actions.get("TOUP")).setEnabled((this.status & 0x1000) != 0);
        ((Action)this.actions.get("TODOWN")).setEnabled((this.status & 0x2000) != 0);
        ((Action)this.actions.get("FINDNODE")).setEnabled((this.status & 0x4000) != 0);
        ((Action)this.actions.get("REFINDNODE")).setEnabled((this.status & 0x8000) != 0);
        this.hasSetActionStatus = true;
        if (this.toolBar != null) {
            this.setToolbarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void setToolbarStatus() {
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.toolBar.getComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    void setMenuStatus() {
        int n = this.menu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.menu.getMenuComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    @Override
    public void setNameChangedListener(SchemaEditor.NameChangedListener listener) {
        this.nameChangedListener = listener;
    }

    @Override
    public void setExceptionListener(SchemaEditor.ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    @Override
    public void setDefaultFilePath(String path) {
        this.defaultFilePath = path;
    }

    public void addNewTableDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        String name2 = this.getNewDefaultNodeName("New_Table_");
        int type = select.getNodeType();
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new TableDeclNodeData(name2));
        this.addToDefaultNode(node);
        if (type == 44) {
            root.add(node);
            this.treeModel.nodeStructureChanged(root);
        } else {
            if (selNode.getParent() != root) {
                return;
            }
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
        }
        this.setSelectedTreeNode(node);
        this.changeContents();
    }

    @Override
    protected String getNewDefaultNodeName(int type) {
        if (type == 45) {
            String basename = "New_Table_";
            return this.getNewDefaultNodeName(basename);
        }
        return super.getNewDefaultNodeName(type);
    }

    @Override
    public Component getEditorPanel() {
        return this;
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
            this.setToolbarStatus();
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(editMenus);
            this.menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    RdbSchemaEditor.this.setMenuStatus();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.setMenuStatus();
        }
        return this.menu;
    }

    @Override
    public Component getPopMenuComponent() {
        return this.tree;
    }

    @Override
    public Properties getProperties() throws MessageException {
        try {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            RdbDeclNodeData rootdata = (RdbDeclNodeData)root.getUserObject();
            return rootdata.getProperties();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    @Override
    public void load(Properties params, Properties ps, Object schema) throws MessageException {
        this.invalidConnect(false);
        this.ps = ps.cloneProperties();
        this.rdbSchema = (RdbSchema)schema;
        this.params = this.rdbSchema.getParameters();
        RdbDeclNodeData rootdata = new RdbDeclNodeData(this.ps);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.defaultNodes.removeAllElements();
        if (this.rdbSchema == null) {
            this.treeModel.nodeStructureChanged(root);
            this.tree.expandRow(0);
            this.tree.setSelectionRow(0);
            this.dtdChanged = false;
            return;
        }
        DeclNodeList nodes = this.rdbSchema.getAllDeclNode();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            DeclNode node = nodes.elementAt(i);
            int nodetype = node.getNodeType();
            DefaultMutableTreeNode treeNode = null;
            switch (nodetype) {
                case 45: {
                    DeclNodeData userdata = new TableDeclNodeData((TableDecl)node);
                    treeNode = new DefaultMutableTreeNode(userdata);
                    break;
                }
                case 8: {
                    String s = ((CommentDecl)node).getComment();
                    if (s == null) {
                        s = "";
                    }
                    DeclNodeData userdata = new DeclNodeData(8, "COMMENT", s);
                    treeNode = new DefaultMutableTreeNode(userdata);
                }
            }
            if (treeNode == null) continue;
            root.add(treeNode);
        }
        this.tree.setModel(this.treeModel);
        this.tree.setSelectionRow(0);
        this.reviewFields();
        this.setStructViewVisible(true);
        this.setContentsViewVisible(true);
        this.dtdChanged = false;
        this.resetEditStatus();
    }

    public void connectToRdb() {
        block7: {
            try {
                String con = this.ps.getValue("connect");
                String name2 = this.ps.getValue("user");
                String pwd = this.ps.getValue("pwd");
                if (con == null || con.length() == 0) {
                    return;
                }
                this.connect = new RdbConnector(con, name2, pwd);
                if (this.connect != null) {
                    Debug.println(MessageException.getMessage("CONN_RDB_OK", con));
                }
            }
            catch (Exception e) {
                if (this.connect != null) {
                    try {
                        this.connect.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connect = null;
                }
                if (this.exceptionListener == null) break block7;
                this.exceptionListener.exceptionHappened(e);
            }
        }
    }

    public RdbConnector getRdbConnector() {
        return this.connect;
    }

    public Vector getTables() {
        if (this.tables != null) {
            return this.tables;
        }
        if (this.connect != null) {
            this.refreshTables();
            return this.tables;
        }
        return null;
    }

    private void refreshTables() {
        if (this.connect == null) {
            this.tables = null;
            return;
        }
        ResultSet res = null;
        try {
            String iotype = this.ps.getValue("direction", "INPUT");
            if ("INPUT".equals(iotype)) {
                try {
                    res = this.connect.getDatabaseTables(new String[]{CMD_NEW_TABLE, "VIEW"});
                }
                catch (Exception e) {
                    res = this.connect.getDatabaseTables(new String[]{CMD_NEW_TABLE});
                }
            } else {
                res = this.connect.getDatabaseTables(new String[]{CMD_NEW_TABLE});
            }
            this.tables = new Vector();
            while (res.next()) {
                String[] ss = new String[]{res.getString(2), res.getString(3), res.getString(4)};
                this.tables.addElement(ss);
            }
        }
        catch (Exception e) {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.exceptionListener != null) {
                this.exceptionListener.exceptionHappened(e);
            }
            this.tables = null;
        }
    }

    public void invalidConnect(boolean review) {
        if (this.connect != null) {
            try {
                this.connect.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.connect = null;
        }
        if (review) {
            this.reviewFields();
        }
    }

    private void reviewFields() {
        DefaultMutableTreeNode rt = (DefaultMutableTreeNode)this.treeModel.getRoot();
        int n = rt.getChildCount();
        this.connectToRdb();
        RdbConnector con = this.getRdbConnector();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node;
            block5: {
                node = (DefaultMutableTreeNode)rt.getChildAt(i);
                DeclNodeData userdata = (DeclNodeData)node.getUserObject();
                if (userdata.getNodeType() != 45) continue;
                node.removeAllChildren();
                if (con != null) {
                    TableDecl decl = (TableDecl)((TableDeclNodeData)userdata).getDeclMode(null, this.params);
                    try {
                        FieldMataData[] fds = con.getTableMataData(decl.repleaceParameters());
                        int n1 = fds.length;
                        for (int j = 0; j < n1; ++j) {
                            CsvSchemaEditor.FieldDeclNodeData fd = new CsvSchemaEditor.FieldDeclNodeData(fds[j].name, fds[j]);
                            DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(fd);
                            node.add(subnode);
                        }
                        this.tree.expandPath(new TreePath(node.getPath()));
                    }
                    catch (Exception e) {
                        if (this.exceptionListener == null) break block5;
                        this.exceptionListener.exceptionHappened(e);
                    }
                }
            }
            if (this.treeModel == null) continue;
            this.treeModel.nodeStructureChanged(node);
        }
    }

    public void viewFieldsNodeUnderTableNode(DefaultMutableTreeNode node) {
        block5: {
            node.removeAllChildren();
            TableDeclNodeData userdata = (TableDeclNodeData)node.getUserObject();
            TableDecl decl = (TableDecl)userdata.getDeclMode(null, this.params);
            RdbConnector con = this.getRdbConnector();
            if (con != null) {
                try {
                    FieldMataData[] fds = con.getTableMataData(decl.repleaceParameters());
                    int n = fds.length;
                    for (int i = 0; i < n; ++i) {
                        CsvSchemaEditor.FieldDeclNodeData fd = new CsvSchemaEditor.FieldDeclNodeData(fds[i].name, fds[i]);
                        DefaultMutableTreeNode subnode = new DefaultMutableTreeNode(fd);
                        node.add(subnode);
                    }
                    this.tree.expandPath(new TreePath(node.getPath()));
                }
                catch (Exception e) {
                    if (this.exceptionListener == null) break block5;
                    this.exceptionListener.exceptionHappened(e);
                }
            }
        }
        if (this.treeModel != null) {
            this.treeModel.nodeStructureChanged(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getSchema() throws MessageException {
        if (this.rdbSchema != null && !this.isChanged()) {
            return this.rdbSchema;
        }
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
        RdbDeclNodeData rootdata = (RdbDeclNodeData)root.getUserObject();
        this.rdbSchema = new RdbSchema(null, this.params);
        DefaultMutableTreeNode currentNode = null;
        try {
            currentNode = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (currentNode != null) {
                DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
                int nodetype = userobj.getNodeType();
                DeclNode declnode = null;
                switch (nodetype) {
                    case 45: {
                        declnode = ((TableDeclNodeData)userobj).getDeclMode(this.rdbSchema);
                        break;
                    }
                    case 8: {
                        declnode = new CommentDeclNode(this.rdbSchema, (String)userobj.getNodeValue());
                    }
                }
                if (declnode != null) {
                    this.rdbSchema.appendChild(declnode);
                } else {
                    MessageException.error("INVALID_DECL", new Object[]{userobj.getNodeTypeNameDes(), userobj.getNodeName()}, null);
                }
                currentNode = currentNode.getNextSibling();
            }
        }
        finally {
            this.lastErrorNode = currentNode;
        }
        return this.rdbSchema;
    }

    boolean msgNameChanged(String oldName, String newName) {
        if (this.nameChangedListener != null) {
            return this.nameChangedListener.nameChanged(oldName, newName);
        }
        return true;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = MessageException.msgCatalog.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            menuItem.setFont(font);
            if (items[i][3] == null) continue;
            try {
                String sk = items[i][3];
                int k = sk.indexOf(":");
                if (k >= 0) {
                    int mask = Integer.parseInt(sk.substring(0, k));
                    int keyid = Integer.parseInt(sk.substring(k + 1));
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    continue;
                }
                int keyid = Integer.parseInt(sk);
                menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return menu;
    }

    protected void registActionEx() {
        AbstractAction a = new AbstractAction(CMD_NEW_TABLE, ImageLoader.load("table.gif", "Table")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RdbSchemaEditor.this.addNewTableDeclNode();
            }
        };
        String s = MessageException.getMessage("CMD_NEW_TABLE");
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_NEW_TABLE, a);
    }

    static class TableFieldDeclPanel
    extends CsvSchemaEditor.FieldDeclPanel {
        @Override
        public void init(DTDEditorPanel parentPanel) {
            super.init(parentPanel);
            this.nameField.setEnabled(false);
            this.typeOption.setEnabled(false);
            this.sizeField.setEnabled(false);
            this.fillField.setEnabled(false);
            this.formatField.setEnabled(false);
            this.valueField.setEnabled(false);
            this.result.setEnabled(false);
        }
    }

    static class TableDeclPanel
    extends ContentsEditPanel {
        TextFieldEx nameField;
        TextAreaEx sqlField;
        ComboTextFieldEx commField;
        ComboTextFieldEx tabField;
        CheckBoxList fieldsList;
        CheckBoxList idsList;
        JButton makeButton;
        protected ResultPanel result;
        Vector tables;

        TableDeclPanel() {
        }

        @Override
        public void init(DTDEditorPanel parentPanel) {
            super.init(parentPanel);
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.insets = new Insets(2, 2, 2, 2);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            JPanel tp = new JPanel();
            tp.setLayout(new GridBagLayout());
            tp.setOpaque(true);
            tp.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("TABLE_DECL")));
            JLabel label = new JLabel(ContentsEditPanel.getMessage("LAB_NAME"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.nameField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.nameChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.nameField, c);
            this.add((Component)tp, gc);
            ++gc.gridy;
            gc.weighty = 1.0;
            tp = new JPanel();
            tp.setLayout(new GridBagLayout());
            tp.setOpaque(true);
            tp.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("SQL_DECL_MK")));
            c.gridy = 0;
            c.gridx = 0;
            c.gridwidth = 2;
            c.gridheight = 1;
            c.weightx = 1.0;
            label = new JLabel(MessageException.getMessage("LAB_SEL_COMM"));
            tp.add((Component)label, c);
            ++c.gridy;
            this.commField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.commandChanged(value);
                    return true;
                }
            };
            tp.add((Component)this.commField, c);
            ++c.gridy;
            label = new JLabel(MessageException.getMessage("LAB_SEL_TAB"));
            tp.add((Component)label, c);
            ++c.gridy;
            this.tabField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.tableChanged(value);
                    return true;
                }
            };
            this.tabField.setModel(new DefaultComboBoxModel(){

                @Override
                public Object getElementAt(int index) {
                    if (tables != null || index < 0 || index >= tables.size()) {
                        String[] ss = (String[])tables.elementAt(index);
                        StringBuffer sb1 = new StringBuffer();
                        String schema = ss[0];
                        if (schema != null && schema.length() > 0) {
                            sb1.append(schema);
                            sb1.append('.');
                        }
                        String table = ss[1];
                        sb1.append(table);
                        String type = ss[2];
                        if (type != null && type.length() > 0) {
                            sb1.append(' ');
                            sb1.append('(');
                            sb1.append(type);
                            sb1.append(")");
                        }
                        return sb1.toString();
                    }
                    return null;
                }

                @Override
                public int getSize() {
                    if (tables != null) {
                        return tables.size();
                    }
                    return 0;
                }
            });
            tp.add((Component)this.tabField, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 1;
            label = new JLabel(MessageException.getMessage("LAB_SEL_FLD"));
            tp.add((Component)label, c);
            ++c.gridx;
            label = new JLabel(MessageException.getMessage("LAB_SEL_KEY"));
            tp.add((Component)label, c);
            c.gridx = 0;
            ++c.gridy;
            this.fieldsList = new CheckBoxList();
            JScrollPane sp = new JScrollPane(this.fieldsList);
            sp.setMinimumSize(new Dimension(this.fieldsList.getMinimumSize().width, 60));
            sp.setPreferredSize(new Dimension(80, 80));
            sp.setBorder(defBorder);
            tp.add((Component)sp, c);
            ++c.gridx;
            this.idsList = new CheckBoxList();
            sp = new JScrollPane(this.idsList);
            sp.setMinimumSize(new Dimension(this.idsList.getMinimumSize().width, 60));
            sp.setPreferredSize(new Dimension(80, 80));
            sp.setBorder(defBorder);
            tp.add((Component)sp, c);
            c.gridx = 0;
            ++c.gridy;
            c.gridwidth = 2;
            this.makeButton = new JButton(ImageLoader.load("todown.gif", "Make"));
            this.makeButton.setMargin(new Insets(0, 0, 0, 0));
            this.makeButton.setBorder(null);
            c.fill = 0;
            tp.add((Component)this.makeButton, c);
            this.makeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.makeSQL();
                }
            });
            this.add((Component)tp, gc);
            ++gc.gridy;
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.sqlField = new TextAreaEx(){

                @Override
                public boolean valueChanged(Object source, String value) {
                    return true;
                }
            };
            this.sqlField.setLineWrap(true);
            sp = new JScrollPane(this.sqlField);
            sp.setAutoscrolls(true);
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c1 = new GridBagConstraints();
            c1.gridy = 0;
            c1.gridx = 0;
            c1.gridwidth = 1;
            c1.gridheight = 2;
            c1.insets = new Insets(2, 2, 2, 2);
            c1.fill = 1;
            c1.weightx = 1.0;
            c1.weighty = 1.0;
            panel.setPreferredSize(new Dimension(80, 80));
            panel.add((Component)sp, c1);
            c1.gridheight = 1;
            ++c1.gridx;
            c1.weightx = 0.0;
            panel.add((Component)new JPanel(), c1);
            ++c1.gridy;
            c1.weighty = 0.0;
            JButton connectButton = new JButton(MappingException.getMessage("CMD_EXECUTE"));
            connectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.sqlChanged(sqlField.getText());
                }
            });
            panel.add((Component)connectButton, c1);
            panel.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("SQL_DECL")));
            this.add((Component)panel, gc);
            ++gc.gridy;
            gc.gridwidth = 0;
            gc.gridheight = 0;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            this.result = new ResultPanel(parentPanel);
            this.setPreferredSize(new Dimension(40, 40));
            this.add((Component)this.result, gc);
        }

        void nameChanged(String value) {
            TableDeclNodeData data = (TableDeclNodeData)this.node.getUserObject();
            String s = data.getNodeName();
            if (!s.equals(value)) {
                if (!TableDeclPanel.isName(value)) {
                    JOptionPane.showMessageDialog(this.parentPanel, ContentsEditPanel.getMessage("INVALID_NAME", value));
                    this.nameField.setText(s);
                    return;
                }
                if (this.parentPanel.hasNameWithoutSelect(value)) {
                    JOptionPane.showMessageDialog(this.parentPanel, ContentsEditPanel.getMessage("DOUBLE_NAME", new Object[]{value}));
                    this.nameField.setText(s);
                    return;
                }
                this.nameChangedTo(value);
                this.viewResult();
            }
        }

        void commandChanged(String value) {
        }

        void tableChanged(String value) {
            int index = this.tabField.getSelectedIndex();
            if (index < 0 || this.tables == null || index >= this.tables.size()) {
                return;
            }
            String[] ss = (String[])this.tables.elementAt(index);
            String schema = ss[0];
            String table = ss[1];
            RdbConnector con = ((RdbSchemaEditor)this.parentPanel).getRdbConnector();
            if (con == null) {
                return;
            }
            this.fieldsList.removeAllItems();
            if (this.idsList.isVisible()) {
                this.idsList.removeAllItems();
            }
            ResultSet res = null;
            try {
                res = con.getDatabaseTableColumns(schema, table);
                if (res == null) {
                    return;
                }
                this.fieldsList.addItem("*");
                while (res.next()) {
                    String s = res.getString(4);
                    this.fieldsList.addItem(s);
                    if (!this.idsList.isVisible()) continue;
                    this.idsList.addItem(s);
                }
            }
            catch (Exception e) {
                Debug.println(e);
            }
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void makeSQL() {
            String comm = (String)this.commField.getSelectedItem();
            if (comm == null) {
                return;
            }
            int type = TableDecl.getType(comm);
            if (type <= 0) {
                return;
            }
            int index = this.tabField.getSelectedIndex();
            if (index < 0 || this.tables == null || index >= this.tables.size()) {
                return;
            }
            String[] ss = (String[])this.tables.elementAt(index);
            String schema = ss[0];
            String table = ss[1];
            StringBuffer sb = new StringBuffer();
            if (schema != null && schema.length() > 0) {
                sb.append(schema);
                sb.append('.');
            }
            sb.append(table);
            String tab = new String(sb);
            Vector<Object> fds = new Vector<Object>();
            Object[] selects = this.fieldsList.getSelectedValues();
            if (selects != null) {
                for (int i = 0; i < selects.length; ++i) {
                    if (selects[i].equals("*")) {
                        fds.removeAllElements();
                        break;
                    }
                    fds.addElement(selects[i]);
                }
            }
            Vector<Object> ids = new Vector<Object>();
            selects = this.idsList.getSelectedValues();
            if (selects != null) {
                for (int i = 0; i < selects.length; ++i) {
                    ids.addElement(selects[i]);
                }
            }
            TableDeclNodeData data = (TableDeclNodeData)this.node.getUserObject();
            TableDecl decl = new TableDecl(null, data.getNodeName(), type, tab, fds, ids);
            data = new TableDeclNodeData(decl);
            this.node.setUserObject(data);
            sb = new StringBuffer();
            decl.getSQLString(sb);
            this.sqlField.setText(sb.toString());
            this.sqlField.select(0, 0);
            ((RdbSchemaEditor)this.parentPanel).viewFieldsNodeUnderTableNode(this.node);
            this.contentsChanged();
            this.viewResult();
        }

        void sqlChanged(String value) {
            if (value == null || value.length() == 0) {
                return;
            }
            try {
                value = value.trim();
                XReader in = XReader.createReader(value.toCharArray(), null);
                if (in.isEOF()) {
                    return;
                }
                String cmd = RdbSchema.maybeGetName(in);
                if (cmd == null || !in.peekWhitespace()) {
                    MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
                }
                TableDeclNodeData data = (TableDeclNodeData)this.node.getUserObject();
                Properties ps = ((RdbSchemaEditor)this.parentPanel).ps;
                String direction = ps.getValue("direction", "INPUT");
                if (cmd.equalsIgnoreCase("SELECT")) {
                    char c;
                    if (!direction.equals("INPUT")) {
                        MessageException.error("INV_SQL_OUT", "INSERT,UPDATE,OVERWRITE", (Locator)in);
                    }
                    StringBuffer sb = new StringBuffer("SELECT ");
                    boolean k = false;
                    while ((c = in.getc()) != '\u0000') {
                        sb.append(c);
                    }
                    data.type = TableDecl.SELECT;
                    data.sql = sb.toString();
                } else {
                    String tableName;
                    if (cmd.equalsIgnoreCase("INSERT")) {
                        data.type = TableDecl.INSERT;
                    } else if (cmd.equalsIgnoreCase("UPDATE")) {
                        data.type = TableDecl.UPDATE;
                    } else if (cmd.equalsIgnoreCase("OVERWRITE")) {
                        data.type = TableDecl.OVERWRITE;
                    } else {
                        MessageException.error("INVAILD_CHAR", cmd, (Locator)in);
                    }
                    if (direction.equals("INPUT")) {
                        MessageException.error("INV_SQL_IN", "SELECT", (Locator)in);
                    }
                    data.fields = RdbSchema.parseFieldList(in);
                    in.peekWhitespace();
                    if (!in.peekIgnoreCase("TO")) {
                        MessageException.error("NEED_CHAR", "TO", (Locator)in);
                    }
                    if (!in.peekWhitespace()) {
                        MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
                    }
                    if ((tableName = RdbSchema.maybeGetNameOrParameter(in)) == null) {
                        MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
                    }
                    if (in.peekc('.')) {
                        String tn = RdbSchema.maybeGetNameOrParameter(in);
                        if (tn == null) {
                            MessageException.error("INVAILD_CHAR", String.valueOf(in.lookupChar()), (Locator)in);
                        }
                        tableName = tableName + "." + tn;
                    }
                    data.rdbTable = tableName;
                    if (data.type != TableDecl.INSERT) {
                        in.peekWhitespace();
                        if (in.peekIgnoreCase("BY") && in.peekWhitespace()) {
                            data.ids = RdbSchema.parseIDList(in);
                        }
                    }
                    in.peekWhitespace();
                    if (!in.isEOF()) {
                        MessageException.error("MUST_END", String.valueOf(in.lookupWord()), (Locator)in);
                    }
                }
            }
            catch (MessageException e) {
                String s = "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> " + e.getMessage();
                JOptionPane.showMessageDialog(this.parentPanel, s);
                return;
            }
            ((RdbSchemaEditor)this.parentPanel).viewFieldsNodeUnderTableNode(this.node);
            this.contentsChanged();
            this.viewResult();
        }

        void viewResult() {
            TableDeclNodeData data = (TableDeclNodeData)this.node.getUserObject();
            TableDecl decl = (TableDecl)data.getDeclMode(null, ((RdbSchemaEditor)this.parentPanel).params);
            if (decl == null) {
                this.result.setText("");
            } else {
                String s = decl.toString();
                TableDecl decl1 = decl.repleaceParameters();
                if (decl1 != decl) {
                    s = s + "\n-------------------------------------------\n" + decl1.toString();
                }
                this.result.setText(s);
            }
        }

        @Override
        public void setTreeNode(DefaultMutableTreeNode node) {
            this.setVisible(false);
            this.node = node;
            TableDeclNodeData data = (TableDeclNodeData)node.getUserObject();
            this.nameField.setText(data.getNodeName());
            TableDecl decl = (TableDecl)data.getDeclMode(null);
            StringBuffer sb = new StringBuffer();
            decl.getSQLString(sb);
            this.sqlField.setText(sb.toString());
            this.sqlField.select(0, 0);
            Properties ps = ((RdbSchemaEditor)this.parentPanel).ps;
            String iotype = ps.getValue("direction", "INPUT");
            this.commField.setEnabledEvent(false);
            this.commField.removeAllItems();
            if (iotype.equals("INPUT")) {
                this.commField.addItem(TableDecl.TYPES[1]);
            } else {
                this.commField.addItem(TableDecl.TYPES[2]);
                this.commField.addItem(TableDecl.TYPES[3]);
                this.commField.addItem(TableDecl.TYPES[4]);
            }
            this.commField.setSelectedIndex(-1);
            this.commField.setEnabledEvent(true);
            this.tabField.setEnabledEvent(false);
            this.tables = ((RdbSchemaEditor)this.parentPanel).getTables();
            this.tabField.setModel(new DefaultComboBoxModel(){

                @Override
                public Object getElementAt(int index) {
                    if (tables != null || index < 0 || index >= tables.size()) {
                        String[] ss = (String[])tables.elementAt(index);
                        StringBuffer sb1 = new StringBuffer();
                        String schema = ss[0];
                        if (schema != null && schema.length() > 0) {
                            sb1.append(schema);
                            sb1.append('.');
                        }
                        String table = ss[1];
                        sb1.append(table);
                        String type = ss[2];
                        if (type != null && type.length() > 0) {
                            sb1.append(' ');
                            sb1.append('(');
                            sb1.append(type);
                            sb1.append(")");
                        }
                        return sb1.toString();
                    }
                    return null;
                }

                @Override
                public int getSize() {
                    if (tables != null) {
                        return tables.size();
                    }
                    return 0;
                }
            });
            if (this.tables != null) {
                this.tabField.setEnabled(true);
            } else {
                this.tabField.setEnabled(false);
                this.fieldsList.removeAllItems();
                if (this.idsList.isVisible()) {
                    this.idsList.removeAllItems();
                }
            }
            this.tabField.setSelectedIndex(-1);
            this.tabField.setEnabledEvent(true);
            this.nameField.requestFocus();
            this.viewResult();
            this.setVisible(true);
        }

        static boolean isName(String s) {
            if (s == null) {
                return false;
            }
            int n = s.length();
            if (n < 1) {
                return false;
            }
            char c = s.charAt(0);
            if (!Character.isLetter(c)) {
                return false;
            }
            for (int i = 1; i < n; ++i) {
                c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return false;
            }
            return true;
        }
    }

    static class RdbDeclPanel
    extends ContentsEditPanel {
        ComboTextFieldEx dirField;
        TextFieldEx connectField;
        TextFieldEx userField;
        JTextField pwdField;
        ComboTextFieldEx errField;
        protected TextFieldEx nameField;
        protected ResultPanel result;
        protected JPanel propertyPanel;
        static String NON = DTDEditorPanel.msgCatalog.getMessage("UNDEF_MARK");

        @Override
        public void init(DTDEditorPanel parentPanel) {
            this.parentPanel = parentPanel;
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridy = 0;
            gc.gridx = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.insets = new Insets(2, 2, 2, 2);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            JPanel tp = new JPanel();
            tp.setLayout(new GridBagLayout());
            tp.setOpaque(true);
            tp.setBorder(BorderFactory.createTitledBorder(MessageException.getMessage("RDB_DECL")));
            JLabel label = new JLabel(MessageException.getMessage("LAB_NAME"));
            tp.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.nameField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.nameChanged(value.trim());
                    return true;
                }
            };
            tp.add((Component)this.nameField, c);
            this.add((Component)tp, gc);
            ++gc.gridy;
            this.propertyPanel = new JPanel();
            this.propertyPanel.setLayout(new GridBagLayout());
            this.propertyPanel.setOpaque(true);
            this.propertyPanel.setBorder(BorderFactory.createTitledBorder(ContentsEditPanel.getMessage("TL_PROPERTY")));
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            label = new JLabel(MessageException.getMessage("LAB_DIRECTION"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.dirField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.propertyChanged("direction", value);
                    return true;
                }
            };
            this.dirField.addItem("INPUT");
            this.dirField.addItem("OUTPUT");
            this.propertyPanel.add((Component)this.dirField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            label = new JLabel(MessageException.getMessage("LAB_CONNECT"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.connectField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("connect", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.connectField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            label = new JLabel(MessageException.getMessage("LAB_DB_USER"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.userField = new TextFieldEx(10){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("user", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.userField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            label = new JLabel(MessageException.getMessage("LAB_DB_PWD"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.pwdField = new PasswordFieldEx(10){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("pwd", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.pwdField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            label = new JLabel(MessageException.getMessage("LAB_DB_ERR"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            c.gridwidth = 2;
            this.errField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("error", value);
                    return true;
                }
            };
            this.errField.addItem("rollback");
            this.errField.addItem("skip");
            this.errField.addItem("stop");
            this.propertyPanel.add((Component)this.errField, c);
            ++c.gridy;
            c.weightx = 0.0;
            c.gridwidth = 1;
            JButton connectButton = new JButton(MappingException.getMessage("CMD_CONNECT"));
            connectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.connect();
                }
            });
            this.propertyPanel.add((Component)connectButton, c);
            this.add((Component)this.propertyPanel, gc);
            ++gc.gridy;
            gc.gridwidth = 0;
            gc.gridheight = 0;
            gc.weighty = 1.0;
            gc.weightx = 1.0;
            this.result = new ResultPanel(parentPanel);
            this.add((Component)this.result, gc);
        }

        protected void nameChanged(String value) {
            RdbDeclNodeData data = (RdbDeclNodeData)this.node.getUserObject();
            String s = data.getNodeName();
            if (s.equals(value)) {
                return;
            }
            if (!this.isName(value) || ((RdbSchemaEditor)this.parentPanel).msgNameChanged(s, value)) {
                if (!this.isName(value)) {
                    JOptionPane.showMessageDialog(this.parentPanel, RdbDeclPanel.getMessage("INVALID_NAME", value));
                    this.nameField.setText(s);
                    return;
                }
                data.setNodeName(value);
                Properties ps = data.getProperties();
                ps.repleace("name", value);
                JTree tree = this.parentPanel.getStructTree();
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                this.nodeStructureChanged();
                tree.setSelectionRow(0);
                this.contentsChanged();
            }
        }

        protected void propertyChanged(String field, String value) {
            RdbDeclNodeData data = (RdbDeclNodeData)this.node.getUserObject();
            Properties ps = data.getProperties();
            if (value != null && value.length() == 0) {
                value = null;
            } else if (NON.equals(value)) {
                value = null;
            }
            String s = ps.getValue(field);
            if (s == value) {
                return;
            }
            if (value != null && value.equals(s)) {
                return;
            }
            ps.repleace(field, value);
            this.result.setText(ps.toString("\n", false, "pwd"));
            this.contentsChanged();
        }

        private void connect() {
            if (this.parentPanel instanceof RdbSchemaEditor) {
                ((RdbSchemaEditor)this.parentPanel).invalidConnect(true);
                ((RdbSchemaEditor)this.parentPanel).refreshTables();
            }
        }

        @Override
        public void setTreeNode(DefaultMutableTreeNode node) {
            super.setTreeNode(node);
            Object obj = node.getUserObject();
            RdbDeclNodeData data = (RdbDeclNodeData)obj;
            this.nameField.setText(data.getNodeName());
            Properties ps = data.getProperties();
            if (ps == null) {
                return;
            }
            String value = ps.getValue("direction");
            this.dirField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.dirField.setSelectedIndex(0);
            } else {
                this.dirField.setSelectedItem(value);
            }
            this.dirField.setEnabledEvent(true);
            value = ps.getValue("connect");
            if (value == null) {
                this.connectField.setText("");
            } else {
                this.connectField.setText(value);
            }
            value = ps.getValue("user");
            if (value == null) {
                value = "";
            }
            this.userField.setText(value);
            value = ps.getValue("pwd");
            if (value == null) {
                value = "";
            }
            this.pwdField.setText(value);
            this.result.setText(ps.toString("\n", false, "pwd"));
            value = ps.getValue("error");
            this.errField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.errField.setSelectedIndex(0);
            } else {
                this.errField.setSelectedItem(value);
            }
            this.errField.setEnabledEvent(true);
        }

        boolean isName(String s) {
            if (s == null) {
                return false;
            }
            int n = s.length();
            if (n < 1) {
                return false;
            }
            char c = s.charAt(0);
            if (!Character.isLetter(c)) {
                return false;
            }
            for (int i = 1; i < n; ++i) {
                c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                return false;
            }
            return true;
        }
    }

    static class TableDeclNodeData
    extends DeclNodeData {
        int type;
        String sql = null;
        String rdbTable = null;
        Vector fields = null;
        Vector ids = null;

        public TableDeclNodeData(String name2) {
            super(45, name2);
            this.type = TableDecl.SELECT;
            this.sql = "";
        }

        public TableDeclNodeData(TableDecl decl) {
            super(45, decl.getNodeName());
            this.type = decl.type;
            this.sql = decl.sql;
            this.rdbTable = decl.rdbTable;
            this.fields = decl.fields;
            this.ids = decl.ids;
        }

        @Override
        protected Object clone() {
            TableDeclNodeData data = new TableDeclNodeData(this.nodename);
            data.type = this.type;
            data.sql = this.sql;
            data.rdbTable = this.rdbTable;
            data.fields = this.fields;
            data.ids = this.ids;
            return data;
        }

        public DeclNode getDeclMode(DeclNode owner) {
            return this.getDeclMode(owner, null);
        }

        public DeclNode getDeclMode(DeclNode owner, Properties params) {
            if (this.type == TableDecl.SELECT) {
                return new TableDecl(owner, this.getNodeName(), this.sql, params);
            }
            return new TableDecl(owner, this.getNodeName(), this.type, this.rdbTable, this.fields, this.ids, params);
        }

        @Override
        public String getNodeTypeNameDes() {
            return MessageException.getMessage("TABLE_DECL");
        }

        @Override
        public String getNodeTypeName() {
            return "Table";
        }

        @Override
        public ImageIcon getImageIcon() {
            return ImageLoader.load("table.gif", "Table");
        }
    }

    static class RdbDeclNodeData
    extends DeclNodeData {
        RdbDeclNodeData(Properties ps) {
            super(44, ps.getValue("name"), ps);
        }

        Properties getProperties() {
            return (Properties)this.getNodeValue();
        }
    }
}

