/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.io.Debug;
import com.argo21.common.util.Properties;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaViewer;
import com.argo21.msg.rdb.RdbConnector;
import com.argo21.msg.rdb.RdbSchema;
import com.argo21.msg.rdb.TableDecl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;

public class RdbSchemaViewer
extends JTree
implements SchemaViewer {
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    private Font defaultFont;
    private DefaultTreeModel treeModel = null;
    private RdbSchema schema = null;
    private RdbConnector rdbConnector = null;
    private String msgname;
    private String connect = "";
    private String user = "";
    private String password = "";

    public RdbSchemaViewer(RdbSchema schema) {
        this();
        this.setSchema(schema);
    }

    public RdbSchemaViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception e) {
            this.defaultFont = this.getFont();
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        this.setCellRenderer(new MyTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this);
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public String getMsgType() {
        return "RDB";
    }

    @Override
    public void load(Properties ps, Object schema) throws SAXException {
        this.msgname = ps.getValue("name");
        this.connect = ps.getValue("connect");
        this.user = ps.getValue("user");
        this.password = ps.getValue("pwd");
        this.setSchema((RdbSchema)schema);
    }

    private void setSchema(RdbSchema schema) {
        this.schema = schema;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        root.removeAllChildren();
        if (schema != null) {
            try {
                this.rdbConnector = new RdbConnector(this.connect, this.user, this.password);
                TableDecl[] tableDecl = schema.getTableDecls();
                for (int i = 0; i < tableDecl.length; ++i) {
                    DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(new DeclNodeData(tableDecl[i].name, 45));
                    root.add(tableNode);
                    FieldMataData[] fms = this.rdbConnector.getTableMataData(tableDecl[i].repleaceParameters());
                    for (int j = 0; j < fms.length; ++j) {
                        tableNode.add(new DefaultMutableTreeNode(new DeclNodeData(fms[j].name, 43)));
                    }
                }
                this.rdbConnector.close();
            }
            catch (MessageException e) {
                Debug.println(e.getMessage());
            }
        } else {
            this.treeModel.nodeStructureChanged(root);
            this.setSelectionRow(0);
            return;
        }
        this.treeModel.nodeStructureChanged(root);
        this.expandAllSubNode(root);
        this.setSelectionRow(0);
    }

    private void expandAllSubNode(DefaultMutableTreeNode node) {
        this.expandPath(new TreePath(node.getPath()));
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
            this.expandAllSubNode(sub);
        }
    }

    private String makeSql(TableDecl tableDecl) {
        if (tableDecl.getType() == TableDecl.SELECT) {
            return tableDecl.getSQL();
        }
        String[] fieldName = tableDecl.getFields();
        if (fieldName.length == 0) {
            return "";
        }
        String sql = "SELECT " + fieldName[0];
        for (int i = 1; i < fieldName.length; ++i) {
            sql = sql + "," + fieldName[i];
        }
        sql = sql + " FROM " + tableDecl.rdbTable;
        return sql;
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Component getDragComponent() {
        return this;
    }

    @Override
    public String getSelectedText() {
        return this.getAbsolutePathOfSelect();
    }

    @Override
    public boolean dragStart(Component source, int x, int y) {
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDragAndDrop(path);
    }

    @Override
    public boolean dragOver(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDragAndDrop(path);
    }

    @Override
    public boolean drop(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDragAndDrop(path);
    }

    private boolean canDragAndDrop(TreePath path) {
        DeclNodeData nodeData;
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        return currentNode.getUserObject() instanceof DeclNodeData && (nodeData = (DeclNodeData)currentNode.getUserObject()).getType() == 43;
    }

    private String getAbsolutePathOfSelect() {
        if (this.schema == null) {
            return null;
        }
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)sel.getLastPathComponent();
        if (selectedNode.getUserObject() instanceof DeclNodeData) {
            DeclNodeData nodeData = (DeclNodeData)selectedNode.getUserObject();
            if (nodeData.getType() == 43) {
                DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode)selectedNode.getParent();
                DeclNodeData tableData = (DeclNodeData)tableNode.getUserObject();
                return this.msgname + "/" + tableData.getName() + "/" + nodeData.getName() + "[*]";
            }
            if (nodeData.getType() == 45) {
                return this.msgname + "/" + nodeData.getName();
            }
        }
        return null;
    }

    class DeclNodeData {
        private String name;
        private int type;

        public DeclNodeData(String name2, int type) {
            this.name = name2;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof DeclNodeData) {
                DeclNodeData declNodeData = (DeclNodeData)userObject;
                this.setText(declNodeData.getName());
                this.setToolTipText(declNodeData.getName());
                if (declNodeData.getType() == 45) {
                    this.setIcon(ImageLoader.load("table.gif", ""));
                } else {
                    this.setIcon(ImageLoader.load("field.gif", ""));
                }
            } else {
                this.setText("");
                this.setToolTipText("");
                this.setIcon(ImageLoader.load("folder.gif", ""));
            }
            this.setFont(RdbSchemaViewer.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

