/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.io.Debug;
import com.argo21.common.lang.XDataException;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.MessageException;
import com.argo21.msg.TableDocument;
import com.argo21.msg.rdb.RdbConnector;
import com.argo21.msg.rdb.RdbTransactionException;
import com.argo21.msg.rdb.TableDecl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;

public class RdbTransaction {
    private Connection con;
    private int transactionMode;
    private int level;
    private int oldLevel;
    private boolean oldAutoCommit;
    private boolean support;
    private Hashtable h;

    public RdbTransaction(Connection con, int transactionMode) {
        this.con = con;
        this.transactionMode = transactionMode;
        this.h = new Hashtable();
        this.level = 2;
        try {
            this.oldAutoCommit = con.getAutoCommit();
            this.oldLevel = con.getTransactionIsolation();
        }
        catch (SQLException e) {
            Debug.println(e.getMessage());
            this.support = false;
        }
        try {
            this.support = con.getMetaData().supportsTransactions();
            if (this.support) {
                con.setAutoCommit(false);
                if (this.oldLevel != this.level) {
                    con.setTransactionIsolation(this.level);
                }
                Debug.println(MessageException.getMessage("TRANSACTION_START"));
                Debug.flush();
            }
        }
        catch (SQLException e) {
            Debug.println(e.getMessage());
            this.support = false;
        }
    }

    public Hashtable getErrorRecord() {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInsert(TableDecl tableDecl, TableDocument table) throws SQLException, RdbTransactionException {
        int type;
        int i;
        String tbName = tableDecl.getRdbTable();
        FieldMataData[] fms = table.getFieldMataData();
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tbName);
        sb.append(' ');
        sb.append('(');
        boolean has = false;
        for (i = 0; i < fms.length; ++i) {
            type = fms[i].getType();
            if (type == 0) continue;
            if (has) {
                sb.append(',');
            }
            sb.append(fms[i].name);
            has = true;
        }
        sb.append(") VALUES (");
        has = false;
        for (i = 0; i < fms.length; ++i) {
            type = fms[i].getType();
            if (type == 0) continue;
            if (has) {
                sb.append(" , ");
            }
            sb.append('?');
            has = true;
        }
        sb.append(") ");
        PreparedStatement stmt = this.con.prepareStatement(sb.toString());
        int rows = table.getRows();
        int cols = table.getCols();
        String successMsg = "{1} success : INSERT <{2}> row TO " + tbName;
        String faultMsg = "fault : INSERT <{1}> row TO " + tbName;
        int[] errorRecords = new int[rows];
        int errorCount = 0;
        try {
            for (int i2 = 0; i2 < rows; ++i2) {
                int k = 0;
                try {
                    for (int j = 0; j < cols; ++j) {
                        int type2 = table.getColType(j);
                        if (type2 == 0) continue;
                        this.repleaceStatementParameter(stmt, k + 1, table, i2, j);
                        ++k;
                    }
                    int r = stmt.executeUpdate();
                    Debug.println(this.replaceMessage(successMsg, new String[]{"" + r, "" + i2}));
                    continue;
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i2;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i2);
                    Debug.println(this.replaceMessage(faultMsg, new String[]{"" + i2}));
                    if (this.transactionMode == 3) continue;
                    throw e1;
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception i2) {}
            int[] errorRecords1 = new int[errorCount];
            System.arraycopy(errorRecords, 0, errorRecords1, 0, errorCount);
            this.h.put(tableDecl.getNodeName(), errorRecords1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execUpdate(TableDecl tableDecl, TableDocument table) throws SQLException, RdbTransactionException {
        String tbName = tableDecl.getRdbTable();
        String[] ids = tableDecl.getIDs();
        FieldMataData[] fms = table.getFieldMataData();
        StringBuffer sb = new StringBuffer("UPDATE " + tbName + " SET ");
        int[] fields = new int[fms.length];
        int fieldCount = 0;
        boolean has = false;
        for (int i = 0; i < fms.length; ++i) {
            String name2 = fms[i].name;
            int type = fms[i].getType();
            if (type == 0 || RdbConnector.constantsString(name2, ids)) continue;
            if (has) {
                sb.append(" , ");
            }
            sb.append(fms[i].name);
            sb.append("=?");
            fields[fieldCount++] = i;
            has = true;
        }
        sb.append(" WHERE ");
        int[] keys = new int[fms.length];
        int keyCount = 0;
        has = false;
        for (int i = 0; i < ids.length; ++i) {
            int j = table.getColIndex(ids[i]);
            if (j < 0) continue;
            if (has) {
                sb.append(" AND ");
            }
            sb.append(ids[i]);
            sb.append("=?");
            keys[keyCount++] = j;
            has = true;
        }
        PreparedStatement stmt = this.con.prepareStatement(sb.toString());
        int rows = table.getRows();
        int cols = table.getCols();
        String successMsg = "{1} success : UPDATE <{2}> row TO " + tbName;
        String faultMsg = "fault: UPDATE <{1}> row TO " + tbName;
        int[] errorRecords = new int[rows];
        int errorCount = 0;
        try {
            for (int i = 0; i < rows; ++i) {
                try {
                    int type;
                    int j;
                    int k = 0;
                    for (j = 0; j < fieldCount; ++j) {
                        type = table.getColType(j);
                        if (type == 0) continue;
                        this.repleaceStatementParameter(stmt, k + 1, table, i, fields[j]);
                        ++k;
                    }
                    for (j = 0; j < keyCount; ++j) {
                        type = table.getColType(j);
                        if (type == 0) continue;
                        this.repleaceStatementParameter(stmt, k + 1, table, i, keys[j]);
                        ++k;
                    }
                    int r = stmt.executeUpdate();
                    Debug.println(this.replaceMessage(successMsg, new String[]{"" + r, "" + i}));
                    continue;
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i);
                    Debug.println(this.replaceMessage(faultMsg, new String[]{"" + i}));
                    if (this.transactionMode == 3) continue;
                    throw e1;
                }
            }
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception i) {}
            int[] errorRecords1 = new int[errorCount];
            System.arraycopy(errorRecords, 0, errorRecords1, 0, errorCount);
            this.h.put(tableDecl.getNodeName(), errorRecords1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execOverWrite(TableDecl tableDecl, TableDocument table) throws SQLException, RdbTransactionException {
        int type;
        int i;
        String tbName = tableDecl.getRdbTable();
        FieldMataData[] fms = table.getFieldMataData();
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tbName);
        sb.append(' ');
        sb.append('(');
        boolean has = false;
        for (i = 0; i < fms.length; ++i) {
            type = fms[i].getType();
            if (type == 0) continue;
            if (has) {
                sb.append(',');
            }
            sb.append(fms[i].name);
            has = true;
        }
        sb.append(") VALUES (");
        has = false;
        for (i = 0; i < fms.length; ++i) {
            type = fms[i].getType();
            if (type == 0) continue;
            if (has) {
                sb.append(',');
            }
            sb.append('?');
            has = true;
        }
        sb.append(") ");
        PreparedStatement stmtInsert = this.con.prepareStatement(sb.toString());
        String[] ids = tableDecl.getIDs();
        sb = new StringBuffer("UPDATE " + tbName + " SET ");
        int[] fields = new int[fms.length];
        int fieldCount = 0;
        has = false;
        for (int i2 = 0; i2 < fms.length; ++i2) {
            String name2 = fms[i2].name;
            int type2 = fms[i2].getType();
            if (type2 == 0 || RdbConnector.constantsString(name2, ids)) continue;
            if (has) {
                sb.append(" , ");
            }
            sb.append(fms[i2].name);
            sb.append("=?");
            fields[fieldCount++] = i2;
            has = true;
        }
        sb.append(" WHERE ");
        int[] keys = new int[fms.length];
        int keyCount = 0;
        has = false;
        for (int i3 = 0; i3 < ids.length; ++i3) {
            int j = table.getColIndex(ids[i3]);
            int type3 = table.getColType(i3);
            if (type3 == 0 || j < 0) continue;
            if (has) {
                sb.append(" AND ");
            }
            sb.append(ids[i3]);
            sb.append("=?");
            keys[keyCount++] = j;
            has = true;
        }
        PreparedStatement stmtUpdate = this.con.prepareStatement(sb.toString());
        int rows = table.getRows();
        int cols = table.getCols();
        String successMsg1 = "{1} success : UPDATE <{2}> row TO " + tbName;
        String successMsg2 = "{1} success : INSERT <{2}> row TO " + tbName;
        String faultMsg1 = "fault : UPDATE <{1}> row TO " + tbName;
        String faultMsg2 = "fault : INSERT <{1}> row TO " + tbName;
        int[] errorRecords = new int[rows];
        int errorCount = 0;
        try {
            boolean op = false;
            for (int i4 = 0; i4 < rows; ++i4) {
                try {
                    int type4;
                    int j;
                    op = false;
                    int k = 0;
                    for (j = 0; j < fieldCount; ++j) {
                        type4 = table.getColType(j);
                        if (type4 == 0) continue;
                        this.repleaceStatementParameter(stmtUpdate, k + 1, table, i4, fields[j]);
                        ++k;
                    }
                    for (j = 0; j < keyCount; ++j) {
                        type4 = table.getColType(j);
                        if (type4 == 0) continue;
                        this.repleaceStatementParameter(stmtUpdate, k + 1, table, i4, keys[j]);
                        ++k;
                    }
                    int r = stmtUpdate.executeUpdate();
                    if (r > 0) {
                        Debug.println(this.replaceMessage(successMsg1, new String[]{"" + r, "" + i4}));
                        continue;
                    }
                    op = true;
                    k = 0;
                    for (int j2 = 0; j2 < cols; ++j2) {
                        int type5 = table.getColType(j2);
                        if (type5 == 0) continue;
                        this.repleaceStatementParameter(stmtInsert, k + 1, table, i4, j2);
                        ++k;
                    }
                    r = stmtInsert.executeUpdate();
                    Debug.println(this.replaceMessage(successMsg2, new String[]{"" + r, "" + i4}));
                    continue;
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i4;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i4);
                    if (!op) {
                        Debug.println(this.replaceMessage(faultMsg1, new String[]{"" + i4}));
                    } else if (op) {
                        Debug.println(this.replaceMessage(faultMsg2, new String[]{"" + i4}));
                    }
                    if (this.transactionMode == 3) continue;
                    throw e1;
                }
            }
        }
        finally {
            try {
                stmtUpdate.close();
            }
            catch (Exception op) {}
            try {
                stmtInsert.close();
            }
            catch (Exception op) {}
            int[] errorRecords1 = new int[errorCount];
            System.arraycopy(errorRecords, 0, errorRecords1, 0, errorCount);
            this.h.put(tableDecl.getNodeName(), errorRecords1);
        }
    }

    private void repleaceStatementParameter(PreparedStatement stmt, int index, TableDocument table, int row, int col) throws SQLException, XDataException {
        FieldMataData[] fms = table.getFieldMataData();
        int type = table.getColType(col);
        switch (type) {
            case 5: {
                stmt.setBoolean(index, table.booleanValue(row, col));
                break;
            }
            case 1: {
                stmt.setInt(index, table.intValue(row, col));
                break;
            }
            case 2: {
                stmt.setLong(index, table.longValue(row, col));
                break;
            }
            case 3: {
                try {
                    stmt.setFloat(index, table.floatValue(row, col));
                }
                catch (SQLException e) {
                    stmt.setDouble(index, table.doubleValue(row, col));
                }
                break;
            }
            case 4: {
                stmt.setDouble(index, table.doubleValue(row, col));
                break;
            }
            case 7: {
                Date date = table.dateValue(row, col);
                if (date != null) {
                    if (fms[col].sqlType == 91) {
                        if (date instanceof java.sql.Date) {
                            stmt.setDate(index, (java.sql.Date)date);
                            break;
                        }
                        stmt.setDate(index, new java.sql.Date(date.getTime()));
                        break;
                    }
                    if (fms[col].sqlType == 92) {
                        if (date instanceof Time) {
                            stmt.setTime(index, (Time)date);
                            break;
                        }
                        stmt.setTime(index, new Time(date.getTime()));
                        break;
                    }
                    if (fms[col].sqlType == 93) {
                        if (date instanceof Timestamp) {
                            stmt.setTimestamp(index, (Timestamp)date);
                            break;
                        }
                        stmt.setTimestamp(index, new Timestamp(date.getTime() / 1000L * 1000L));
                        break;
                    }
                    String data = table.stringValue(row, col);
                    if (data == null) {
                        data = "";
                    }
                    try {
                        stmt.setString(index, data);
                    }
                    catch (SQLException e) {
                        stmt.setObject(index, data);
                    }
                    break;
                }
                if (fms[col].sqlType == 91 || fms[col].sqlType == 92 || fms[col].sqlType == 93) {
                    stmt.setNull(index, fms[col].sqlType);
                    break;
                }
                stmt.setObject(index, null);
                break;
            }
            default: {
                String data = table.stringValue(row, col);
                if (data == null) {
                    data = "";
                }
                try {
                    stmt.setString(index, data);
                    break;
                }
                catch (SQLException e) {
                    stmt.setObject(index, data);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execInsert1(TableDecl tableDecl, TableDocument table, Statement stmt) throws SQLException, RdbTransactionException {
        String tbName = tableDecl.getRdbTable();
        FieldMataData[] fd = table.getFieldMataData();
        String[] fds = tableDecl.getFields();
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tbName);
        sb.append(' ');
        boolean has = false;
        if (fds != null && fds.length > 0) {
            sb.append('(');
            for (int i = 0; i < fds.length; ++i) {
                int type = fd[i].getType();
                if (type == 0) continue;
                if (has) {
                    sb.append(',');
                }
                sb.append(fds[i]);
                has = true;
            }
            sb.append(") ");
        }
        sb.append("VALUES ");
        String baseSql = sb.toString();
        int rows = table.getRows();
        int cols = table.getCols();
        String successMsg = "{1} success : {2}";
        String faultMsg = "fault : {1}";
        int[] errorRecords = new int[rows];
        int errorCount = 0;
        try {
            for (int i = 0; i < rows; ++i) {
                sb = new StringBuffer(baseSql);
                sb.append('(');
                has = false;
                for (int j = 0; j < cols; ++j) {
                    int type = fd[j].getType();
                    if (type == 0) continue;
                    if (has) {
                        sb.append(" , ");
                    }
                    sb.append(RdbConnector.getStatementParameter(table, i, j));
                    has = true;
                }
                sb.append(')');
                String sql = sb.toString();
                try {
                    int r = stmt.executeUpdate(sql);
                    Debug.println(this.replaceMessage(successMsg, new String[]{"" + r, this.con.nativeSQL(sql)}));
                    continue;
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i);
                    Debug.println(this.replaceMessage(faultMsg, new String[]{this.con.nativeSQL(sql)}));
                    if (this.transactionMode == 3) continue;
                    throw e1;
                }
            }
        }
        finally {
            int[] errorRecords1 = new int[errorCount];
            System.arraycopy(errorRecords, 0, errorRecords1, 0, errorCount);
            this.h.put(tableDecl.getNodeName(), errorRecords1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execUpdate1(TableDecl tableDecl, TableDocument table, Statement stmt) throws SQLException, RdbTransactionException {
        String tbName = tableDecl.getRdbTable();
        String[] ids = tableDecl.getIDs();
        FieldMataData[] fd = table.getFieldMataData();
        String baseSql = "UPDATE " + tbName + " SET ";
        String successMsg = "{1} success : {2}";
        String faultMsg = "fault : {1}";
        int rows = table.getRows();
        int cols = table.getCols();
        int[] errorRecords = new int[rows];
        int errorCount = 0;
        try {
            for (int i = 0; i < rows; ++i) {
                StringBuffer sb = new StringBuffer(baseSql);
                boolean has = false;
                for (int j = 0; j < cols; ++j) {
                    int type = fd[i].getType();
                    if (type == 0 || RdbConnector.constantsString(fd[j].name, ids)) continue;
                    if (has) {
                        sb.append(" , ");
                    }
                    sb.append(fd[j].name);
                    sb.append(" = ");
                    sb.append(RdbConnector.getStatementParameter(table, i, j));
                    has = true;
                }
                sb.append(" WHERE ");
                has = false;
                for (int k = 0; k < ids.length; ++k) {
                    int j = table.getColIndex(ids[k]);
                    if (j < 0) continue;
                    if (has) {
                        sb.append(" AND ");
                    }
                    sb.append(ids[k]);
                    sb.append(" = ");
                    sb.append(RdbConnector.getStatementParameter(table, i, j));
                    has = true;
                }
                String sql = sb.toString();
                try {
                    int r = stmt.executeUpdate(sql);
                    Debug.println(this.replaceMessage(successMsg, new String[]{"" + r, this.con.nativeSQL(sql)}));
                    continue;
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i);
                    Debug.println(this.replaceMessage(faultMsg, new String[]{this.con.nativeSQL(sql)}));
                    if (this.transactionMode == 3) continue;
                    throw e1;
                }
            }
        }
        finally {
            int[] errorRecords1 = new int[errorCount];
            System.arraycopy(errorRecords, 0, errorRecords1, 0, errorCount);
            this.h.put(tableDecl.getNodeName(), errorRecords1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execOverWrite1(TableDecl tableDecl, TableDocument table, Statement stmt) throws SQLException, RdbTransactionException {
        String tbName = tableDecl.getRdbTable();
        String[] ids = tableDecl.getIDs();
        FieldMataData[] fd = table.getFieldMataData();
        String[] fds = tableDecl.getFields();
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tbName);
        sb.append(' ');
        boolean has = false;
        if (fds != null && fds.length > 0) {
            sb.append('(');
            for (int i = 0; i < fds.length; ++i) {
                int type = fd[i].getType();
                if (type == 0) continue;
                if (has) {
                    sb.append(',');
                }
                sb.append(fds[i]);
                has = true;
            }
            sb.append(") ");
        }
        sb.append("VALUES ");
        String baseInsert = sb.toString();
        String successMsg = "{1} success : {2}";
        String faultMsg = "fault : {1}";
        String baseUpdate = "UPDATE " + tbName + " SET ";
        int rows = table.getRows();
        int cols = table.getCols();
        int[] errorRecords = new int[rows];
        int errorCount = 0;
        try {
            for (int i = 0; i < rows; ++i) {
                sb = new StringBuffer(baseUpdate);
                has = false;
                for (int j = 0; j < cols; ++j) {
                    int type;
                    if (RdbConnector.constantsString(fd[j].name, ids) || (type = fd[i].getType()) == 0) continue;
                    if (has) {
                        sb.append(" , ");
                    }
                    sb.append(fd[j].name);
                    sb.append(" = ");
                    sb.append(RdbConnector.getStatementParameter(table, i, j));
                    has = true;
                }
                sb.append(" WHERE ");
                has = false;
                for (int k = 0; k < ids.length; ++k) {
                    int j = table.getColIndex(ids[k]);
                    if (j < 0) continue;
                    if (has) {
                        sb.append(" AND ");
                    }
                    sb.append(ids[k]);
                    sb.append(" = ");
                    sb.append(RdbConnector.getStatementParameter(table, i, j));
                    has = true;
                }
                String sql = sb.toString();
                int r = 0;
                try {
                    r = stmt.executeUpdate(sql);
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i);
                    Debug.println(this.replaceMessage(faultMsg, new String[]{this.con.nativeSQL(sql)}));
                    if (this.transactionMode != 3) {
                        throw e1;
                    }
                    --errorCount;
                    continue;
                }
                if (r > 0) {
                    Debug.println(this.replaceMessage(successMsg, new String[]{"" + r, this.con.nativeSQL(sql)}));
                    continue;
                }
                sb = new StringBuffer(baseInsert);
                sb.append('(');
                has = false;
                for (int j = 0; j < cols; ++j) {
                    int type = fd[i].getType();
                    if (type == 0) continue;
                    if (has) {
                        sb.append(',');
                    }
                    sb.append(RdbConnector.getStatementParameter(table, i, j));
                    has = true;
                }
                sb.append(')');
                sql = sb.toString();
                try {
                    r = stmt.executeUpdate(sql);
                    Debug.println(this.replaceMessage(successMsg, new String[]{"" + r, this.con.nativeSQL(sql)}));
                    continue;
                }
                catch (Exception e) {
                    errorRecords[errorCount++] = i;
                    RdbTransactionException e1 = new RdbTransactionException(e, tableDecl.getNodeName(), i);
                    Debug.println(this.replaceMessage(faultMsg, new String[]{this.con.nativeSQL(sql)}));
                    if (this.transactionMode == 3) continue;
                    throw e1;
                }
            }
        }
        finally {
            int[] errorRecords1 = new int[errorCount];
            System.arraycopy(errorRecords, 0, errorRecords1, 0, errorCount);
            this.h.put(tableDecl.getNodeName(), errorRecords1);
        }
    }

    private String replaceMessage(String msg, String[] parameters) {
        StringBuffer buffer = new StringBuffer(msg);
        int paramPos = -1;
        int len = buffer.length();
        for (int i = 0; i < len; ++i) {
            char c = buffer.charAt(i);
            if (c == '{') {
                paramPos = i;
                continue;
            }
            if (c != '}' || paramPos < 0) continue;
            try {
                int k = Integer.parseInt(buffer.substring(paramPos + 1, i));
                String param = String.valueOf(parameters[k - 1]);
                buffer.replace(paramPos, i + 1, param);
                len = len + paramPos + param.length() - 1 - i;
                i = paramPos + param.length() - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            paramPos = -1;
        }
        return buffer.toString();
    }

    public void commit() throws SQLException {
        if (this.support) {
            this.con.commit();
            Debug.println(MessageException.getMessage("TRANSACTION_COMMIT"));
            Debug.flush();
        }
    }

    public void rollback() throws SQLException {
        if (this.support) {
            this.con.rollback();
            Debug.println(MessageException.getMessage("TRANSACTION_ROLLBACK"));
            Debug.flush();
        }
    }

    public void close() {
        if (this.support) {
            try {
                if (this.oldAutoCommit) {
                    this.con.setAutoCommit(this.oldAutoCommit);
                }
                if (this.oldLevel != this.level) {
                    this.con.setTransactionIsolation(this.oldLevel);
                }
            }
            catch (SQLException e) {
                Debug.println(e.getMessage());
                this.support = false;
            }
        }
    }
}

