/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.msg.FieldMataData;
import com.argo21.msg.FieldNode;
import com.argo21.msg.TableDocument;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class ResultSetTable
implements TableDocument {
    ResultSet document;
    NodeList childNodes = new NodeList(){

        @Override
        public Node item(int index) {
            return null;
        }

        @Override
        public int getLength() {
            int rows = ResultSetTable.this.getRows();
            int cols = ResultSetTable.this.getCols();
            return rows * cols;
        }
    };

    ResultSetTable(ResultSet resultSet) {
        this.document = resultSet;
    }

    @Override
    public FieldMataData[] getFieldMataData() {
        try {
            ResultSetMetaData metadata = this.document.getMetaData();
            int n = metadata.getColumnCount();
            FieldMataData[] fieldMataData = new FieldMataData[n];
            for (int i = 1; i <= n; ++i) {
                String fdName = metadata.getColumnName(i);
                int fdType = metadata.getColumnType(i);
                int fdSize = metadata.getColumnDisplaySize(i);
                boolean nullAble = metadata.isNullable(i) == 1;
                String fdValue = null;
                int type = FieldMataData.SqlType2XDataType(fdType);
                if (XData.isNumber(type)) {
                    fdSize = 0;
                }
                fieldMataData[i - 1] = new FieldMataData(fdName, type, fdType, fdSize, nullAble, fdValue);
            }
            return fieldMataData;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void appendRow(String[] rowData) throws XDataException {
    }

    @Override
    public void extendRow(int maxRow) throws XDataException {
    }

    @Override
    public int getCols() {
        try {
            return this.document.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public int getRows() {
        try {
            this.document.last();
            return this.document.getRow();
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public int getColIndex(String colName) {
        try {
            ResultSetMetaData sd = this.document.getMetaData();
            int n = sd.getColumnCount();
            int i = 1;
            if (i <= n) {
                colName.equals(sd.getColumnClassName(i));
                return i - 1;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public String getColName(int col) {
        try {
            ResultSetMetaData sd = this.document.getMetaData();
            return sd.getColumnName(col + 1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public int getColType(int col) {
        try {
            ResultSetMetaData sd = this.document.getMetaData();
            int type = sd.getColumnType(col + 1);
            return FieldMataData.SqlType2XDataType(type);
        }
        catch (SQLException e) {
            return 0;
        }
    }

    @Override
    public String formatValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getString(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return null;
        }
    }

    @Override
    public boolean booleanValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getBoolean(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return false;
        }
    }

    @Override
    public int intValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getInt(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return 0;
        }
    }

    @Override
    public long longValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getLong(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return 0L;
        }
    }

    @Override
    public float floatValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getFloat(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return 0.0f;
        }
    }

    @Override
    public double doubleValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getDouble(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return 0.0;
        }
    }

    @Override
    public String stringValue(int row, int col) {
        try {
            ++row;
            while (this.document.getRow() > row) {
                this.document.previous();
            }
            while (this.document.getRow() < row) {
                this.document.next();
            }
            return this.document.getString(col + 1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public Date dateValue(int row, int col) throws XDataException {
        try {
            this.document.absolute(row + 1);
            return this.document.getDate(col + 1);
        }
        catch (SQLException e) {
            XData.error(e, false);
            return null;
        }
    }

    @Override
    public Object objectValue(int row, int col) {
        try {
            this.document.absolute(row + 1);
            return this.document.getObject(col + 1);
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void setValue(int row, int col, boolean value) throws XDataException {
    }

    @Override
    public void setValue(int row, int col, int value) throws XDataException {
    }

    @Override
    public void setValue(int row, int col, long value) throws XDataException {
    }

    @Override
    public void setValue(int row, int col, float value) throws XDataException {
    }

    @Override
    public void setValue(int row, int col, double value) throws XDataException {
    }

    @Override
    public void setValue(int row, int col, String value) throws XDataException {
    }

    @Override
    public void setValue(int row, int col, Date value) throws XDataException {
    }

    @Override
    public DocumentType getDoctype() {
        return null;
    }

    @Override
    public DOMImplementation getImplementation() {
        return null;
    }

    @Override
    public Element getDocumentElement() {
        return null;
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        return null;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return null;
    }

    @Override
    public Text createTextNode(String data) {
        return null;
    }

    @Override
    public Comment createComment(String data) {
        return null;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        return null;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttribute(String name2) throws DOMException {
        return null;
    }

    @Override
    public EntityReference createEntityReference(String name2) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        return null;
    }

    @Override
    public String getNodeName() {
        return "#table";
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public short getNodeType() {
        return 14;
    }

    @Override
    public Node getParentNode() {
        return null;
    }

    @Override
    public NodeList getChildNodes() {
        return this.childNodes;
    }

    @Override
    public Node getFirstChild() {
        int rows = this.getRows();
        int cols = this.getCols();
        return rows > 0 && cols > 0 ? new FieldNode(this, 0, 0) : null;
    }

    @Override
    public Node getLastChild() {
        int rows = this.getRows();
        int cols = this.getCols();
        return rows > 0 && cols > 0 ? new FieldNode(this, rows - 1, cols - 1) : null;
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return null;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        return null;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        return null;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        int rows = this.getRows();
        int cols = this.getCols();
        return rows > 0 && cols > 0;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return null;
    }

    @Override
    public String getLocalName() {
        return this.getNodeName();
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        XNodeSet nd = new XNodeSet(new Node[0]);
        return nd.nodeset();
    }

    @Override
    public Element getElementById(String elementId) {
        return null;
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        return null;
    }

    public void setEncoding(String encoding) {
    }

    @Override
    public Node adoptNode(Node source) {
        return null;
    }

    public void setVersion(String version) {
    }

    public String getVersion() {
        return null;
    }

    public boolean getStandalone() {
        return false;
    }

    public String getEncoding() {
        return null;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    public void setStandalone(boolean standalone) {
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public Object getUserData(String key) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return false;
    }

    @Override
    public boolean isSameNode(Node other) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    static {
        XNode.registNodeType(14, "table");
    }
}

