/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.lang.DataTypeDecl;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DeclNode;
import java.util.Vector;

public class TableDecl
implements DeclNode {
    public static int SELECT = 1;
    public static int INSERT = 2;
    public static int UPDATE = 3;
    public static int OVERWRITE = 4;
    public static String[] TYPES = new String[]{"", "SELECT", "INSERT", "UPDATE", "OVERWRITE"};
    private static String PARAMETER_START = "{%";
    private static String PARAMETER_END = "%}";
    String name;
    DeclNode owner = null;
    int type;
    String sql = null;
    String rdbTable;
    Vector fields = null;
    Vector ids = null;
    Properties params = null;

    public static int getType(String name2) {
        for (int i = 1; i < TYPES.length; ++i) {
            if (!TYPES[i].equalsIgnoreCase(name2)) continue;
            return i;
        }
        return 0;
    }

    public static String getTypeName(int type) {
        if (type >= 1 && type < TYPES.length) {
            return TYPES[type];
        }
        return null;
    }

    public TableDecl(DeclNode owner, String name2, String sql) {
        this(owner, name2, sql, null);
    }

    public TableDecl(DeclNode owner, String name2, String sql, Properties params) {
        this.params = params;
        this.type = SELECT;
        this.owner = owner;
        this.name = name2;
        this.sql = sql;
    }

    public TableDecl(DeclNode owner, String name2, int type, String rdbTable, Vector fields, Vector ids) {
        this(owner, name2, type, rdbTable, fields, ids, null);
    }

    public TableDecl(DeclNode owner, String name2, int type, String rdbTable, Vector fields, Vector ids, Properties params) {
        this.type = type;
        this.owner = owner;
        this.name = name2;
        this.params = params;
        if (type == SELECT) {
            if (fields != null && fields.size() > 0) {
                int n = fields.size();
                StringBuffer sb = new StringBuffer("SELECT ");
                for (int i = 0; i < n; ++i) {
                    sb.append(fields.elementAt(i));
                    if (i >= n - 1) continue;
                    sb.append(',');
                }
                sb.append(" FROM ");
                sb.append(rdbTable);
                this.sql = sb.toString();
            } else {
                this.sql = "SELECT * FROM " + rdbTable;
            }
        } else {
            this.rdbTable = rdbTable;
            this.fields = fields;
            this.ids = ids;
            this.sql = null;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getRdbTable() {
        return this.rdbTable;
    }

    public String getSQL() {
        return this.sql == null ? "" : this.sql;
    }

    public String[] getFields() {
        if (this.fields != null) {
            Object[] res = new String[this.fields.size()];
            this.fields.copyInto(res);
            return res;
        }
        return new String[0];
    }

    public String[] getIDs() {
        if (this.ids != null) {
            Object[] res = new String[this.ids.size()];
            this.ids.copyInto(res);
            return res;
        }
        return new String[0];
    }

    @Override
    public DataTypeDecl getDataTypeDecl() {
        return null;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    @Override
    public int getNodeType() {
        return 45;
    }

    public void setDataTypeDecl(DataTypeDecl dtDecl) {
    }

    public void getSQLString(StringBuffer sb) {
        if (this.type == SELECT) {
            sb.append(this.sql);
        } else {
            int i;
            int n;
            sb.append(TYPES[this.type]);
            sb.append(' ');
            int n2 = n = this.fields == null ? 0 : this.fields.size();
            if (n == 0) {
                sb.append("*");
            } else {
                for (i = 0; i < n; ++i) {
                    sb.append(this.fields.elementAt(i));
                    if (i >= n - 1) continue;
                    sb.append(',');
                }
            }
            sb.append(" TO ");
            sb.append(this.rdbTable);
            if (this.type == INSERT) {
                return;
            }
            int n3 = n = this.ids == null ? 0 : this.ids.size();
            if (n != 0) {
                sb.append(" BY ");
                for (i = 0; i < n; ++i) {
                    sb.append(this.ids.elementAt(i));
                    if (i >= n - 1) continue;
                    sb.append(',');
                }
            }
        }
    }

    public TableDecl repleaceParameters(Properties params) {
        this.params = params;
        return this.repleaceParameters();
    }

    public TableDecl repleaceParameters() {
        Vector ids;
        Vector fields;
        String value;
        if (this.params == null) {
            return this;
        }
        if (this.type == SELECT) {
            String sql = this.sql;
            int n1 = PARAMETER_START.length();
            int n2 = PARAMETER_END.length();
            boolean hasparam = false;
            int k1 = sql.indexOf(PARAMETER_START);
            while (k1 >= 0) {
                int k2 = sql.indexOf(PARAMETER_END, k1 + n1);
                if (k2 > k1) {
                    String value2 = this.params.getValue(sql.substring(k1 + n1, k2));
                    if (value2 != null) {
                        sql = sql.substring(0, k1) + value2 + sql.substring(k2 + n2);
                        hasparam = true;
                    } else {
                        sql = sql.substring(0, k1) + sql.substring(k2 + n2);
                        hasparam = true;
                    }
                    k1 = sql.indexOf(PARAMETER_START, k2 + n2);
                    continue;
                }
                k1 = -1;
            }
            if (hasparam) {
                return new TableDecl(this.owner, this.name, sql, this.params);
            }
            return this;
        }
        String rdbTable = this.rdbTable;
        boolean hasparam = false;
        if (rdbTable.startsWith(PARAMETER_START) && rdbTable.endsWith(PARAMETER_END) && (value = this.params.getValue(rdbTable.substring(1, rdbTable.length() - 1))) != null) {
            rdbTable = value;
            hasparam = true;
        }
        Vector vector = fields = this.fields == null ? null : (Vector)this.fields.clone();
        if (fields != null) {
            int n = fields.size();
            for (int i = 0; i < n; ++i) {
                String value3;
                String fd = (String)fields.elementAt(i);
                if (!fd.startsWith(PARAMETER_START) || !fd.endsWith(PARAMETER_END) || (value3 = this.params.getValue(fd.substring(1, fd.length() - 1))) == null) continue;
                fields.setElementAt(value3, i);
                hasparam = true;
            }
        }
        Vector vector2 = ids = this.ids == null ? null : (Vector)this.ids.clone();
        if (ids != null) {
            int n = ids.size();
            for (int i = 0; i < n; ++i) {
                String value4;
                String fd = (String)ids.elementAt(i);
                if (!fd.startsWith(PARAMETER_START) || !fd.endsWith(PARAMETER_END) || (value4 = this.params.getValue(fd.substring(1, fd.length() - 1))) == null) continue;
                ids.setElementAt(value4, i);
                hasparam = true;
            }
        }
        if (hasparam) {
            return new TableDecl(this.owner, this.name, this.type, rdbTable, fields, ids, this.params);
        }
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("<!TABLE ");
        sb.append(this.name);
        sb.append(" (");
        this.getSQLString(sb);
        sb.append(")>");
        return sb.toString();
    }

    @Override
    public DeclNode getParentDecl() {
        return this.owner;
    }

    @Override
    public DeclNode getOwner() {
        return this.owner;
    }

    @Override
    public String getNodeTypeName() {
        return "TableDecl";
    }
}

