/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.rdb;

import com.argo21.common.lang.XData;
import com.argo21.common.lang.XNode;
import com.argo21.jxp.xpath.Expr;
import com.argo21.jxp.xpath.RootExpr;
import com.argo21.jxp.xpath.StepExpr;
import com.argo21.jxp.xpath.XPathException;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.msg.TableDocument;
import com.argo21.msg.csv.StepExprForTable;
import com.argo21.msg.rdb.TableSetDocument;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XPathForRdbParser
extends XPathParser {
    @Override
    protected Expr parseLocationPath() throws XPathException {
        if (this.in.peek("/")) {
            Expr expr1 = this.parseRelativeLocationPath();
            expr1 = this.compose(StepExpr.getAbbreviatedStepExpr("//"), expr1);
            return new RootExpr(expr1);
        }
        return this.parseRelativeLocationPath();
    }

    @Override
    protected Expr parseRelativeLocationPath() throws XPathException {
        StepExpr expr1 = this.parseStep();
        if (expr1 == null) {
            return null;
        }
        if (this.in.peek("/")) {
            return this.compose(expr1, this.parseRelativeLocationPath());
        }
        return expr1;
    }

    @Override
    protected StepExpr parseStep() throws XPathException {
        StepExpr step;
        boolean isTable;
        String name2 = this.in.peekName();
        if (name2 == null) {
            XPathException.fatal("INVALID_CHAR", String.valueOf(this.in.getc()), (Locator)this.in);
        }
        if (this.refrance != null) {
            isTable = this.refrance.indexOf("/") < 0;
            this.refrance = this.refrance + "/" + name2;
        } else {
            isTable = this.in.isChar('/');
        }
        if (isTable) {
            step = new StepExprForTableSet(name2);
        } else {
            Expr predicate;
            step = new StepExprForTable(name2);
            while ((predicate = this.parsePredicate()) != null) {
                step.appendPredicate(predicate);
            }
        }
        return step;
    }

    public static class StepExprForTableSet
    extends StepExpr {
        String tableName;

        StepExprForTableSet(String tableName) {
            super(0, null);
            this.tableName = tableName;
        }

        @Override
        public int getType() {
            return 27;
        }

        @Override
        public XData eval(XData context, XPathSurpport surpport) throws SAXException {
            Object context1 = context.objectValue();
            if (context1 instanceof TableSetDocument) {
                this.resultName = this.tableName;
                TableSetDocument tbs = (TableSetDocument)context1;
                TableDocument tb = tbs.getTable(this.tableName);
                if (tb != null) {
                    return new XNode(tb);
                }
            }
            XPathException.fatal("INVALID_NODE", this.tableName, null);
            return null;
        }

        @Override
        public String getShortPath() {
            return this.tableName;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("table");
            sb.append("::");
            sb.append(this.tableName);
            if (this.predicaties != null) {
                for (int i = 0; i < this.predicaties.length; ++i) {
                    sb.append('[');
                    sb.append(this.predicaties[i].toString());
                    sb.append(']');
                }
            }
            return sb.toString();
        }
    }
}

