/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xml;

import com.argo21.common.lang.XmlNames;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.msg.MessageException;
import com.argo21.msg.xml.XmlDtdViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class ImportOptionDialog
extends JDialog
implements ActionListener,
TreeSelectionListener {
    boolean is_OK = false;
    XmlDtdViewer dtdviewer;
    JButton okButton;
    JButton cancelButton;
    JLabel selectRoot;
    JRadioButton appendDTD;
    JRadioButton rewriteDTD;
    JTextField prefixField;
    JTextField nameSpaceField;
    JCheckBox nsTitle;
    String selectRootText = MessageException.getMessage("LAB_IMPORT_ROOT");

    ImportOptionDialog(Frame frame, String title) {
        super(frame, title, true);
        JPanel tp = new JPanel(new BorderLayout());
        this.setContentPane(tp);
        tp.add((Component)this.createContentPanel(), "Center");
        JPanel tp2 = new JPanel();
        tp2.setLayout(new FlowLayout(1));
        this.okButton = new JButton(MessageException.getMessage("BUTTON_OK"));
        tp2.add(this.okButton);
        this.cancelButton = new JButton(MessageException.getMessage("BUTTON_CANCEL"));
        tp2.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        tp.add((Component)tp2, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ImportOptionDialog.this.is_OK = false;
                ImportOptionDialog.this.setVisible(false);
            }
        });
        this.setSize(480, 440);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DeclNode node = this.dtdviewer.getSelectedNodeDecl();
        if (node != null && node.getNodeType() == 20) {
            this.selectRoot.setText(this.selectRootText + node.getNodeName());
        } else {
            this.selectRoot.setText(this.selectRootText);
        }
    }

    private JPanel createContentPanel() {
        JPanel tp = new JPanel();
        Font font = this.getFont();
        Font deffont = new Font(font.getName(), 0, 12);
        tp.setFont(deffont);
        tp.setBorder(BorderFactory.createEtchedBorder());
        this.dtdviewer = new XmlDtdViewer();
        this.dtdviewer.setBorder(BorderFactory.createEtchedBorder());
        this.dtdviewer.addTreeSelectionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(1, 1, 1, 1);
        c.fill = 1;
        tp.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        JPanel tp2 = new JPanel(new BorderLayout());
        tp2.setFont(deffont);
        String s = MessageException.getMessage("LAB_DTD_VIEW");
        tp2.setBorder(BorderFactory.createTitledBorder(s));
        JScrollPane sp = new JScrollPane(this.dtdviewer);
        tp2.add((Component)sp, "Center");
        this.selectRoot = new JLabel(this.selectRootText);
        tp2.add((Component)this.selectRoot, "South");
        this.selectRoot.setFont(deffont);
        tp.add((Component)tp2, c);
        ButtonGroup group = new ButtonGroup();
        tp2 = new JPanel();
        tp2.setFont(deffont);
        tp2.setLayout(new FlowLayout(0));
        s = MessageException.getMessage("LAB_IMPORT_FMT");
        tp2.setBorder(BorderFactory.createTitledBorder(s));
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        tp.add((Component)tp2, c);
        s = MessageException.getMessage("BUTTON_ADD");
        this.appendDTD = new JRadioButton(s);
        tp2.add(this.appendDTD);
        this.appendDTD.setFont(deffont);
        this.appendDTD.setSelected(false);
        s = MessageException.getMessage("BUTTON_WRITE");
        this.rewriteDTD = new JRadioButton(s);
        tp2.add(this.rewriteDTD);
        this.rewriteDTD.setFont(deffont);
        this.rewriteDTD.setSelected(true);
        group.add(this.appendDTD);
        group.add(this.rewriteDTD);
        tp2 = new JPanel();
        tp2.setFont(deffont);
        c.gridx = 0;
        ++c.gridy;
        s = MessageException.getMessage("LAB_TITLE_NS");
        tp2.setBorder(BorderFactory.createTitledBorder(s));
        tp2.setLayout(new GridBagLayout());
        tp.add((Component)tp2, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        s = MessageException.getMessage("LAB_USE_NS");
        this.nsTitle = new JCheckBox(s);
        this.nsTitle.setFont(deffont);
        this.nsTitle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean b = e.getStateChange() == 1;
                ImportOptionDialog.this.prefixField.setEnabled(b);
                ImportOptionDialog.this.nameSpaceField.setEnabled(b);
            }
        });
        tp2.add((Component)this.nsTitle, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        s = MessageException.getMessage("LAB_NS_PREFIX");
        JLabel lab = new JLabel(s);
        tp2.add((Component)lab, c);
        lab.setFont(deffont);
        ++c.gridx;
        c.weightx = 1.0;
        this.prefixField = new JTextField("");
        this.prefixField.setEnabled(false);
        tp2.add((Component)this.prefixField, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.weighty = 0.0;
        s = MessageException.getMessage("LAB_NS_URI");
        lab = new JLabel(s);
        tp2.add((Component)lab, c);
        lab.setFont(deffont);
        ++c.gridx;
        c.weightx = 1.0;
        this.nameSpaceField = new JTextField("");
        this.nameSpaceField.setEnabled(false);
        tp2.add((Component)this.nameSpaceField, c);
        return tp;
    }

    public void setDTD(DTDDocument dtd) {
        this.dtdviewer.setDTD(dtd, true);
    }

    public boolean isOk() {
        return this.is_OK;
    }

    public String getRootTag() {
        DeclNode decl = this.dtdviewer.getSelectedNodeDecl();
        if (decl != null && decl.getNodeType() == 20) {
            return decl.getNodeName();
        }
        return null;
    }

    public boolean isAppendOption() {
        return this.appendDTD.isSelected();
    }

    public boolean isNameSpaceEnabled() {
        return this.nsTitle.isSelected();
    }

    public boolean isRewrite() {
        return this.rewriteDTD.isSelected();
    }

    public String getPrefix() {
        return this.prefixField.getText().trim();
    }

    public String getNameSpace() {
        return this.nameSpaceField.getText().trim();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if (obj == this.okButton) {
            if (this.isNameSpaceEnabled() && !this.checkNsPrefix()) {
                return;
            }
            this.is_OK = true;
            this.setVisible(false);
        } else if (obj == this.cancelButton) {
            this.is_OK = false;
            this.setVisible(false);
        }
    }

    boolean checkNsUri() {
        String ns = this.getPrefix();
        boolean b = XmlNames.isUnqualifiedName(ns);
        if (!b) {
            String s = MessageException.getMessage("ERR_NS_URI");
            JOptionPane.showMessageDialog(this, s);
            this.nameSpaceField.requestFocus();
        }
        return b;
    }

    boolean checkNsPrefix() {
        String prefix = this.getPrefix();
        boolean b = XmlNames.isUnqualifiedName(prefix);
        if (!b) {
            String s = MessageException.getMessage("ERR_NS_PREFIX");
            JOptionPane.showMessageDialog(this, s);
            this.prefixField.requestFocus();
        }
        return b;
    }

    static class CompTitledBorder
    extends TitledBorder {
        protected JComponent component;

        public CompTitledBorder(JComponent component) {
            this(null, component, 1, 2);
        }

        public CompTitledBorder(Border border) {
            this(border, (JComponent)null, 1, 2);
        }

        public CompTitledBorder(Border border, JComponent component) {
            this(border, component, 1, 2);
        }

        public CompTitledBorder(Border border, JComponent component, int titleJustification, int titlePosition) {
            super(border, null, titleJustification, titlePosition, null, null);
            this.component = component;
            if (border == null) {
                this.border = super.getBorder();
            }
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Rectangle borderR = new Rectangle(x + 2, y + 2, width - 4, height - 4);
            Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            Rectangle rect = new Rectangle(x, y, width, height);
            Insets insets = this.getBorderInsets(c);
            Rectangle compR = this.getComponentRect(rect, insets);
            switch (this.titlePosition) {
                case 1: {
                    int diff = compR.height + 2;
                    borderR.y += diff;
                    borderR.height -= diff;
                    break;
                }
                case 0: 
                case 2: {
                    int diff = insets.top / 2 - borderInsets.top - 2;
                    borderR.y += diff;
                    borderR.height -= diff;
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    int diff = insets.bottom / 2 - borderInsets.bottom - 2;
                    borderR.height -= diff;
                    break;
                }
                case 6: {
                    int diff = compR.height + 2;
                    borderR.height -= diff;
                }
            }
            this.border.paintBorder(c, g, borderR.x, borderR.y, borderR.width, borderR.height);
            Color col = g.getColor();
            g.setColor(c.getBackground());
            g.fillRect(compR.x, compR.y, compR.width, compR.height);
            g.setColor(col);
            this.component.repaint();
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets borderInsets = this.border != null ? this.border.getBorderInsets(c) : new Insets(0, 0, 0, 0);
            insets.top = 4 + borderInsets.top;
            insets.right = 4 + borderInsets.right;
            insets.bottom = 4 + borderInsets.bottom;
            insets.left = 4 + borderInsets.left;
            if (c == null || this.component == null) {
                return insets;
            }
            int compHeight = 0;
            if (this.component != null) {
                compHeight = this.component.getPreferredSize().height;
            }
            switch (this.titlePosition) {
                case 1: {
                    insets.top += compHeight + 2;
                    break;
                }
                case 0: 
                case 2: {
                    insets.top += Math.max(compHeight, borderInsets.top) - borderInsets.top;
                    break;
                }
                case 3: {
                    insets.top += compHeight + 2;
                    break;
                }
                case 4: {
                    insets.bottom += compHeight + 2;
                    break;
                }
                case 5: {
                    insets.bottom += Math.max(compHeight, borderInsets.bottom) - borderInsets.bottom;
                    break;
                }
                case 6: {
                    insets.bottom += compHeight + 2;
                }
            }
            return insets;
        }

        public JComponent getTitleComponent() {
            return this.component;
        }

        public void setTitleComponent(JComponent component) {
            this.component = component;
        }

        public Rectangle getComponentRect(Rectangle rect, Insets borderInsets) {
            Dimension compD = this.component.getPreferredSize();
            Rectangle compR = new Rectangle(0, 0, compD.width, compD.height);
            switch (this.titlePosition) {
                case 1: {
                    compR.y = 2;
                    break;
                }
                case 0: 
                case 2: {
                    compR.y = 2 + (borderInsets.top - 2 - 2 - compD.height) / 2;
                    break;
                }
                case 3: {
                    compR.y = borderInsets.top - compD.height - 2;
                    break;
                }
                case 4: {
                    compR.y = rect.height - borderInsets.bottom + 2;
                    break;
                }
                case 5: {
                    compR.y = rect.height - borderInsets.bottom + 2 + (borderInsets.bottom - 2 - 2 - compD.height) / 2;
                    break;
                }
                case 6: {
                    compR.y = rect.height - compD.height - 2;
                }
            }
            switch (this.titleJustification) {
                case 0: 
                case 1: {
                    compR.x = 5 + borderInsets.left;
                    break;
                }
                case 3: {
                    compR.x = rect.width - borderInsets.right - 5 - compR.width;
                    break;
                }
                case 2: {
                    compR.x = (rect.width - compR.width) / 2;
                }
            }
            return compR;
        }
    }

    static class CompTitledPane
    extends JPanel {
        protected CompTitledBorder border;
        protected JComponent component;
        protected JPanel panel;

        public CompTitledPane() {
            this(new JLabel("Title"));
        }

        public CompTitledPane(JComponent component) {
            this.component = component;
            this.border = new CompTitledBorder(component);
            this.setBorder(this.border);
            this.panel = new JPanel();
            this.setLayout(null);
            this.add(component);
            this.add(this.panel);
        }

        public JPanel getPanel() {
            return this.panel;
        }

        public JComponent getTitleComponent() {
            return this.component;
        }

        public void setTitleComponent(JComponent newComponent) {
            this.remove(this.component);
            this.add(newComponent);
            this.border.setTitleComponent(newComponent);
            this.component = newComponent;
        }

        public JPanel getContentPane() {
            return this.panel;
        }

        @Override
        public void doLayout() {
            Insets insets = this.getInsets();
            Rectangle rect = this.getBounds();
            rect.x = 0;
            rect.y = 0;
            Rectangle compR = this.border.getComponentRect(rect, insets);
            this.component.setBounds(compR);
            rect.x += insets.left;
            rect.y += insets.top;
            rect.width -= insets.left + insets.right;
            rect.height -= insets.top + insets.bottom;
            this.panel.setBounds(rect);
        }
    }
}

