/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xml;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DTDException;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.vdtd.AttDefDeclNodeData;
import com.argo21.jxp.vdtd.ContentsEditPanel;
import com.argo21.jxp.vdtd.DTDDeclNodeData;
import com.argo21.jxp.vdtd.DTDDeclPanel;
import com.argo21.jxp.vdtd.DTDEditorPanel;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.NSDeclNodeData;
import com.argo21.map.MappingException;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.xml.ImportDTDDialog;
import com.argo21.msg.xml.ImportOptionDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;

public class XmlDtdEditor
extends DTDEditorPanel
implements SchemaEditor {
    static final String CMD_IMPORT_DTD = "CMD_IMPORT";
    static final String CMD_EXPORT_DTD = "CMD_EXPORT";
    static String[] toolBarNames = new String[]{"ELEMENT", "SUBELEMENT", "ATTDEF", "COMMENT", "PI", "-", "NODECOPY", "REMOVE", "TOUP", "TODOWN"};
    static String[][] editMenus = new String[][]{{"ELEMENT", "E", null, null}, {"SUBELEMENT", "S", null, null}, {"ATTDEF", "A", null, null}, {"COMMENT", "M", null, null}, {"PI", "P", null, null}, {"NAMESPACE", "N", null, null}, {"-", null, null, null}, {"NODECOPY", "C", null, "2:155"}, {"REMOVE", "D", null, String.valueOf(127)}, {"-", null, null, null}, {"FINDNODE", "F", null, "2:70"}, {"REFINDNODE", "R", null, String.valueOf(114)}, {"-", null, null}, {"TOUP", "U", null, null}, {"TODOWN", "W", null, null}, {"-", null, null, null}, {"CMD_IMPORT", null, null, null}, {"CMD_EXPORT", null, null, null}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    private Properties ps;
    private SchemaEditor.NameChangedListener nameChangedListener = null;
    private SchemaEditor.ExceptionListener exceptionListener = null;
    private String defaultFilePath = null;

    public XmlDtdEditor() {
        super((DTDDecl)null, true);
        this.registActionEx();
    }

    @Override
    protected void registContentsEditorPanel() {
        super.registContentsEditorPanel();
        ExDTDDeclPanel ep = new ExDTDDeclPanel();
        ((ContentsEditPanel)ep).init(this);
        this.setContentsEditPanel(27, ep);
    }

    @Override
    public String getMsgType() {
        return this.ps.getValue("type");
    }

    @Override
    public String getMsgName() {
        return this.ps.getValue("name");
    }

    @Override
    public void close() {
        this.nameChangedListener = null;
        this.exceptionListener = null;
    }

    @Override
    protected void resetEditStatus() {
        super.resetEditStatus();
        if (this.toolBar != null) {
            this.setToolbarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void setToolbarStatus() {
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.toolBar.getComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    void setMenuStatus() {
        int n = this.menu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.menu.getMenuComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    String getUrlString(File file) {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return "file:" + path;
    }

    protected Frame getOwnerFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    @Override
    public void setDefaultFilePath(String path) {
        this.defaultFilePath = path;
    }

    protected DefaultMutableTreeNode getSelectDeclNode() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode root = this.getRoot();
        if (root == null || root == node) {
            return null;
        }
        while (node.getParent() != root) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return node;
    }

    void importDTD() {
        Properties ps;
        Frame f = this.getOwnerFrame();
        if (f == null) {
            return;
        }
        ImportDTDDialog in = new ImportDTDDialog(f, MessageException.getMessage(CMD_IMPORT_DTD), this.defaultFilePath);
        Point p = f.getLocation();
        p.translate((f.getWidth() - in.getWidth()) / 2, (f.getHeight() - in.getHeight()) / 2);
        in.setLocation(p);
        try {
            ps = this.getProperties();
        }
        catch (Exception e) {
            ps = this.ps;
        }
        in.setEncoding(ps.getValue("encoding"));
        in.setVisible(true);
        String errMsg = null;
        try {
            DefaultMutableTreeNode root;
            DTDDocument dtd = in.getDTD();
            if (dtd == null) {
                return;
            }
            ImportOptionDialog optdlg = new ImportOptionDialog(f, MessageException.getMessage("CMD_IMPORT_OPTION"));
            p = f.getLocation();
            p.translate((f.getWidth() - optdlg.getWidth()) / 2, (f.getHeight() - optdlg.getHeight()) / 2);
            optdlg.setLocation(p);
            optdlg.setDTD(dtd);
            optdlg.setVisible(true);
            if (!optdlg.isOk()) {
                return;
            }
            String rootname = optdlg.getRootTag();
            if (rootname != null) {
                dtd.filterAndSort(rootname);
            } else {
                dtd.removeAllEntityDecl();
            }
            if (optdlg.isNameSpaceEnabled()) {
                String prefix = optdlg.getPrefix();
                String nsuri = optdlg.getNameSpace();
                dtd.addPrefix(prefix, nsuri);
            }
            if (optdlg.isRewrite()) {
                String s;
                int rs;
                root = this.getRoot();
                if (root.getChildCount() > 0 && (rs = JOptionPane.showConfirmDialog(this, s = MappingException.getMessage("QST_CHANGE_SCHEMA"), MappingException.getMessage("DLG_CONFIRM"), 2)) != 0) {
                    return;
                }
                String encoding = in.getEncoding();
                if (encoding != null) {
                    ps.repleace("encoding", encoding);
                }
                this.load(null, ps, dtd);
            } else {
                root = this.getRoot();
                DefaultMutableTreeNode node = this.getSelectDeclNode();
                int index = -1;
                if (node != null && node != root) {
                    index = root.getIndex(node) + 1;
                    this.insertDTD(dtd, index, true);
                    ElementDecl rdecl = dtd.getRootElement();
                    if (rdecl != null) {
                        this.appendCpNodeToElement(node, rdecl.getNodeName());
                    }
                } else {
                    index = root.getChildCount();
                    this.insertDTD(dtd, index, true);
                }
            }
        }
        catch (DTDException e) {
            String systemId = e.getSystemId();
            errMsg = systemId != null ? systemId + "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage() : "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage();
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        this.changeContents();
        if (errMsg != null) {
            JOptionPane.showMessageDialog(this, errMsg);
        }
    }

    void exportDTD() {
        int rs;
        FileFilterEx filter = new FileFilterEx(new String[]{"dtd"}, "DTD Files");
        File file = this.getSaveFileName(filter);
        if (file == null) {
            return;
        }
        String s = file.getName();
        if (s != null && s.indexOf(".") < 0) {
            s = s + ".dtd";
            String parent = file.getParent();
            file = parent != null ? new File(parent, s) : new File(s);
        }
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, MappingException.getMessage("INVALID_FILE", file.getPath()));
            return;
        }
        if (file.exists() && (rs = JOptionPane.showConfirmDialog(this, s = MappingException.getMessage("QST_SAVEOVER", file.getPath()), MappingException.getMessage("DLG_CONFIRM"), 0)) == 1) {
            return;
        }
        String errMsg = null;
        DTDDecl dtd = null;
        try {
            dtd = this.getDTD();
        }
        catch (DTDException e) {
            String systemId = e.getSystemId();
            errMsg = systemId != null ? systemId + "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage() : "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage();
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (errMsg != null) {
            JOptionPane.showMessageDialog(this, errMsg);
            return;
        }
        try {
            dtd.save(file.toString());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    @Override
    protected void setActionEnabled() {
        ((Action)this.actions.get("NAMESPACE")).setEnabled((this.status & 0x200) != 0);
        super.setActionEnabled();
    }

    @Override
    public void setNameChangedListener(SchemaEditor.NameChangedListener listener) {
        this.nameChangedListener = listener;
    }

    @Override
    public void setExceptionListener(SchemaEditor.ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    protected void registActionEx() {
        String s = MessageException.getMessage(CMD_IMPORT_DTD);
        AbstractAction a = new AbstractAction(CMD_IMPORT_DTD){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlDtdEditor.this.importDTD();
            }
        };
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_IMPORT_DTD, a);
        s = msgCatalog.getMessage("CMD_NEW_NSDEF");
        a = new AbstractAction("NAMESPACE", ImageLoader.load("namespace.gif", "NS")){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlDtdEditor.this.addNewNsDeclNode();
            }
        };
        a.putValue("ShortDescription", s);
        this.actions.put("NAMESPACE", a);
        s = MessageException.getMessage(CMD_EXPORT_DTD);
        a = new AbstractAction(CMD_EXPORT_DTD){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlDtdEditor.this.exportDTD();
            }
        };
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_EXPORT_DTD, a);
    }

    @Override
    public Component getEditorPanel() {
        return this;
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
            this.setToolbarStatus();
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(editMenus);
            this.menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    XmlDtdEditor.this.setMenuStatus();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.setMenuStatus();
        }
        return this.menu;
    }

    @Override
    public Component getPopMenuComponent() {
        return this.tree;
    }

    @Override
    public Properties getProperties() throws MessageException {
        try {
            return this.getDTD().getProperties();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    @Override
    public void load(Properties params, Properties ps, Object schema) throws MessageException {
        this.ps = ps;
        DTDDecl dtd1 = (DTDDecl)schema;
        if (dtd1.getProperties() != ps) {
            dtd1.getProperties().removeAll();
            String name2 = ps.getValue("name");
            int n = ps.getSize();
            for (int i = 0; i < n; ++i) {
                dtd1.putProperty(ps.getName(i), ps.getValue(i));
            }
        }
        this.setDTD(dtd1);
    }

    @Override
    public Object getSchema() throws MessageException {
        try {
            return this.getDTD();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    boolean msgNameChanged(String oldName, String newName) {
        if (this.nameChangedListener != null) {
            return this.nameChangedListener.nameChanged(oldName, newName);
        }
        return true;
    }

    File getSaveFileName(FileFilter filter) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(MessageException.getMessage(CMD_EXPORT_DTD));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        try {
            File currentDirectory = new File(this.defaultFilePath);
            if (!currentDirectory.exists()) {
                currentDirectory = new File(System.getProperty("user.dir"));
            }
            if (currentDirectory.exists()) {
                fileChooser.setCurrentDirectory(currentDirectory);
            }
        }
        catch (Exception currentDirectory) {
            // empty catch block
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        int result = fileChooser.showSaveDialog(this);
        if (result != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        return file;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = MessageException.msgCatalog.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
        }
        return menu;
    }

    public void addNewNsDeclNode() {
        DefaultMutableTreeNode selNode = this.getSelectedTreeNode();
        if (selNode == null) {
            return;
        }
        DeclNodeData select = (DeclNodeData)selNode.getUserObject();
        if (select == null) {
            return;
        }
        int type = select.getNodeType();
        if (type == 20) {
            String name2 = this.getNewDefaultNodeName("xmlns:prefix");
            String elemName = select.getNodeName();
            NSDeclNodeData ndata = new NSDeclNodeData(elemName, name2);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(ndata);
            this.addToDefaultNode(node);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
            while (selNode.getParent() != root) {
                selNode = (DefaultMutableTreeNode)selNode.getParent();
            }
            int pos = this.treeModel.getIndexOfChild(root, selNode);
            this.treeModel.insertNodeInto(node, root, pos + 1);
            String prefix = name2.substring(6);
            Hashtable<String, Boolean> sbset = new Hashtable<String, Boolean>();
            sbset.put(elemName, Boolean.TRUE);
            this.addPrefixToTree(sbset, prefix);
            ndata.setElementName(select.getNodeName());
            this.setSelectedTreeNode(node);
            this.changeContents();
        }
    }

    private void addPrefixToTree(Hashtable sbset, String prefix) {
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            String elem;
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            int nodetype = data.getNodeType();
            String name2 = data.getNodeName();
            if (nodetype == 20) {
                if (sbset.containsKey(name2)) {
                    this.addPrefixToElement(node, prefix);
                }
            } else if (nodetype == 22 && sbset.containsKey(elem = ((AttDefDeclNodeData)data).getElementName())) {
                ((AttDefDeclNodeData)data).setElementName(prefix + ":" + elem);
            }
            node = node.getNextSibling();
        }
    }

    private void addPrefixToElement(DefaultMutableTreeNode node, String prefix) {
        DeclNodeData data;
        String name2;
        Hashtable sbset = new Hashtable();
        this.addPrefixToAttr(node, prefix);
        this.addPrefixToChildren(node, prefix, sbset);
        if (!sbset.isEmpty()) {
            this.addPrefixToTree(sbset, prefix);
        }
        if ((name2 = (data = (DeclNodeData)node.getUserObject()).getNodeName()).indexOf(58) < 0) {
            this.treeNodeNameChanged(node, prefix + ":" + name2);
        }
    }

    private void addPrefixToAttr(DefaultMutableTreeNode parent, String prefix) {
        DeclNodeData data = (DeclNodeData)parent.getUserObject();
        String elementName = data.getNodeName();
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            String elem;
            data = (DeclNodeData)node.getUserObject();
            int nodetype = data.getNodeType();
            String name2 = data.getNodeName();
            if (nodetype == 22 && elementName.equals(elem = ((AttDefDeclNodeData)data).getElementName()) && name2.indexOf(58) < 0) {
                this.treeNodeNameChanged(node, prefix + ":" + name2);
            }
            node = node.getNextSibling();
        }
    }

    private void addPrefixToChildren(DefaultMutableTreeNode parent, String prefix, Hashtable sbset) {
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)parent.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            int type = data.getNodeType();
            if (type == 31) {
                String name2 = data.getNodeName();
                if (name2.indexOf(58) < 0) {
                    sbset.put(name2, Boolean.TRUE);
                    this.treeNodeNameChanged(node, prefix + ":" + name2);
                }
                this.addPrefixToChildren(node, prefix, sbset);
            } else if (type == 30) {
                this.addPrefixToChildren(node, prefix, sbset);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    protected void nameSpaceChanged(String prefix, String prefix1) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            String name2;
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            int type = data.getNodeType();
            if (type == 20) {
                name2 = data.getNodeName();
                if (name2.startsWith(prefix)) {
                    this.treeNodeNameChanged(node, prefix1 + name2.substring(prefix.length()));
                }
                this.nameSpaceChanged(node, prefix, prefix1);
            } else if (type == 22) {
                name2 = data.getNodeName();
                if (name2.startsWith(prefix)) {
                    this.treeNodeNameChanged(node, prefix1 + name2.substring(prefix.length()));
                }
                if ((name2 = ((AttDefDeclNodeData)data).getElementName()).startsWith(prefix)) {
                    ((AttDefDeclNodeData)data).setElementName(prefix1 + name2.substring(prefix.length()));
                    this.treeModel.nodeChanged(node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private void nameSpaceChanged(DefaultMutableTreeNode parent, String prefix, String prefix1) {
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)parent.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            int type = data.getNodeType();
            if (type == 31) {
                String name2 = data.getNodeName();
                if (name2.startsWith(prefix)) {
                    this.treeNodeNameChanged(node, prefix1 + name2.substring(prefix.length()));
                }
                this.nameSpaceChanged(node, prefix, prefix1);
            } else if (type == 30) {
                this.nameSpaceChanged(node, prefix, prefix1);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    protected void changeNsElement(String oldelem, String newelem) {
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            NSDeclNodeData da;
            DeclNodeData data = (DeclNodeData)node.getUserObject();
            if (data.getNodeType() == 25 && oldelem.equals((da = (NSDeclNodeData)data).getElementName())) {
                da.setElementName(newelem);
            }
            node = node.getNextSibling();
        }
    }

    @Override
    protected String searchPrefix(DefaultMutableTreeNode node) {
        String elem = null;
        while (node != null) {
            DeclNodeData select = (DeclNodeData)node.getUserObject();
            if (select.getNodeType() == 20) {
                elem = select.getNodeName();
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (elem == null) {
            return null;
        }
        String prefix = XmlNames.getPrefix(elem);
        if (prefix != null) {
            return prefix;
        }
        return this.searchPrefix(elem);
    }

    @Override
    protected String searchPrefix(String element) {
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            NSDeclNodeData da;
            DeclNodeData data1 = (DeclNodeData)node.getUserObject();
            int nodetype = data1.getNodeType();
            if (nodetype == 25 && element.equals((da = (NSDeclNodeData)data1).getElementName())) {
                return da.getPrefix();
            }
            node = node.getNextSibling();
        }
        return null;
    }

    static class ExDTDDeclPanel
    extends DTDDeclPanel {
        ComboTextFieldEx dirField;
        JCheckBox withexdtd;
        JCheckBox withdtd;
        JCheckBox checkField;
        JCheckBox checkIndent;
        JCheckBox checkEmptyTag;
        TextFieldEx urlField;
        TextFieldEx dtdurlField;

        ExDTDDeclPanel() {
        }

        @Override
        public void init(DTDEditorPanel parentPanel) {
            super.init(parentPanel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            c.weightx = 0.0;
            JLabel label = new JLabel(MessageException.getMessage("LAB_DIRECTION"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.dirField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.propertyChanged("direction", value);
                    return true;
                }
            };
            this.dirField.addItem("INPUT");
            this.dirField.addItem("OUTPUT");
            this.propertyPanel.add((Component)this.dirField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_DOC_URL"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.urlField = new TextFieldEx(){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("url", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.urlField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_SYS_URL"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.dtdurlField = new TextFieldEx(){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("SYSTEM", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.dtdurlField, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.withexdtd = new JCheckBox(MessageException.getMessage("LAB_WITHEXDTD"));
            this.withexdtd.setFont(this.getDefaultFont());
            this.withexdtd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = withexdtd.isSelected() ? "YES" : "NO";
                    this.propertyChanged("withexdtd", value);
                }
            });
            this.propertyPanel.add((Component)this.withexdtd, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.withdtd = new JCheckBox(MessageException.getMessage("LAB_WITHDTD"));
            this.withdtd.setFont(this.getDefaultFont());
            this.withdtd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = withdtd.isSelected() ? "YES" : "NO";
                    this.propertyChanged("withdtd", value);
                }
            });
            this.propertyPanel.add((Component)this.withdtd, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.checkField = new JCheckBox(MessageException.getMessage("LAB_DTDCHECK"));
            this.checkField.setFont(this.getDefaultFont());
            this.checkField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = checkField.isSelected() ? "YES" : "NO";
                    this.propertyChanged("validate", value);
                }
            });
            this.propertyPanel.add((Component)this.checkField, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.checkIndent = new JCheckBox(MessageException.getMessage("LAB_INDENT"));
            this.checkIndent.setFont(this.getDefaultFont());
            this.checkIndent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = checkIndent.isSelected() ? "true" : "false";
                    this.propertyChanged("indent", value);
                }
            });
            this.propertyPanel.add((Component)this.checkIndent, c);
        }

        @Override
        protected void nameChanged(String value) {
            DTDDeclNodeData data = (DTDDeclNodeData)this.node.getUserObject();
            String s = data.getNodeName();
            if (s.equals(value)) {
                return;
            }
            if (!ExDTDDeclPanel.isName(value)) {
                super.nameChanged(value);
                return;
            }
            if (((XmlDtdEditor)this.parentPanel).msgNameChanged(s, value)) {
                super.nameChanged(value);
            }
        }

        @Override
        protected void propertyChanged(String field, String value) {
            super.propertyChanged(field, value);
            if (field.equals("withexdtd") && this.withexdtd.isSelected()) {
                String dtdurl;
                if (this.withdtd.isSelected()) {
                    super.propertyChanged("withdtd", "NO");
                    this.withdtd.setSelected(false);
                }
                if ((dtdurl = this.dtdurlField.getText()).equals("")) {
                    this.dtdurlField.setText("http://");
                    super.propertyChanged("SYSTEM", "http://");
                }
            } else if (field.equals("withdtd") && this.withdtd.isSelected() && this.withexdtd.isSelected()) {
                super.propertyChanged("withexdtd", "NO");
                this.withexdtd.setSelected(false);
            }
        }

        @Override
        public void setTreeNode(DefaultMutableTreeNode node) {
            super.setTreeNode(node);
            Object obj = node.getUserObject();
            DTDDeclNodeData data = (DTDDeclNodeData)obj;
            this.nameField.setText(data.getNodeName());
            Properties ps = data.getProperties();
            if (ps == null) {
                return;
            }
            String value = ps.getValue("direction");
            this.dirField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.dirField.setSelectedIndex(0);
            } else {
                this.dirField.setSelectedItem(value);
            }
            this.dirField.setEnabledEvent(true);
            value = ps.getValue("url");
            if (value == null) {
                this.urlField.setText("");
            } else {
                this.urlField.setText(value);
            }
            value = ps.getValue("SYSTEM");
            if (value == null) {
                this.dtdurlField.setText("");
            } else {
                this.dtdurlField.setText(value);
            }
            value = ps.getValue("withexdtd");
            if (value == null) {
                this.withexdtd.setSelected(false);
            } else {
                this.withexdtd.setSelected(value.equalsIgnoreCase("YES"));
            }
            value = ps.getValue("withdtd");
            if (value == null) {
                this.withdtd.setSelected(false);
            } else {
                this.withdtd.setSelected(value.equalsIgnoreCase("YES"));
            }
            value = ps.getValue("validate");
            if (value == null) {
                this.checkField.setSelected(false);
            } else {
                this.checkField.setSelected(value.equalsIgnoreCase("YES"));
            }
            value = ps.getValue("indent");
            if (value == null) {
                this.checkIndent.setSelected(true);
            } else {
                this.checkIndent.setSelected(value.equalsIgnoreCase("true"));
            }
            this.result.setText(this.stringProperties(ps));
        }

        @Override
        protected String stringProperties(Properties properties) {
            String s = super.stringProperties(properties);
            if (s == null || s.length() == 0) {
                return properties.toString("\n", false);
            }
            return s + "\n-------------------\n" + properties.toString("\n", false);
        }
    }
}

