/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xml;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.AttDef;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.ElementDecl;
import com.argo21.jxp.vdtd.AttDefDeclNodeData;
import com.argo21.jxp.vdtd.DTDDeclNodeData;
import com.argo21.jxp.vdtd.DeclNodeData;
import com.argo21.jxp.vdtd.ElementDeclNodeData;
import com.argo21.msg.SchemaViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;

public class XmlDtdViewer
extends JTree
implements SchemaViewer {
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    private Font defaultFont;
    private DTDDecl dtd = null;
    private DefaultTreeModel treeModel = null;
    boolean selectChanged = false;
    String msgname;

    public XmlDtdViewer(DTDDecl dtd) {
        this();
        this.setDTD(dtd);
    }

    public XmlDtdViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception e) {
            this.defaultFont = this.getFont();
        }
        DTDDeclNodeData rootdata = new DTDDeclNodeData("DEFAULT-ROOT");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        this.setCellRenderer(new MyTreeCellRenderer());
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this);
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Component getDragComponent() {
        return this;
    }

    @Override
    public String getSelectedText() {
        return this.getAbsolutePathOfSelect();
    }

    @Override
    public boolean dragStart(Component source, int x, int y) {
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return true;
    }

    @Override
    public boolean dragOver(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDrop(path);
    }

    @Override
    public boolean drop(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDrop(path);
    }

    boolean canDrop(TreePath path) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        if (userobj.getNodeType() == 20) {
            ElementDeclNodeData decl = (ElementDeclNodeData)userobj;
            return decl.getType() == 2;
        }
        return true;
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public String getMsgType() {
        return "XML";
    }

    @Override
    public void load(Properties ps, Object dtd) throws SAXException {
        this.msgname = ps.getValue("name");
        this.setDTD((DTDDecl)dtd);
    }

    public String getAbsolutePathOfSelect() {
        if (this.dtd == null) {
            return null;
        }
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        int n = sel.getPathCount();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            DeclNodeData userobj = (DeclNodeData)node.getUserObject();
            names[i] = userobj.getNodeType() == 22 ? "@" + userobj.getNodeName() : userobj.getNodeName();
        }
        return this.msgname + this.dtd.getAbsolutePath(names, '/');
    }

    public void treeNodeSelected(TreeSelectionEvent e) {
        this.selectChanged = true;
    }

    public TreePath getSelectedPath() {
        return this.getSelectionPath();
    }

    public String[] getSelectedPathNames() {
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return new String[0];
        }
        int n = sel.getPathCount();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            DeclNodeData userobj = (DeclNodeData)node.getUserObject();
            names[i] = userobj.getNodeType() == 22 ? "@" + userobj.getNodeName() : userobj.getNodeName();
        }
        return names;
    }

    public DeclNode getSelectedNodeDecl() {
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)sel.getLastPathComponent();
        DeclNodeData userobj = (DeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        String name2 = userobj.getNodeName();
        Object declnode = null;
        switch (nodetype) {
            case 20: {
                return this.dtd.getElementDecl(name2);
            }
            case 22: {
                String elem = ((AttDefDeclNodeData)userobj).getElementName();
                return this.dtd.getAttListDecl(elem, name2);
            }
        }
        return null;
    }

    public void setDTD(DTDDecl dtd) {
        this.dtd = dtd;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Object rootName = null;
        root.removeAllChildren();
        if (dtd != null) {
            dtd.resolveParameterRefrance();
            dtd.resolveEntity();
            dtd.resolveHierarchy();
            ElementDecl elem = dtd.getRootElement();
            if (elem != null) {
                ElementDeclNodeData rootdata = new ElementDeclNodeData(elem);
                DynamicTreeNode treeNode = new DynamicTreeNode(rootdata);
                this.treeModel = new DefaultTreeModel(treeNode);
                this.setModel(this.treeModel);
                root = (DefaultMutableTreeNode)this.treeModel.getRoot();
                this.treeModel.nodeChanged(root);
                this.invalidate();
            }
        } else {
            this.treeModel.nodeStructureChanged(root);
            this.setSelectionRow(0);
            return;
        }
        this.treeModel.nodeStructureChanged(root);
        Hashtable elemTab = new Hashtable();
        this.expandAllSubNode(root, elemTab, true);
        this.setSelectionRow(0);
    }

    public void setDTD(DTDDecl dtd, boolean all) {
        ElementDeclNodeData userdata;
        DynamicTreeNode treeNode;
        ElementDecl decl;
        if (!all) {
            this.setDTD(dtd);
            return;
        }
        this.dtd = dtd;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        String rootName = null;
        if (dtd != null) {
            rootName = dtd.getNodeName();
        }
        if (root.getUserObject().toString().equals("DEFAULT-ROOT")) {
            DeclNodeData rootdata = new DeclNodeData(27, "DTD", null);
            root.setUserObject(rootdata);
        }
        if (dtd != null) {
            dtd.resolveParameterRefrance();
            dtd.resolveEntity();
            dtd.resolveHierarchy();
        }
        root.removeAllChildren();
        if (dtd == null) {
            this.treeModel.nodeStructureChanged(root);
            this.expandRow(0);
            this.setSelectionRow(0);
            return;
        }
        Hashtable store = new Hashtable();
        DeclNodeList nodes = dtd.getAllDeclNode();
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            ElementDecl decl2;
            int type;
            DeclNode node = nodes.elementAt(i);
            int nodetype = node.getNodeType();
            if (nodetype != 20 || (type = (decl2 = (ElementDecl)node).getType()) == 2 || type == 0) continue;
            ElementDeclNodeData userdata2 = new ElementDeclNodeData(decl2);
            DynamicTreeNode treeNode2 = new DynamicTreeNode(userdata2);
            root.add(treeNode2);
        }
        if (root.getChildCount() == 0 && (decl = dtd.getRootElement()) != null && (treeNode = new DynamicTreeNode(userdata = new ElementDeclNodeData(decl))) != null) {
            root.add(treeNode);
        }
        this.treeModel.nodeStructureChanged(root);
        store.clear();
        this.expandAllSubNode(root, store, root.getChildCount() < 2);
        this.setSelectionRow(0);
    }

    private void expandAllSubNode(DefaultMutableTreeNode node, Hashtable elemTab, boolean deep) {
        block4: {
            block3: {
                this.expandPath(new TreePath(node.getPath()));
                if (!deep) {
                    return;
                }
                DeclNodeData data = (DeclNodeData)node.getUserObject();
                int type = data.getNodeType();
                if (data.getNodeType() != 20) break block3;
                String name2 = data.getNodeName();
                if (elemTab.containsKey(name2)) break block4;
                elemTab.put(name2, data);
                int n = node.getChildCount();
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandAllSubNode(sub, elemTab, deep);
                }
                break block4;
            }
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                this.expandAllSubNode(sub, elemTab, deep);
            }
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    public DTDDeclNodeData getRootData() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        return (DTDDeclNodeData)root.getUserObject();
    }

    public void setRootData(DTDDeclNodeData data) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        root.setUserObject(data);
        this.treeModel.nodeChanged(root);
    }

    void addSubNodesTo(DefaultMutableTreeNode parent) {
        DeclNodeData data = (DeclNodeData)parent.getUserObject();
        int type = data.getNodeType();
        String name2 = data.getNodeName();
        if (type == 20) {
            DeclNodeData data1;
            int i;
            ElementDecl decl = this.dtd.getElementDecl(name2);
            if (name2 == null) {
                return;
            }
            DeclNodeList list = decl.getAttListDecls();
            int n = list.getLength();
            for (i = 0; i < n; ++i) {
                data1 = new AttDefDeclNodeData((AttDef)list.item(i));
                parent.add(new DefaultMutableTreeNode(data1));
            }
            list = decl.getSubElementDecls();
            n = list.getLength();
            for (i = 0; i < n; ++i) {
                data1 = new ElementDeclNodeData((ElementDecl)list.item(i));
                parent.add(new DynamicTreeNode(data1));
            }
        }
    }

    DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    void setSelectedTreeNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    class DynamicTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasLoaded;

        public DynamicTreeNode(Object obj) {
            super(obj);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            if (!this.hasLoaded) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.hasLoaded = true;
            XmlDtdViewer.this.addSubNodesTo(this);
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof DeclNodeData) {
                this.setIcon(((DeclNodeData)userObject).getImageIcon());
            }
            this.setFont(XmlDtdViewer.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

