/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xml;

import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.ReplaceLFWriter;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.util.BizTranCache;
import com.argo21.common.util.BizTranCacheNodeSet;
import com.argo21.common.util.Properties;
import com.argo21.jxp.dtd.DTDDecl;
import com.argo21.jxp.dtd.DTDDocument;
import com.argo21.jxp.dtd.DeclNode;
import com.argo21.jxp.dtd.DeclNodeList;
import com.argo21.jxp.dtd.PIDecl;
import com.argo21.jxp.dtd.XmlValidation;
import com.argo21.jxp.parser.IXmlParser;
import com.argo21.jxp.parser.XmlParser;
import com.argo21.jxp.xpath.DTDXPathSurpport;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageException;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlMsg
extends BaseMessage {
    public static final String MSGTYPE = "XML";
    private static final String EXTTYPE = "XML".toLowerCase();
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_WITHDTD = "withdtd";
    public static final String PROPERTY_WITHEXDTD = "withexdtd";
    public static final String PROPERTY_VALIDATE = "validate";
    public static final String PROPERTY_PUBLICID = "PUBLIC";
    public static final String PROPERTY_SYSTEMID = "SYSTEM";
    public static final String PROPERTY_INDENT = "indent";
    public static final String PROPERTY_CREATEEMPTYTAG = "createEmptyTag";
    private boolean isChanged = false;
    protected String version = null;
    protected boolean withdtd = false;
    protected boolean withexdtd = false;
    protected String systemid = null;
    protected boolean doValidate = false;
    protected DTDDecl dtd = null;
    protected Document document = null;
    protected XPathParser xpathParser = null;
    protected XPathSurpport xpathSurpport;
    private boolean initialized = false;
    private long lastModifies = 0L;
    protected String setIndent = null;
    protected String createEmptyTag = null;

    @Override
    public String getMsgType() {
        return MSGTYPE;
    }

    @Override
    public boolean isReady() {
        return this.document != null;
    }

    @Override
    public long getLastModifies() {
        return this.lastModifies;
    }

    @Override
    public Properties getProperties() {
        Properties ps = super.getProperties();
        String s = this.withdtd ? "YES" : "NO";
        ps.append(PROPERTY_WITHDTD, s);
        s = this.withexdtd ? "YES" : "NO";
        ps.append(PROPERTY_WITHEXDTD, s);
        ps.append(PROPERTY_SYSTEMID, this.systemid);
        s = this.doValidate ? "YES" : "NO";
        ps.append(PROPERTY_VALIDATE, s);
        ps.append(PROPERTY_INDENT, this.setIndent);
        ps.append(PROPERTY_CREATEEMPTYTAG, this.createEmptyTag);
        return ps;
    }

    @Override
    public Properties getDefaultProperties() {
        Properties ps = super.getDefaultProperties();
        ps.append(PROPERTY_VERSION, "1.0");
        return ps;
    }

    @Override
    public void setProperties(Properties properties) throws MessageException {
        super.setProperties(properties);
        String s = properties.getValue(PROPERTY_VERSION);
        if (s != null && s.trim().length() > 0) {
            this.version = s;
        }
        if ((s = properties.getValue(PROPERTY_WITHDTD, "NO")).equalsIgnoreCase("YES")) {
            this.withdtd = true;
        } else if (s.equalsIgnoreCase("NO")) {
            this.withdtd = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_WITHDTD, s}, null);
        }
        s = properties.getValue(PROPERTY_WITHEXDTD, "NO");
        if (s.equalsIgnoreCase("YES")) {
            this.withexdtd = true;
        } else if (s.equalsIgnoreCase("NO")) {
            this.withexdtd = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_WITHEXDTD, s}, null);
        }
        s = properties.getValue(PROPERTY_SYSTEMID);
        if (s != null && s.trim().length() > 0) {
            this.systemid = s;
        }
        if ((s = properties.getValue(PROPERTY_VALIDATE, "NO")).equalsIgnoreCase("YES")) {
            this.doValidate = true;
        } else if (s.equalsIgnoreCase("NO")) {
            this.doValidate = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_VALIDATE, s}, null);
        }
        s = properties.getValue(PROPERTY_INDENT);
        if (s != null && s.trim().length() > 0) {
            this.setIndent = s;
        }
        if ((s = properties.getValue(PROPERTY_CREATEEMPTYTAG)) != null && s.trim().length() > 0) {
            this.createEmptyTag = s;
        }
        this.initialized = false;
    }

    @Override
    public Object getSchema() {
        return this.dtd;
    }

    @Override
    public void setSchema(Object dtd) throws MessageException {
        if (dtd instanceof DTDDecl) {
            this.dtd = (DTDDecl)dtd;
        } else {
            this.dtd = null;
            MessageException.error("CANT_CAST_SCHEMA", new Object[]{dtd.getClass().getName(), this.getMsgType()}, null);
        }
        this.initialized = false;
    }

    @Override
    public void readSchema(Reader in) throws MessageException {
        try {
            XReader reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
            DTDDocument dtd = new DTDDocument(this.getMsgName());
            dtd.parseDTDDecl(reader);
            if (this.encoding == null) {
                this.encoding = dtd.getEncoding();
            }
            this.dtd = dtd;
        }
        catch (Exception e) {
            this.dtd = null;
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public void writeSchema(Writer out) throws MessageException {
        try {
            if (this.dtd instanceof DTDDocument) {
                ((DTDDocument)this.dtd).writeEx(out, true);
            } else {
                this.dtd.write(out);
            }
        }
        catch (Exception e) {
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document instanceof Document) {
            this.document = (Document)document;
            if (this.xpathSurpport != null) {
                this.xpathSurpport.setDocument(this.document);
            }
        } else {
            this.document = null;
            this.error("CANT_CAST_DOM", new Object[]{document.getClass().getName(), this.getMsgType()});
        }
    }

    @Override
    public void read(URL url) throws SAXException {
        if (url == null) {
            return;
        }
        try {
            InputSource is;
            if (this.encoding == null) {
                is = XReader.createInputSource(url, false);
                this.encoding = is.getEncoding();
            } else {
                is = new InputSource(XReader.createReader(url.openStream(), this.encoding));
                is.setSystemId(url.toString());
            }
            IXmlParser parser = XmlParser.getXmlParser();
            try {
                this.document = parser.createXmlDocument(is, false);
            }
            catch (SAXException e) {
                this.error(e);
            }
            Element elem = this.document.getDocumentElement();
            if (elem != null) {
                XmlParser.trimNode(elem, this.dtd);
            }
            this.checkMatch();
            if (this.xpathSurpport != null) {
                this.xpathSurpport.setDocument(this.document);
            }
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    @Override
    public void read(InputStream in) throws SAXException {
        try {
            InputSource is = XReader.createInputSource(this.encoding, in, false, null);
            if (this.encoding == null) {
                this.encoding = is.getEncoding();
            }
            IXmlParser parser = XmlParser.getXmlParser();
            try {
                this.document = parser.createXmlDocument(is, false);
            }
            catch (SAXException e) {
                this.error(e);
            }
            Element elem = this.document.getDocumentElement();
            if (elem != null) {
                XmlParser.trimNode(elem, this.dtd);
            }
            this.checkMatch();
            this.xpathSurpport.setDocument(this.document);
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    @Override
    public void read(Reader in) throws SAXException {
        try {
            if (this.encoding == null) {
                if (in instanceof XReader) {
                    this.encoding = ((XReader)in).getEncoding();
                } else if (in instanceof InputStreamReader) {
                    String s = ((InputStreamReader)in).getEncoding();
                    this.encoding = MIME2Java.reverse(s);
                }
            }
            InputSource is = new InputSource(in);
            IXmlParser parser = XmlParser.getXmlParser();
            try {
                this.document = parser.createXmlDocument(is, false);
            }
            catch (SAXException e) {
                this.error(e);
            }
            Element elem = this.document.getDocumentElement();
            if (elem != null) {
                XmlParser.trimNode(elem, this.dtd);
            }
            this.checkMatch();
            this.xpathSurpport.setDocument(this.document);
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    public void checkMatch() throws SAXException {
        if (this.dtd == null || this.document == null || !this.doValidate) {
            return;
        }
        XmlValidation validation = new XmlValidation(this.dtd, this.document, this.handler);
        validation.parse();
    }

    @Override
    public void submit() throws SAXException {
        if (this.direction.equals("INPUT")) {
            return;
        }
        if (!this.isStreamIO()) {
            URL documentURL = this.getDocumentURL();
            this.write(documentURL, false);
        }
    }

    @Override
    public void write(OutputStream out) throws SAXException {
        OutputStreamWriter writer = null;
        if (this.encoding == null) {
            writer = new OutputStreamWriter(out);
            String en = writer.getEncoding();
            this.encoding = MIME2Java.reverse(en);
        } else {
            String s = MIME2Java.convert(this.encoding);
            try {
                writer = new OutputStreamWriter(out, s);
            }
            catch (UnsupportedEncodingException e) {
                this.error("INVALID_ENCODING", this.encoding);
            }
        }
        this.write(writer);
    }

    @Override
    public void write(Writer out) throws SAXException {
        try {
            if (this.document != null) {
                if (this.xpathSurpport instanceof DTDXPathSurpport) {
                    DTDXPathSurpport surpport = (DTDXPathSurpport)this.xpathSurpport;
                    surpport.terminateDocument();
                }
                if (this.encoding == null && out instanceof OutputStreamWriter) {
                    this.encoding = MIME2Java.reverse(((OutputStreamWriter)out).getEncoding());
                }
                IXmlParser parser = XmlParser.getXmlParser();
                if (this.withexdtd) {
                    parser.setDoctype(this.document, null, this.systemid, null);
                }
                if (this.withdtd) {
                    StringWriter sw = new StringWriter();
                    this.dtd.write(sw, false);
                    sw.flush();
                    String internalSubset = sw.toString();
                    parser.setDoctype(this.document, null, null, internalSubset);
                    sw.close();
                }
                Element documentElement = this.document.getDocumentElement();
                DeclNodeList nodes = this.dtd.getAllDeclNode();
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                    DeclNode node = nodes.elementAt(i);
                    if (node.getNodeType() != 7) continue;
                    PIDecl piDecl = (PIDecl)node;
                    ProcessingInstruction pi = this.document.createProcessingInstruction(piDecl.getNodeName(), piDecl.getContents());
                    this.document.insertBefore(pi, documentElement);
                }
                boolean indentFlag = true;
                String indent = this.getProperties().getValue(PROPERTY_INDENT);
                if (indent != null && indent.equals("false")) {
                    indentFlag = false;
                }
                Writer writer = indentFlag ? new BufferedWriter(out) : new ReplaceLFWriter(new BufferedWriter(out), this.eol);
                parser.writeXmlDocument(this.document, writer, this.encoding, indentFlag);
                writer.flush();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void close() throws MessageException {
        this.document = null;
    }

    @Override
    public void clearDocument() {
        if (this.direction != "INPUT" && this.document != null) {
            Element node = this.document.getDocumentElement();
            this.document.removeChild(node);
            this.lastModifies = System.currentTimeMillis();
        }
    }

    @Override
    public boolean init() throws SAXException {
        if (this.direction == "INPUT") {
            if (!this.isStreamIO()) {
                URL documentURL = this.getDocumentURL();
                this.read(documentURL);
            }
            this.xpathSurpport = this.dtd != null ? new DTDXPathSurpport(this.dtd, this.document) : new DefaultXPathSurpport(this.document);
            this.xpathSurpport.setExtendable(false);
        } else {
            try {
                IXmlParser parser = XmlParser.getXmlParser();
                this.document = parser.createXmlDocument();
                this.lastModifies = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.document = null;
                this.error(e);
            }
            this.xpathSurpport = this.dtd != null ? new DTDXPathSurpport(this.dtd, this.document) : new DefaultXPathSurpport(this.document);
            this.xpathSurpport.setExtendable(true);
            this.isChanged = true;
        }
        this.initialized = true;
        return true;
    }

    private String getNodeText(Node node) {
        if (node.getNodeType() == 1) {
            for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 3) continue;
                return current.getNodeValue();
            }
        }
        return "";
    }

    @Override
    public ExtOperand parseOperand(Operand orient, VariableReference variables, XReader in) throws SAXException {
        if (!this.initialized && !this.init()) {
            this.error("CANT_INIT_MSG", this.name);
        }
        if (this.xpathSurpport.getVariableReference() != variables) {
            this.xpathSurpport.setVariableReference(variables);
        }
        if (this.xpathParser == null) {
            this.xpathParser = new XPathParser();
        }
        XPath xpath = this.xpathParser.parse(in);
        XPathOperand op = new XPathOperand(orient, xpath);
        String s = orient.getReference();
        s = s + "/" + xpath.getNodePathString();
        op.setReference(s);
        return op;
    }

    public String toString() {
        Properties ps = this.getProperties();
        return ps.toString(",");
    }

    public static void main(String[] args) {
    }

    @Override
    public String getExtension() {
        return EXTTYPE;
    }

    @Override
    public boolean isSettingIndent() {
        boolean indentFlag = true;
        String indent = this.getProperties().getValue(PROPERTY_INDENT);
        if (indent != null && indent.equals("false")) {
            indentFlag = false;
        }
        return indentFlag;
    }

    class XPathOperand
    extends ExtOperand {
        XPathOperand(Operand orient, Object expression) {
            super(orient, expression);
        }

        @Override
        public String getEncoding() {
            return XmlMsg.this.encoding;
        }

        private XData selectData(XData ref) throws XDataException {
            XPath xpath = (XPath)this.expression;
            BizTranCacheNodeSet cNodeSet = BizTranCache.getNode(xpath.getNodePathString(XmlMsg.this.xpathSurpport), XmlMsg.this.name);
            Node cNode = cNodeSet.getNode();
            try {
                if (ref.isObject()) {
                    Object obj = ref.objectValue();
                    if (obj instanceof XmlMsg) {
                        XNodeSet xns;
                        if (cNode != null) {
                            xns = new XNodeSet(cNode);
                        } else {
                            Document doc = ((XmlMsg)obj).document;
                            xns = new XNodeSet(doc);
                        }
                        return xpath.eval(xns, XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof Node) {
                        return xpath.eval(new XNodeSet((Node)obj), XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof NodeList) {
                        return xpath.eval(new XNodeSet((NodeList)obj), XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XNode) {
                        return xpath.eval((XNode)obj, XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XNodeSet) {
                        return xpath.eval((XNodeSet)obj, XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XData) {
                        XData.error("CANT_TO_NODE", ((XData)obj).getPrimitiveTypeName());
                    } else {
                        XData.error("CANT_TO_NODE", obj.getClass().getName());
                    }
                } else {
                    if (ref instanceof XNode) {
                        return xpath.eval((XNode)ref, XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (ref instanceof XNodeSet) {
                        return xpath.eval((XNodeSet)ref, XmlMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    XData.error("CANT_TO_NODE", ref.getPrimitiveTypeName());
                }
            }
            catch (XDataException e) {
                throw e;
            }
            catch (Exception e) {
                XData.error(e, true);
            }
            return null;
        }

        @Override
        protected XData getData(XData ref) throws XDataException {
            XmlMsg.this.xpathSurpport.setExtendable(false);
            return this.selectData(ref);
        }

        @Override
        protected void setData(XData ref, XData data) throws XDataException {
            if ("NO".equals(XmlMsg.this.createEmptyTag) && (data.stringValue() == null || data.stringValue().length() == 0)) {
                return;
            }
            XmlMsg.this.xpathSurpport.setExtendable(XmlMsg.this.getDirection() != "INPUT");
            XmlMsg.this.xpathSurpport.setDefaultNumber(data.size());
            XData target = this.selectData(ref);
            XDataMultipleException exception = null;
            int n = target.size();
            if (data.isInteger()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.longValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isFloat()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.doubleValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isBoolean()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.booleanValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isDate()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.dateValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.stringValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            }
            XmlMsg.this.lastModifies = System.currentTimeMillis();
            if (exception != null) {
                throw exception;
            }
        }
    }
}

