/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xsd;

import com.argo21.common.gui.ComboTextFieldEx;
import com.argo21.common.gui.FileFilterEx;
import com.argo21.common.gui.ImageLoader;
import com.argo21.common.gui.TextFieldEx;
import com.argo21.common.lang.XmlNames;
import com.argo21.common.util.Properties;
import com.argo21.jxp.vxsd.XDeclNodeData;
import com.argo21.jxp.vxsd.XSDDeclNodeData;
import com.argo21.jxp.vxsd.XSDDeclPanel;
import com.argo21.jxp.vxsd.XSDEditorPanel;
import com.argo21.jxp.vxsd.XsdContentsEditPanel;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XSDException;
import com.argo21.map.MappingException;
import com.argo21.msg.MessageException;
import com.argo21.msg.SchemaEditor;
import com.argo21.msg.xsd.ImportXSDDialog;
import com.argo21.msg.xsd.ImportXSDOptionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.xml.sax.SAXParseException;

public class XmlXsdEditor
extends XSDEditorPanel
implements SchemaEditor {
    static final String CMD_IMPORT_XSD = "CMD_IMPORT";
    static final String CMD_EXPORT_XSD = "CMD_EXPORT";
    static String[] toolBarNames = new String[]{"ELEMENT", "ATTDEF", "COMPLEX", "SIMPLE", "MODELGRP", "ATTGRP", "INCLUDE", "IMPORT", "COMMENT", "PI", "-", "NODECOPY", "REMOVE", "FINDNODE", "TOUP", "TODOWN", "-", "VALID_SCHEMA"};
    static String[][] editMenus = new String[][]{{"ELEMENT", "E", null, null}, {"ATTDEF", "A", null, null}, {"COMPLEX", null, null, null}, {"SIMPLE", null, null, null}, {"MSG", null, null, null}, {"MODELGRP", null, null, null}, {"ATTGRP", null, null, null}, {"IDENTITY", null, null, null}, {"FACET", null, null, null}, {"ANYATTR", null, null, null}, {"XPATH", null, null, null}, {"INCLUDE", "I", null, null}, {"IMPORT", "M", null, null}, {"ANNOTATION=", null, null, null}, {"NOTATION", null, null, null}, {"COMMENT", "M", null, null}, {"PI", "P", null, null}, {"NODECOPY", "C", null, "2:155"}, {"REMOVE", "D", null, String.valueOf(127)}, {"FINDNODE", "F", null, "2:70"}, {"REFINDNODE", "R", null, String.valueOf(114)}, {"TOUP", "U", null, null}, {"TODOWN", "W", null, null}, {"-", null, null, null}, {"CMD_IMPORT", null, null, null}, {"CMD_EXPORT", null, null, null}};
    private JToolBar toolBar = null;
    private JMenu menu = null;
    private Properties ps;
    private SchemaEditor.NameChangedListener nameChangedListener = null;
    private SchemaEditor.ExceptionListener exceptionListener = null;
    private String defaultFilePath = null;

    public XmlXsdEditor() {
        super((XSDDecl)null, true);
        this.registActionEx();
    }

    @Override
    protected void registContentsEditorPanel() {
        super.registContentsEditorPanel();
        ExDTDDeclPanel ep = new ExDTDDeclPanel();
        ((XsdContentsEditPanel)ep).init(this);
        this.setContentsEditPanel(72, ep);
    }

    @Override
    public String getMsgType() {
        return this.ps.getValue("type");
    }

    @Override
    public String getMsgName() {
        return this.ps.getValue("name");
    }

    @Override
    public void close() {
        this.nameChangedListener = null;
        this.exceptionListener = null;
    }

    @Override
    public void resetEditStatus() {
        super.resetEditStatus();
        if (this.toolBar != null) {
            this.setToolbarStatus();
        }
        if (this.menu != null) {
            this.setMenuStatus();
        }
    }

    void setToolbarStatus() {
        int n = this.toolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.toolBar.getComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    void setMenuStatus() {
        int n = this.menu.getMenuComponentCount();
        for (int i = 0; i < n; ++i) {
            Action a;
            Component c = this.menu.getMenuComponent(i);
            String name2 = c.getName();
            if (name2 == null || (a = (Action)this.actions.get(name2)) == null) continue;
            c.setEnabled(a.isEnabled());
        }
    }

    String getUrlString(File file) {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file.isDirectory()) {
            path = path + "/";
        }
        return "file:" + path;
    }

    protected Frame getOwnerFrame() {
        Container parent;
        for (parent = this; parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            return (Frame)parent;
        }
        return null;
    }

    @Override
    public void setDefaultFilePath(String path) {
        this.defaultFilePath = path;
    }

    protected DefaultMutableTreeNode getSelectDeclNode() {
        DefaultMutableTreeNode node = this.getSelectedTreeNode();
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode root = this.getRoot();
        if (root == null || root == node) {
            return null;
        }
        while (node.getParent() != root) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        return node;
    }

    void importXSD() {
        Properties ps;
        Frame f = this.getOwnerFrame();
        if (f == null) {
            return;
        }
        ImportXSDDialog in = new ImportXSDDialog(f, MessageException.getMessage(CMD_IMPORT_XSD), this.defaultFilePath);
        Point p = f.getLocation();
        p.translate((f.getWidth() - in.getWidth()) / 2, (f.getHeight() - in.getHeight()) / 2);
        in.setLocation(p);
        try {
            ps = this.getProperties();
        }
        catch (Exception e) {
            ps = this.ps;
        }
        in.setEncoding(ps.getValue("encoding"));
        in.setVisible(true);
        String errMsg = null;
        try {
            XSDDocument xsd = in.getXSD();
            if (xsd == null) {
                return;
            }
            ImportXSDOptionDialog optdlg = new ImportXSDOptionDialog(f, MessageException.getMessage("CMD_IMPORT_OPTION"));
            p = f.getLocation();
            p.translate((f.getWidth() - optdlg.getWidth()) / 2, (f.getHeight() - optdlg.getHeight()) / 2);
            optdlg.setLocation(p);
            optdlg.setXSD(xsd);
            optdlg.setVisible(true);
            if (!optdlg.isOk()) {
                return;
            }
            Properties properties = xsd.getProperties();
            ps.repleace("schemaPrefix", properties.getValue("schemaPrefix"));
            if (optdlg.isRewrite()) {
                String s;
                int rs;
                DefaultMutableTreeNode root = this.getRoot();
                if (root.getChildCount() > 0 && (rs = JOptionPane.showConfirmDialog(this, s = MappingException.getMessage("QST_CHANGE_SCHEMA"), MappingException.getMessage("DLG_CONFIRM"), 2)) != 0) {
                    return;
                }
                String encoding = in.getEncoding();
                if (encoding != null) {
                    ps.repleace("encoding", encoding);
                }
                this.load(null, ps, xsd);
            }
        }
        catch (XSDException e) {
            errMsg = this.createParseErrorMsg(e);
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        this.changeContents();
        if (errMsg != null) {
            JOptionPane.showMessageDialog(this, errMsg);
        }
    }

    private String createParseErrorMsg(XSDException e) {
        Exception orgEx = e.getException();
        if (orgEx == null || !(orgEx instanceof SAXParseException)) {
            return e.getMessage();
        }
        SAXParseException ex = (SAXParseException)orgEx;
        StringBuffer buf = new StringBuffer();
        if (e.getSystemId() != null) {
            buf.append(e.getSystemId());
        }
        buf.append("<").append(ex.getLineNumber()).append(",");
        buf.append(ex.getColumnNumber()).append(">").append(System.getProperty("line.separator"));
        this.clearMessageWindow();
        String s = new StringBuffer(buf.toString()).append(ex.getMessage()).toString();
        this.printlnToMessageWindow(s);
        String m = "";
        if (e.getMessage() != null) {
            m = e.getMessage();
        }
        return new StringBuffer(buf.toString()).append(m).toString();
    }

    void exportXSD() {
        int rs;
        FileFilterEx filter = new FileFilterEx(new String[]{"xsd"}, "XSD Files");
        File file = this.getSaveFileName(filter);
        if (file == null) {
            return;
        }
        String s = file.getName();
        if (s != null && s.indexOf(".") < 0) {
            s = s + ".xsd";
            String parent = file.getParent();
            file = parent != null ? new File(parent, s) : new File(s);
        }
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(this, MappingException.getMessage("INVALID_FILE", file.getPath()));
            return;
        }
        if (file.exists() && (rs = JOptionPane.showConfirmDialog(this, s = MappingException.getMessage("QST_SAVEOVER", file.getPath()), MappingException.getMessage("DLG_CONFIRM"), 0)) == 1) {
            return;
        }
        String errMsg = null;
        XSDDecl xsd = null;
        try {
            xsd = this.getXSD();
        }
        catch (XSDException e) {
            String systemId = e.getSystemId();
            errMsg = systemId != null ? systemId + "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage() : "<" + e.getLineNumber() + "," + e.getColumnNumber() + "> :" + e.getMessage();
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (errMsg != null) {
            JOptionPane.showMessageDialog(this, errMsg);
            return;
        }
        try {
            xsd.save(file.toString());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    @Override
    protected void setActionEnabled() {
        ((Action)this.actions.get("NAMESPACE")).setEnabled((this.status & 0x200) != 0);
        super.setActionEnabled();
    }

    @Override
    public void setNameChangedListener(SchemaEditor.NameChangedListener listener) {
        this.nameChangedListener = listener;
    }

    @Override
    public void setExceptionListener(SchemaEditor.ExceptionListener listener) {
        this.exceptionListener = listener;
    }

    protected void registActionEx() {
        String s = MessageException.getMessage(CMD_IMPORT_XSD);
        AbstractAction a = new AbstractAction(CMD_IMPORT_XSD){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlXsdEditor.this.importXSD();
            }
        };
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_IMPORT_XSD, a);
        s = msgCatalog.getMessage("CMD_NEW_NSDEF");
        a = new AbstractAction("NAMESPACE", ImageLoader.load("namespace.gif", "NS")){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlXsdEditor.this.addNewNsDeclNode();
            }
        };
        a.putValue("ShortDescription", s);
        this.actions.put("NAMESPACE", a);
        s = MessageException.getMessage(CMD_EXPORT_XSD);
        a = new AbstractAction(CMD_EXPORT_XSD){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlXsdEditor.this.exportXSD();
            }
        };
        a.putValue("ShortDescription", s);
        this.actions.put(CMD_EXPORT_XSD, a);
    }

    @Override
    public Component getEditorPanel() {
        return this;
    }

    @Override
    public JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = this.createToolbar(toolBarNames);
            this.setToolbarStatus();
        }
        return this.toolBar;
    }

    @Override
    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = this.creatMenu(editMenus);
            this.menu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    XmlXsdEditor.this.setMenuStatus();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            this.setMenuStatus();
        }
        return this.menu;
    }

    @Override
    public Component getPopMenuComponent() {
        return this.tree;
    }

    @Override
    public Properties getProperties() throws MessageException {
        try {
            XSDDecl xsd = this.getXSD();
            xsd.resolveHierarchy();
            xsd.resolveAttrOnElement();
            return xsd.getProperties();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    @Override
    public void load(Properties params, Properties ps, Object schema) throws MessageException {
        this.ps = ps;
        XSDDecl xsd1 = (XSDDecl)schema;
        if (xsd1.getProperties() != ps) {
            xsd1.getProperties().removeAll();
            String name2 = ps.getValue("name");
            int n = ps.getSize();
            for (int i = 0; i < n; ++i) {
                xsd1.putProperty(ps.getName(i), ps.getValue(i));
            }
        }
        this.setXSD(xsd1);
    }

    @Override
    public Object getSchema() throws MessageException {
        try {
            return this.getXSD();
        }
        catch (Exception e) {
            throw new MessageException(null, this.getMsgName(), this.getMsgName(), 0, 0, e);
        }
    }

    boolean msgNameChanged(String oldName, String newName) {
        if (this.nameChangedListener != null) {
            return this.nameChangedListener.nameChanged(oldName, newName);
        }
        return true;
    }

    File getSaveFileName(FileFilter filter) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogTitle(MessageException.getMessage(CMD_EXPORT_XSD));
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        try {
            File currentDirectory = new File(this.defaultFilePath);
            if (!currentDirectory.exists()) {
                currentDirectory = new File(System.getProperty("user.dir"));
            }
            if (currentDirectory.exists()) {
                fileChooser.setCurrentDirectory(currentDirectory);
            }
        }
        catch (Exception currentDirectory) {
            // empty catch block
        }
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setPreferredSize(new Dimension(500, 260));
        int result = fileChooser.showSaveDialog(this);
        if (result != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        return file;
    }

    private JToolBar createToolbar(String[] names) {
        JToolBar toolbar = new JToolBar();
        toolbar.setMargin(new Insets(0, 0, 0, 0));
        toolbar.setFloatable(false);
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            if (names[i].equals("-")) {
                toolbar.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(names[i]);
            if (act == null) continue;
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            JButton bt = new JButton((Icon)icon){

                @Override
                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            bt.setRequestFocusEnabled(false);
            bt.setMargin(new Insets(1, 1, 1, 1));
            bt.setName(names[i]);
            bt.setToolTipText((String)act.getValue("ShortDescription"));
            bt.addActionListener(act);
            toolbar.add(bt);
        }
        return toolbar;
    }

    private JMenu creatMenu(String[][] items) {
        String s = MessageException.msgCatalog.getMessage("MENU_EDIT");
        if (s.indexOf("E") < 0) {
            s = s + "(E)";
        }
        JMenu menu = new JMenu(s);
        menu.setMnemonic('E');
        Font font1 = menu.getFont();
        Font font = new Font(font1.getName(), 0, 12);
        menu.setFont(font);
        for (int i = 0; i < items.length; ++i) {
            String itemname = items[i][0];
            if (itemname.equals("-")) {
                menu.addSeparator();
                continue;
            }
            Action act = (Action)this.actions.get(itemname);
            String dec = (String)act.getValue("ShortDescription");
            if (items[i][1] != null && dec.indexOf(items[i][1]) < 0) {
                dec = dec + "(" + items[i][1] + ")";
            }
            JMenuItem menuItem = items[i][2] == null ? new JMenuItem(dec) : new JCheckBoxMenuItem(dec);
            menuItem.setName(itemname);
            menu.add(menuItem);
            ImageIcon icon = (ImageIcon)act.getValue("SmallIcon");
            if (icon != null) {
                menuItem.setIcon(icon);
                menuItem.setHorizontalTextPosition(4);
            }
            menuItem.addActionListener(act);
            if (items[i][1] != null) {
                menuItem.setMnemonic(items[i][1].charAt(0));
            }
            if (items[i][2] != null) {
                menuItem.setSelected(items[i][2].equals("Y"));
            }
            if (items[i][3] != null) {
                try {
                    s = items[i][3];
                    int k = s.indexOf(":");
                    if (k >= 0) {
                        int mask = Integer.parseInt(s.substring(0, k));
                        int keyid = Integer.parseInt(s.substring(k + 1));
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, mask));
                    } else {
                        int keyid = Integer.parseInt(s);
                        menuItem.setAccelerator(KeyStroke.getKeyStroke(keyid, 0));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            menuItem.setFont(font);
        }
        return menu;
    }

    public void addNewNsDeclNode() {
    }

    private void addPrefixToTree(Hashtable sbset, String prefix) {
    }

    private void addPrefixToElement(DefaultMutableTreeNode node, String prefix) {
        XDeclNodeData data;
        String name2;
        Hashtable sbset = new Hashtable();
        this.addPrefixToAttr(node, prefix);
        this.addPrefixToChildren(node, prefix, sbset);
        if (!sbset.isEmpty()) {
            this.addPrefixToTree(sbset, prefix);
        }
        if ((name2 = (data = (XDeclNodeData)node.getUserObject()).getNodeName()).indexOf(58) < 0) {
            this.treeNodeNameChanged(node, prefix + ":" + name2);
        }
    }

    private void addPrefixToAttr(DefaultMutableTreeNode parent, String prefix) {
    }

    private void addPrefixToChildren(DefaultMutableTreeNode parent, String prefix, Hashtable sbset) {
    }

    @Override
    protected void nameSpaceChanged(String prefix, String prefix1) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void nameSpaceChanged(DefaultMutableTreeNode parent, String prefix, String prefix1) {
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)parent.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            XDeclNodeData data = (XDeclNodeData)node.getUserObject();
            int n = data.getNodeType();
        }
    }

    @Override
    protected void changeNsElement(String oldelem, String newelem) {
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (node != null) {
            XDeclNodeData data = (XDeclNodeData)node.getUserObject();
            node = node.getNextSibling();
        }
    }

    @Override
    protected String searchPrefix(DefaultMutableTreeNode node) {
        String elem = null;
        while (node != null) {
            XDeclNodeData select = (XDeclNodeData)node.getUserObject();
            if (select.getNodeType() == 50) {
                elem = select.getNodeName();
                break;
            }
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (elem == null) {
            return null;
        }
        String prefix = XmlNames.getPrefix(elem);
        if (prefix != null) {
            return prefix;
        }
        return this.searchPrefix(elem);
    }

    @Override
    protected String searchPrefix(String element) {
        DefaultMutableTreeNode root = this.getRoot();
        DefaultMutableTreeNode node = null;
        try {
            node = (DefaultMutableTreeNode)root.getFirstChild();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static class ExDTDDeclPanel
    extends XSDDeclPanel {
        ComboTextFieldEx dirField;
        JCheckBox withxsd;
        JCheckBox checkField;
        JCheckBox checkIndent;
        JCheckBox checkEmptyTag;
        TextFieldEx prefixField;
        TextFieldEx urlField;
        TextFieldEx insPrefixField;
        JPanel schemaPanel;
        JPanel schemaDefPanel;
        TextFieldEx schemaNameSpaceField;
        TextFieldEx schemaUrlField;
        JButton addButton;
        JButton delButton;
        JList schemaList;
        JScrollPane schemaListScroll;

        ExDTDDeclPanel() {
        }

        @Override
        public void init(XSDEditorPanel parentPanel) {
            super.init(parentPanel);
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.fill = 1;
            c.weightx = 0.0;
            JLabel label = new JLabel(MessageException.getMessage("LAB_DIRECTION"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.dirField = new ComboTextFieldEx(false){

                @Override
                public boolean valueChanged(Object source, String value) {
                    this.propertyChanged("direction", value);
                    return true;
                }
            };
            this.dirField.addItem("INPUT");
            this.dirField.addItem("OUTPUT");
            this.propertyPanel.add((Component)this.dirField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_XSD_PREFIX"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.prefixField = new TextFieldEx(){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("schemaPrefix", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.prefixField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_DOC_URL"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.urlField = new TextFieldEx(){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("url", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.urlField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            label = new JLabel(MessageException.getMessage("LAB_INS_PREFIX"));
            this.propertyPanel.add((Component)label, c);
            ++c.gridx;
            c.weightx = 1.0;
            this.insPrefixField = new TextFieldEx(){

                @Override
                public boolean valueChanged(Object Source2, String value) {
                    this.propertyChanged("instancePrefix", value);
                    return true;
                }
            };
            this.propertyPanel.add((Component)this.insPrefixField, c);
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 0.0;
            this.schemaPanel = new JPanel();
            this.schemaPanel.setLayout(new GridBagLayout());
            this.schemaPanel.setOpaque(true);
            this.schemaPanel.setBorder(BorderFactory.createTitledBorder("SchemaLocation"));
            c.gridx = 0;
            ++c.gridy;
            c.weightx = 1.0;
            c.gridwidth = 1;
            JPanel rd6 = new JPanel();
            rd6.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.weightx = 1.0;
            gc.fill = 1;
            rd6.add((Component)new JLabel(ExDTDDeclPanel.getMessage("LAB_NAMESPACE")), gc);
            gc.gridx = 1;
            gc.gridy = 0;
            this.schemaNameSpaceField = new TextFieldEx(35);
            rd6.add((Component)this.schemaNameSpaceField, gc);
            gc.gridx = 0;
            gc.gridy = 1;
            rd6.add((Component)new JLabel(ExDTDDeclPanel.getMessage("LAB_SCHEMALOCATION")), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            this.schemaUrlField = new TextFieldEx(35);
            rd6.add((Component)this.schemaUrlField, gc);
            this.schemaPanel.add((Component)rd6, c);
            c.gridx = 0;
            ++c.gridy;
            ImageIcon downIcon = ImageLoader.load("todown.gif", "Down");
            ImageIcon upIcon = ImageLoader.load("toup.gif", "Up");
            this.schemaDefPanel = new JPanel();
            this.schemaDefPanel.setLayout(new FlowLayout(1, 20, 0));
            this.addButton = new JButton(downIcon);
            this.schemaDefPanel.add(this.addButton);
            this.addButton.setMargin(new Insets(0, 0, 0, 0));
            this.addButton.setBorder(null);
            this.delButton = new JButton(upIcon);
            this.schemaDefPanel.add(this.delButton);
            this.delButton.setMargin(new Insets(0, 0, 0, 0));
            this.delButton.setBorder(null);
            c.insets = new Insets(0, 2, 0, 2);
            this.schemaPanel.add((Component)this.schemaDefPanel, c);
            ++c.gridy;
            c.insets = new Insets(2, 2, 2, 2);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.addSchemaLocation(schemaNameSpaceField.getText().trim(), schemaUrlField.getText().trim());
                }
            });
            this.delButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.deleteSchemaLocation();
                }
            });
            c.gridx = 0;
            c.weightx = 0.0;
            c.gridx = 0;
            c.weightx = 1.0;
            c.gridheight = 1;
            this.schemaList = new JList(new DefaultListModel());
            this.schemaList.setFont(new Font(this.schemaList.getFont().getName(), 0, 11));
            this.schemaList.setBackground(Color.white);
            this.schemaList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.selectSchemaLocation();
                }
            });
            this.schemaListScroll = new JScrollPane(this.schemaList);
            this.schemaListScroll.setPreferredSize(new Dimension(100, 60));
            this.schemaPanel.add((Component)this.schemaListScroll, c);
            c.gridwidth = 2;
            this.propertyPanel.add((Component)this.schemaPanel, c);
            c.gridwidth = 1;
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.withxsd = new JCheckBox(MessageException.getMessage("LAB_WITHXSD"));
            this.withxsd.setFont(this.getDefaultFont());
            this.withxsd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = withxsd.isSelected() ? "YES" : "NO";
                    this.propertyChanged("withxsd", value);
                }
            });
            this.propertyPanel.add((Component)this.withxsd, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.checkField = new JCheckBox(MessageException.getMessage("LAB_DTDCHECK"));
            this.checkField.setFont(this.getDefaultFont());
            this.checkField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = checkField.isSelected() ? "YES" : "NO";
                    this.propertyChanged("validate", value);
                }
            });
            this.propertyPanel.add((Component)this.checkField, c);
            c.gridx = 1;
            ++c.gridy;
            c.weightx = 1.0;
            this.checkIndent = new JCheckBox(MessageException.getMessage("LAB_INDENT"));
            this.checkIndent.setFont(this.getDefaultFont());
            this.checkIndent.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String value = checkIndent.isSelected() ? "true" : "false";
                    this.propertyChanged("indent", value);
                }
            });
            this.propertyPanel.add((Component)this.checkIndent, c);
        }

        private void addSchemaLocation(String nameSpace, String url) {
            if (nameSpace.equals("") || url.equals("")) {
                return;
            }
            String schemaLocation = "<" + nameSpace + ">" + url;
            DefaultListModel model = (DefaultListModel)this.schemaList.getModel();
            if (!model.contains(schemaLocation)) {
                boolean replace = false;
                for (int i = 0; i < model.size(); ++i) {
                    int col;
                    String list_schemaLocation = (String)model.getElementAt(i);
                    String list_nameSpace = list_schemaLocation.substring(1, col = list_schemaLocation.indexOf(">"));
                    if (!nameSpace.equals(list_nameSpace)) continue;
                    model.setElementAt(schemaLocation, i);
                    replace = true;
                }
                if (!replace) {
                    model.addElement(schemaLocation);
                }
                this.schemaNameSpaceField.setText("");
                this.schemaUrlField.setText("");
                this.schemaLocationPropertyChanged(model);
            }
        }

        private void deleteSchemaLocation() {
            int index = this.schemaList.getSelectedIndex();
            if (index >= 0) {
                DefaultListModel model = (DefaultListModel)this.schemaList.getModel();
                model.remove(index);
                this.schemaLocationPropertyChanged(model);
            }
        }

        private void schemaLocationPropertyChanged(DefaultListModel model) {
            StringBuffer sbNameSpace = new StringBuffer();
            StringBuffer sbURL = new StringBuffer();
            for (int i = 0; i < model.size(); ++i) {
                String list_schemaLocation = (String)model.getElementAt(i);
                int col = list_schemaLocation.indexOf(">");
                sbNameSpace.append(list_schemaLocation.substring(1, col));
                sbNameSpace.append(",");
                sbURL.append(list_schemaLocation.substring(col + 1));
                sbURL.append(",");
            }
            if (sbNameSpace.length() > 0) {
                sbNameSpace.deleteCharAt(sbNameSpace.length() - 1);
            }
            if (sbURL.length() > 0) {
                sbURL.deleteCharAt(sbURL.length() - 1);
            }
            super.propertyChanged("pluralSchemaLocation", sbNameSpace.toString());
            super.propertyChanged("pluralSchemaLocationURL", sbURL.toString());
        }

        private void selectSchemaLocation() {
            String schemaLocation = (String)this.schemaList.getSelectedValue();
            if (schemaLocation != null) {
                int col = schemaLocation.indexOf(">");
                this.schemaNameSpaceField.setText(schemaLocation.substring(1, col));
                this.schemaUrlField.setText(schemaLocation.substring(col + 1));
            }
        }

        @Override
        protected void nameChanged(String value) {
            XSDDeclNodeData data = (XSDDeclNodeData)this.node.getUserObject();
            String s = data.getNodeName();
            if (s.equals(value)) {
                return;
            }
            if (!ExDTDDeclPanel.isName(value)) {
                super.nameChanged(value);
                return;
            }
            if (((XmlXsdEditor)this.parentPanel).msgNameChanged(s, value)) {
                super.nameChanged(value);
            }
        }

        @Override
        protected void propertyChanged(String field, String value) {
            super.propertyChanged(field, value);
        }

        @Override
        public void setTreeNode(DefaultMutableTreeNode node) {
            super.setTreeNode(node);
            Object obj = node.getUserObject();
            XSDDeclNodeData data = (XSDDeclNodeData)obj;
            this.nameField.setText(data.getNodeName());
            Properties ps = data.getProperties();
            if (ps == null) {
                return;
            }
            String value = ps.getValue("direction");
            this.dirField.setEnabledEvent(false);
            if (value == null || value.length() == 0) {
                this.dirField.setSelectedIndex(0);
            } else {
                this.dirField.setSelectedItem(value);
            }
            this.dirField.setEnabledEvent(true);
            value = ps.getValue("url");
            if (value == null) {
                this.urlField.setText("");
            } else {
                this.urlField.setText(value);
            }
            value = ps.getValue("schemaPrefix");
            if (value == null) {
                this.prefixField.setText("");
            } else {
                this.prefixField.setText(value);
            }
            this.prefixField.setEnabled(false);
            String nameSpaces = ps.getValue("pluralSchemaLocation");
            String urls = ps.getValue("pluralSchemaLocationURL");
            if (nameSpaces != null && urls != null) {
                StringTokenizer pslTokenizer = new StringTokenizer(nameSpaces, ",");
                StringTokenizer pslURLTokenizer = new StringTokenizer(urls, ",");
                while (pslTokenizer.hasMoreTokens() && pslURLTokenizer.hasMoreTokens()) {
                    this.addSchemaLocation(pslTokenizer.nextToken().trim(), pslURLTokenizer.nextToken().trim());
                }
            }
            if ((value = ps.getValue("instancePrefix")) == null) {
                this.insPrefixField.setText("");
            } else {
                this.insPrefixField.setText(value);
            }
            value = ps.getValue("withxsd");
            value = ps.getValue("withxsd");
            if (value == null) {
                this.withxsd.setSelected(false);
            } else {
                this.withxsd.setSelected(value.equalsIgnoreCase("YES"));
            }
            value = ps.getValue("validate");
            if (value == null) {
                this.checkField.setSelected(false);
            } else {
                this.checkField.setSelected(value.equalsIgnoreCase("YES"));
            }
            value = ps.getValue("indent");
            if (value == null) {
                this.checkIndent.setSelected(true);
            } else {
                this.checkIndent.setSelected(value.equalsIgnoreCase("true"));
            }
            this.result.setText(this.stringProperties(ps));
        }

        @Override
        protected String stringProperties(Properties properties) {
            String s = super.stringProperties(properties);
            if (s == null || s.length() == 0) {
                return properties.toString("\n", false);
            }
            return s + "\n-------------------\n" + properties.toString("\n", false);
        }
    }
}

