/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xsd;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.util.Properties;
import com.argo21.jxp.vxsd.XDeclNodeData;
import com.argo21.jxp.vxsd.XSDDeclNodeData;
import com.argo21.jxp.vxsd.XsdAttDefDeclNodeData;
import com.argo21.jxp.vxsd.XsdElementDeclNodeData;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdAttDef;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdDeclNodeList;
import com.argo21.jxp.xsd.XsdElementDecl;
import com.argo21.jxp.xsd.XsdTypeRef;
import com.argo21.msg.SchemaViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.xml.sax.SAXException;

public class XmlXsdViewer
extends JTree
implements SchemaViewer {
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    private Font defaultFont;
    private XSDDecl xsd = null;
    private DefaultTreeModel treeModel = null;
    boolean selectChanged = false;
    String msgname;

    public XmlXsdViewer(XSDDecl xsd) {
        this();
        this.setXSD(xsd);
    }

    public XmlXsdViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception e) {
            this.defaultFont = this.getFont();
        }
        XSDDeclNodeData rootdata = new XSDDeclNodeData("DEFAULT-ROOT");
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootdata);
        this.treeModel = new DefaultTreeModel(root);
        this.setModel(this.treeModel);
        this.setCellRenderer(new MyTreeCellRenderer());
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this);
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public Component getViewer() {
        return this;
    }

    @Override
    public Component getDragComponent() {
        return this;
    }

    @Override
    public String getSelectedText() {
        return this.getAbsolutePathOfSelect();
    }

    @Override
    public boolean dragStart(Component source, int x, int y) {
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return true;
    }

    @Override
    public boolean dragOver(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDrop(path);
    }

    @Override
    public boolean drop(Component source, int x, int y, String dragText) {
        if (source == this) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path == null) {
            return false;
        }
        this.setSelectionPath(path);
        return this.canDrop(path);
    }

    boolean canDrop(TreePath path) {
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        XDeclNodeData userobj = (XDeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        if (userobj.getNodeType() == 50) {
            XsdElementDeclNodeData decl = (XsdElementDeclNodeData)userobj;
            return decl.getType() == 5;
        }
        return true;
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    @Override
    public String getMsgType() {
        return "XSD";
    }

    @Override
    public void load(Properties ps, Object xsd) throws SAXException {
        this.msgname = ps.getValue("name");
        this.setXSD((XSDDecl)xsd);
    }

    public String getAbsolutePathOfSelect() {
        if (this.xsd == null) {
            return null;
        }
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        int n = sel.getPathCount();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            XDeclNodeData userobj = (XDeclNodeData)node.getUserObject();
            names[i] = userobj.getNodeType() == 55 ? "@" + userobj.getNodeName() : userobj.getNodeName();
        }
        return this.msgname + this.xsd.getAbsolutePath(names, '/');
    }

    public void treeNodeSelected(TreeSelectionEvent e) {
        this.selectChanged = true;
    }

    public TreePath getSelectedPath() {
        return this.getSelectionPath();
    }

    public String[] getSelectedPathNames() {
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return new String[0];
        }
        int n = sel.getPathCount();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)sel.getPathComponent(i);
            XDeclNodeData userobj = (XDeclNodeData)node.getUserObject();
            names[i] = userobj.getNodeType() == 55 ? "@" + userobj.getNodeName() : userobj.getNodeName();
        }
        return names;
    }

    public XsdDeclNode getSelectedNodeDecl() {
        TreePath sel = this.getSelectionPath();
        if (sel == null) {
            return null;
        }
        DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)sel.getLastPathComponent();
        XDeclNodeData userobj = (XDeclNodeData)currentNode.getUserObject();
        int nodetype = userobj.getNodeType();
        String name2 = userobj.getNodeName();
        Object declnode = null;
        switch (nodetype) {
            case 50: {
                return this.xsd.getElementDecl(name2);
            }
        }
        return null;
    }

    public void setXSD(XSDDecl xsd) {
        this.xsd = xsd;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Object rootName = null;
        root.removeAllChildren();
        if (xsd != null) {
            xsd.resolveHierarchy();
            xsd.resolveAttrOnElement();
            XsdElementDecl elem = xsd.getRootElement();
            if (elem != null) {
                XsdElementDeclNodeData rootdata = new XsdElementDeclNodeData(elem);
                DynamicTreeNode treeNode = new DynamicTreeNode(rootdata);
                this.treeModel = new DefaultTreeModel(treeNode);
                this.setModel(this.treeModel);
                root = (DefaultMutableTreeNode)this.treeModel.getRoot();
                this.treeModel.nodeChanged(root);
                this.invalidate();
            }
        } else {
            this.treeModel.nodeStructureChanged(root);
            this.setSelectionRow(0);
            return;
        }
        this.treeModel.nodeStructureChanged(root);
        Hashtable elemTab = new Hashtable();
        this.expandAllSubNode(root, elemTab, true);
        this.setSelectionRow(0);
    }

    public void setXSD(XSDDecl xsd, boolean all) {
        XsdElementDeclNodeData rootdata;
        DynamicTreeNode treeNode;
        if (!all) {
            this.setXSD(xsd);
            return;
        }
        this.xsd = xsd;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        String rootName = null;
        if (xsd != null) {
            rootName = xsd.getNodeName();
        }
        if (root.getUserObject().toString().equals("DEFAULT-ROOT")) {
            XDeclNodeData rootdata2 = new XDeclNodeData(72, "XSD", null);
            root.setUserObject(rootdata2);
        }
        if (xsd != null) {
            xsd.resolveHierarchy();
            xsd.resolveAttrOnElement();
        }
        root.removeAllChildren();
        if (xsd == null) {
            this.treeModel.nodeStructureChanged(root);
            this.expandRow(0);
            this.setSelectionRow(0);
            return;
        }
        DefaultMutableTreeNode rootnode = null;
        XsdElementDecl elem = xsd.getRootElement();
        if (elem != null && (treeNode = new DynamicTreeNode(rootdata = new XsdElementDeclNodeData(elem))) != null) {
            root.add(treeNode);
            rootnode = treeNode;
        }
        Hashtable store = new Hashtable();
        this.treeModel.nodeStructureChanged(root);
        store.clear();
        if (rootnode != null) {
            this.expandAllSubNode(rootnode, store, rootnode.getChildCount() < 2);
            this.setSelectionRow(0);
        }
    }

    private void expandAllSubNode(DefaultMutableTreeNode node, Hashtable elemTab, boolean deep) {
        block4: {
            block3: {
                TreePath tp = new TreePath(node.getPath());
                this.expandPath(tp);
                if (!deep) {
                    return;
                }
                XDeclNodeData data = (XDeclNodeData)node.getUserObject();
                if (data.getNodeType() != 50) break block3;
                String name2 = tp.toString();
                int pathCount = tp.getPathCount();
                if (elemTab.containsKey(name2) || pathCount >= 10) break block4;
                elemTab.put(name2, data);
                int n = node.getChildCount();
                for (int i = 0; i < n; ++i) {
                    DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                    this.expandAllSubNode(sub, elemTab, deep);
                }
                break block4;
            }
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode sub = (DefaultMutableTreeNode)node.getChildAt(i);
                this.expandAllSubNode(sub, elemTab, deep);
            }
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.treeModel.getRoot();
    }

    public XSDDeclNodeData getRootData() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        return (XSDDeclNodeData)root.getUserObject();
    }

    public void setRootData(XSDDeclNodeData data) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        root.setUserObject(data);
        this.treeModel.nodeChanged(root);
    }

    void addSubNodesTo(DefaultMutableTreeNode parent) {
        XDeclNodeData data = (XDeclNodeData)parent.getUserObject();
        int type = data.getNodeType();
        String name2 = data.getNodeName();
        if (type == 50) {
            if (name2 == null) {
                return;
            }
            XsdElementDeclNodeData eledata = (XsdElementDeclNodeData)data;
            XsdElementDecl decl = null;
            if (eledata.getRef() != null) {
                XsdTypeRef ref = eledata.getRef();
                XsdDeclNode node = ref.getDeclNode();
                if (node == null) {
                    return;
                }
                if (node.getNodeType() != 50) {
                    return;
                }
                decl = (XsdElementDecl)node;
            } else {
                XsdElementDecl tmpEle = eledata.getElementDecl();
                XSDDocument tmpxsd = (XSDDocument)tmpEle.getXsd();
                if (tmpxsd == null) {
                    return;
                }
                decl = tmpEle;
            }
            XsdDeclNodeList list = decl.getAttListDecls();
            int n = list.getLength();
            for (int i = 0; i < n; ++i) {
                XsdAttDefDeclNodeData data1 = new XsdAttDefDeclNodeData((XsdAttDef)list.item(i));
                parent.add(new DefaultMutableTreeNode(data1));
            }
            XsdDeclNodeList elelist = decl.getSubElementDecls();
            n = elelist.getLength();
            for (int i = 0; i < n; ++i) {
                XsdElementDeclNodeData data1 = new XsdElementDeclNodeData((XsdElementDecl)elelist.item(i));
                parent.add(new DynamicTreeNode(data1));
            }
        }
    }

    DefaultMutableTreeNode getSelectedTreeNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    void setSelectedTreeNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    class DynamicTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasLoaded;

        public DynamicTreeNode(Object obj) {
            super(obj);
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            if (!this.hasLoaded) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.hasLoaded = true;
            XmlXsdViewer.this.addSubNodesTo(this);
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof XDeclNodeData) {
                this.setIcon(((XDeclNodeData)userObject).getImageIcon());
            }
            this.setFont(XmlXsdViewer.this.defaultFont);
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

