/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xsd;

import com.argo21.jxp.parser.XmlParser;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XsdDOMTreeEntryFactory {
    Node node;
    Reference ref;
    int childLength;
    String name;
    String value;
    int type;

    public XsdDOMTreeEntryFactory(Node node) {
        this.node = node;
        this.childLength = 0;
        this.name = node.getNodeName();
        this.type = node.getNodeType();
        if (node != null) {
            String s;
            short type = node.getNodeType();
            if (type == 1) {
                String s2 = XmlParser.getElementText(node);
                if (!"".equals(s2.trim())) {
                    this.value = s2;
                }
            } else if (type == 2) {
                String s3 = node.getNodeValue().trim();
                if (!"".equals(s3.trim())) {
                    this.value = s3;
                }
            } else if (type == 8 && !(s = node.getNodeValue()).startsWith("{{") && !s.endsWith("}}")) {
                this.value = s;
            }
        }
    }

    public XsdDOMTreeEntryFactory(String name2, String value, int type) {
        this.name = name2;
        this.value = value;
        this.type = type;
        this.node = null;
        this.childLength = 0;
    }

    public Node getNode() {
        return this.node;
    }

    public int getType() {
        return this.type;
    }

    private XsdDOMTreeEntryFactory[] getChildObject() {
        XsdDOMTreeEntryFactory[] childObject = null;
        if (this.ref != null) {
            childObject = (XsdDOMTreeEntryFactory[])this.ref.get();
        }
        if (childObject == null) {
            short type;
            Node node;
            int i;
            if (this.node == null) {
                childObject = new XsdDOMTreeEntryFactory[]{};
                this.ref = new SoftReference<XsdDOMTreeEntryFactory[]>(childObject);
                this.childLength = 0;
                return childObject;
            }
            NodeList children = this.node.getChildNodes();
            NamedNodeMap nmap = this.node.getAttributes();
            int n1 = children.getLength();
            int n2 = 0;
            if (nmap != null) {
                n2 = nmap.getLength();
            }
            childObject = new XsdDOMTreeEntryFactory[n1 + n2];
            int k = 0;
            for (i = 0; i < n2; ++i) {
                node = nmap.item(i);
                type = node.getNodeType();
                if (type != 2) continue;
                childObject[k++] = new XsdDOMTreeEntryFactory(node);
            }
            for (i = 0; i < n1; ++i) {
                String value;
                node = children.item(i);
                type = node.getNodeType();
                if (type == 1) {
                    childObject[k++] = new XsdDOMTreeEntryFactory(node);
                    continue;
                }
                if (type != 8 || (value = node.getNodeValue()).startsWith("{{") || value.endsWith("}}")) continue;
                childObject[k++] = new XsdDOMTreeEntryFactory(node);
            }
            this.ref = new SoftReference<XsdDOMTreeEntryFactory[]>(childObject);
            this.childLength = k;
        }
        return childObject;
    }

    public int getChildCount() {
        if (this.node == null) {
            return 0;
        }
        this.getChildObject();
        return this.childLength;
    }

    public XsdDOMTreeEntryFactory getChild(int index) {
        XsdDOMTreeEntryFactory[] childObject = this.getChildObject();
        if (index >= 0 && index < this.childLength) {
            return childObject[index];
        }
        return null;
    }

    public boolean isLeaf() {
        XsdDOMTreeEntryFactory[] childObject = this.getChildObject();
        return this.childLength <= 0;
    }

    public int getIndexOfChild(XsdDOMTreeEntryFactory child) {
        XsdDOMTreeEntryFactory[] childObject = this.getChildObject();
        for (int i = 0; i < this.childLength; ++i) {
            Node childNode = childObject[i].getNode();
            if (childNode == null || !childNode.equals(child.getNode())) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.value == null ? this.name : this.name + " -- " + this.value;
    }
}

