/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xsd;

import com.argo21.common.gui.GuiUtils;
import com.argo21.common.gui.ImageLoader;
import com.argo21.msg.DocumentViewer;
import com.argo21.msg.MessageException;
import com.argo21.msg.xsd.XsdDOMTreeEntryFactory;
import com.argo21.msg.xsd.XsdDOMTreeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XsdDocumentViewer
extends JTree
implements DocumentViewer {
    public static Color SelectedBackgroundColor = UIManager.getColor("Tree.selectionBackground");
    private Font defaultFont = null;
    private ImageIcon elementIcon = ImageLoader.load("element.gif", "Element");
    private ImageIcon attrIcon = ImageLoader.load("attr.gif", "Attribute");
    private ImageIcon commentIcon = ImageLoader.load("comment.gif", "Comment");
    private Document doc = null;
    private String msgname = null;
    private TreeModel treeModel;

    public XsdDocumentViewer() {
        try {
            this.defaultFont = new Font("Dialog", 0, 12);
        }
        catch (Exception e) {
            this.defaultFont = this.getFont();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int y;
                int x;
                JTree source = (JTree)e.getSource();
                TreePath path = source.getClosestPathForLocation(x = e.getX(), y = e.getY());
                if (path != null && e.getModifiers() == 16) {
                    source.setSelectionPath(path);
                }
            }
        });
        GuiUtils.setLookAndFeel(GuiUtils.lookAndFeelClassName, this);
        this.setCellRenderer(new MyTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public void reView() {
        this.treeModel = new XsdDOMTreeModel(this.doc);
        this.setModel(this.treeModel);
        this.expand(10000);
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document == null) {
            this.doc = null;
            this.treeModel = new XsdDOMTreeModel(null);
            this.setModel(this.treeModel);
            return;
        }
        if (document instanceof Document) {
            if (this.doc == document) {
                this.reView();
                return;
            }
            this.doc = (Document)document;
            this.treeModel = new XsdDOMTreeModel(this.doc);
            this.setModel(this.treeModel);
            this.expand(10000);
        } else {
            this.doc = null;
            MessageException.error("CANT_VIEW_DOC", new Object[]{document.getClass().getName(), this.getMsgType()}, null);
        }
    }

    @Override
    public String getMsgType() {
        return "XSD";
    }

    @Override
    public String getMsgName() {
        return this.msgname;
    }

    public void setMsgName(String msgname) {
        this.msgname = msgname;
    }

    @Override
    public Object getDocument() {
        return this.doc;
    }

    @Override
    public Component getViewer() {
        return this;
    }

    public void expandAll() {
        int k = this.getRowCount();
        int index = 0;
        while (true) {
            if (index < k) {
                this.expandRow(index++);
                continue;
            }
            k = this.getRowCount();
            if (index >= k) break;
        }
    }

    public void expand(int limit) {
        int k = this.getRowCount();
        int index = 0;
        while (index < limit) {
            while (index < k) {
                this.expandRow(index++);
                if (index < limit) continue;
            }
            if (index < (k = this.getRowCount())) continue;
            break;
        }
    }

    class MyTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        protected boolean selected;

        MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            this.setText(stringValue);
            this.setToolTipText(stringValue);
            try {
                XsdDOMTreeEntryFactory userObject = (XsdDOMTreeEntryFactory)value;
                int type = userObject.getType();
                if (type == 1) {
                    this.setIcon(XsdDocumentViewer.this.elementIcon);
                } else if (type == 2) {
                    this.setIcon(XsdDocumentViewer.this.attrIcon);
                } else if (type == 8) {
                    this.setIcon(XsdDocumentViewer.this.commentIcon);
                }
                this.setFont(XsdDocumentViewer.this.defaultFont);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.selected = selected;
            return this;
        }

        @Override
        public void paint(Graphics g) {
            Icon currentI = this.getIcon();
            Color bColor = this.selected ? SelectedBackgroundColor : (this.getParent() != null ? this.getParent().getBackground() : this.getBackground());
            g.setColor(bColor);
            if (currentI != null && this.getText() != null) {
                int offset = currentI.getIconWidth() + this.getIconTextGap();
                g.fillRect(offset, 0, this.getWidth() - 1 - offset, this.getHeight() - 1);
            } else {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
            super.paint(g);
        }
    }
}

