/*
 * Decompiled with CFR 0.152.
 */
package com.argo21.msg.xsd;

import com.argo21.common.io.MIME2Java;
import com.argo21.common.io.ReplaceLFWriter;
import com.argo21.common.io.XReader;
import com.argo21.common.lang.ExtOperand;
import com.argo21.common.lang.Operand;
import com.argo21.common.lang.VariableReference;
import com.argo21.common.lang.XData;
import com.argo21.common.lang.XDataException;
import com.argo21.common.lang.XDataMultipleException;
import com.argo21.common.lang.XNode;
import com.argo21.common.lang.XNodeSet;
import com.argo21.common.util.BizTranCache;
import com.argo21.common.util.BizTranCacheNodeSet;
import com.argo21.common.util.Properties;
import com.argo21.jxp.parser.IXmlParser;
import com.argo21.jxp.parser.Xerces;
import com.argo21.jxp.parser.XmlParser;
import com.argo21.jxp.xpath.DefaultXPathSurpport;
import com.argo21.jxp.xpath.XPath;
import com.argo21.jxp.xpath.XPathParser;
import com.argo21.jxp.xpath.XPathSurpport;
import com.argo21.jxp.xpath.XSDXPathSurpport;
import com.argo21.jxp.xsd.XSDDecl;
import com.argo21.jxp.xsd.XSDDocument;
import com.argo21.jxp.xsd.XsdDeclNode;
import com.argo21.jxp.xsd.XsdDeclNodeList;
import com.argo21.jxp.xsd.XsdPIDecl;
import com.argo21.msg.BaseMessage;
import com.argo21.msg.MessageException;
import com.argo21.msg.xsd.XsdErrorHandler;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XsdMsg
extends BaseMessage {
    public static final String MSGTYPE = "XSD";
    private static final String EXTTYPE = "xml";
    public static final String PROPERTY_VERSION = "version";
    public static final String PROPERTY_PREFIX = "schemaPrefix";
    public static final String PROPERTY_LOCATION = "schemaLocation";
    public static final String PROPERTY_PLURAL_LOCATION = "pluralSchemaLocation";
    public static final String PROPERTY_PLURAL_LOCATION_URL = "pluralSchemaLocationURL";
    public static final String PROPERTY_INS_PREFIX = "instancePrefix";
    public static final String PROPERTY_WITHXSD = "withxsd";
    public static final String PROPERTY_VALIDATE = "validate";
    public static final String PROPERTY_PUBLICID = "PUBLIC";
    public static final String PROPERTY_SYSTEMID = "SYSTEM";
    public static final String PROPERTY_INDENT = "indent";
    public static final String PROPERTY_CREATEEMPTYTAG = "createEmptyTag";
    private boolean isChanged = false;
    protected String version = null;
    protected String schemaPrefix = null;
    protected String schemaLocation = null;
    protected String pluralSchemaLocation = null;
    protected String pluralSchemaLocationURL = null;
    protected String instancePrefix = null;
    protected boolean withxsd = false;
    protected boolean doValidate = false;
    protected XSDDecl xsd = null;
    protected Document document = null;
    protected XPathParser xpathParser = null;
    protected XPathSurpport xpathSurpport;
    private boolean initialized = false;
    private long lastModifies = 0L;
    protected String setIndent = null;
    protected String createEmptyTag = null;
    private List exceptions = null;

    @Override
    public String getMsgType() {
        return MSGTYPE;
    }

    @Override
    public boolean isReady() {
        return this.document != null;
    }

    @Override
    public long getLastModifies() {
        return this.lastModifies;
    }

    @Override
    public Properties getProperties() {
        Properties ps = super.getProperties();
        String s = this.withxsd ? "YES" : "NO";
        ps.append(PROPERTY_WITHXSD, s);
        s = this.doValidate ? "YES" : "NO";
        ps.append(PROPERTY_VALIDATE, s);
        ps.append(PROPERTY_PREFIX, this.schemaPrefix);
        ps.append(PROPERTY_LOCATION, this.schemaLocation);
        ps.append(PROPERTY_PLURAL_LOCATION, this.pluralSchemaLocation);
        ps.append(PROPERTY_PLURAL_LOCATION_URL, this.pluralSchemaLocationURL);
        ps.append(PROPERTY_INS_PREFIX, this.instancePrefix);
        ps.append(PROPERTY_INDENT, this.setIndent);
        ps.append(PROPERTY_CREATEEMPTYTAG, this.createEmptyTag);
        return ps;
    }

    @Override
    public Properties getDefaultProperties() {
        Properties ps = super.getDefaultProperties();
        ps.append(PROPERTY_VERSION, "1.0");
        return ps;
    }

    @Override
    public void setProperties(Properties properties) throws MessageException {
        super.setProperties(properties);
        String s = properties.getValue(PROPERTY_VERSION);
        if (s != null && s.trim().length() > 0) {
            this.version = s;
        }
        if ((s = properties.getValue(PROPERTY_WITHXSD, "NO")).equalsIgnoreCase("YES")) {
            this.withxsd = true;
        } else if (s.equalsIgnoreCase("NO")) {
            this.withxsd = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_WITHXSD, s}, null);
        }
        s = properties.getValue(PROPERTY_VALIDATE, "NO");
        if (s.equalsIgnoreCase("YES")) {
            this.doValidate = true;
        } else if (s.equalsIgnoreCase("NO")) {
            this.doValidate = false;
        } else {
            MessageException.error("INVALID_PARAM", new Object[]{PROPERTY_VALIDATE, s}, null);
        }
        s = properties.getValue(PROPERTY_PREFIX);
        if (s != null && s.trim().length() > 0) {
            this.schemaPrefix = s;
        }
        if ((s = properties.getValue(PROPERTY_LOCATION)) != null && s.trim().length() > 0) {
            this.schemaLocation = s;
        }
        if ((s = properties.getValue(PROPERTY_PLURAL_LOCATION)) != null && s.trim().length() > 0) {
            this.pluralSchemaLocation = s;
        }
        if ((s = properties.getValue(PROPERTY_PLURAL_LOCATION_URL)) != null && s.trim().length() > 0) {
            this.pluralSchemaLocationURL = s;
        }
        if ((s = properties.getValue(PROPERTY_INS_PREFIX)) != null && s.trim().length() > 0) {
            this.instancePrefix = s;
        }
        if ((s = properties.getValue(PROPERTY_INDENT)) != null && s.trim().length() > 0) {
            this.setIndent = s;
        }
        if ((s = properties.getValue(PROPERTY_CREATEEMPTYTAG)) != null && s.trim().length() > 0) {
            this.createEmptyTag = s;
        }
        this.initialized = false;
    }

    @Override
    public Object getSchema() {
        return this.xsd;
    }

    @Override
    public void setSchema(Object xsd) throws MessageException {
        if (xsd instanceof XSDDecl) {
            this.xsd = (XSDDecl)xsd;
        } else {
            this.xsd = null;
            MessageException.error("CANT_CAST_SCHEMA", new Object[]{xsd.getClass().getName(), this.getMsgType()}, null);
        }
        this.initialized = false;
    }

    @Override
    public void readSchema(Reader in) throws MessageException {
        try {
            XReader reader = in instanceof XReader ? (XReader)in : XReader.createReader(in);
            XSDDocument xsd = new XSDDocument(this.getMsgName());
            xsd.setProperties(this.getProperties());
            xsd.parseXSDDecl(reader, false, reader.getParentPath());
            xsd.resolveHierarchy();
            xsd.resolveAttrOnElement();
            if (this.encoding == null) {
                this.encoding = xsd.getEncoding();
            }
            this.xsd = xsd;
        }
        catch (Exception e) {
            this.xsd = null;
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public void writeSchema(Writer out) throws MessageException {
        try {
            if (this.xsd instanceof XSDDocument) {
                ((XSDDocument)this.xsd).writeEx(out, true);
            } else {
                this.xsd.write(out);
            }
        }
        catch (Exception e) {
            MessageException.error(null, new Object[0], e, null);
        }
    }

    @Override
    public Object getDocument() {
        return this.document;
    }

    @Override
    public void setDocument(Object document) throws SAXException {
        if (document instanceof Document) {
            this.document = (Document)document;
            if (this.xpathSurpport != null) {
                this.xpathSurpport.setDocument(this.document);
            }
        } else {
            this.document = null;
            this.error("CANT_CAST_DOM", new Object[]{document.getClass().getName(), this.getMsgType()});
        }
    }

    @Override
    public void read(URL url) throws SAXException {
        if (url == null) {
            return;
        }
        try {
            InputSource is;
            if (this.encoding == null) {
                is = XReader.createInputSource(url, false);
                this.encoding = is.getEncoding();
            } else {
                is = new InputSource(XReader.createReader(url.openStream(), this.encoding));
                is.setSystemId(url.toString());
            }
            IXmlParser parser = XmlParser.getXmlParser();
            try {
                this.document = parser.createXmlDocument(is, false);
            }
            catch (SAXException e) {
                this.error(e);
            }
            Element elem = this.document.getDocumentElement();
            if (elem != null) {
                XmlParser.trimNode(elem, this.xsd);
            }
            if (this.xpathSurpport != null) {
                this.xpathSurpport.setDocument(this.document);
            }
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    @Override
    public void read(InputStream in) throws SAXException {
        try {
            InputSource is = XReader.createInputSource(this.encoding, in, false, null);
            if (this.encoding == null) {
                this.encoding = is.getEncoding();
            }
            IXmlParser parser = XmlParser.getXmlParser();
            try {
                this.document = parser.createXmlDocument(is, false);
            }
            catch (SAXException e) {
                this.error(e);
            }
            Element elem = this.document.getDocumentElement();
            if (elem != null) {
                XmlParser.trimNode(elem, this.xsd);
            }
            this.xpathSurpport.setDocument(this.document);
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    @Override
    public void read(Reader in) throws SAXException {
        try {
            if (this.encoding == null) {
                if (in instanceof XReader) {
                    this.encoding = ((XReader)in).getEncoding();
                } else if (in instanceof InputStreamReader) {
                    String s = ((InputStreamReader)in).getEncoding();
                    this.encoding = MIME2Java.reverse(s);
                }
            }
            InputSource is = new InputSource(in);
            IXmlParser parser = XmlParser.getXmlParser();
            try {
                this.document = parser.createXmlDocument(is, false);
            }
            catch (SAXException e) {
                this.error(e);
            }
            Element elem = this.document.getDocumentElement();
            if (elem != null) {
                XmlParser.trimNode(elem, this.xsd);
            }
            this.xpathSurpport.setDocument(this.document);
            this.lastModifies = System.currentTimeMillis();
        }
        catch (SAXException e) {
            this.document = null;
            throw e;
        }
        catch (Exception e) {
            this.document = null;
            this.error(e);
        }
    }

    @Override
    public void submit() throws SAXException {
        if (this.direction.equals("INPUT")) {
            return;
        }
        if (!this.isStreamIO()) {
            URL documentURL = this.getDocumentURL();
            this.write(documentURL, false);
        }
    }

    @Override
    public void write(OutputStream out) throws SAXException {
        OutputStreamWriter writer = null;
        if (this.encoding == null) {
            writer = new OutputStreamWriter(out);
            String en = writer.getEncoding();
            this.encoding = MIME2Java.reverse(en);
        } else {
            String s = MIME2Java.convert(this.encoding);
            try {
                writer = new OutputStreamWriter(out, s);
            }
            catch (UnsupportedEncodingException e) {
                this.error("INVALID_ENCODING", this.encoding);
            }
        }
        this.write(writer);
    }

    @Override
    public void write(Writer out) throws SAXException {
        try {
            if (this.document != null) {
                if (this.xpathSurpport instanceof XSDXPathSurpport) {
                    XSDXPathSurpport surpport = (XSDXPathSurpport)this.xpathSurpport;
                    surpport.terminateDocument();
                }
                if (this.encoding == null && out instanceof OutputStreamWriter) {
                    this.encoding = MIME2Java.reverse(((OutputStreamWriter)out).getEncoding());
                }
                Xerces.setEol(this.eol);
                IXmlParser parser = XmlParser.getXmlParser();
                Element documentElement = this.document.getDocumentElement();
                XsdDeclNodeList nodes = this.xsd.getAllDeclNode();
                int n = nodes.size();
                for (int i = 0; i < n; ++i) {
                    XsdDeclNode node = nodes.elementAt(i);
                    if (node.getNodeType() != 7) continue;
                    XsdPIDecl piDecl = (XsdPIDecl)node;
                    ProcessingInstruction pi = this.document.createProcessingInstruction(piDecl.getNodeName(), piDecl.getContents());
                    this.document.insertBefore(pi, documentElement);
                }
                boolean indentFlag = true;
                String indent = this.getProperties().getValue(PROPERTY_INDENT);
                if (indent != null && indent.equals("false")) {
                    indentFlag = false;
                }
                Writer writer = indentFlag ? new BufferedWriter(out) : new ReplaceLFWriter(new BufferedWriter(out), this.eol);
                parser.writeXmlDocument(this.document, writer, this.encoding, indentFlag);
                writer.flush();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void close() throws MessageException {
        this.document = null;
    }

    @Override
    public void clearDocument() {
        if (this.direction != "INPUT" && this.document != null) {
            Element node = this.document.getDocumentElement();
            this.document.removeChild(node);
            this.lastModifies = System.currentTimeMillis();
        }
    }

    @Override
    public boolean init() throws SAXException {
        if (this.direction == "INPUT") {
            if (!this.isStreamIO()) {
                URL documentURL = this.getDocumentURL();
                this.read(documentURL);
            }
            this.xpathSurpport = this.xsd != null ? new XSDXPathSurpport(this.xsd, this.document) : new DefaultXPathSurpport(this.document);
            this.xpathSurpport.setExtendable(false);
        } else {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setValidating(true);
                dbf.setNamespaceAware(true);
                dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                DocumentBuilder db = null;
                try {
                    db = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException ex) {
                    System.err.println("Fail to create DocumentBuilder: " + ex.getMessage());
                    return false;
                }
                DOMImplementation domimpl = db.getDOMImplementation();
                this.document = domimpl.createDocument(this.xsd.getNameSpace(), "root", null);
                this.lastModifies = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.document = null;
                this.error(e);
            }
            this.xpathSurpport = this.xsd != null ? new XSDXPathSurpport(this.xsd, this.document) : new DefaultXPathSurpport(this.document);
            this.xpathSurpport.setExtendable(true);
            this.isChanged = true;
        }
        this.initialized = true;
        return true;
    }

    private String getNodeText(Node node) {
        if (node.getNodeType() == 1) {
            for (Node current = node.getFirstChild(); current != null; current = current.getNextSibling()) {
                if (current.getNodeType() != 3) continue;
                return current.getNodeValue();
            }
        }
        return "";
    }

    @Override
    public ExtOperand parseOperand(Operand orient, VariableReference variables, XReader in) throws SAXException {
        if (!this.initialized) {
            if (!this.init()) {
                this.error("CANT_INIT_MSG", this.name);
            }
            this.clearDocument();
        }
        if (this.xpathSurpport.getVariableReference() != variables) {
            this.xpathSurpport.setVariableReference(variables);
        }
        if (this.xpathParser == null) {
            this.xpathParser = new XPathParser();
        }
        XPath xpath = this.xpathParser.parse(in);
        XPathOperand op = new XPathOperand(orient, xpath);
        String s = orient.getReference();
        s = s + "/" + xpath.getNodePathString();
        op.setReference(s);
        return op;
    }

    public String toString() {
        Properties ps = this.getProperties();
        return ps.toString(",");
    }

    public static void main(String[] args) {
    }

    @Override
    public boolean validateMessage(String mapPath) {
        boolean result = false;
        if (this.doValidate) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            dbf.setNamespaceAware(true);
            dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            String prefix = null;
            NamedNodeMap nnm = this.document.getDocumentElement().getAttributes();
            for (int i = 0; i < nnm.getLength(); ++i) {
                if (!"http://www.w3.org/2001/XMLSchema-instance".equals(nnm.item(i).getNodeValue())) continue;
                prefix = nnm.item(i).getLocalName();
                if (prefix == null || prefix.length() > 0) break;
                prefix = null;
                break;
            }
            String slName = PROPERTY_LOCATION;
            String noslName = "noNamespaceSchemaLocation";
            String xmlnsName = "xmlns";
            if (this.pluralSchemaLocation != null && !"".equals(this.pluralSchemaLocation) && this.pluralSchemaLocationURL != null && !"".equals(this.pluralSchemaLocationURL)) {
                StringBuffer sb = new StringBuffer();
                StringTokenizer pslTokenizer = new StringTokenizer(this.pluralSchemaLocation, ",");
                StringTokenizer pslURLTokenizer = new StringTokenizer(this.pluralSchemaLocationURL, ",");
                while (pslTokenizer.hasMoreTokens() && pslURLTokenizer.hasMoreTokens()) {
                    sb.append(pslTokenizer.nextToken().trim());
                    sb.append(" ");
                    sb.append(pslURLTokenizer.nextToken().trim());
                    sb.append(" ");
                }
                if (prefix == null) {
                    prefix = "xsi";
                }
                this.document.getDocumentElement().setAttribute(xmlnsName + ":" + prefix, "http://www.w3.org/2001/XMLSchema-instance");
                if (noslName.equals(this.pluralSchemaLocation)) {
                    this.document.getDocumentElement().setAttribute(prefix + ":" + noslName, this.pluralSchemaLocationURL);
                } else {
                    this.document.getDocumentElement().setAttribute(prefix + ":" + slName, sb.toString().trim());
                    this.document.getDocumentElement().removeAttribute(prefix + ":" + noslName);
                }
            } else {
                boolean hasSchemaLocation = false;
                if (prefix != null) {
                    slName = prefix + ":" + slName;
                    noslName = prefix + ":" + noslName;
                }
                String sl = this.document.getDocumentElement().getAttribute(slName);
                String nosl = this.document.getDocumentElement().getAttribute(noslName);
                if (sl != null && !"".equals(sl) || nosl != null && !"".equals(nosl)) {
                    hasSchemaLocation = true;
                }
                if (!hasSchemaLocation) {
                    dbf.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", new ByteArrayInputStream(this.xsd.toString().getBytes()));
                }
            }
            DocumentBuilder db = null;
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (ParserConfigurationException ex) {
                throw new RuntimeException(ex);
            }
            XsdErrorHandler eh = new XsdErrorHandler();
            db.setErrorHandler(eh);
            try {
                String user_dir = System.getProperty("user.dir");
                if (mapPath != null) {
                    File tfile = new File(mapPath);
                    System.setProperty("user.dir", tfile.getCanonicalPath());
                }
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.write(baos);
                ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                db.parse(bais);
                if (!this.withxsd) {
                    this.document.getDocumentElement().removeAttribute(xmlnsName + ":" + prefix);
                    this.document.getDocumentElement().removeAttribute(prefix + ":" + slName);
                    this.document.getDocumentElement().removeAttribute(prefix + ":" + noslName);
                }
                result = eh.getResult();
                this.exceptions = eh.getExceptions();
                System.setProperty("user.dir", user_dir);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        result = true;
        return result;
    }

    @Override
    public List getExceptions() {
        return this.exceptions;
    }

    @Override
    public String getExtension() {
        return EXTTYPE;
    }

    @Override
    public boolean doValidate() {
        return this.doValidate;
    }

    @Override
    public boolean isSettingIndent() {
        boolean indentFlag = true;
        String indent = this.getProperties().getValue(PROPERTY_INDENT);
        if (indent != null && indent.equals("false")) {
            indentFlag = false;
        }
        return indentFlag;
    }

    class XPathOperand
    extends ExtOperand {
        XPathOperand(Operand orient, Object expression) {
            super(orient, expression);
        }

        @Override
        public String getEncoding() {
            return XsdMsg.this.encoding;
        }

        private XData selectData(XData ref) throws XDataException {
            XPath xpath = (XPath)this.expression;
            BizTranCacheNodeSet cNodeSet = BizTranCache.getNode(xpath.getNodePathString(XsdMsg.this.xpathSurpport), XsdMsg.this.name);
            Node cNode = cNodeSet.getNode();
            try {
                if (ref.isObject()) {
                    Object obj = ref.objectValue();
                    if (obj instanceof XsdMsg) {
                        XNodeSet xns;
                        if (cNode != null) {
                            xns = new XNodeSet(cNode);
                        } else {
                            Document doc = ((XsdMsg)obj).document;
                            xns = new XNodeSet(doc);
                        }
                        return xpath.eval(xns, XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof Node) {
                        return xpath.eval(new XNodeSet((Node)obj), XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof NodeList) {
                        return xpath.eval(new XNodeSet((NodeList)obj), XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XNode) {
                        return xpath.eval((XNode)obj, XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XNodeSet) {
                        return xpath.eval((XNodeSet)obj, XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (obj instanceof XData) {
                        XData.error("CANT_TO_NODE", ((XData)obj).getPrimitiveTypeName());
                    } else {
                        XData.error("CANT_TO_NODE", obj.getClass().getName());
                    }
                } else {
                    if (ref instanceof XNode) {
                        return xpath.eval((XNode)ref, XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    if (ref instanceof XNodeSet) {
                        return xpath.eval((XNodeSet)ref, XsdMsg.this.xpathSurpport, cNodeSet.getDepth());
                    }
                    XData.error("CANT_TO_NODE", ref.getPrimitiveTypeName());
                }
            }
            catch (XDataException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                XData.error(e, true);
            }
            return null;
        }

        @Override
        protected XData getData(XData ref) throws XDataException {
            XsdMsg.this.xpathSurpport.setExtendable(false);
            return this.selectData(ref);
        }

        @Override
        protected void setData(XData ref, XData data) throws XDataException {
            if ("NO".equals(XsdMsg.this.createEmptyTag) && (data.stringValue() == null || data.stringValue().length() == 0)) {
                return;
            }
            XsdMsg.this.xpathSurpport.setExtendable(XsdMsg.this.getDirection() != "INPUT");
            XsdMsg.this.xpathSurpport.setDefaultNumber(data.size());
            XData target = this.selectData(ref);
            XDataMultipleException exception = null;
            int n = target.size();
            if (data.isInteger()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.longValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isFloat()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.doubleValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isBoolean()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.booleanValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else if (data.isDate()) {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.dateValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    try {
                        target.setValue(i, data.stringValue(i));
                        continue;
                    }
                    catch (XDataException e) {
                        if (exception != null) {
                            exception.addException(e);
                            continue;
                        }
                        exception = new XDataMultipleException(e);
                    }
                }
            }
            XsdMsg.this.lastModifies = System.currentTimeMillis();
            if (exception != null) {
                throw exception;
            }
        }
    }
}

