/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nts.commons.passfile;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Arrays;

public abstract class AbstractPassfile {
    private static final int[] RANGE_PRODUCT_ID = new int[]{0, 6};
    private static final int[] RANGE_SERIAL_NO = new int[]{6, 6};
    private static final int[] RANGE_LICENSE_OWNER = new int[]{181, 48};
    private static final int[] RANGE_OWNER_LENGTH = new int[]{229, 2};
    private static final int[] RANGE_PROTECT_KEY = new int[]{248, 6};
    private static final int[] RANGE_EVALUATION = new int[]{256, 1};
    private static final String CHARSET = "Shift_JIS";
    private final byte[] _bytes;

    protected AbstractPassfile(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this._bytes = byArray;
    }

    final byte[] getBytes() {
        byte[] byArray = new byte[this._bytes.length];
        System.arraycopy(this._bytes, 0, byArray, 0, this._bytes.length);
        return byArray;
    }

    public final byte[] getBytes(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this._bytes, n, byArray, 0, n2);
        return byArray;
    }

    public final void setBytes(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        System.arraycopy(byArray, 0, this._bytes, n, byArray.length);
    }

    public final String getProductID() {
        return new String(this.getBytes(RANGE_PRODUCT_ID[0], RANGE_PRODUCT_ID[1]));
    }

    public final String getSerialNo(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length != RANGE_SERIAL_NO[1]) {
            throw new IllegalArgumentException("Decode key is not 6 bytes.");
        }
        byte[] byArray2 = this.getBytes(RANGE_SERIAL_NO[0], RANGE_SERIAL_NO[1]);
        char[] cArray = new char[RANGE_SERIAL_NO[1]];
        for (int i = 0; i < RANGE_SERIAL_NO[1]; ++i) {
            cArray[i] = (char)(byArray2[i] ^ byArray[i]);
        }
        return new String(cArray);
    }

    public final void setSerialNo(String string, byte[] byArray) {
        if (string == null || byArray == null) {
            throw new NullPointerException();
        }
        if (byArray.length != RANGE_SERIAL_NO[1]) {
            throw new IllegalArgumentException("Decode key is not 6 bytes.");
        }
        if (string.length() != RANGE_SERIAL_NO[1]) {
            throw new IllegalArgumentException("Invalid size: " + string);
        }
        byte[] byArray2 = new byte[RANGE_SERIAL_NO[1]];
        for (int i = 0; i < RANGE_SERIAL_NO[1]; ++i) {
            byArray2[i] = (byte)(string.charAt(i) ^ byArray[i]);
        }
        this.setBytes(RANGE_SERIAL_NO[0], byArray2);
    }

    public final String getLicenseOwner() {
        String string = "";
        int n = this.getOwnerLength();
        if (n > 0) {
            try {
                string = new String(this.getBytes(RANGE_LICENSE_OWNER[0], n), CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                IllegalStateException illegalStateException = new IllegalStateException(unsupportedEncodingException.getMessage());
                illegalStateException.initCause(unsupportedEncodingException);
                throw illegalStateException;
            }
        }
        return string;
    }

    private int getOwnerLength() {
        int n = 0;
        String string = new String(this.getBytes(RANGE_OWNER_LENGTH[0], RANGE_OWNER_LENGTH[1]));
        if ((string = string.trim()).length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public final void setLicenseOwner(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        byte[] byArray = new byte[RANGE_LICENSE_OWNER[1]];
        Arrays.fill(byArray, (byte)0);
        try {
            byte[] byArray2 = string.getBytes(CHARSET);
            if (byArray2.length > RANGE_LICENSE_OWNER[1]) {
                throw new IllegalArgumentException("Too long name: " + string);
            }
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            this.setBytes(RANGE_LICENSE_OWNER[0], byArray);
            this.setOwnerLength(byArray2.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IllegalStateException illegalStateException = new IllegalStateException(unsupportedEncodingException.getMessage());
            illegalStateException.initCause(unsupportedEncodingException);
            throw illegalStateException;
        }
    }

    private void setOwnerLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string = decimalFormat.format(n);
        if (string.length() > RANGE_OWNER_LENGTH[1]) {
            throw new IllegalArgumentException("Too big size: " + n);
        }
        this.setBytes(RANGE_OWNER_LENGTH[0], string.getBytes());
    }

    public final String getProtectKey() {
        return new String(this.getBytes(RANGE_PROTECT_KEY[0], RANGE_PROTECT_KEY[1]));
    }

    public final boolean isEvaluationCopy() {
        byte by = this.getBytes(RANGE_EVALUATION[0], RANGE_EVALUATION[1])[0];
        switch (by) {
            case 48: {
                return false;
            }
            case 49: {
                return true;
            }
        }
        return false;
    }
}

