/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nts.commons.properties;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nts.commons.properties.PropertyParseException;
import jp.co.argo21.nts.commons.properties.Validator;
import org.apache.commons.configuration.Configuration;

public class DifferenceValidator
implements Validator {
    protected String key;
    protected List targets = new ArrayList();

    private DifferenceValidator() {
    }

    public DifferenceValidator(String string) {
        this.key = string;
    }

    public void addTarget(String string) {
        this.addTarget(string, String.class);
    }

    public void addTarget(String string, Class clazz) throws IllegalArgumentException {
        try {
            clazz.getConstructor(String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new IllegalArgumentException(noSuchMethodException.getMessage());
        }
        this.targets.add(new Target(string, clazz));
    }

    public void validate(Configuration configuration) throws PropertyParseException {
        String[] stringArray = this.getStringArray(configuration, this.key);
        for (int i = 0; i < stringArray.length; ++i) {
            for (Target target : this.targets) {
                String[] stringArray2 = this.getStringArray(configuration, target.key);
                try {
                    Object t = target.clazz.getConstructor(String.class).newInstance(stringArray[i]);
                    for (int j = 0; j < stringArray.length; ++j) {
                        Constructor constructor = target.clazz.getConstructor(String.class);
                        if (!t.equals(constructor.newInstance(stringArray2[j]))) continue;
                        throw new PropertyParseException("key(\"" + this.key + "\") and " + "key(\"" + target.key + "\") are " + "same value(\"" + stringArray[i] + "\").");
                    }
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                    throw new IllegalStateException(instantiationException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                    throw new IllegalStateException(illegalAccessException.getMessage());
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                    Throwable throwable = invocationTargetException.getTargetException();
                    throw new PropertyParseException(throwable.getMessage(), throwable);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    noSuchMethodException.printStackTrace();
                    throw new IllegalStateException(noSuchMethodException.getMessage());
                }
            }
        }
    }

    private String[] getStringArray(Configuration configuration, String string) {
        String[] stringArray = configuration.getStringArray(string);
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{configuration.getString(string)};
        }
        return stringArray;
    }

    private class Target {
        private String key;
        private Class clazz;

        private Target(String string, Class clazz) {
            this.key = string;
            this.clazz = clazz;
        }
    }
}

