/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nts.commons.properties;

import jp.co.argo21.nts.commons.properties.PropertyParseException;
import jp.co.argo21.nts.commons.properties.Validatable;
import org.apache.commons.validator.GenericValidator;

public class IntRangeValidator
implements Validatable {
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;

    private IntRangeValidator(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    public static IntRangeValidator getInstance(int n, int n2) {
        return new IntRangeValidator(n, n2);
    }

    public static IntRangeValidator getInstanceWithMin(int n) {
        return new IntRangeValidator(n, Integer.MAX_VALUE);
    }

    public static IntRangeValidator getInstanceWithMax(int n) {
        return new IntRangeValidator(Integer.MIN_VALUE, n);
    }

    public void validate(String string) throws PropertyParseException {
        if (this.max < this.min) {
            throw new PropertyParseException("invalid max(" + this.max + ") and min(" + this.min + ")");
        }
        if (GenericValidator.isBlankOrNull((String)string) || !GenericValidator.isInt((String)string)) {
            throw new PropertyParseException("target is \"" + string + "\"");
        }
        int n = Integer.parseInt(string);
        if (!GenericValidator.isInRange((int)n, (int)this.min, (int)this.max)) {
            throw new PropertyParseException("invalid range(max=" + this.max + ", min=" + this.min + ") :" + string);
        }
    }
}

