/*
 * Decompiled with CFR 0.152.
 */
package jp.co.argo21.nts.commons.properties;

import java.util.ArrayList;
import java.util.List;
import jp.co.argo21.nts.commons.properties.PropertyParseException;
import jp.co.argo21.nts.commons.properties.Validatable;
import jp.co.argo21.nts.commons.properties.Validator;
import org.apache.commons.configuration.Configuration;

public class SimpleValidator
implements Validator {
    protected String key;
    protected List validators = new ArrayList();

    private SimpleValidator() {
    }

    public SimpleValidator(String string) {
        this.key = string;
    }

    public SimpleValidator(String string, Validatable validatable) {
        this.key = string;
        this.addValidator(validatable);
    }

    public void addValidator(Validatable validatable) {
        this.validators.add(validatable);
    }

    public void validate(Configuration configuration) throws PropertyParseException {
        for (int i = 0; i < this.validators.size(); ++i) {
            Validatable validatable = (Validatable)this.validators.get(i);
            try {
                String[] stringArray = configuration.getStringArray(this.key);
                if (stringArray == null || stringArray.length == 0) {
                    validatable.validate(configuration.getString(this.key));
                    continue;
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    validatable.validate(stringArray[j]);
                }
                continue;
            }
            catch (PropertyParseException propertyParseException) {
                throw new PropertyParseException("Invalid key(" + this.key + ") or value: " + propertyParseException.getMessage(), propertyParseException);
            }
        }
    }
}

