/*
 * Decompiled with CFR 0.152.
 */
package com.flexera.ia.sshutils;

import com.flexera.ia.sshutils.FlexUserInfo;
import com.flexera.ia.sshutils.RemoteExecutionException;
import com.flexera.ia.sshutils.SSHConfigSpec;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class SSHUtils {
    public static int executeCommand(SSHConfigSpec sSHConfigSpec, String string, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Command " + string + " failed with Exit Status=" + n);
        }
        return n;
    }

    public static int executeCommand(SSHConfigSpec sSHConfigSpec, String string, StringBuilder stringBuilder) throws IOException, JSchException, RemoteExecutionException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                stringBuilder.append(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Command " + string + " failed with Exit Status=" + n);
        }
        return n;
    }

    public static int executeCommandWithStatus(SSHConfigSpec sSHConfigSpec, String string, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        return n;
    }

    public static int executeCommandInStartDirectory(SSHConfigSpec sSHConfigSpec, String string, String string2, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand("cd " + string2 + ";" + string);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Command " + string2 + "/" + string + " failed with Exit Status=" + n);
        }
        return n;
    }

    public static int executeShellScript(SSHConfigSpec sSHConfigSpec, String string, String string2, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        return SSHUtils.executeShellScriptInSpecificShell(sSHConfigSpec, string, string2, "sh", printStream);
    }

    public static boolean testSSHConnectionToMachine(SSHConfigSpec sSHConfigSpec) {
        JSch jSch = new JSch();
        Session session = null;
        try {
            session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
            session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
            session.connect();
            session.disconnect();
            return true;
        }
        catch (JSchException jSchException) {
            return false;
        }
    }

    public static boolean testSSHConnectionToMachine(SSHConfigSpec sSHConfigSpec, StringBuilder stringBuilder) {
        JSch jSch = new JSch();
        Session session = null;
        try {
            session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
            session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
            session.connect();
            session.disconnect();
            return true;
        }
        catch (JSchException jSchException) {
            if (jSchException.getMessage().equalsIgnoreCase("Auth fail")) {
                stringBuilder.append(jSchException.getMessage());
            }
            return false;
        }
    }

    public static int executeShellScriptInSpecificShell(SSHConfigSpec sSHConfigSpec, String string, String string2, String string3, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand("cd " + string2 + ";sh " + string);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            if (!channel.isClosed() && channel.getExitStatus() == 0) {
                System.out.println("Exit Status changed before Channel closure !");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        System.out.println("Exit status of JSCH channel: " + n);
        long l = 100000L;
        SSHUtils.waitForChannelClosure(channel, l);
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Script " + string2 + "/" + string + " failed with Exit Status=" + n);
        }
        return n;
    }

    public static void waitForChannelClosure(Channel channel, long l) throws RuntimeException {
        long l2 = System.currentTimeMillis() + l;
        try {
            while (!channel.isClosed() && System.currentTimeMillis() < l2) {
                Thread.sleep(250L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted", interruptedException);
        }
        if (!channel.isClosed()) {
            throw new RuntimeException("Channel not closed properly !!!");
        }
    }

    public static int createNewFile(SSHConfigSpec sSHConfigSpec, String string, String string2, boolean bl) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        String string3 = "";
        string3 = bl ? "cd " + string + ";mkdir " + string2 : "cd " + string + ";touch " + string2;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string3);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n;
            if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                sSHConfigSpec.getStreamToWriteErrorsAndWarnings().print(new String(byArray, 0, n));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        int n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Create File with parent directory=" + string + " file=" + string2 + "failed with Exit Status=" + n);
        }
        return n;
    }

    public static void copyLocalFileToRemoteMachine(SSHConfigSpec sSHConfigSpec, String string, String string2) throws FileNotFoundException, IOException, JSchException {
        int n;
        if (string == null) {
            throw new FileNotFoundException("Cannot copy file to remote machine. Local File is null.");
        }
        if (!new File(string).exists()) {
            throw new FileNotFoundException("Cannot copy file to remote machine. The specified local file does not exist. File specified=" + string);
        }
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        boolean bl = false;
        String string3 = "scp " + (bl ? "-p" : "") + " -t " + string2;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string3);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        int n2 = SSHUtils.aa(inputStream);
        if (n2 != 0) {
            throw new JSchException("Acknowledgement not successful :" + n2);
        }
        File file = new File(string);
        if (bl) {
            string3 = "T " + file.lastModified() / 1000L + " 0";
            string3 = string3 + " " + file.lastModified() / 1000L + " 0\n";
            outputStream.write(string3.getBytes());
            outputStream.flush();
            int n3 = SSHUtils.aa(inputStream);
            if (n3 != 0) {
                System.err.println("Could not print time stamp");
            }
        }
        long l = file.length();
        string3 = "C0644 " + l + " ";
        string3 = string.lastIndexOf(47) > 0 ? string3 + string.substring(string.lastIndexOf(47) + 1) : string3 + string;
        string3 = string3 + "\n";
        outputStream.write(string3.getBytes());
        outputStream.flush();
        int n4 = SSHUtils.aa(inputStream);
        if (n4 != 0) {
            throw new JSchException("Acknowledgement not successful :" + n4);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileInputStream = null;
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        n = SSHUtils.aa(inputStream);
        if (n != 0) {
            throw new JSchException("Acknowledgement not successful :" + n);
        }
        outputStream.close();
        channel.disconnect();
        session.disconnect();
    }

    public static void copyRemoteFileToLocalMachine(SSHConfigSpec sSHConfigSpec, String string, String string2) throws FileNotFoundException, IOException, JSchException {
        int n;
        String string3 = null;
        if (new File(string).isDirectory()) {
            string3 = string + File.separator;
        }
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        String string4 = "scp -f " + string2;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string4);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        while ((n = SSHUtils.aa(inputStream)) == 67) {
            int n2;
            inputStream.read(byArray, 0, 5);
            long l = 0L;
            while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                l = l * 10L + (long)(byArray[0] - 48);
            }
            String string5 = null;
            int n3 = 0;
            while (true) {
                inputStream.read(byArray, n3, 1);
                if (byArray[n3] == 10) break;
                ++n3;
            }
            string5 = new String(byArray, 0, n3);
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            FileOutputStream fileOutputStream = new FileOutputStream(string3 == null ? string : string3 + string5);
            do {
                n2 = (long)byArray.length < l ? byArray.length : (int)l;
                if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                fileOutputStream.write(byArray, 0, n2);
            } while ((l -= (long)n2) != 0L);
            fileOutputStream.close();
            fileOutputStream = null;
            int n4 = SSHUtils.aa(inputStream);
            if (n4 != 0) {
                throw new JSchException("Acknowledgement not successful :" + n4);
            }
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
        }
        channel.disconnect();
        session.disconnect();
    }

    private static int aa(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return n;
        }
        if (n == -1) {
            return n;
        }
        if (n == 1 || n == 2) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                n2 = inputStream.read();
                stringBuffer.append((char)n2);
            } while (n2 != 10);
            if (n == 1) {
                System.err.print(stringBuffer.toString());
            }
            if (n == 2) {
                System.err.print(stringBuffer.toString());
            }
        }
        return n;
    }

    public static int deleteAFileOrFolder(SSHConfigSpec sSHConfigSpec, String string, String string2) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        String string3 = "";
        string3 = "cd " + string + ";rm -rf " + string2;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string3);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n;
            if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                sSHConfigSpec.getStreamToWriteErrorsAndWarnings().print(new String(byArray, 0, n));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        int n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Create File with parent directory=" + string + " file=" + string2 + "failed with Exit Status=" + n);
        }
        return n;
    }

    public static void copyRemoteFolderContentsToLocalFolder(SSHConfigSpec sSHConfigSpec, String string, String string2) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        File file;
        String string3;
        SSHUtils.executeCommand(sSHConfigSpec, "cd  " + string + "; ls > " + "FileList.txt", System.err);
        String string4 = string2 + File.separator + "FileList.txt";
        SSHUtils.copyRemoteFileToLocalMachine(sSHConfigSpec, string4, string + "/FileList.txt");
        Vector<String> vector = new Vector<String>();
        FileInputStream fileInputStream = new FileInputStream(string4);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        while ((string3 = bufferedReader.readLine()) != null) {
            vector.add(string3);
        }
        dataInputStream.close();
        if (vector != null && !vector.isEmpty()) {
            for (int i = 0; i < vector.size(); ++i) {
                String string5 = (String)vector.get(i);
                SSHUtils.copyRemoteFileToLocalMachine(sSHConfigSpec, string2 + File.separator + string5, string + "/" + string5);
            }
        }
        if ((file = new File(string4)) != null && file.exists()) {
            file.delete();
        }
    }

    public static int createNewFileForWindows(SSHConfigSpec sSHConfigSpec, String string, String string2, boolean bl) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        String string3 = "";
        string3 = bl ? "cmd.exe /c md " + string + "\\" + string2 : "cmd.exe /c fsutil file createnew " + string + "\\" + string2 + " 0";
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string3);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n;
            if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                sSHConfigSpec.getStreamToWriteErrorsAndWarnings().print(new String(byArray, 0, n));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        int n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Create File with parent directory=" + string + " file=" + string2 + "failed with Exit Status=" + n);
        }
        return n;
    }

    public static int deleteAFileOrFolderOnWindows(SSHConfigSpec sSHConfigSpec, String string, String string2, boolean bl) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        String string3 = "";
        string3 = !bl ? "cmd.exe /c del /F /Q " + string + "\\" + string2 : "cmd.exe /c rd /S /Q " + string + "\\" + string2;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string3);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n;
            if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, 1024)) >= 0) {
                sSHConfigSpec.getStreamToWriteErrorsAndWarnings().print(new String(byArray, 0, n));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        int n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Create File with parent directory=" + string + " file=" + string2 + "failed with Exit Status=" + n);
        }
        return n;
    }

    public static void copyLocalFileToRemoteMachineWindows(SSHConfigSpec sSHConfigSpec, String string, String string2, PrintStream printStream) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        String string3 = "/";
        String string4 = "C:\\ftproot";
        String string5 = "";
        String string6 = System.getProperty("java.io.tmpdir");
        String string7 = "";
        if (string == null || !new File(string).exists()) {
            throw new FileNotFoundException("Local File is null");
        }
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.setPassword(sSHConfigSpec.getPassword());
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp channelSftp = (ChannelSftp)channel;
        try {
            channelSftp.put(string, string3);
            channelSftp.put(SSHUtils.ab(string4 + File.separator + new File(string).getName(), string2), string3);
        }
        catch (SftpException sftpException) {
            throw new RemoteExecutionException("File Transer from local to remote failed");
        }
        string7 = "cmd.exe /c " + string4 + File.separator + "CopyLocal2Remote.bat";
        SSHUtils.executeCommand(sSHConfigSpec, string7, System.err);
        File file = new File(string6 + "CopyLocal2Remote.bat");
        if (file.exists()) {
            file.deleteOnExit();
        }
        channelSftp.exit();
        session.disconnect();
    }

    public static void copyRemoteFileToLocalMachineWindows(SSHConfigSpec sSHConfigSpec, String string, String string2, PrintStream printStream) throws FileNotFoundException, IOException, JSchException, RemoteExecutionException {
        String string3 = "/";
        String string4 = "C:\\ftproot";
        String string5 = "";
        String string6 = System.getProperty("java.io.tmpdir");
        String string7 = "";
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.setPassword(sSHConfigSpec.getPassword());
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp channelSftp = (ChannelSftp)channel;
        string7 = "cmd.exe /c " + string4 + File.separator + "CopyFile.bat";
        try {
            channelSftp.put(SSHUtils.ab(string2, string4), string3);
            SSHUtils.executeCommand(sSHConfigSpec, string7, System.err);
            channelSftp.get(string3 + File.separator + new File(string2).getName(), string);
        }
        catch (SftpException sftpException) {
            throw new RemoteExecutionException("File Transer from Remote to Local Machine failed");
        }
        File file = new File(string6 + "CopyFile.bat");
        if (file.exists()) {
            file.deleteOnExit();
        }
        channelSftp.exit();
        session.disconnect();
    }

    private static String ab(String string, String string2) throws IOException {
        String string3 = System.getProperty("java.io.tmpdir");
        File file = new File(string3 + "CopyFile.bat");
        String string4 = "move " + string + " " + string2;
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                throw new IOException("cannot create the Batch file");
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(string4.getBytes());
        fileOutputStream.close();
        return file.getAbsolutePath();
    }

    public static int executeShellScriptWithStatus(SSHConfigSpec sSHConfigSpec, String string, String string2, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        return SSHUtils.executeShellScriptInSpecificShellWithStatus(sSHConfigSpec, string, string2, "sh", printStream);
    }

    public static int executeShellScriptInSpecificShellWithStatus(SSHConfigSpec sSHConfigSpec, String string, String string2, String string3, PrintStream printStream) throws IOException, JSchException, RemoteExecutionException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand("cd " + string2 + ";sh " + string);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            if (!channel.isClosed() && channel.getExitStatus() == 0) {
                System.out.println("Exit Status changed before Channel closure !");
            }
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        System.out.println("Exit status of JSCH channel: " + n);
        long l = 100000L;
        SSHUtils.waitForChannelClosure(channel, l);
        channel.disconnect();
        session.disconnect();
        return n;
    }

    public static void copyRemoteFileToLocalMachineWithPublicPrivateKeyAuthentication(String string, String string2, String string3, String string4, String string5) throws FileNotFoundException, IOException, JSchException {
        int n;
        String string6 = null;
        if (new File(string4).isDirectory()) {
            string6 = string4 + File.separator;
        }
        JSch jSch = new JSch();
        jSch.addIdentity(string3);
        Session session = jSch.getSession(string2, string, 22);
        Flexeraabg flexeraabg = new Flexeraabg(string, string2, string3);
        session.setUserInfo((UserInfo)flexeraabg);
        session.connect();
        String string7 = "scp -f " + string5;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string7);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        while ((n = SSHUtils.aa(inputStream)) == 67) {
            int n2;
            inputStream.read(byArray, 0, 5);
            long l = 0L;
            while (inputStream.read(byArray, 0, 1) >= 0 && byArray[0] != 32) {
                l = l * 10L + (long)(byArray[0] - 48);
            }
            String string8 = null;
            int n3 = 0;
            while (true) {
                inputStream.read(byArray, n3, 1);
                if (byArray[n3] == 10) break;
                ++n3;
            }
            string8 = new String(byArray, 0, n3);
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
            FileOutputStream fileOutputStream = new FileOutputStream(string6 == null ? string4 : string6 + string8);
            do {
                n2 = (long)byArray.length < l ? byArray.length : (int)l;
                if ((n2 = inputStream.read(byArray, 0, n2)) < 0) break;
                fileOutputStream.write(byArray, 0, n2);
            } while ((l -= (long)n2) != 0L);
            fileOutputStream.close();
            fileOutputStream = null;
            int n4 = SSHUtils.aa(inputStream);
            if (n4 != 0) {
                throw new JSchException("Acknowledgement not successful :" + n4);
            }
            byArray[0] = 0;
            outputStream.write(byArray, 0, 1);
            outputStream.flush();
        }
        channel.disconnect();
        session.disconnect();
    }

    public static void copyLocalFileToRemoteMachineWithPublicPrivateKeyAuthentication(String string, String string2, String string3, String string4, String string5) throws FileNotFoundException, IOException, JSchException {
        int n;
        if (string4 == null) {
            throw new FileNotFoundException("Cannot copy file to remote machine. Local File is null.");
        }
        if (!new File(string4).exists()) {
            throw new FileNotFoundException("Cannot copy file to remote machine. The specified local file does not exist. File specified=" + string4);
        }
        JSch jSch = new JSch();
        jSch.addIdentity(string3);
        Session session = jSch.getSession(string2, string, 22);
        Flexeraabg flexeraabg = new Flexeraabg(string, string2, string3);
        session.setUserInfo((UserInfo)flexeraabg);
        session.connect();
        boolean bl = false;
        String string6 = "scp " + (bl ? "-p" : "") + " -t " + string5;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string6);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        int n2 = SSHUtils.aa(inputStream);
        if (n2 != 0) {
            throw new JSchException("Acknowledgement not successful :" + n2);
        }
        File file = new File(string4);
        if (bl) {
            string6 = "T " + file.lastModified() / 1000L + " 0";
            string6 = string6 + " " + file.lastModified() / 1000L + " 0\n";
            outputStream.write(string6.getBytes());
            outputStream.flush();
            int n3 = SSHUtils.aa(inputStream);
            if (n3 != 0) {
                System.err.println("Could not print time stamp");
            }
        }
        long l = file.length();
        string6 = "C0644 " + l + " ";
        string6 = string4.lastIndexOf(47) > 0 ? string6 + string4.substring(string4.lastIndexOf(47) + 1) : string6 + string4;
        string6 = string6 + "\n";
        outputStream.write(string6.getBytes());
        outputStream.flush();
        int n4 = SSHUtils.aa(inputStream);
        if (n4 != 0) {
            throw new JSchException("Acknowledgement not successful :" + n4);
        }
        FileInputStream fileInputStream = new FileInputStream(string4);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileInputStream = null;
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        n = SSHUtils.aa(inputStream);
        if (n != 0) {
            throw new JSchException("Acknowledgement not successful :" + n);
        }
        outputStream.close();
        channel.disconnect();
        session.disconnect();
    }

    public static int executeShellScriptWithPublicPrivateKeyAuthentication(String string, String string2, String string3, String string4, String string5, PrintStream printStream, PrintStream printStream2) throws IOException, JSchException, RemoteExecutionException {
        return SSHUtils.executeShellScriptInSpecificShellWithPublicPrivateKeyAuthentication(string, string2, string3, string4, string5, "sh", printStream, printStream2);
    }

    public static int executeShellScriptInSpecificShellWithPublicPrivateKeyAuthentication(String string, String string2, String string3, String string4, String string5, String string6, PrintStream printStream, PrintStream printStream2) throws RemoteExecutionException, JSchException, IOException {
        int n = -1;
        JSch jSch = new JSch();
        jSch.addIdentity(string3);
        Session session = jSch.getSession(string2, string, 22);
        Flexeraabg flexeraabg = new Flexeraabg(string, string2, string3);
        session.setUserInfo((UserInfo)flexeraabg);
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand("cd " + string5 + ";sh " + string4);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)printStream2, true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("ShellScript " + string5 + "/" + string4 + " failed with Exit Status=" + n);
        }
        return n;
    }

    public static int executeCommandWithPublicPrivateKeyAuthentication(String string, String string2, String string3, String string4, PrintStream printStream, PrintStream printStream2) throws RemoteExecutionException, JSchException, IOException {
        int n = -1;
        JSch jSch = new JSch();
        jSch.addIdentity(string3);
        Session session = jSch.getSession(string2, string, 22);
        Flexeraabg flexeraabg = new Flexeraabg(string, string2, string3);
        session.setUserInfo((UserInfo)flexeraabg);
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string4);
        channel.setInputStream(null);
        ((ChannelExec)channel).setErrStream((OutputStream)printStream, true);
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream2.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        if (n != 0) {
            throw new RemoteExecutionException("Command " + string4 + " failed with Exit Status=" + n);
        }
        return n;
    }

    public static int executeSudoCommandWithStatus(SSHConfigSpec sSHConfigSpec, String string, String string2, PrintStream printStream) throws JSchException, IOException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand("sudo -S -p ' ' " + string);
        ((ChannelExec)channel).setPty(true);
        InputStream inputStream = channel.getInputStream();
        OutputStream outputStream = channel.getOutputStream();
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        channel.connect();
        outputStream.write((string2 + "\n").getBytes());
        outputStream.flush();
        byte[] byArray = new byte[1024];
        while (true) {
            int n2;
            if (inputStream.available() > 0 && (n2 = inputStream.read(byArray, 0, 1024)) >= 0) {
                printStream.print(new String(byArray, 0, n2));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        return n;
    }

    public static int executeSudoCommandWithStatus(SSHConfigSpec sSHConfigSpec, String string, String string2, StringBuilder stringBuilder) throws JSchException, IOException {
        int n = -1;
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand("sudo -S -p ' ' " + string);
        ((ChannelExec)channel).setPty(true);
        InputStream inputStream = channel.getInputStream();
        OutputStream outputStream = channel.getOutputStream();
        ((ChannelExec)channel).setErrStream((OutputStream)sSHConfigSpec.getStreamToWriteErrorsAndWarnings(), true);
        channel.connect();
        outputStream.write((string2 + "\n").getBytes());
        outputStream.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while (true) {
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                stringBuilder.append(string3 + "\n");
                string3 = bufferedReader.readLine();
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        n = channel.getExitStatus();
        channel.disconnect();
        session.disconnect();
        return n;
    }

    public static void copyLocalFileToRemoteMachineNoTimeStamp(SSHConfigSpec sSHConfigSpec, String string, String string2) throws FileNotFoundException, IOException, JSchException {
        int n;
        if (string == null) {
            throw new FileNotFoundException("Cannot copy file to remote machine. Local File is null.");
        }
        if (!new File(string).exists()) {
            throw new FileNotFoundException("Cannot copy file to remote machine. The specified local file does not exist. File specified=" + string);
        }
        JSch jSch = new JSch();
        Session session = jSch.getSession(sSHConfigSpec.getUserName(), sSHConfigSpec.getHostName(), sSHConfigSpec.getSshport());
        session.setUserInfo((UserInfo)new FlexUserInfo(sSHConfigSpec));
        session.connect();
        String string3 = "scp  -t " + string2;
        Channel channel = session.openChannel("exec");
        ((ChannelExec)channel).setCommand(string3);
        OutputStream outputStream = channel.getOutputStream();
        InputStream inputStream = channel.getInputStream();
        channel.connect();
        int n2 = SSHUtils.aa(inputStream);
        if (n2 != 0) {
            throw new JSchException("Acknowledgement not successful :" + n2);
        }
        File file = new File(string);
        long l = file.length();
        string3 = "C0644 " + l + " ";
        string3 = string.lastIndexOf(47) > 0 ? string3 + string.substring(string.lastIndexOf(47) + 1) : string3 + string;
        string3 = string3 + "\n";
        outputStream.write(string3.getBytes());
        outputStream.flush();
        int n3 = SSHUtils.aa(inputStream);
        if (n3 != 0) {
            throw new JSchException("Acknowledgement not successful :" + n3);
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileInputStream = null;
        byArray[0] = 0;
        outputStream.write(byArray, 0, 1);
        outputStream.flush();
        n = SSHUtils.aa(inputStream);
        if (n != 0) {
            throw new JSchException("Acknowledgement not successful :" + n);
        }
        outputStream.close();
        channel.disconnect();
        session.disconnect();
    }
}

