/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer;

import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.InstanceDefinition;
import com.zerog.ia.installer.util.Version;
import com.zerog.registry.FeatureDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;

public class InstanceDetector {
    private static InstanceDetector aa;
    private transient InstanceDefinition ab;

    private InstanceDetector() {
    }

    public static InstanceDetector getInstance() {
        if (aa == null) {
            aa = new InstanceDetector();
        }
        return aa;
    }

    public int getNumberOfInstancesAlreadyInstalledOnHost(Installer installer) {
        ArrayList arrayList = this.getAlreadyInstalledInstances(installer);
        if (arrayList == null) {
            return 0;
        }
        return arrayList.size();
    }

    public ArrayList getAlreadyInstalledInstances(Installer installer) {
        ArrayList<Flexeraapg> arrayList = new ArrayList<Flexeraapg>();
        boolean bl = this.aa();
        Flexeraauy.ai("Detecting Installed Instances ...");
        Flexeraapm flexeraapm = Flexeraapm.ai();
        if (Flexeraapm.ai().aj() == null) {
            flexeraapm.af(installer, true);
        }
        Enumeration enumeration = Flexeraapm.ai().ar();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Flexeraapg flexeraapg = (Flexeraapg)enumeration.nextElement();
            if (!flexeraapg.ab().toString().equals(installer.getInstallerInfoData().getProductID().toString())) continue;
            if (bl) {
                Version version;
                Version version2 = installer.getInstallerInfoData().getProductVersion();
                if (!this.shouldAddBasedOnVersion(this.ab, version2, version = new Version(flexeraapg.getVersion()))) continue;
                arrayList.add(flexeraapg);
                continue;
            }
            arrayList.add(flexeraapg);
        }
        return arrayList;
    }

    public boolean shouldAddBasedOnVersion(InstanceDefinition instanceDefinition, Version version, Version version2) {
        if (version.equalsTo(version2)) {
            return true;
        }
        if (instanceDefinition.getVersionPartIdentifiesInstance() == 20) {
            if (version.getMajor() > version2.getMajor()) {
                return true;
            }
            if (version.getMajor() == version2.getMajor() && version.greaterThanOrEqualTo(version2)) {
                return true;
            }
        } else if (instanceDefinition.getVersionPartIdentifiesInstance() == 21) {
            if (version.getMajor() > version2.getMajor()) {
                return true;
            }
            if (version.getMajor() == version2.getMajor()) {
                if (version.getMinor() > version2.getMinor()) {
                    return true;
                }
                if (version.getMinor() == version2.getMinor() && version.greaterThanOrEqualTo(version2)) {
                    return true;
                }
            }
        } else if (instanceDefinition.getVersionPartIdentifiesInstance() == 22) {
            if (version.getMajor() > version2.getMajor()) {
                return true;
            }
            if (version.getMajor() == version2.getMajor()) {
                if (version.getMinor() > version2.getMinor()) {
                    return true;
                }
                if (version.getMinor() == version2.getMinor()) {
                    if (version.getRevision() > version2.getRevision()) {
                        return true;
                    }
                    if (version.getRevision() == version2.getRevision() && version.greaterThanOrEqualTo(version2)) {
                        return true;
                    }
                }
            }
        } else if (version.greaterThanOrEqualTo(version2)) {
            return true;
        }
        return false;
    }

    public Vector getAlreadyInstalledInstanceNamesVector(Installer installer) {
        ArrayList arrayList = this.getAlreadyInstalledInstances(installer);
        Vector<String> vector = new Vector<String>();
        if (arrayList != null) {
            for (Flexeraapg flexeraapg : arrayList) {
                if (flexeraapg == null) continue;
                vector.add(flexeraapg.getInstallationPath());
            }
        }
        return vector;
    }

    public Flexeraapg getCorrespondingProductDescriptor(Installer installer, String string) {
        Flexeraapm flexeraapm = Flexeraapm.ai();
        if (Flexeraapm.ai().aj() == null) {
            flexeraapm.af(installer, true);
        }
        Enumeration enumeration = Flexeraapm.ai().ar();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Flexeraapg flexeraapg = (Flexeraapg)enumeration.nextElement();
            if (!flexeraapg.ab().toString().equals(installer.getInstallerInfoData().getProductID().toString()) || !flexeraapg.getInstallationPath().equals(string)) continue;
            return flexeraapg;
        }
        return null;
    }

    public String getUninstallerLocation(Installer installer, String string) {
        String string2 = null;
        Flexeraapg flexeraapg = this.getCorrespondingProductDescriptor(installer, string);
        if (flexeraapg != null) {
            Flexeraapj flexeraapj = Flexeraapm.ai().aj();
            Enumeration enumeration = flexeraapj.al(flexeraapg);
            while (enumeration != null && enumeration.hasMoreElements()) {
                FeatureDescriptor featureDescriptor = (FeatureDescriptor)enumeration.nextElement();
                Enumeration enumeration2 = flexeraapj.an(featureDescriptor);
                while (enumeration2 != null && enumeration2.hasMoreElements()) {
                    Flexeraapc flexeraapc = (Flexeraapc)enumeration2.nextElement();
                    if (flexeraapc == null || flexeraapc.getName() == null || !flexeraapc.getInstallationPath().endsWith(installer.getUninstaller().getDestinationName())) continue;
                    string2 = flexeraapc.getInstallationPath();
                }
            }
        }
        return string2;
    }

    public InstanceDefinition getIDefinition() {
        return this.ab;
    }

    public void setIDefinition(InstanceDefinition instanceDefinition) {
        this.ab = instanceDefinition;
    }

    private boolean aa() {
        return this.ab != null && this.ab.getInstanceDefinitionBy() == 11;
    }

    public boolean isThisOvertopInstallationBasedOnLocation(Installer installer, String string) {
        ArrayList arrayList = this.getAlreadyInstalledInstances(installer);
        if (arrayList == null || arrayList.size() <= 0) {
            return false;
        }
        for (Flexeraapg flexeraapg : arrayList) {
            if (!flexeraapg.getInstallationPath().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisOvertopInstallationBasedOnPhysicalLocation(Installer installer, String string) {
        ArrayList arrayList = this.getAlreadyInstalledInstances(installer);
        if (arrayList == null || arrayList.size() <= 0) {
            return false;
        }
        for (Flexeraapg flexeraapg : arrayList) {
            if (!flexeraapg.getInstallationPath().equals(string) || !new File(string).exists()) continue;
            return true;
        }
        return false;
    }

    public ArrayList getAlreadyInstalledInstancesBasedOnUpgradeCode(Installer installer) {
        ArrayList<Flexeraapg> arrayList = new ArrayList<Flexeraapg>();
        boolean bl = this.aa();
        Flexeraauy.ai("Detecting Installed Instances ...");
        Flexeraapm flexeraapm = Flexeraapm.ai();
        if (Flexeraapm.ai().aj() == null) {
            flexeraapm.af(installer, true);
        }
        Enumeration enumeration = Flexeraapm.ai().ar();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Flexeraapg flexeraapg = (Flexeraapg)enumeration.nextElement();
            if (!flexeraapg.aq().toString().equals(installer.getInstallerInfoData().getUpgradeCode().toString())) continue;
            arrayList.add(flexeraapg);
        }
        return arrayList;
    }
}

