/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.consoles;

import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.Uninstaller;
import com.zerog.ia.installer.installpanels.ProgressActionPanel;
import com.zerog.util.ZGSys;

public class UninstallRollbackConsoleUI {
    private int percentDone = 0;
    private int progressShown = 0;
    private float rollbackStarted = 0.0f;

    public void executeConsoleAction(Installer installer) {
        Uninstaller.getInstance().uninstall(installer);
    }

    public boolean setup() {
        this.addUninstallListener();
        return true;
    }

    private void addUninstallListener() {
        Uninstaller.getInstance().addUninstallListener(new Flexeraakm(){
            private int aa;

            public void categoryStarted(Flexeraakl flexeraakl) {
                this.aa = 0;
                UninstallRollbackConsoleUI.this.showUninstallCategoryStart();
            }

            public void categoryPercentDone(Flexeraakl flexeraakl) {
                UninstallRollbackConsoleUI.this.incrementPercentDone(flexeraakl.aa() - this.aa);
                if (flexeraakl.aa() > this.aa) {
                    this.aa = flexeraakl.aa();
                }
            }

            public void displayTextChanged(Flexeraakl flexeraakl) {
            }

            public void productUninstalled(Flexeraakl flexeraakl) {
                UninstallRollbackConsoleUI.this.showUninstallProgress();
            }

            public void exceptionOccurred(Flexeraakl flexeraakl) {
            }

            public void uninstallerExited(Flexeraakl flexeraakl) {
                ProgressActionPanel.getInstanceIfInstantiated().progressBar.setValue(0);
                UninstallRollbackConsoleUI.this.showUninstallProgressComplete();
            }
        });
    }

    private void incrementPercentDone(int n) {
        this.percentDone += n;
        while (this.percentDone > this.progressShown) {
            if (this.progressShown % 25 == 0) {
                ZGSys.aa.println("*");
            } else {
                ZGSys.aa.print("*");
            }
            ++this.progressShown;
        }
    }

    private void showUninstallProgressComplete() {
        ZGSys.aa.println(" -]");
    }

    private void showUninstallProgress() {
        ZGSys.aa.println("*");
    }

    private void showUninstallCategoryStart() {
        ZGSys.aa.println("");
        ZGSys.aa.println("...*");
    }

    private void showUninstallProgressStart() {
        ZGSys.aa.println("[- *");
    }
}

