/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.hosts;

import com.zerog.ia.designer.build.BuildSettings;
import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.hosts.JEEHostable;
import com.zerog.ia.installer.hosts.ServerHost;
import com.zerog.ia.installer.util.ClassInfoManager;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;

public class JEEHost
extends ServerHost {
    public static final String VISUALNAME = IAResourceBundle.getValue("JEEHost.visualName.self");
    public static final String GERONIMO_STRING = "Geronimo 1.1.1 or newer";
    public static final String WEBSPHERE_STRING = "WebSphere";
    public static final String JBOSS_STRING = "JBoss 4.0.5 or newer";
    public static final String WEBLOGIC_STRING = "WebLogic 10.0";
    public static final String TOMCAT_STRING = "Tomcat";
    public static final String SUNAPPSERVER_STRING = "Sun Application Server 9";
    public static final String RESIN_STRING = "Resin 3.1.x";
    public static final String GERONIMO_ID = "geronimo";
    public static final String WEBSPHERE_ID = "websphere";
    public static final String JBOSS_ID = "jboss";
    public static final String WEBLOGIC_ID = "weblogic";
    public static final String TOMCAT_ID = "tomcat";
    public static final String SUNAPPSERVER_ID = "sun";
    public static final String RESIN_ID = "resin";

    public JEEHost() {
        super(JEEHostable.class);
        this.ab = GERONIMO_ID;
    }

    public String getTopologyType() {
        return "JEEHost";
    }

    public String getVisualNameSelf() {
        String string = this.getServerType();
        StringBuffer stringBuffer = new StringBuffer(this.getServerDisplayName(string));
        if (TOMCAT_ID.equals(string)) {
            if (this.getServerName() != null) {
                if (!this.getServerName().trim().equals("")) {
                    stringBuffer.append(" (");
                    stringBuffer.append(this.getServerName());
                    stringBuffer.append(")");
                }
            }
        } else if (WEBSPHERE_ID.equals(string)) {
            if (this.getConnectionName() != null) {
                if (!this.getConnectionName().trim().equals("")) {
                    stringBuffer.append(" (");
                    stringBuffer.append(this.getConnectionName());
                    stringBuffer.append(")");
                }
            }
        } else if (this.getServerPath() != null) {
            if (!this.getServerPath().trim().equals("")) {
                stringBuffer.append(" (");
                stringBuffer.append(this.getServerPath());
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    public static boolean canBeDisplayed() {
        return true;
    }

    public IAStatus installSelf() throws Exception {
        return null;
    }

    public boolean isInInvalidState() {
        if (this.ab.equals(WEBSPHERE_ID)) {
            if (this.ak.trim().equals("") || !this.getLocalRemoteWebsphereDeploy() && !this.getSaveArchiveWebsphere()) {
                return true;
            }
            if (this.getLocalRemoteWebsphereDeploy()) {
                if (this.getWebsphereDependencyPath().trim().equals("")) {
                    return true;
                }
            }
        } else if (this.ab.equals(TOMCAT_ID)) {
            if (this.aj.trim().equals("") || !this.getLocalTomcatDeploy() && !this.getRemoteTomcatDeploy() && !this.getTomcatDoNotDeploy()) {
                return true;
            }
        } else if (this.aa.equals("")) {
            return true;
        }
        return this.checkForInvalidVM();
    }

    public boolean checkForInvalidVM() {
        BuildSettings buildSettings = (BuildSettings)this.getInstaller().getBuildSettings();
        if (this.ab.equals(WEBLOGIC_ID)) {
            return ZGUtil.checkForSpecificInvalidVM(buildSettings.getValidVMList(), "1.6");
        }
        return false;
    }

    public String getServerDisplayName(String string) {
        if (string.equals(GERONIMO_ID)) {
            return GERONIMO_STRING;
        }
        if (string.equals(JBOSS_ID)) {
            return JBOSS_STRING;
        }
        if (string.equals(WEBSPHERE_ID)) {
            return WEBSPHERE_STRING;
        }
        if (string.equals(WEBLOGIC_ID)) {
            return WEBLOGIC_STRING;
        }
        if (string.equals(TOMCAT_ID)) {
            return TOMCAT_STRING;
        }
        if (string.equals(SUNAPPSERVER_ID)) {
            return SUNAPPSERVER_STRING;
        }
        if (string.equals(RESIN_ID)) {
            return RESIN_STRING;
        }
        return string;
    }

    public String getServerTypeFromDisplayName(String string) {
        if (string.equals(GERONIMO_STRING)) {
            return GERONIMO_ID;
        }
        if (string.equals(JBOSS_STRING)) {
            return JBOSS_ID;
        }
        if (string.equals(WEBSPHERE_STRING)) {
            return WEBSPHERE_ID;
        }
        if (string.equals(WEBLOGIC_STRING)) {
            return WEBLOGIC_ID;
        }
        if (string.equals(TOMCAT_STRING)) {
            return TOMCAT_ID;
        }
        if (string.equals(SUNAPPSERVER_STRING)) {
            return SUNAPPSERVER_ID;
        }
        if (string.equals(RESIN_STRING)) {
            return RESIN_ID;
        }
        return this.ab;
    }

    static {
        ClassInfoManager.aa(JEEHost.class, VISUALNAME, "com/zerog/ia/designer/images/actions/JEEHost.png");
    }
}

