/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.iseries.service;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.data.ProgramCallDocument;
import com.zerog.ia.installer.iseries.service.i5OSProductInfoService;
import com.zerog.ia.installer.iseries.service.i5OSService;
import com.zerog.ia.installer.iseries.service.i5OSServiceFactory;

public class ProdInfoImpl
implements i5OSProductInfoService {
    private static final String CLASSNAME = "prodInfo";
    private final String ANY = "*ANY";
    private i5OSService i5;
    private String productID;
    private String productOption;
    private String minVRM = "*ANY";
    private String PTFID;
    private String VRM;
    private boolean installed;
    private String installedVRM;
    private String primLang;
    private String loadedState;
    private final String prodInfopcml = "com.zerog.ia.installer.iseries.util.prodInfo";
    private String ptfInfopclm = "com.zerog.ia.installer.iseries.util.pzrtv";
    private String logInfopcml = "com.zerog.ia.installer.iseries.util.pzlog";
    private String genInfopcml = "com.zerog.ia.installer.iseries.util.pzgen";
    private ProgramCallDocument prodpcmlDoc;
    private ProgramCallDocument ptfpcmlDoc;
    private ProgramCallDocument logpcmlDoc;
    private ProgramCallDocument genpcmlDoc;
    private String Loaded_Status;
    private String Savf_Status;
    private String Superseding_PTF;
    private String IPL_Act;
    private boolean InfoAvailable;
    private String Pending_Act;
    private String Library;
    private String File;
    private boolean Logged;

    private i5OSService getI5Service() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.i5 == null) {
            this.i5 = i5OSServiceFactory.newInstance();
        }
        return this.i5;
    }

    public void setI5Service(i5OSService i5OSService2) {
        this.i5 = i5OSService2;
    }

    public boolean retrieveGenInfo() {
        try {
            this.InfoAvailable = this.makePZGennmCall();
            if (this.InfoAvailable) {
                // empty if block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean retrievePTFInfo() {
        try {
            this.InfoAvailable = this.makePZRTVCall();
            if (this.InfoAvailable) {
                // empty if block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean retrieveProdInfo() {
        String string = "retrieveProdInfo";
        try {
            this.installed = this.makeSZCall();
            return this.installed;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void debugMsg(String string) {
        System.out.println("debug: " + string);
    }

    private boolean makePZLOGCall() throws Exception {
        boolean bl = false;
        try {
            AS400 aS400 = this.getI5Service().geti5();
            this.logpcmlDoc = new ProgramCallDocument(aS400, this.logInfopcml);
            this.logpcmlDoc.setValue("pzlog.PTFInformation.PID", (Object)this.productID);
            this.logpcmlDoc.setValue("pzlog.PTFInformation.PTF_ID", (Object)this.PTFID);
            this.logpcmlDoc.setValue("pzlog.PTFInformation.Rls", (Object)this.VRM);
            this.logpcmlDoc.setValue("pzlog.QaulName.filename", (Object)this.File);
            this.logpcmlDoc.setValue("pzlog.QaulName.libname", (Object)this.Library);
            this.logpcmlDoc.setValue("pzlog.MemberName", (Object)"          ");
            if (this.logpcmlDoc.callProgram("pzlog")) {
                bl = true;
            } else {
                AS400Message[] aS400MessageArray = this.logpcmlDoc.getMessageList("pzlog");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    String string = aS400MessageArray[i].getID();
                    if (string.equals("CPF0C1F")) continue;
                    System.out.println(string + " - " + aS400MessageArray[i].getText());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception on pzlog " + exception.getLocalizedMessage());
            exception.printStackTrace();
            throw exception;
        }
        return bl;
    }

    private boolean makePZRTVCall() throws Exception {
        boolean bl = false;
        try {
            AS400 aS400 = this.getI5Service().geti5();
            this.ptfpcmlDoc = new ProgramCallDocument(aS400, this.ptfInfopclm);
            this.ptfpcmlDoc.setIntValue("pzrtv.lengthofreceiver", this.ptfpcmlDoc.getOutputsize("pzrtv.returnedInfo"));
            this.ptfpcmlDoc.setValue("pzrtv.PTFinfo.PID", (Object)this.productID);
            this.ptfpcmlDoc.setValue("pzrtv.PTFinfo.PTF_ID", (Object)this.PTFID);
            this.ptfpcmlDoc.setValue("pzrtv.PTFinfo.RLS_LVL", (Object)this.VRM);
            this.ptfpcmlDoc.setIntValue("pzrtv.PTFinfo.CCSID", 65535);
            this.ptfpcmlDoc.setValue("pzrtv.PTFinfo.Close_Files", (Object)"0");
            if (this.ptfpcmlDoc.callProgram("pzrtv")) {
                this.Loaded_Status = (String)this.ptfpcmlDoc.getValue("pzrtv.returnedInfo.Loaded_Sts");
                this.Savf_Status = (String)this.ptfpcmlDoc.getValue("pzrtv.returnedInfo.Savf_Sts");
                this.Superseding_PTF = (String)this.ptfpcmlDoc.getValue("pzrtv.returnedInfo.Superseding_PTF");
                this.IPL_Act = (String)this.ptfpcmlDoc.getValue("pzrtv.returnedInfo.IPL_Act");
                this.Pending_Act = (String)this.ptfpcmlDoc.getValue("pzrtv.returnedInfo.Act_Pnd");
                bl = true;
            } else {
                AS400Message[] aS400MessageArray = this.ptfpcmlDoc.getMessageList("pzrtv");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    String string = aS400MessageArray[i].getID();
                    if (string.equals("CPF0C1F")) continue;
                    System.out.println(string + " - " + aS400MessageArray[i].getText());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return bl;
    }

    private boolean makePZGennmCall() throws Exception {
        boolean bl = false;
        try {
            AS400 aS400 = this.getI5Service().geti5();
            this.genpcmlDoc = new ProgramCallDocument(aS400, this.genInfopcml);
            this.genpcmlDoc.setIntValue("pzgen.LengthofReceiver", this.genpcmlDoc.getOutputsize("pzgen.ReturnInfo"));
            this.genpcmlDoc.setValue("pzgen.PTFInformation.PID", (Object)this.productID);
            this.genpcmlDoc.setValue("pzgen.PTFInformation.PTF_ID", (Object)this.PTFID);
            this.genpcmlDoc.setValue("pzgen.PTFInformation.Rls", (Object)this.VRM);
            this.genpcmlDoc.setValue("pzgen.PTFInformation.NLV", (Object)"    ");
            if (this.genpcmlDoc.callProgram("pzgen")) {
                this.File = (String)this.genpcmlDoc.getValue("pzgen.ReturnInfo.Fil_Nam");
                this.Library = (String)this.genpcmlDoc.getValue("pzgen.ReturnInfo.Lib_Nam");
                System.out.println("in GenPTFmn :: makePZGennmCall : " + this.File + " File " + this.Library + " Library");
                bl = true;
            } else {
                AS400Message[] aS400MessageArray = this.genpcmlDoc.getMessageList("pzgen");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    String string = aS400MessageArray[i].getID();
                    if (string.equals("CPF0C1F")) continue;
                    System.out.println(string + " - " + aS400MessageArray[i].getText());
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception on pzlog " + exception.getLocalizedMessage());
            exception.printStackTrace();
            throw exception;
        }
        return bl;
    }

    private boolean makeSZCall() throws Exception {
        String string = "makeSZCall";
        boolean bl = false;
        try {
            this.prodpcmlDoc = new ProgramCallDocument(this.getI5Service().geti5(), "com.zerog.ia.installer.iseries.util.prodInfo");
            this.prodpcmlDoc.setIntValue("szprdinf.lengthOfParm1", this.prodpcmlDoc.getOutputsize("szprdinf.returnedInfo"));
            this.prodpcmlDoc.setValue("szprdinf.product.productID", (Object)this.productID);
            this.prodpcmlDoc.setValue("szprdinf.product.vrm", (Object)"*ONLY");
            if (this.productOption.compareTo("*BASE") == 0) {
                this.prodpcmlDoc.setValue("szprdinf.product.option", (Object)"0000");
            } else if (!this.productOption.startsWith("00")) {
                if (this.productOption.length() < 2) {
                    this.prodpcmlDoc.setValue("szprdinf.product.option", (Object)("000" + this.productOption));
                } else {
                    this.prodpcmlDoc.setValue("szprdinf.product.option", (Object)("00" + this.productOption));
                }
            } else {
                this.prodpcmlDoc.setValue("szprdinf.product.option", (Object)this.productOption);
            }
            if (this.prodpcmlDoc.callProgram("szprdinf")) {
                this.installedVRM = (String)this.prodpcmlDoc.getValue("szprdinf.returnedInfo.vrm");
                this.primLang = (String)this.prodpcmlDoc.getValue("szprdinf.returnedInfo.primLang");
                this.loadedState = (String)this.prodpcmlDoc.getValue("szprdinf.returnedInfo.loadState");
                ProdInfoImpl.debugMsg(" in makeSZCall of prodInfo :: installedVRM : " + this.installedVRM);
                ProdInfoImpl.debugMsg(" in makeSZCall of prodInfo :: primLang : " + this.primLang);
                ProdInfoImpl.debugMsg(" in makeSZCall of prodInfo :: loadedState : " + this.loadedState);
                if (this.loadedState.equals("90")) {
                    bl = true;
                }
            } else {
                AS400Message[] aS400MessageArray = this.prodpcmlDoc.getMessageList("szprdinf");
                for (int i = 0; i < aS400MessageArray.length; ++i) {
                    ProdInfoImpl.debugMsg(" in makeSZCall of prodInfo: msgText" + aS400MessageArray[i].getText());
                    String string2 = aS400MessageArray[i].getID();
                    if (string2.equals("CPF0C1F")) continue;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        return bl;
    }

    public void setProductID(String string) {
        this.productID = string.toUpperCase();
    }

    public void setFileName(String string) {
        this.File = string.toUpperCase();
    }

    public void setProductOption(String string) {
        String string2 = string.toUpperCase();
        if (string2.equals("*BASE")) {
            this.productOption = "*BASE";
            return;
        }
        if (string.length() == 4) {
            int n = string.lastIndexOf(0);
            this.productOption = n != 4 ? string.substring(n + 1, 4) : string.substring(3, 4);
            return;
        }
        this.productOption = string;
    }

    public boolean CanbeApplied() {
        if (this.InfoAvailable) {
            if (this.Loaded_Status != null) {
                if (this.Loaded_Status.equals("1")) {
                    if (this.IPL_Act.equals("0")) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public boolean CanbeRemoved() {
        if (this.InfoAvailable) {
            if (this.Loaded_Status.equals("1") | this.Loaded_Status.equals("2")) {
                if (this.IPL_Act.equals("0")) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String getRelease() {
        return this.VRM;
    }

    public boolean isLoaded() {
        boolean bl = false;
        if (this.InfoAvailable) {
            if (this.Loaded_Status.equals("0") | this.Loaded_Status.equals("4") | this.Loaded_Status.equals("5")) {
                bl = false;
            } else if (this.Loaded_Status.equals("6")) {
                this.setPTFID(this.Superseding_PTF);
                this.setProductID(this.productID);
                this.setRelease(this.VRM);
                if (this.isLoaded()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public boolean SavfExists() {
        if (this.InfoAvailable) {
            return !this.Savf_Status.equals("0");
        }
        return false;
    }

    public void setPTFID(String string) {
        this.PTFID = string.toUpperCase();
    }

    public void setLibName(String string) {
        this.Library = string.toUpperCase();
    }

    public boolean LogPTF() {
        try {
            this.Logged = this.makePZLOGCall();
            if (this.Logged) {
                // empty if block
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getPTFID() {
        return this.PTFID;
    }

    public void setRelease(String string) {
        this.VRM = string.toUpperCase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTempPermApplied() {
        boolean bl;
        block5: {
            block4: {
                bl = false;
                if (!this.InfoAvailable) return bl;
                if (this.Loaded_Status.equals("2")) break block4;
                if (!this.Loaded_Status.equals("3")) break block5;
            }
            if (this.Pending_Act.equals("0")) {
                return true;
            }
        }
        if (!this.Loaded_Status.equals("6")) return bl;
        this.setPTFID(this.Superseding_PTF);
        this.setProductID(this.productID);
        this.setRelease(this.VRM);
        this.retrievePTFInfo();
        if (!this.isTempPermApplied()) return bl;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPermApplied() {
        boolean bl = false;
        if (!this.InfoAvailable) return bl;
        if (this.Loaded_Status.equals("3")) {
            if (this.Pending_Act.equals("0")) {
                return true;
            }
        }
        if (!this.Loaded_Status.equals("6")) return bl;
        this.setPTFID(this.Superseding_PTF);
        this.setProductID(this.productID);
        this.setRelease(this.VRM);
        this.retrievePTFInfo();
        if (!this.isPermApplied()) return bl;
        return true;
    }

    public String SupersedingPTF() {
        if (this.InfoAvailable) {
            return this.Superseding_PTF;
        }
        return "       ";
    }

    public void setMinVRM(String string) {
        this.minVRM = string.toUpperCase();
    }

    public String getProductID() {
        return this.productID;
    }

    public String getProductOption() {
        return this.productOption;
    }

    public String getMinVRM() {
        return this.minVRM;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public String getInstalledVRM() {
        return this.installedVRM;
    }

    public String getFileName() {
        return this.File;
    }

    public String getLibName() {
        return this.Library;
    }

    public String getPrimLang() {
        return this.primLang;
    }
}

