/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.iseries.service;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.MessageQueue;
import com.zerog.ia.api.pub.InstallException;
import com.zerog.ia.api.pub.InstallerProxy;
import com.zerog.ia.installer.IAStatus;
import com.zerog.ia.installer.IAStatusLog;
import com.zerog.ia.installer.hosts.OSHostable;
import com.zerog.ia.installer.iseries.service.i5OSActionService;
import com.zerog.ia.installer.iseries.service.i5OSService;
import com.zerog.ia.installer.iseries.service.i5OSServiceFactory;
import com.zerog.ia.installer.resources.ResourceAction;
import com.zerog.ia.installer.uninstall.UninstallService;
import com.zerog.ia.installer.util.DependenciesPropertyData;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.util.ZGUtil;
import com.zerog.util.zip.ZipCreator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;

public class i5OSActionServiceImpl
extends ResourceAction
implements UninstallService,
i5OSActionService,
OSHostable {
    public static final String OS400_INSTALL_DIR_VARIABLE = "$OS400_INSTALL_DIR$";
    public UninstallService uninstallService;
    public transient i5OSService i5;
    public static final String OS400_UNINSTALL_FILE = "i5OSFile";
    public static final String OS400_UNINSTALL_DIRECTORY = "i5OSDirectory";
    public static String FILE_SIZE_FIELD = "fileSize";
    private static final int lineSize = 134;
    private String[] objectList;
    private String subtree = "*ALL";
    private static final String IAIFS = "/IAIFSList";
    public static VariableFacade variables = VariableFacade.getInstance();
    private static final String copyright = "(C) Copyright IBM Corporation 2007.";
    private int ccsid;
    private int estimatedTimeToInstall;
    public static final String IA_OVERRIDE_PANEL = "IA_OS400_OVERRIDE_LIBS";
    public static final String IA_DEFAULT_PANEL = "IA_OS400_DEFAULT_LIBS";
    private static String middleName = null;
    private String productName = null;
    private static String productURL = "/product.xml";
    private static final int NOT_ATTEMPTED = 0;
    public static final int RAIR_ADD = 1;
    public static final int RAIR_REMOVE = 2;
    private static transient boolean RAIRAvailable;
    public int requiredBytes;
    public Vector appsToList = new Vector();
    public Vector appsToRegister = new Vector();
    public Vector appsToUnregister = new Vector();
    private String ccsid_ = "37";
    public String CCSID_ATTR = "CCSID=";
    public String COMP_ATTR = "ComponentName=";
    public String FEATURE_ATTR = "FeatureName=";
    public String INST_ATTR = "Instance=";
    public String INSTALLER_ATTR = "InstallerType=";
    private String installerType_ = "InstallAnywhere (9.0)";
    public String PACKAGED_ATTR = "PackagedProduct=";
    public String PRODUCT_ATTR = "ProductName=";
    public String RELEASE_ATTR = "ComponentVersion=";
    public String VENDOR_ATTR = "ComponentVendor=";
    private int flushFactor;
    private int copyFactor;
    private int restoreFactor;
    public static String TEMPFILENAMEQSYSFORMAT;
    public static String TEMPFILENAMEIFSFORMAT;
    private static final String ARCHIVE_VAR_NAME = "$ArchiveName$";
    public static String IA_SIGN_ON;
    public String[] moreSaveParms;
    public String[] moreRestoreParms;
    public boolean useTempFile;
    private int resourceIndex;
    private static final boolean DEBUG_REG;
    private static String IATempPath;
    private boolean pathChecked = false;
    private String presetUninstallerInstallLocation;
    private String tempUninstallerFolder;
    private static final Vector requiredDependencies;
    private static final String HSQL_LIB = "hsqldb.jar";
    private static final String CLOUDSCAPE_LIB = "derby.jar";
    private static transient Vector v;
    private IFSFile ifsTempFile = null;
    public final String NOTSET = "$$unspecified$$";
    private static final boolean NOISY;
    private Vector deployedDirsVect = new Vector();
    private long fileSize;
    public static Comparator reverseOrderComparator;
    private static Vector i5OSIFSDirDeleteBackLog;

    private i5OSService getI5Service() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.i5 == null) {
            this.i5 = i5OSServiceFactory.newInstance();
        }
        return this.i5;
    }

    private void findFiles(AS400 aS400, String string, String string2, String string3) throws IOException {
        try {
            IFSFile iFSFile;
            String[] stringArray;
            if (string != null) {
                if (!string.startsWith("/")) {
                    string = "/" + string;
                }
            }
            if (string2 != null) {
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
            }
            if ((stringArray = (iFSFile = new IFSFile(aS400, string2)).list()) == null) {
                // empty if block
            }
            for (int i = 0; i < stringArray.length; ++i) {
                IFSFile iFSFile2 = new IFSFile(aS400, iFSFile.getAbsolutePath() + "/" + stringArray[i]);
                i5OSActionServiceImpl.debugMsg("in i5OSIFSBuilder :: findfiles : thisFile = " + iFSFile2.getAbsolutePath());
                if (iFSFile2.isFile()) {
                    String string4 = iFSFile2.getAbsolutePath();
                    v.addElement(string4.substring(string.length()));
                }
                if (!iFSFile2.isDirectory()) continue;
                if (!string3.equals("*ALL")) continue;
                this.findFiles(aS400, string, iFSFile2.getAbsolutePath(), string3);
            }
            if (!string2.equals(string)) {
                String string5 = iFSFile.getAbsolutePath();
                v.addElement(string5.substring(string.length()));
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public i5OSActionServiceImpl() {
        try {
            this.i5 = this.getI5Service();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ccsid = 37;
        this.moreRestoreParms = null;
        this.useTempFile = true;
    }

    public i5OSActionServiceImpl(i5OSService i5OSService2) {
        this.i5 = i5OSService2;
        this.ccsid = 37;
        this.moreRestoreParms = null;
        this.useTempFile = true;
    }

    public static boolean canBeDisplayed() {
        return false;
    }

    public String[] generateRestoreCommand() {
        return new String[0];
    }

    public String[] generateDeleteCommand() {
        return new String[0];
    }

    public String toString() {
        return "";
    }

    public int getPositionofSaveCmd() {
        return 1;
    }

    public void setResourceIndex(int n) {
        this.resourceIndex = n;
    }

    public int getResourceIndex() {
        return this.resourceIndex;
    }

    public static void debugMsg(String string) {
        Flexeraauy.ag("debug: " + string);
    }

    public IAStatus install(InstallerProxy installerProxy) throws Exception {
        IAStatus iAStatus = new IAStatus(this, 95);
        i5OSActionServiceImpl.debugMsg("Entering Install in ProductAbstract");
        try {
            iAStatus.mergeStatus(this.performRestore(installerProxy));
            if (iAStatus.getSuccessLevel() != 97 || iAStatus.getSuccessLevel() != 96) {
                this.postInstall();
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                if (this.isAddResourceSelf()) {
                    super.installSelf();
                }
            }
        }
        catch (InstallException installException) {
            iAStatus = new IAStatus(this, 97);
        }
        return iAStatus;
    }

    public void postInstall() {
    }

    public boolean isAddResourceSelf() {
        return true;
    }

    public InputStream getResourceInputStream() throws IOException {
        return null;
    }

    public String getArchivedResourceName() {
        return "";
    }

    public IAStatus performRestore(InstallerProxy installerProxy) throws InstallException {
        IAStatus iAStatus;
        block12: {
            i5OSActionServiceImpl.debugMsg("Entering performRestore");
            iAStatus = new IAStatus(this, 95);
            try {
                String[] stringArray;
                String[] stringArray2;
                int n = this.flushFactor + this.copyFactor + this.restoreFactor;
                if (n == 0) {
                    n = 1;
                }
                this.deleteTempfile();
                InputStream inputStream = this.getResourceInputStream();
                String string = this.getifsTempFile().getAbsolutePath();
                i5OSActionServiceImpl.debugMsg("ifsTempFileName is : " + string);
                int n2 = 1024;
                byte[] byArray = new byte[n2];
                if (this.getI5Service().isInstallRemote()) {
                    stringArray2 = this.getTempDirectory(installerProxy).toString();
                    stringArray = this.getArchivedResourceName();
                    this.extractLibrary(inputStream, (String)stringArray2, (String)stringArray);
                    this.getI5Service().moveModule2Host(this.getI5Service().geti5(), new File((String)stringArray2, (String)stringArray), this.ifsTempFile.toString(), false);
                } else {
                    stringArray2 = new IFSFileOutputStream(this.ifsTempFile, -4, false, this.ccsid);
                    int n3 = inputStream.read(byArray);
                    while (n3 > 0) {
                        stringArray2.write(byArray, 0, n3);
                        n3 = inputStream.read(byArray);
                    }
                    stringArray2.close();
                }
                inputStream.close();
                stringArray2 = this.generateRestoreCommand();
                stringArray = new String[2 + stringArray2.length];
                stringArray[0] = "CPYFRMSTMF FROMSTMF('" + string + "') TOMBR('" + TEMPFILENAMEIFSFORMAT + "')";
                int n4 = 1;
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[n4] = stringArray2[i];
                    ++n4;
                }
                stringArray[n4] = "DLTF FILE(" + TEMPFILENAMEQSYSFORMAT + ")";
                String[] stringArray3 = this.getMoreRestoreParms();
                for (int i = 0; i < stringArray3.length; ++i) {
                    stringArray[1] = stringArray[1] + " " + stringArray3[i];
                }
                StringBuffer stringBuffer = new StringBuffer(System.getProperty("line.separator"));
                for (int i = 0; i < stringArray.length; ++i) {
                    i5OSActionServiceImpl.debugMsg(stringArray[i]);
                    stringBuffer.append(Flexeraavc.af("", 26) + "CL:" + stringArray[i] + System.getProperty("line.separator"));
                    AS400Message[] aS400MessageArray = this.getI5Service().runCLCommand(stringArray[i]);
                    if (i == 0) {
                        installerProxy.setProgressPercentage(this.copyFactor);
                    }
                    if (i == 1) {
                        installerProxy.setProgressPercentage(this.restoreFactor);
                    }
                    boolean bl = this.handleMessages(aS400MessageArray);
                    for (int j = 0; j < aS400MessageArray.length; ++j) {
                        stringBuffer.append(Flexeraavc.af("", 26) + aS400MessageArray[j].getID() + " - " + aS400MessageArray[j].getText() + System.getProperty("line.separator"));
                    }
                    if (bl) continue;
                    iAStatus.appendStatus(stringBuffer.toString(), 97);
                    if (i >= aS400MessageArray.length - 1) continue;
                    i = aS400MessageArray.length - 1;
                }
                this.ifsTempFile.delete();
            }
            catch (Exception exception) {
                i5OSActionServiceImpl.debugMsg(exception.getLocalizedMessage());
                this.deleteTempfile();
                if (!(exception instanceof InstallException)) break block12;
                throw (InstallException)exception;
            }
        }
        return iAStatus;
    }

    public File getTempDirectory(InstallerProxy installerProxy) throws IOException {
        return installerProxy.getTempDirectory();
    }

    public IFSFile getifsTempFile() {
        return this.ifsTempFile;
    }

    public void setifsTempFile(String string) {
        if (string == null) {
            try {
                this.ifsTempFile = this.getI5Service().createIFSTempFile();
            }
            catch (Exception exception) {
                i5OSActionServiceImpl.debugMsg(exception.getLocalizedMessage());
            }
        } else {
            try {
                this.ifsTempFile = new IFSFile(this.getI5Service().geti5(), this.i5.getIATempPath() + "/" + string);
                this.ifsTempFile.createNewFile();
            }
            catch (Exception exception) {
                i5OSActionServiceImpl.debugMsg(exception.getLocalizedMessage());
            }
        }
    }

    private void extractLibrary(InputStream inputStream, String string, String string2) throws IOException {
        File file = new File(string, string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        i5OSActionServiceImpl.debugMsg("Remote install - temporary outputfile: " + file.getAbsolutePath());
        boolean bl = false;
        int n = inputStream.read(byArray);
        while (n > 0) {
            fileOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        inputStream.close();
        fileOutputStream.close();
    }

    private boolean handleMessages(AS400Message[] aS400MessageArray) {
        String[] stringArray = new String[5];
        stringArray[0] = "CPD377B";
        stringArray[1] = "CPF3848";
        stringArray[2] = "CPF3773";
        stringArray[3] = "CPF2110";
        stringArray[4] = "CPF383E";
        String[] stringArray2 = stringArray;
        for (int i = 0; i < aS400MessageArray.length; ++i) {
            String string = aS400MessageArray[i].getID();
            String string2 = aS400MessageArray[i].getText();
            int n = aS400MessageArray[i].getType();
            String string3 = string + " " + string2;
            if (n == 1 || n == 4) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string.equals(stringArray2[j])) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private void deleteTempfile() {
        try {
            this.getI5Service().runCLCommand("DLTF " + TEMPFILENAMEQSYSFORMAT);
        }
        catch (Exception exception) {
            i5OSActionServiceImpl.debugMsg(exception.getLocalizedMessage());
        }
    }

    public String[] getNamesfromToken(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public long getEstimatedTimeToInstall(InstallerProxy installerProxy) {
        return this.estimatedTimeToInstall;
    }

    public void setMoreSaveParms(String[] stringArray) {
        if (stringArray == null) {
            this.moreSaveParms = new String[0];
        } else {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            this.moreSaveParms = stringArray2;
        }
    }

    public String[] getMoreSaveParms() {
        if (this.moreSaveParms == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.moreSaveParms.length];
        System.arraycopy(this.moreSaveParms, 0, stringArray, 0, this.moreSaveParms.length);
        return stringArray;
    }

    public void setMoreRestoreParms(String[] stringArray) {
        this.moreRestoreParms = stringArray == null ? new String[0] : stringArray;
    }

    public String[] getMoreRestoreParms() {
        if (this.moreRestoreParms == null) {
            this.moreRestoreParms = this.getDefaultRestoreParms();
        }
        return this.moreRestoreParms;
    }

    public String[] getDefaultRestoreParms() {
        return new String[0];
    }

    public boolean validateProperties(InstallerProxy installerProxy) {
        return true;
    }

    public int getUninstallSequenceNum() {
        return 1630;
    }

    public String getUninstallDisplayName(String string) {
        return null;
    }

    public String getSubtree() {
        return this.subtree;
    }

    public void setSubtree(String string) {
        this.subtree = string;
    }

    public String[] uninstall(String string) {
        IAStatus iAStatus;
        block13: {
            System.out.println("in uninstall : data " + string);
            iAStatus = new IAStatus((Object)this, 26 + string, 95);
            iAStatus.setActionDescription(Flexeraavc.af(iAStatus.getActionName() + ":", 26) + string.substring(string.indexOf("|") + 1).trim());
            if (string.indexOf(OS400_UNINSTALL_FILE) >= 0) {
                String string2 = string.substring(string.indexOf(OS400_UNINSTALL_FILE));
                String string3 = string2.substring(string2.indexOf("|") + 1).trim();
                try {
                    IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string3);
                    iFSFile.delete();
                    this.deletei5OSIFSDirDeleteBackLog();
                }
                catch (Exception exception) {
                    iAStatus.appendStatus(97);
                }
            } else if (string.indexOf(OS400_UNINSTALL_DIRECTORY) >= 0) {
                String string4 = string.substring(string.indexOf(OS400_UNINSTALL_DIRECTORY));
                String string5 = string4.substring(string4.indexOf("|") + 1).trim();
                try {
                    IFSFile iFSFile = new IFSFile(this.getI5Service().geti5(), string5);
                    iFSFile.delete();
                    if (iFSFile.exists()) {
                        this.addi5OSIFSDirDeleteBackLog(iFSFile);
                        break block13;
                    }
                    this.deletei5OSIFSDirDeleteBackLog();
                }
                catch (Exception exception) {
                    iAStatus.appendStatus(97);
                }
            } else {
                i5OSActionServiceImpl.debugMsg(" uninstall  :  data " + string);
                String[] stringArray = this.generateDeleteFromUninstallData(string);
                if (stringArray == null) {
                    return null;
                }
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.handleMessages(this.getI5Service().runCLCommand(stringArray[i]));
                    }
                }
                catch (Exception exception) {
                    System.out.println(exception.getLocalizedMessage());
                    iAStatus.appendStatus(97);
                }
            }
        }
        IAStatusLog.getInstance().addStatus(iAStatus);
        return null;
    }

    private void addi5OSIFSDirDeleteBackLog(IFSFile iFSFile) {
        i5OSIFSDirDeleteBackLog.add(iFSFile);
    }

    private void deletei5OSIFSDirDeleteBackLog() {
        for (IFSFile iFSFile : i5OSIFSDirDeleteBackLog) {
            try {
                iFSFile.delete();
                if (iFSFile.exists()) continue;
                i5OSIFSDirDeleteBackLog.remove(iFSFile);
            }
            catch (IOException iOException) {}
        }
    }

    public String[] generateDeleteFromUninstallData(String string) {
        block3: {
            block2: {
                if (string == null) break block2;
                if (!string.trim().equals("")) break block3;
            }
            return new String[0];
        }
        return Flexeraavc.ab(string, "|");
    }

    public long getEstimatedTimeToUninstall(String string) {
        return 0L;
    }

    public int getUninstallSortType() {
        return 0;
    }

    public Flexeraau7 createSortComparisonObject() {
        return null;
    }

    public String getUninstallFilePath(String string) {
        return null;
    }

    public IAStatus installResource() {
        return null;
    }

    public String getResourceName() {
        return "";
    }

    public String getResourceType() {
        return "iseries";
    }

    public String getResourcePath() {
        return "";
    }

    public String getResourceArguments() {
        String string = Flexeraavc.aa(this.generateDeleteCommand(), "|");
        return string;
    }

    public String generateName(int n) {
        int n2;
        Object object;
        if (n == 999) {
            n = 0;
            middleName = null;
        }
        if (middleName == null) {
            object = new Integer((int)(Math.random() * 10000.0));
            middleName = ((Integer)object).toString();
            n2 = 4;
            while (n2 > middleName.length()) {
                middleName = "0" + middleName;
            }
        }
        object = new Integer(n + 1).toString();
        object = ((String)object).trim();
        n2 = 3;
        while (n2 > ((String)object).length()) {
            object = "0" + (String)object;
        }
        return "Q" + middleName + (String)object;
    }

    public void logToQHST(String string) {
        try {
            MessageQueue messageQueue = new MessageQueue(this.getI5Service().geti5(), "/QSYS.LIB/QHST.MSGQ");
            messageQueue.sendInformational(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPropertiesResourceName() {
        return "i5OS.properties";
    }

    public void zipCustomCodeSelf(ZipCreator zipCreator) {
        Vector<DependenciesPropertyData> vector = new Vector<DependenciesPropertyData>(16);
        vector.add(new DependenciesPropertyData("jt400Small.jar", ZGUtil.getResourceDirectory() + File.separator + "ibm" + File.separator + "os400"));
        Flexeraal2.ac(zipCreator, this, vector);
    }

    private String replaceXMLEntities(String string) {
        String string2;
        block8: {
            string2 = "";
            try {
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) == '&') {
                        string2 = string2 + "&amp;";
                        continue;
                    }
                    if (string.charAt(i) == '<') {
                        string2 = string2 + "&lt;";
                        continue;
                    }
                    if (string.charAt(i) == '>') {
                        string2 = string2 + "&gt;";
                        continue;
                    }
                    if (string.charAt(i) == '\"') {
                        string2 = string2 + "&quot;";
                        continue;
                    }
                    if (string.charAt(i) == '\'') {
                        string2 = string2 + "&apos;";
                        continue;
                    }
                    string2 = string2 + string.charAt(i);
                }
            }
            catch (Exception exception) {
                if (!NOISY) break block8;
                System.out.println("An exception occurred parsing the string for XML.");
                System.out.println(System.err);
            }
        }
        return string2;
    }

    public void mkdirs(IFSFile iFSFile) throws IOException {
        IFSFile iFSFile2 = new IFSFile(iFSFile.getSystem(), iFSFile.getParent());
        if (!iFSFile2.exists()) {
            this.mkdirs(iFSFile2);
        }
        iFSFile.mkdir();
        this.addDeployedDir(iFSFile.toString());
    }

    public void addDeployedDir(String string) {
        this.deployedDirsVect.add(string);
    }

    public Vector getDeployedDirsVector() {
        Collections.sort(this.deployedDirsVect, reverseOrderComparator);
        return this.deployedDirsVect;
    }

    public void addDirectoryToResource() {
        for (String string : this.getDeployedDirsVector()) {
            i5OSResource i5OSResource2 = new i5OSResource();
            String[] stringArray = new String[2];
            stringArray[0] = OS400_UNINSTALL_DIRECTORY;
            stringArray[1] = string.toString();
            i5OSResource2.setResourceArguments(stringArray);
            this.ab(i5OSResource2);
        }
    }

    public long getSizeSelf() {
        try {
            if (!this.getI5Service().isInstallRemote()) {
                return this.fileSize;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long l) {
        this.fileSize = l;
    }

    private boolean rollbackEnabledCancel() {
        return super.getRollbackEnabledCancel();
    }

    static {
        TEMPFILENAMEQSYSFORMAT = "QTEMP/QIATEMP";
        TEMPFILENAMEIFSFORMAT = "/QSYS.LIB/QTEMP.LIB/QIATEMP.FILE";
        IA_SIGN_ON = variables.substitute("$ia_signon_i5OS$");
        DEBUG_REG = System.getProperty("debug.i5OSRAIR_REG") != null;
        IATempPath = "/tmp/InstallAnywhere";
        requiredDependencies = new Vector();
        v = new Vector();
        NOISY = System.getProperty("debug.i5ActionAbstract") != null;
        reverseOrderComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return object2.toString().compareTo(object.toString());
            }
        };
        i5OSIFSDirDeleteBackLog = new Vector();
    }

    public class i5OSResource
    implements Flexeraapq {
        private String resourceName = "";
        private String resourceArguements = "";
        private String resourcePath = "";

        public void setResourceArguments(String string) {
            this.resourceArguements = string;
        }

        public void setResourceArguments(String[] stringArray) {
            this.resourceArguements = Flexeraavc.aa(stringArray, "|");
        }

        public String getResourceArguments() {
            return this.resourceArguements;
        }

        public Flexeraapb getResourceComponent() {
            return i5OSActionServiceImpl.this.getInstallComponent();
        }

        public void setResourceName(String string) {
            this.resourceName = string;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourcePath(String string) {
            this.resourcePath = string;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getResourceType() {
            return "iseries";
        }

        public boolean isResourceUninstallable() {
            return i5OSActionServiceImpl.this.getShouldUninstall();
        }

        public boolean getRollbackEnabledCancel() {
            return i5OSActionServiceImpl.this.rollbackEnabledCancel();
        }

        public boolean getRollbackEnabledError() {
            return false;
        }
    }
}

