/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.rules.operators;

import com.zerog.ia.installer.InstallPiece;
import com.zerog.ia.installer.Rule;
import com.zerog.ia.installer.rules.TagChk;
import com.zerog.ia.installer.rules.operators.ANDOperator;
import com.zerog.ia.installer.rules.operators.DoubleArguementRuleOperator;
import com.zerog.ia.installer.rules.operators.EvaluatableOperators;
import com.zerog.ia.installer.rules.operators.LeftParenthesisOperator;
import com.zerog.ia.installer.rules.operators.NotOperator;
import com.zerog.ia.installer.rules.operators.OROperator;
import com.zerog.ia.installer.rules.operators.RightParenthesisOperator;
import com.zerog.ia.installer.rules.operators.RuleOperationException;
import com.zerog.ia.installer.rules.operators.RuleOperator;
import com.zerog.ia.installer.rules.operators.RuleValidationException;
import com.zerog.ia.installer.rules.operators.SingleArguementRuleOperator;
import com.zerog.util.IAResourceBundle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class RuleEvaluationUtility {
    private static boolean shouldDebug = false;

    public static boolean validateRulesExpression(InstallPiece installPiece, boolean bl) throws RuleValidationException {
        Vector vector;
        block8: {
            block7: {
                vector = new Vector();
                if (installPiece.getRuleExpression() == null) break block7;
                if (!installPiece.getRuleExpression().trim().equals("")) break block8;
            }
            return true;
        }
        boolean bl2 = RuleEvaluationUtility.parseAndValidateRuleExpression(installPiece, vector);
        if (!bl2) {
            return false;
        }
        if (bl) {
            RuleEvaluationUtility.constructRuleExprVector(installPiece, vector);
        }
        return true;
    }

    public static boolean evaluateRulesExpressionForPieceAlone(InstallPiece installPiece, Hashtable hashtable) throws RuleValidationException, RuleOperationException {
        Vector vector;
        block8: {
            block7: {
                vector = new Vector();
                if (installPiece.getRuleExpression() == null) break block7;
                if (!installPiece.getRuleExpression().trim().equals("")) break block8;
            }
            return true;
        }
        if (RuleEvaluationUtility.parseAndValidateRuleExpression(installPiece, vector)) {
            Vector vector2 = RuleEvaluationUtility.constructRuleExprVector(installPiece, vector);
            ArrayList arrayList = RuleEvaluationUtility.convertInfixToPostFix(vector2);
            return RuleEvaluationUtility.evaluatePostFix(arrayList, hashtable);
        }
        return false;
    }

    public static void assignDefaultRuleExpressionForPiece(InstallPiece installPiece, Vector vector) {
        String string;
        block16: {
            block15: {
                block14: {
                    block13: {
                        string = "";
                        for (int i = 0; i < vector.size(); ++i) {
                            String string2;
                            block12: {
                                Rule rule;
                                block11: {
                                    rule = (Rule)vector.get(i);
                                    string2 = rule.getRuleId();
                                    if (string2 == null) break block11;
                                    if (!string2.trim().equals("")) break block12;
                                }
                                rule.generateAndSetRuleId();
                                string2 = rule.getRuleId();
                            }
                            if (installPiece.getLogically_AND_Rules()) {
                                string = string + " && " + string2;
                                continue;
                            }
                            string = string + " || " + string2;
                        }
                        string = string.trim();
                        if (string.endsWith("&&")) break block13;
                        if (!string.endsWith("||")) break block14;
                    }
                    string = string.substring(0, string.length() - 2);
                }
                string = string.trim();
                if (string.startsWith("&&")) break block15;
                if (!string.startsWith("||")) break block16;
            }
            string = string.substring(2);
        }
        string = string.trim();
        installPiece.setRuleExpression(string);
    }

    private static boolean evaluatePostFix(ArrayList arrayList, Hashtable hashtable) throws RuleOperationException {
        Stack stack = new Stack();
        if (arrayList == null || arrayList.isEmpty()) {
            return true;
        }
        for (Object e : arrayList) {
            boolean bl;
            Rule rule;
            EvaluatableOperators evaluatableOperators;
            if (e instanceof Rule) {
                stack.push(e);
                continue;
            }
            if (e instanceof SingleArguementRuleOperator) {
                evaluatableOperators = (SingleArguementRuleOperator)e;
                rule = null;
                if (!stack.empty()) {
                    bl = ((SingleArguementRuleOperator)evaluatableOperators).evaluateOperator(new Rule[]{(Rule)stack.pop()}, hashtable);
                    rule = new Rule(){

                        public boolean checkSelf(Hashtable hashtable) {
                            return bl;
                        }

                        public String getGenericDisplayString() {
                            return "";
                        }
                    };
                }
                if (rule == null) continue;
                stack.push(rule);
                continue;
            }
            if (!(e instanceof DoubleArguementRuleOperator)) continue;
            evaluatableOperators = (DoubleArguementRuleOperator)e;
            rule = null;
            if (!stack.empty()) {
                bl = ((DoubleArguementRuleOperator)evaluatableOperators).evaluateOperator(new Rule[]{(Rule)stack.pop(), (Rule)stack.pop()}, hashtable);
                rule = new Rule(){

                    public boolean checkSelf(Hashtable hashtable) {
                        return bl;
                    }

                    public String getGenericDisplayString() {
                        return "";
                    }
                };
            }
            if (rule == null) continue;
            stack.push(rule);
        }
        return ((Rule)stack.pop()).checkSelf(hashtable);
    }

    private static void out(String string) {
        if (shouldDebug) {
            System.out.println(string);
        }
    }

    private static ArrayList convertInfixToPostFix(Vector vector) throws RuleValidationException {
        Stack<LeftParenthesisOperator> stack = new Stack<LeftParenthesisOperator>();
        ArrayList arrayList = new ArrayList();
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        stack.push(new LeftParenthesisOperator());
        vector.add(new RightParenthesisOperator());
        for (Object e : vector) {
            Object object;
            boolean bl;
            if (e instanceof Rule) {
                arrayList.add(e);
                continue;
            }
            if (e instanceof LeftParenthesisOperator) {
                stack.push((LeftParenthesisOperator)e);
                continue;
            }
            if (e instanceof RightParenthesisOperator) {
                if (stack.isEmpty()) continue;
                bl = true;
                object = stack.peek();
                while (!(object instanceof LeftParenthesisOperator) && bl) {
                    arrayList.add(stack.pop());
                    if (!stack.isEmpty()) {
                        object = stack.peek();
                        continue;
                    }
                    bl = false;
                }
                if (stack.isEmpty()) continue;
                stack.pop();
                continue;
            }
            if (!(e instanceof RuleOperator) || stack.isEmpty()) continue;
            bl = true;
            object = (RuleOperator)stack.peek();
            while (object.getPrecedence() <= ((RuleOperator)e).getPrecedence() && bl) {
                Object e2 = stack.pop();
                if (e2 instanceof EvaluatableOperators) {
                    arrayList.add(e2);
                }
                if (!stack.isEmpty()) {
                    object = (RuleOperator)stack.peek();
                    continue;
                }
                bl = false;
            }
            stack.push((LeftParenthesisOperator)e);
        }
        return arrayList;
    }

    private static boolean parseAndValidateRuleExpression(InstallPiece installPiece, Vector vector) throws RuleValidationException {
        boolean bl;
        block10: {
            String string;
            block12: {
                block11: {
                    bl = true;
                    string = installPiece.getRuleExpression().trim();
                    if (string == null) break block10;
                    if ("".equals(string)) break block10;
                    if (string.startsWith("&")) break block11;
                    if (string.endsWith("&")) break block11;
                    if (string.startsWith("|")) break block11;
                    if (string.endsWith("|")) break block11;
                    if (string.startsWith(")")) break block11;
                    if (string.endsWith("(")) break block11;
                    if (!string.endsWith("!")) break block12;
                }
                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.illegalOperatorStartEnd"));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "&&,||,!,(,)", true);
            while (stringTokenizer.hasMoreElements()) {
                String string2;
                block14: {
                    block13: {
                        string2 = ((String)stringTokenizer.nextElement()).trim();
                        if ("&".equals(string2)) break block13;
                        if (!"|".equals(string2)) break block14;
                    }
                    string2 = string2 + ((String)stringTokenizer.nextElement()).trim();
                }
                vector.add(string2);
            }
        }
        if (vector != null && vector.size() > 0) {
            for (int i = 0; i < vector.size(); ++i) {
                if (!"".equals(vector.get(i))) continue;
                vector.remove(i);
            }
        }
        if (vector != null && vector.size() > 0) {
            bl = RuleEvaluationUtility.validate(installPiece, vector);
        }
        return bl;
    }

    private static boolean validate(InstallPiece installPiece, Vector vector) throws RuleValidationException {
        boolean bl = true;
        int n = 0;
        if (vector == null || vector.size() == 0) {
            return true;
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2] = (String)enumeration.nextElement();
            ++n2;
        }
        if (RuleEvaluationUtility.hasDuplicateRuleIDs(installPiece)) {
            throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.duplicateID"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string;
                block34: {
                    block35: {
                        String string2;
                        block32: {
                            block33: {
                                string = stringArray[i];
                                string2 = null;
                                if (i + 1 != stringArray.length) {
                                    string2 = stringArray[i + 1];
                                }
                                if ("!".equals(string)) {
                                    boolean bl2 = false;
                                    boolean bl3 = false;
                                    int n3 = i;
                                    while (!bl2 && !bl3) {
                                        if (n3 == 0) {
                                            bl2 = true;
                                            bl3 = true;
                                            break;
                                        }
                                        if ("(".equals(stringArray[--n3])) continue;
                                        if ("&&".equals(stringArray[n3])) {
                                            bl2 = true;
                                            bl3 = true;
                                            break;
                                        }
                                        if ("||".equals(stringArray[n3])) {
                                            bl2 = true;
                                            bl3 = true;
                                            break;
                                        }
                                        if ("!".equals(stringArray[n3])) {
                                            bl2 = true;
                                            bl3 = true;
                                            break;
                                        }
                                        bl = false;
                                        throw new RuleValidationException("Invalid Expression");
                                    }
                                }
                                if (!"!".equals(string)) break block32;
                                if ("&&".equals(string2)) break block33;
                                if (!"||".equals(string2)) break block32;
                            }
                            bl = false;
                            throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.illegalUsageOfNot"));
                        }
                        if ("&&".equals(string)) {
                            if ("||".equals(string2)) {
                                bl = false;
                                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.illegalANDfollowedOR"));
                            }
                        }
                        if ("||".equals(string)) {
                            if ("&&".equals(string2)) {
                                bl = false;
                                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.illegalORfollowedAND"));
                            }
                        }
                        if ("&&".equals(string)) {
                            if ("&&".equals(string2)) {
                                bl = false;
                                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.illegalANDfollowedAND"));
                            }
                        }
                        if ("||".equals(string)) {
                            if ("||".equals(string2)) {
                                bl = false;
                                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.illegalORfollowedOR"));
                            }
                        }
                        if (!"(".equals(string)) break block34;
                        if ("&&".equals(string2)) break block35;
                        if (!"||".equals(string2)) break block34;
                    }
                    bl = false;
                    throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.ParenthesisFollowedByANDOR"));
                }
                if ("(".equals(string)) {
                    ++n;
                    continue;
                }
                if (!")".equals(string) || --n >= 0) continue;
                bl = false;
                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.missingMatchingParenthesis"));
            }
            catch (Exception exception) {
                if (exception instanceof RuleValidationException) {
                    throw (RuleValidationException)exception;
                }
                throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.unknownErrorInParsing") + exception.getMessage());
            }
        }
        if (n != 0) {
            bl = false;
            throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.missingParenthesis"));
        }
        return bl;
    }

    private static Vector constructRuleExprVector(InstallPiece installPiece, Vector vector) throws RuleValidationException {
        Enumeration enumeration = vector.elements();
        Vector vector2 = installPiece.getRulesVector();
        Vector<Object> vector3 = new Vector<Object>();
        Rule rule = null;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ("&&".equals(string)) {
                vector3.add(new ANDOperator());
                continue;
            }
            if ("||".equals(string)) {
                vector3.add(new OROperator());
                continue;
            }
            if ("!".equals(string)) {
                vector3.add(new NotOperator());
                continue;
            }
            if ("(".equals(string)) {
                vector3.add(new LeftParenthesisOperator());
                continue;
            }
            if (")".equals(string)) {
                vector3.add(new RightParenthesisOperator());
                continue;
            }
            if (vector2 != null && vector2.size() > 0) {
                rule = RuleEvaluationUtility.getRuleFromID(vector2, string);
            }
            if (rule != null) {
                vector3.add(rule);
                continue;
            }
            throw new RuleValidationException(IAResourceBundle.getValue("Designer.rules.new.container.validation.invalid.ruleid") + ":" + string);
        }
        return vector3;
    }

    private static Rule getRuleFromID(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            Rule rule = (Rule)vector.get(i);
            if (rule instanceof TagChk || !(string2 = rule.getRuleId()).equalsIgnoreCase(string)) continue;
            return rule;
        }
        return null;
    }

    private static boolean hasDuplicateRuleIDs(InstallPiece installPiece) {
        boolean bl = false;
        if (installPiece == null) {
            return false;
        }
        Vector vector = installPiece.getRulesVector();
        if (vector == null || vector.isEmpty()) {
            return false;
        }
        Rule[] ruleArray = new Rule[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            ruleArray[n] = (Rule)enumeration.nextElement();
            ++n;
        }
        for (int i = 0; i < ruleArray.length; ++i) {
            Rule rule = ruleArray[i];
            if (rule instanceof TagChk) continue;
            String string = rule.getRuleId();
            Rule rule2 = null;
            String string2 = "";
            if (i + 1 != ruleArray.length) {
                rule2 = ruleArray[i + 1];
                if (rule2 instanceof TagChk) continue;
                string2 = rule2.getRuleId();
            }
            if (string == null || string2 == null || !string.equalsIgnoreCase(string2)) continue;
            bl = true;
        }
        return bl;
    }
}

