/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.uninstall;

import com.zerog.ia.installer.Installer;
import com.zerog.ia.installer.Rule;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryAIX;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryDBScript;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryFiles;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryFolders;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryJEEArchive;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryLAX;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryLinks;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryMergeModules;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryNativePackages;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryRAIR;
import com.zerog.ia.installer.actions.ExecuteUninstallCategoryRegistries;
import com.zerog.ia.installer.actions.UninstallCategory;
import com.zerog.ia.installer.rules.PlatformChk;
import com.zerog.util.IAResourceBundle;
import com.zerog.util.ZGUtil;

public class UninstallCategoryFactory {
    public UninstallCategory filesCategory = new UninstallCategory();
    public UninstallCategory laxCategory = new UninstallCategory();
    public UninstallCategory linksCategory = new UninstallCategory();
    public UninstallCategory regCategory = new UninstallCategory();
    public UninstallCategory nativeCategory = new UninstallCategory();
    public UninstallCategory foldersCategory = new UninstallCategory();
    public UninstallCategory othersCategory = new UninstallCategory();
    public static final String NEW_CATEGORY_FILE = IAResourceBundle.getValue("UninstallPhase.category.default.name.file");
    public static final String NEW_CATEGORY_FOLDER = IAResourceBundle.getValue("UninstallPhase.category.default.name.folder");
    public static final String NEW_CATEGORY_LAUNCHANYWHERE = IAResourceBundle.getValue("UninstallPhase.category.default.name.lax");
    public static final String NEW_CATEGORY_LINK = IAResourceBundle.getValue("UninstallPhase.category.default.name.link");
    public static final String NEW_CATEGORY_REGISTRY = IAResourceBundle.getValue("UninstallPhase.category.default.name.reg");
    public static final String NEW_CATEGORY_NATIVE = IAResourceBundle.getValue("UninstallPhase.category.default.name.native");
    public static final String NEW_CATEGORY_OTHERS = IAResourceBundle.getValue("UninstallPhase.category.default.name.others");

    public void createDefaultUninstallCategories(Installer installer) {
        this.filesCategory.setCategoryName(NEW_CATEGORY_FILE);
        this.laxCategory.setCategoryName(NEW_CATEGORY_LAUNCHANYWHERE);
        this.linksCategory.setCategoryName(NEW_CATEGORY_LINK);
        this.regCategory.setCategoryName(NEW_CATEGORY_REGISTRY);
        this.nativeCategory.setCategoryName(NEW_CATEGORY_NATIVE);
        this.foldersCategory.setCategoryName(NEW_CATEGORY_FOLDER);
        this.othersCategory.setCategoryName(NEW_CATEGORY_OTHERS);
        this.filesCategory.addVisualChild(new ExecuteUninstallCategoryFiles());
        this.laxCategory.addVisualChild(new ExecuteUninstallCategoryLAX());
        this.linksCategory.addVisualChild(new ExecuteUninstallCategoryLinks());
        this.regCategory.addVisualChild(new ExecuteUninstallCategoryRegistries());
        this.nativeCategory.addVisualChild(new ExecuteUninstallCategoryNativePackages());
        this.foldersCategory.addVisualChild(new ExecuteUninstallCategoryFolders());
        this.nativeCategory.addVisualChild(new ExecuteUninstallCategoryAIX());
        this.nativeCategory.addVisualChild(new ExecuteUninstallCategoryRAIR());
        this.othersCategory.addVisualChild(new ExecuteUninstallCategoryJEEArchive());
        this.othersCategory.addVisualChild(new ExecuteUninstallCategoryDBScript());
        this.othersCategory.addVisualChild(new ExecuteUninstallCategoryMergeModules());
        this.setRulesOnDefaultCategories();
        installer.addVisualChild(this.filesCategory);
        installer.addVisualChild(this.laxCategory);
        installer.addVisualChild(this.linksCategory);
        installer.addVisualChild(this.regCategory);
        installer.addVisualChild(this.nativeCategory);
        installer.addVisualChild(this.foldersCategory);
        installer.addVisualChild(this.othersCategory);
    }

    public void setRulesOnDefaultCategories() {
        PlatformChk platformChk = new PlatformChk();
        platformChk.removeFromDoNotInstallOnPlatformList("^Windows.*");
        platformChk.addToInstallOnPlatformList("^Windows.*");
        this.regCategory.addRule(platformChk);
        ZGUtil.setRuleExpressionForInstallPiece(this.regCategory, (Rule)platformChk);
        PlatformChk platformChk2 = new PlatformChk();
        platformChk2.removeFromInstallOnPlatformList("Windows NT");
        platformChk2.removeFromInstallOnPlatformList("Windows 2000");
        platformChk2.removeFromInstallOnPlatformList("Windows XP");
        platformChk2.removeFromInstallOnPlatformList("Windows 2003");
        platformChk2.removeFromInstallOnPlatformList("Windows Vista");
        platformChk2.removeFromInstallOnPlatformList("Windows 7");
        platformChk2.removeFromInstallOnPlatformList("Windows 8");
        platformChk2.removeFromInstallOnPlatformList("Windows 10");
        platformChk2.removeFromInstallOnPlatformList("Windows 2016");
        platformChk2.removeFromDoNotInstallOnPlatformList("AIX");
        platformChk2.removeFromDoNotInstallOnPlatformList("Linux");
        platformChk2.removeFromDoNotInstallOnPlatformList("HP-UX");
        platformChk2.removeFromDoNotInstallOnPlatformList("Solaris");
        platformChk2.removeFromDoNotInstallOnPlatformList("Mac OS X");
        platformChk2.removeFromDoNotInstallOnPlatformList("SunOS");
        platformChk2.removeFromDoNotInstallOnPlatformList("FreeBSD");
        platformChk2.removeFromDoNotInstallOnPlatformList("NetWare");
        platformChk2.removeFromDoNotInstallOnPlatformList("OS/400");
        platformChk2.removeFromDoNotInstallOnPlatformList("Unlisted Platforms");
        platformChk2.addToInstallOnPlatformList("AIX");
        platformChk2.addToInstallOnPlatformList("Linux");
        platformChk2.addToInstallOnPlatformList("HP-UX");
        platformChk2.addToInstallOnPlatformList("Solaris");
        platformChk2.addToInstallOnPlatformList("Mac OS X");
        platformChk2.addToInstallOnPlatformList("SunOS");
        platformChk2.addToInstallOnPlatformList("FreeBSD");
        platformChk2.addToInstallOnPlatformList("NetWare");
        platformChk2.addToInstallOnPlatformList("OS/400");
        platformChk2.addToInstallOnPlatformList("Unlisted Platforms");
        this.nativeCategory.addRule(platformChk2);
        ZGUtil.setRuleExpressionForInstallPiece(this.nativeCategory, (Rule)platformChk2);
    }
}

