/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.util;

import com.zerog.ia.installer.util.BidiUtil;
import com.zerog.ia.installer.util.MnemonicString;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class BidiUtilBase
implements BidiUtil {
    public String applyTextOrientation(String string) {
        return this.applyTextOrientation(string, this.getPreferredOrientation());
    }

    public Image flipImage(Image image, Component component, int n, int n2) throws InterruptedException {
        if (null == image || null == component || n < 2 || n2 < 1) {
            return image;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 1);
        if (!mediaTracker.waitForID(1, 10000L)) {
            return image;
        }
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        if (pixelGrabber.grabPixels() && (pixelGrabber.getStatus() & 0x20) != 0) {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n >> 1; ++j) {
                    int n3 = j + i * n;
                    int n4 = BidiUtilBase.aa(j, n) + i * n;
                    int n5 = nArray[n3];
                    nArray[n3] = nArray[n4];
                    nArray[n4] = n5;
                }
            }
        }
        return component.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public boolean isBidiLocale() {
        return !this.getPreferredOrientation().isLeftToRight();
    }

    public ComponentOrientation getPreferredOrientation() {
        return ComponentOrientation.getOrientation(this.getDefaultLocale());
    }

    public int resolveJustification(int n) {
        if (!this.getPreferredOrientation().isLeftToRight() && n == 0) {
            return 2;
        }
        if (!this.getPreferredOrientation().isLeftToRight() && n == 2) {
            return 0;
        }
        return n;
    }

    public static int aa(int n, int n2) {
        return n2 - n - 1;
    }

    public ComponentOrientation getPreferredOrientation(int n) {
        switch (n) {
            case 1: {
                return ComponentOrientation.LEFT_TO_RIGHT;
            }
            case 2: {
                return ComponentOrientation.RIGHT_TO_LEFT;
            }
        }
        return this.getPreferredOrientation();
    }

    public boolean RTL_Oriented(int n) {
        switch (n) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return !this.getPreferredOrientation().isLeftToRight();
    }

    public String shapeString(String string, int n) {
        return string;
    }

    public char unshapeString(char c, int n) {
        return c;
    }

    public boolean isArabicString(String string) {
        return true;
    }

    public String unApplyTextOrientation(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < string.length(); ++i) {
            char c = cArray[i];
            if (c == '\u202b' || c == '\u202a') continue;
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    public String getJavaVMVendor() {
        return System.getProperty("java.vm.vendor").toLowerCase();
    }

    public String getJavaVMVersion() {
        String string = System.getProperty("java.specification.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        stringTokenizer.nextToken();
        return stringTokenizer.nextToken();
    }

    public boolean isShapedString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] < '\ufe70') continue;
            if (cArray[i] > '\ufefc') continue;
            return true;
        }
        return false;
    }

    public StringBuffer handleBidiString(StringBuffer stringBuffer, int n, boolean bl, char c, MnemonicString mnemonicString) {
        return stringBuffer;
    }

    public boolean isCharBeforeBiDiChar(char[] cArray, int n, int n2, boolean bl) {
        return false;
    }

    public abstract Locale getDefaultLocale();

    public abstract String applyTextOrientation(String var1, ComponentOrientation var2);
}

