/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.ia.installer.util.service;

import com.installshield.boot.streamhandler.ISMPURLStreamHandlerFactory;
import com.installshield.util.FileUtils;
import com.installshield.util.regex.RegexUtil;
import com.installshield.wizard.service.DebugLogWrapper;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceManagerImpl;
import com.installshield.wizard.service.ServiceManagerLoader;
import com.installshield.wizard.service.system.GenericSystemUtilService;
import com.installshield.wizard.service.system.RebootRequestListener;
import com.installshield.wizard.service.system.SystemUtilService;
import com.zerog.ia.installer.util.VariableFacade;
import com.zerog.ia.installer.util.service.RegexEvaluatorWrapper;
import com.zerog.interfaces.service.ServiceManager;
import com.zerog.interfaces.util.DebugLog;
import com.zerog.util.ZGUtil;
import java.net.URL;
import java.net.URLStreamHandlerFactory;

public class ServiceManagerWrapper
implements ServiceManager,
RebootRequestListener {
    private static final String REBOOT_IA_VARIABLE_NAME = "RESTART_NEEDED";
    private static boolean initializedEnvironment = false;
    private static boolean initializedLockedFilesHandler = false;
    private ServiceManagerImpl internalManager = null;
    private DebugLog log = new Flexeraamz();
    private DebugLogWrapper logWrapper;

    public ServiceManagerWrapper() throws Exception {
        this.log.setLoggingContext("ServiceManagerWrapper");
        this.logWrapper = new DebugLogWrapper();
        this.logWrapper.setDebugLog(this.log);
        this.initialize();
    }

    public void setDebugLog(DebugLog debugLog) {
        this.internalManager.setDebugLog(debugLog);
    }

    public DebugLog getDebugLog() {
        return this.internalManager.getDebugLog();
    }

    public Object getService(Class clazz) {
        return this.internalManager.getService(clazz);
    }

    public boolean isServicesShutdown() {
        return this.internalManager.isServicesShutdown();
    }

    public void shutdownServices() {
        this.internalManager.shutdownServices();
        this.printDebugMessage("Cleaning temp files: START");
        String[] stringArray = FileUtils.deleteTempFiles();
        for (int i = 0; i < stringArray.length; ++i) {
            this.printDebugMessage("WARNING: could not delete temporary file " + stringArray[i]);
        }
        this.printDebugMessage("Cleaning temp files: END");
    }

    private void initialize() throws ServiceException {
        this.initializeEnvironment();
        this.internalManager = null;
        try {
            String string = ZGUtil.removeLeadingSlashes("/services.inf");
            String string2 = ZGUtil.findInZips(string);
            this.printDebugMessage("Services Zip Path = " + string2);
            this.internalManager = (ServiceManagerImpl)ServiceManagerLoader.loadServiceManager((String)string2);
            this.internalManager.setDebugLog(this.log);
            this.initializeLockedFilesHandler((ServiceManager)this.internalManager);
            this.initializeRebootRequestListener((ServiceManager)this.internalManager);
        }
        catch (ServiceException serviceException) {
            this.printDebugError(serviceException);
            throw serviceException;
        }
    }

    private void initializeEnvironment() {
        if (!initializedEnvironment) {
            URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new ISMPURLStreamHandlerFactory());
            try {
                RegexUtil.setRegexEvaluatorClass((String)RegexEvaluatorWrapper.class.getName());
            }
            catch (Exception exception) {
                this.printDebugError(exception);
            }
            initializedEnvironment = true;
        }
    }

    private void initializeLockedFilesHandler(ServiceManager serviceManager) {
        if (!initializedLockedFilesHandler) {
            try {
                GenericSystemUtilService genericSystemUtilService = (GenericSystemUtilService)serviceManager.getService(SystemUtilService.class);
                genericSystemUtilService.registerLockedFilesHandler();
            }
            catch (ServiceException serviceException) {
                this.printDebugError(serviceException);
            }
            initializedLockedFilesHandler = true;
        }
    }

    private void initializeRebootRequestListener(ServiceManager serviceManager) {
        GenericSystemUtilService genericSystemUtilService = (GenericSystemUtilService)serviceManager.getService(SystemUtilService.class);
        genericSystemUtilService.addRebootRequestListener((RebootRequestListener)this);
    }

    public void rebootRequiredStateChanged(boolean bl) {
        if (bl) {
            VariableFacade.getInstance().setVariable(REBOOT_IA_VARIABLE_NAME, "YES_REQUIRED");
        }
    }

    private void printDebugMessage(String string) {
        this.logWrapper.logEvent((Object)this, "dbg", (Object)string);
    }

    private void printDebugError(Exception exception) {
        this.logWrapper.logEvent((Object)this, "dbg", (Object)exception);
    }
}

