/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.commands;

import com.zerog.util.IAResourceBundle;
import com.zerog.util.commands.id;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class rpm
extends Flexeraaus {
    public static String isValidTargetDistro = "";
    private static Boolean isSuperUser = null;
    private static Boolean isValidPlatform = null;

    public rpm() {
        super("rpm");
    }

    public void install(File file, File file2, boolean bl, boolean bl2) throws Exception {
        if (!rpm.getIsValidPlatform()) {
            throw new Exception(6, Flexeraacn.aa().ab() + " is not a valid platform for RPM");
        }
        if (!rpm.getIsSuperUser()) {
            throw new Exception(5, IAResourceBundle.getValue("Installlog.InstallRPM.insufficientpermissioninstall"));
        }
        if (!file.exists()) {
            throw new Exception(1, file.getPath() + " not found");
        }
        if (isValidTargetDistro.equalsIgnoreCase("Ubuntu")) {
            throw new Exception(7, "The target distribution selected does not match the machine linux distribution");
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("-i");
        if (bl) {
            vector.addElement("--nodeps");
        }
        if (bl2) {
            vector.addElement("--force");
        }
        if (file2 != null) {
            vector.addElement("--prefix");
            vector.addElement(file2.getPath());
        }
        vector.addElement(file.getPath());
        this.ae(vector);
        this.ah(false);
        this.ao(false);
        this.run();
        if (this.am() == Flexeraaus.af) {
            throw new Exception(2, "rpm is not installed");
        }
        if (this.am() == Flexeraaus.ag) {
            throw new Exception(3, this.an());
        }
    }

    public void install(File file) throws Exception {
        this.install(file, null, false, false);
    }

    public void install(File file, boolean bl) throws Exception {
        this.install(file, null, bl, false);
    }

    public void remove(String string, boolean bl) throws Exception {
        if (!rpm.getIsValidPlatform()) {
            throw new Exception(6, Flexeraacn.aa().ab() + " is not a valid platform for RPM");
        }
        if (!rpm.getIsSuperUser()) {
            throw new Exception(5, IAResourceBundle.getValue("Installlog.InstallRPM.insufficientpermissionremove"));
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("-e");
        if (bl) {
            vector.addElement("--nodeps");
        }
        vector.addElement(string);
        this.ae(vector);
        this.ah(false);
        this.run();
        if (this.am() == Flexeraaus.af) {
            throw new Exception(2, "rpm is not installed");
        }
        if (this.am() == Flexeraaus.ag) {
            throw new Exception(3, this.an());
        }
    }

    public void remove(String string) throws Exception {
        this.remove(string, false);
    }

    public Version version() throws Exception {
        if (!rpm.getIsValidPlatform()) {
            throw new Exception(6, Flexeraacn.aa().ab() + " is not a valid platform for RPM");
        }
        String[] stringArray = new String[1];
        stringArray[0] = "--version";
        this.ad(stringArray);
        this.ah(true);
        this.run();
        if (this.am() == Flexeraaus.af) {
            throw new Exception(2, "rpm is not installed on this system");
        }
        if (this.am() == Flexeraaus.ag) {
            throw new Exception(3, this.an());
        }
        Version version = new Version(0, 0, 0);
        try {
            RE rE = new RE(".*([0-9]+)\\.([0-9]+)\\.?([0-9]*).*");
            if (!rE.match(this.aj().toString())) {
                throw new Exception(4, "could not grok '" + this.aj().toString() + "' into a version");
            }
            version.major = Integer.parseInt(rE.getParen(1));
            version.minor = Integer.parseInt(rE.getParen(2));
            version.patch = Integer.parseInt(rE.getParen(3).length() > 0 ? rE.getParen(3) : "0");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new Exception(0, rESyntaxException.getClass().getName() + ": " + rESyntaxException.getMessage());
        }
        return version;
    }

    public Info query(File file) throws Exception {
        if (!rpm.getIsValidPlatform()) {
            throw new Exception(6, Flexeraacn.aa().ab() + " is not a valid platform for RPM");
        }
        if (file == null) {
            throw new IllegalArgumentException("packageFile must not be null");
        }
        if (!file.exists()) {
            throw new Exception(1, file.getPath() + " not found");
        }
        Vector<String> vector = new Vector<String>();
        vector.addElement("-q");
        vector.addElement("--queryformat");
        vector.addElement("NAME=%{NAME}\\nSIZE=%{SIZE}\\nPREFIXES=%{PREFIXES}\\n");
        vector.addElement("-p");
        vector.addElement(file.getPath());
        this.ae(vector);
        this.ah(true);
        this.run();
        if (this.am() == Flexeraaus.af) {
            throw new Exception(2, "rpm is not installed on this system");
        }
        if (this.am() == Flexeraaus.ag) {
            throw new Exception(3, this.an());
        }
        Info info = new Info();
        StringTokenizer stringTokenizer = new StringTokenizer(this.aj().toString(), "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            String string2 = string.substring(0, string.indexOf("="));
            String string3 = string.substring(string2.length() + 1, string.length());
            if (string2.equalsIgnoreCase("name")) {
                info.packageName = string3;
                continue;
            }
            if (string2.equalsIgnoreCase("size")) {
                info.size = Long.parseLong(string3);
                continue;
            }
            if (!string2.equalsIgnoreCase("prefixes")) continue;
            info.prefixes = string3;
        }
        return info;
    }

    private static boolean getIsSuperUser() {
        if (isSuperUser == null) {
            isSuperUser = new Boolean(new id().getUserID() == 0);
        }
        return isSuperUser;
    }

    private static boolean getIsValidPlatform() {
        if (isValidPlatform == null) {
            isValidPlatform = new Boolean(Flexeraacn.ag);
        }
        return isValidPlatform;
    }

    public static class Info {
        public String packageName = "";
        public long size = 0L;
        public String prefixes = "";

        public boolean isRelocateable() {
            return !this.prefixes.equalsIgnoreCase("(none)");
        }
    }

    public static class Version {
        public int major;
        public int minor;
        public int patch;

        public Version(int n, int n2, int n3) {
            this.major = n;
            this.minor = n2;
            this.patch = n3;
        }

        public Version() {
        }

        public int compareTo(Version version) {
            Version version2 = this;
            long l = version2.major << 24 | version2.minor << 12 | version2.patch;
            long l2 = version.major << 24 | version.minor << 12 | version.patch;
            return new Long(l).compareTo(new Long(l2));
        }
    }

    public class Exception
    extends java.lang.Exception {
        public static final int EMBEDED = 0;
        public static final int FILE_NOT_FOUND = 1;
        public static final int RPM_NOT_INSTALLED = 2;
        public static final int RPM_FAILURE = 3;
        public static final int VERSION_GROK_FAILURE = 4;
        public static final int INSUFFICIENT_PERMISSIONS = 5;
        public static final int INVALID_PLATFORM = 6;
        public static final int INVALID_TARGETDISTRO = 7;
        public int code;

        public Exception(int n, String string) {
            super(string);
            this.code = n;
        }
    }
}

