/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.vmpackcreation;

import com.zerog.util.vmpackcreation.JVMPack;
import com.zerog.util.vmpackcreation.JVMPackCreator;
import com.zerog.util.vmpackcreation.JVMPackCreatorStatusObserver;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

public abstract class JVMPackCreatorImpl
implements JVMPackCreator {
    private ArrayList listOfObservers = new ArrayList();

    public Properties createVMProperties(JVMPack jVMPack) {
        Properties properties = new Properties();
        properties.put("vm.platform", this.getVMPlatformName());
        properties.put("vm.platform.flavor", this.getVMPlatformFlavor(jVMPack));
        properties.put("vm.name", jVMPack.getNameOfVMPack());
        properties.put("vm.exe.path", this.getVMExePath());
        return properties;
    }

    public boolean writeJVMPropertiesToFile(Properties properties, String string, String string2) {
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdirs();
        }
        boolean bl = true;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2 + File.separator + string);
            properties.store(fileOutputStream, "");
            bl = true;
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            bl = false;
            iOException.printStackTrace();
        }
        return bl;
    }

    public String getNameOfVMProperties() {
        return "vm.properties";
    }

    public void adjustSourcePathForVMPackIfJDKWasSupplied(JVMPack jVMPack) {
        block5: {
            File file;
            String string;
            block4: {
                string = jVMPack.getSourceLocationOfVMPack();
                if (new File(string + File.separator + "bin" + File.separator + "javac.exe").exists()) break block4;
                if (!new File(string + File.separator + "bin" + File.separator + "javac.bin").exists()) break block5;
            }
            if ((file = new File(string + File.separator + "jre")).exists()) {
                jVMPack.setSourceLocationOfVMPack(file.getAbsolutePath());
            }
        }
    }

    public void addObserver(JVMPackCreatorStatusObserver jVMPackCreatorStatusObserver) {
        if (!this.listOfObservers.contains(jVMPackCreatorStatusObserver)) {
            this.listOfObservers.add(jVMPackCreatorStatusObserver);
        }
    }

    public void removeObserver(JVMPackCreatorStatusObserver jVMPackCreatorStatusObserver) {
        if (this.listOfObservers.contains(jVMPackCreatorStatusObserver)) {
            this.listOfObservers.remove(jVMPackCreatorStatusObserver);
        }
    }

    public void notifyObservers(Object object) {
        for (JVMPackCreatorStatusObserver jVMPackCreatorStatusObserver : this.listOfObservers) {
            jVMPackCreatorStatusObserver.update(object);
        }
    }

    public abstract String getVMPlatformName();

    public abstract String getVMPlatformFlavor(JVMPack var1);

    public abstract String getVMExePath();
}

