/*
 * Decompiled with CFR 0.152.
 */
package com.zerog.util.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    private static byte[] aa = new byte[131072];
    private File ab;
    private ZipOutputStream ac = null;
    private boolean ad = true;
    private long ae = 0L;
    private Vector af = new Vector();

    public ZipCreator(File file, boolean bl) throws FileNotFoundException {
        this.ab = file;
        this.ad = bl;
        new File(file.getParent()).mkdirs();
        this.ac = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        this.ae = 0L;
    }

    public void setNotifyWhenDuplicateEntries(boolean bl) {
        this.ad = bl;
    }

    public boolean getNotifyWhenDuplicateEntries() {
        return this.ad;
    }

    public long getSize() {
        return this.ae;
    }

    public File getZipPath() {
        return this.ab;
    }

    public boolean close() {
        try {
            this.closeZip();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public void closeZip() throws IOException {
        this.ac.flush();
        this.ac.closeEntry();
        this.ac.close();
    }

    public Flexeraaxf addFile(File file) throws ZipException, IOException {
        Flexeraaxe flexeraaxe = new Flexeraaxe(file.getCanonicalPath(), file);
        return this.addFile(flexeraaxe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flexeraaxf addFile(Flexeraaxi flexeraaxi) throws ZipException, IOException {
        InputStream inputStream = flexeraaxi.aa();
        if (inputStream != null) {
            try {
                Flexeraaxf flexeraaxf = this.addInputStream(inputStream, flexeraaxi.ad());
                return flexeraaxf;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.aa(flexeraaxi.ad());
    }

    public void addFile(File file, long l, long l2) throws ZipException, IOException {
        Flexeraaxe flexeraaxe = new Flexeraaxe(file.getCanonicalPath(), file);
        this.addFile(flexeraaxe, l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Flexeraaxf addFile(Flexeraaxi flexeraaxi, long l, long l2) throws ZipException, IOException {
        Flexeraaxi flexeraaxi2 = null;
        if (flexeraaxi instanceof Flexeraaxe) {
            flexeraaxi2 = new Flexeraaxe((Flexeraaxe)flexeraaxi, l, l2);
        } else if (flexeraaxi instanceof Flexeraaxh) {
            flexeraaxi2 = new Flexeraaxh((Flexeraaxh)flexeraaxi, l, l2);
        } else if (flexeraaxi instanceof Flexeraaxi) {
            flexeraaxi2 = flexeraaxi;
        } else {
            System.err.println("Error:- ZipCreator does not handle this type of ZGZipEntry: " + flexeraaxi.getClass().toString());
        }
        InputStream inputStream = null;
        inputStream = flexeraaxi2.aa();
        if (inputStream != null) {
            try {
                Flexeraaxf flexeraaxf = this.ab(inputStream, flexeraaxi2.ad(), l, l2, flexeraaxi.ad().getMethod() == 8);
                return flexeraaxf;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.aa(flexeraaxi.ad());
    }

    public void mergeInZip(ZipFile zipFile) throws ZipException, IOException {
        this.mergeInZip(zipFile, true);
    }

    public void mergeInZip(ZipFile zipFile, boolean bl) throws ZipException, IOException {
        if (zipFile.entries() != null) {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
                if (bl) {
                    zipEntry2.setMethod(8);
                } else {
                    zipEntry2.setMethod(0);
                    zipEntry2.setCrc(zipEntry.getCrc());
                    zipEntry2.setSize(zipEntry.getSize());
                }
                if (zipEntry.getTime() != -1L) {
                    zipEntry2.setTime(zipEntry.getTime());
                }
                if (zipEntry.getExtra() != null) {
                    zipEntry2.setExtra(zipEntry.getExtra());
                }
                if (zipEntry.getComment() != null) {
                    zipEntry2.setComment(zipEntry.getComment());
                }
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                this.addInputStream(inputStream, zipEntry2);
                inputStream.close();
            }
        }
    }

    public Flexeraaxf addInputStream(InputStream inputStream, ZipEntry zipEntry) throws ZipException, IOException {
        return this.ab(inputStream, zipEntry, -1L, -1L, false);
    }

    public Flexeraaxf addInputStream(InputStream inputStream, ZipEntry zipEntry, long l) throws ZipException, IOException {
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        if (zipEntry.getExtra() != null) {
            zipEntry2.setExtra(zipEntry.getExtra());
        }
        return this.ab(inputStream, zipEntry2, 0L, l, zipEntry.getMethod() == 8);
    }

    public void addDirectoryContents(String string, File file) throws ZipException, IOException {
        String[] stringArray = file.list();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Flexeraave flexeraave = new Flexeraave(file.getPath() + File.separator + stringArray[i]);
            String string2 = string.toString() + "/" + Flexeraave.aa(flexeraave);
            if (flexeraave.isDirectory()) {
                this.addDirectoryContents(string, flexeraave);
                this.addFile(flexeraave);
                continue;
            }
            this.addFile(flexeraave);
        }
    }

    private Flexeraaxf aa(ZipEntry zipEntry) throws IOException {
        try {
            this.ac.putNextEntry(zipEntry);
            this.ae += zipEntry.getSize();
            this.ac.closeEntry();
            return new Flexeraaxf(0L, 0L, true);
        }
        catch (ZipException zipException) {
            if (zipException.getMessage().indexOf("duplicate") != -1) {
                Flexeraauy.ai("duplicate entry (add directory): " + zipException.getMessage());
                return new Flexeraaxf(0L, 0L, true);
            }
            throw zipException;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public Vector getZipEntryNames() {
        return this.af;
    }

    private Flexeraaxf ab(InputStream inputStream, ZipEntry zipEntry, long l, long l2, boolean bl) throws ZipException, IOException {
        Flexeraaxf flexeraaxf;
        Flexeraaxf flexeraaxf2;
        boolean bl2;
        block18: {
            bl2 = false;
            flexeraaxf2 = null;
            this.ac.putNextEntry(zipEntry);
            if (zipEntry.isDirectory() || l == 0L && l2 == 0L) break block18;
            flexeraaxf2 = l2 == -1L ? this.ac(inputStream) : this.ad(inputStream, l, l2, bl);
            this.af.add(zipEntry.getName());
            Flexeraaxf flexeraaxf3 = flexeraaxf2;
            Object var13_11 = null;
            this.ac.flush();
            this.ac.closeEntry();
            if (!bl2) {
                if (zipEntry.getMethod() == 0 && zipEntry.getSize() != -1L) {
                    this.ae += zipEntry.getSize();
                    flexeraaxf2.ac(zipEntry.getSize());
                } else if (zipEntry.getMethod() == 8 && zipEntry.getCompressedSize() != -1L) {
                    this.ae += zipEntry.getCompressedSize();
                    flexeraaxf2.ac(zipEntry.getCompressedSize());
                }
            }
            return flexeraaxf3;
        }
        try {
            flexeraaxf = flexeraaxf2 = new Flexeraaxf(0L, 0L, true);
            Object var13_12 = null;
        }
        catch (ZipException zipException) {
            block19: {
                Flexeraaxf flexeraaxf4;
                try {
                    if (zipException.getMessage().indexOf("duplicate") == -1) break block19;
                    Flexeraauy.ai("duplicate entry (add file): " + zipException.getMessage());
                    flexeraaxf2 = new Flexeraaxf(0L, 0L, true);
                    if (this.ad) break block19;
                    bl2 = true;
                    flexeraaxf4 = flexeraaxf2;
                    Object var13_13 = null;
                }
                catch (Throwable throwable) {
                    block20: {
                        block21: {
                            Object var13_14 = null;
                            this.ac.flush();
                            this.ac.closeEntry();
                            if (bl2) break block20;
                            if (zipEntry.getMethod() != 0 || zipEntry.getSize() == -1L) break block21;
                            this.ae += zipEntry.getSize();
                            flexeraaxf2.ac(zipEntry.getSize());
                            break block20;
                        }
                        if (zipEntry.getMethod() != 8 || zipEntry.getCompressedSize() == -1L) break block20;
                        this.ae += zipEntry.getCompressedSize();
                        flexeraaxf2.ac(zipEntry.getCompressedSize());
                    }
                    throw throwable;
                }
                this.ac.flush();
                this.ac.closeEntry();
                if (!bl2) {
                    if (zipEntry.getMethod() == 0 && zipEntry.getSize() != -1L) {
                        this.ae += zipEntry.getSize();
                        flexeraaxf2.ac(zipEntry.getSize());
                    } else if (zipEntry.getMethod() == 8 && zipEntry.getCompressedSize() != -1L) {
                        this.ae += zipEntry.getCompressedSize();
                        flexeraaxf2.ac(zipEntry.getCompressedSize());
                    }
                }
                return flexeraaxf4;
            }
            throw zipException;
        }
        this.ac.flush();
        this.ac.closeEntry();
        if (!bl2) {
            if (zipEntry.getMethod() == 0 && zipEntry.getSize() != -1L) {
                this.ae += zipEntry.getSize();
                flexeraaxf2.ac(zipEntry.getSize());
            } else if (zipEntry.getMethod() == 8 && zipEntry.getCompressedSize() != -1L) {
                this.ae += zipEntry.getCompressedSize();
                flexeraaxf2.ac(zipEntry.getCompressedSize());
            }
        }
        return flexeraaxf;
    }

    private Flexeraaxf ac(InputStream inputStream) throws IOException {
        long l = 0L;
        int n = inputStream.read(aa);
        while (n != -1) {
            l += (long)n;
            this.ac.write(aa, 0, n);
            n = inputStream.read(aa);
        }
        return new Flexeraaxf(l, true);
    }

    private Flexeraaxf ad(InputStream inputStream, long l, long l2, boolean bl) throws IOException {
        int n = 0;
        int n2 = 0;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = l2 - l;
        Deflater deflater = new Deflater();
        this.ac.setLevel(9);
        deflater.setLevel(9);
        int n3 = (int)Math.min(l5, 131072L);
        long l6 = inputStream.skip(l);
        if (l6 != l) {
            System.err.println("Unable to move to requested start point in file");
            throw new IOException("Unable to skip " + l + " bytes into inputstream");
        }
        do {
            if ((n = inputStream.read(aa, 0, (int)Math.min(l5, (long)n3))) >= 0) {
                this.ac.write(aa, 0, n);
                this.ac.flush();
                if (bl) {
                    deflater.reset();
                    deflater.setInput(aa, 0, n);
                    deflater.finish();
                    n2 = deflater.deflate(aa);
                    l5 -= (long)n2;
                    l3 += (long)n;
                    l4 += (long)n2;
                    continue;
                }
                l5 -= (long)n;
                l3 += (long)n;
                l4 += (long)n;
                continue;
            }
            return new Flexeraaxf(l3, l4, true);
        } while (l5 > 0L);
        return new Flexeraaxf(l3, l4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addFile(File file, String string) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ZipEntry zipEntry = new ZipEntry(string);
            this.addInputStream(fileInputStream, zipEntry);
            Object var6_5 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }
}

