/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.bg;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_bg extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u2013 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u043e\u0441\u043a\u0432\u0430",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u042f\u043f\u043e\u043d\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "JST",
               "\u042f\u043f\u043e\u043d\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 - \u043b\u044f\u0442\u043d\u043e\u0442\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "JDT",
               "\u042f\u043f\u043e\u043d\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "JT",
            };
        final String[] Argentina = new String[] {
               "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430",
               "AST",
               "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "AST",
               "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430",
               "AT",
            };
        final String[] Hovd = new String[] {
               "\u0425\u043e\u0432\u0434",
               "HST",
               "\u0425\u043e\u0432\u0434 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "HST",
               "\u0425\u043e\u0432\u0434",
               "HT",
            };
        final String[] Magadan = new String[] {
               "\u041c\u0430\u0433\u0430\u0434\u0430\u043d",
               "MST",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u043d \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "MST",
               "\u041c\u0430\u0433\u0430\u0434\u0430\u043d",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACWST",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACWDT",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "CEST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "CEST",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0421\u0430\u0445\u0430\u043b\u0438\u043d",
               "SST",
               "\u0421\u0430\u0445\u0430\u043b\u0438\u043d \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "SST",
               "\u0421\u0430\u0445\u0430\u043b\u0438\u043d",
               "ST",
            };
        final String[] Macquarie = new String[] {
               "\u041c\u0430\u043a\u043a\u0443\u043e\u0440\u0438",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] America_Eastern = new String[] {
               "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0438\u0437\u0442\u043e\u0447\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "EST",
               "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0438\u0437\u0442\u043e\u0447\u043d\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "EDT",
               "\u0418\u0437\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0425\u0430\u0432\u0430\u0439\u0441\u043a\u043e \u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "HAST",
               "\u0425\u0430\u0432\u0430\u0439\u0441\u043a\u043e \u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e \u043b\u044f\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "HADT",
               "\u0425\u0430\u0432\u0430\u0439\u0441\u043a\u043e \u0430\u043b\u0435\u0443\u0442\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACST",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "ACDT",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CAT",
            };
        final String[] Lord_Howe = new String[] {
               "\u041b\u043e\u0440\u0434 \u0425\u0430\u0443 \u2013 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "LHST",
               "\u041b\u043e\u0440\u0434 \u0425\u0430\u0443 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "LHDT",
               "\u041b\u043e\u0440\u0434 \u0425\u0430\u0443",
               "LHT",
            };
        final String[] Yakutsk = new String[] {
               "\u042f\u043a\u0443\u0442\u0441\u043a",
               "YST",
               "\u042f\u043a\u0443\u0442\u0441\u043a \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "YST",
               "\u042f\u043a\u0443\u0442\u0441\u043a",
               "YT",
            };
        final String[] America_Pacific = new String[] {
               "\u0422\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "PST",
               "\u0422\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "PDT",
               "\u0422\u0438\u0445\u043e\u043e\u043a\u0435\u0430\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u043e \u043b\u044f\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WEST",
               "\u0417\u0430\u043f\u0430\u0434\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "WET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0418\u0437\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "EEST",
               "\u0418\u0437\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "EEST",
               "\u0418\u0437\u0442\u043e\u0447\u043d\u043e\u0435\u0432\u0440\u043e\u043f\u0435\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0427\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u041d\u044e\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434",
               "NST",
               "\u041b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u041d\u044e\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434",
               "NDT",
               "\u041d\u044e\u0444\u0430\u0443\u043d\u0434\u043b\u0435\u043d\u0434",
               "NT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430 \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430 \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAST",
               "\u0410\u0440\u0436\u0435\u043d\u0442\u0438\u043d\u0430 \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "AST",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "ADT",
               "\u0410\u0442\u043b\u0430\u043d\u0442\u0438\u0447\u0435\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "AT",
            };
        final String[] GMT = new String[] {
               "\u0427\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0413\u0440\u0438\u043d\u0443\u0438\u0447",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433",
               "YST",
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "YST",
               "\u0415\u043a\u0430\u0442\u0435\u0440\u0438\u043d\u0431\u0443\u0440\u0433",
               "YT",
            };
        final String[] Volgograd = new String[] {
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u043e\u043b\u0433\u043e\u0433\u0440\u0430\u0434",
               "VT",
            };
        final String[] Israel = new String[] {
               "\u0427\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0418\u0437\u0440\u0430\u0435\u043b",
               "IST",
               "\u041b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0418\u0437\u0440\u0430\u0435\u043b",
               "IDT",
               "\u0427\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0418\u0437\u0440\u0430\u0435\u043b",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u2013 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Omsk = new String[] {
               "\u041e\u043c\u0441\u043a",
               "OST",
               "\u041e\u043c\u0441\u043a \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "OST",
               "\u041e\u043c\u0441\u043a",
               "OT",
            };
        final String[] Australia_Western = new String[] {
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AWST",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "AWDT",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Mongolia = new String[] {
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0442\u043e\u0440",
               "UBST",
               "\u0423\u043b\u0430\u043d \u0411\u0430\u0442\u043e\u0440 \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "UBST",
               "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "CST",
               "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "CDT",
               "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "CT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "AEST",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "AEDT",
               "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EAT",
            };
        final String[] America_Mountain = new String[] {
               "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u043f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "MST",
               "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u043f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u0430 \u043b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "MDT",
               "\u041f\u043b\u0430\u043d\u0438\u043d\u0441\u043a\u043e \u0432\u0440\u0435\u043c\u0435",
               "MT",
            };
        final String[] Alaska = new String[] {
               "\u0427\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0410\u043b\u044f\u0441\u043a\u0430",
               "AKST",
               "\u041b\u044f\u0442\u043d\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0410\u043b\u044f\u0441\u043a\u0430",
               "AKDT",
               "\u0427\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430 \u0410\u043b\u044f\u0441\u043a\u0430",
               "AKT",
            };
        final String[] Novosibirsk = new String[] {
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a",
               "NST",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "NST",
               "\u041d\u043e\u0432\u043e\u0441\u0438\u0431\u0438\u0440\u0441\u043a",
               "NT",
            };
        final String[] Vladivostok = new String[] {
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a",
               "VST",
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "VST",
               "\u0412\u043b\u0430\u0434\u0438\u0432\u043e\u0441\u0442\u043e\u043a",
               "VT",
            };
        final String[] Irkutsk = new String[] {
               "\u0418\u0440\u043a\u0443\u0442\u0441\u043a",
               "IST",
               "\u0418\u0440\u043a\u0443\u0442\u0441\u043a \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "IST",
               "\u0418\u0440\u043a\u0443\u0442\u0441\u043a",
               "IT",
            };
        final String[] Noronha = new String[] {
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u043d\u044f",
               "FNST",
               "\u0424\u0435\u0440\u043d\u0430\u043d\u0434\u043e \u0434\u0435 \u041d\u043e\u0440\u043e\u043d\u044f \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "FNST",
               "\u041d\u043e\u0440\u043e\u043d\u044f",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d",
               "CST",
               "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "CST",
               "\u0427\u043e\u0439\u0431\u0430\u043b\u0441\u0430\u043d",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "BST",
               "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f",
               "BT",
            };
        final String[] China = new String[] {
               "\u041a\u0438\u0442\u0430\u0439\u0441\u043a\u0430 \u0447\u0430\u0441\u043e\u0432\u0430 \u0437\u043e\u043d\u0430",
               "CST",
               "China Daylight Time",
               "CDT",
               "China Time",
               "CT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a",
               "KST",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a \u2013 \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "KST",
               "\u041a\u0440\u0430\u0441\u043d\u043e\u044f\u0440\u0441\u043a",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WKT",
               "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "WKST",
               "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d \u2013 \u0437\u0430\u043f\u0430\u0434\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "WKT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EKT",
               "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u043b\u044f\u0442\u043d\u043e \u0447\u0430\u0441\u043e\u0432\u043e \u0432\u0440\u0435\u043c\u0435",
               "EKST",
               "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d \u2013 \u0438\u0437\u0442\u043e\u0447\u043d\u043e \u0432\u0440\u0435\u043c\u0435",
               "EKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Europe/Brussels", Europe_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Damascus", Europe_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Creston", America_Mountain },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "Australia/Perth", Australia_Western },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "America/Resolute", America_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Europe/Skopje", Europe_Central },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "Africa/Bamako", GMT },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Barbados", Atlantic },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Thule", Atlantic },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Asia/Sakhalin", Sakhalin },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Kamchatka", Magadan },
            { "America/Nome", Alaska },
            { "Africa/Sao_Tome", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Rainy_River", America_Central },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Belem", Brasilia },
            { "Africa/Ceuta", Europe_Central },
            { "America/Jujuy", Argentina },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "America/Pangnirtung", America_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Whitehorse", America_Pacific },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "America/Antigua", Atlantic },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Yakutat", Alaska },
            { "America/Argentina/Tucuman", Argentina },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "America/Merida", America_Central },
            { "America/Mazatlan", America_Mountain },
            { "Europe/Tirane", Europe_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "Africa/Monrovia", GMT },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Africa/Accra", GMT },
            { "Asia/Amman", Europe_Eastern },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
