/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.id;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_id extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "Waktu Afrika Tengah",
               "CAT",
               "Central Africa Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "Waktu Standar Moskow",
               "MST",
               "Waktu Musim Panas Moskow",
               "MST",
               "Waktu Moskow",
               "MT",
            };
        final String[] Hovd = new String[] {
               "Waktu Standar Hovd",
               "HST",
               "Waktu Musim Panas Hovd",
               "HST",
               "Waktu Hovd",
               "HT",
            };
        final String[] Magadan = new String[] {
               "Waktu Standar Magadan",
               "MST",
               "Waktu Musim Panas Magadan",
               "MST",
               "Waktu Magadan",
               "MT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waktu Standar Barat Tengah Australia",
               "ACWST",
               "Waktu Terang Barat Tengah Australia",
               "ACWDT",
               "Waktu Barat Tengah Australia",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "Waktu Standar Eropa Tengah",
               "CEST",
               "Waktu Musim Panas Eropa Tengah",
               "CEST",
               "Waktu Eropa Tengah",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "Waktu Standar Sakhalin",
               "SST",
               "Waktu Musim Panas Sakhalin",
               "SST",
               "Waktu Sakhalin",
               "ST",
            };
        final String[] America_Eastern = new String[] {
               "Waktu Baku Timur",
               "EST",
               "Waktu Terang Hari Timur",
               "EDT",
               "Waktu Timur",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "Waktu Standar Lord Howe",
               "LHST",
               "Waktu Terang Lord Howe",
               "LHDT",
               "Waktu Lord Howe",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "Waktu Standar Selandia Baru",
               "NZST",
               "Waktu Terang Selandia Baru",
               "NZDT",
               "Waktu Selandia Baru",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "Waktu Samudera Hindia",
               "IOT",
               "Indian Ocean Summer Time",
               "IOST",
               "Indian Ocean Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "Waktu Standar Yakutsk",
               "YST",
               "Waktu Musim Panas Yakutsk",
               "YST",
               "Waktu Yakutsk",
               "YT",
            };
        final String[] Mauritius = new String[] {
               "Waktu Standar Mauritius",
               "MST",
               "Waktu Musim Panas Mauritius",
               "MST",
               "Waktu Mauritius",
               "MT",
            };
        final String[] Africa_Eastern = new String[] {
               "Waktu Afrika Timur",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Kosrae = new String[] {
               "Waktu Kosrae",
               "KT",
               "Kosrae Summer Time",
               "KST",
               "Kosrae Time",
               "KT",
            };
        final String[] Marshall_Islands = new String[] {
               "Waktu Kep. Marshall",
               "MIT",
               "Marshall Islands Summer Time",
               "MIST",
               "Marshall Islands Time",
               "MIT",
            };
        final String[] Europe_Eastern = new String[] {
               "Waktu Standar Eropa Timur",
               "EEST",
               "Waktu Musim Panas Eropa Timur",
               "EEST",
               "Waktu Eropa Timur",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "Waktu Standar Newfoundland",
               "NST",
               "Waktu Siang Hari Newfoundland",
               "NDT",
               "Waktu Newfoundland",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "Waktu Afganistan",
               "AT",
               "Afghanistan Summer Time",
               "AST",
               "Afghanistan Time",
               "AT",
            };
        final String[] Argentina_Western = new String[] {
               "Waktu Standar Argentina Barat",
               "WAST",
               "Waktu Musim Panas Argentina Barat",
               "WAST",
               "Waktu Argentina Barat",
               "WAT",
            };
        final String[] Atlantic = new String[] {
               "Waktu Standar Atlantik",
               "AST",
               "Waktu Terang Atlantik",
               "ADT",
               "Waktu Atlantik",
               "AT",
            };
        final String[] Bolivia = new String[] {
               "Waktu Bolivia",
               "BT",
               "Bolivia Summer Time",
               "BST",
               "Bolivia Time",
               "BT",
            };
        final String[] Yekaterinburg = new String[] {
               "Waktu Standar Yekaterinburg",
               "YST",
               "Waktu Musim Panas Yekaterinburg",
               "YST",
               "Waktu Yekaterinburg",
               "YT",
            };
        final String[] Maldives = new String[] {
               "Waktu Maladewa",
               "MT",
               "Maldives Summer Time",
               "MST",
               "Maldives Time",
               "MT",
            };
        final String[] Indonesia_Central = new String[] {
               "Waktu Indonesia Tengah",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] Africa_Southern = new String[] {
               "Waktu Standar Afrika Selatan",
               "SAST",
               "South Africa Daylight Time",
               "SADT",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "Waktu Syowa",
               "ST",
               "Syowa Summer Time",
               "SST",
               "Syowa Time",
               "ST",
            };
        final String[] Line_Islands = new String[] {
               "Waktu Kep. Line",
               "LIT",
               "Line Islands Summer Time",
               "LIST",
               "Line Islands Time",
               "LIT",
            };
        final String[] Omsk = new String[] {
               "Waktu Standar Omsk",
               "OST",
               "Waktu Musim Panas Omsk",
               "OST",
               "Waktu Omsk",
               "OT",
            };
        final String[] Seychelles = new String[] {
               "Waktu Seychelles",
               "ST",
               "Seychelles Summer Time",
               "SST",
               "Seychelles Time",
               "ST",
            };
        final String[] Mongolia = new String[] {
               "Waktu Standar Ulan Bator",
               "UBST",
               "Waktu Musim Panas Ulan Bator",
               "UBST",
               "Waktu Ulan Bator",
               "UBT",
            };
        final String[] America_Central = new String[] {
               "Waktu Baku Tengah",
               "CST",
               "Waktu Terang Hari Tengah",
               "CDT",
               "Waktu Tengah",
               "CT",
            };
        final String[] Niue = new String[] {
               "Waktu Niue",
               "NT",
               "Niue Summer Time",
               "NST",
               "Niue Time",
               "NT",
            };
        final String[] Falkland = new String[] {
               "Waktu Standar Kep. Falkland",
               "FIST",
               "Waktu Musim Panas Kep. Falkland",
               "FIST",
               "Waktu Kep. Falkland",
               "FIT",
            };
        final String[] Novosibirsk = new String[] {
               "Waktu Standar Novosibirsk",
               "NST",
               "Waktu Musim Panas Novosibirsk",
               "NST",
               "Waktu Novosibirsk",
               "NT",
            };
        final String[] Azores = new String[] {
               "Waktu Standar Azores",
               "AST",
               "Waktu Musim Panas Azores",
               "AST",
               "Waktu Azores",
               "AT",
            };
        final String[] Bhutan = new String[] {
               "Waktu Bhutan",
               "BT",
               "Bhutan Summer Time",
               "BST",
               "Bhutan Time",
               "BT",
            };
        final String[] Nauru = new String[] {
               "Waktu Nauru",
               "NT",
               "Nauru Summer Time",
               "NST",
               "Nauru Time",
               "NT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waktu Standar Krasnoyarsk",
               "KST",
               "Waktu Musim Panas Krasnoyarsk",
               "KST",
               "Waktu Krasnoyarsk",
               "KT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waktu Kazakhstan Barat",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Christmas = new String[] {
               "Waktu Pulau Natal",
               "CIT",
               "Christmas Island Summer Time",
               "CIST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "Waktu Standar Amazon",
               "AST",
               "Waktu Musim Panas Amazon",
               "AST",
               "Waktu Amazon",
               "AT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Waktu Kazakhstan Timur",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Fiji = new String[] {
               "Waktu Standar Fiji",
               "FST",
               "Waktu Musim Panas Fiji",
               "FST",
               "Waktu Fiji",
               "FT",
            };
        final String[] Reunion = new String[] {
               "Waktu Reunion",
               "RT",
               "Reunion Summer Time",
               "RST",
               "Reunion Time",
               "RT",
            };
        final String[] Cocos = new String[] {
               "Waktu Kepulauan Cocos",
               "CIT",
               "Cocos Islands Summer Time",
               "CIST",
               "Cocos Islands Time",
               "CIT",
            };
        final String[] Chatham = new String[] {
               "Waktu Standar Chatham",
               "CST",
               "Waktu Terang Chatham",
               "CDT",
               "Waktu Chatham",
               "CT",
            };
        final String[] Vostok = new String[] {
               "Waktu Vostok",
               "VT",
               "Vostok Summer Time",
               "VST",
               "Vostok Time",
               "VT",
            };
        final String[] Argentina = new String[] {
               "Waktu Standar Argentina",
               "AST",
               "Waktu Musim Panas Argentina",
               "AST",
               "Waktu Argentina",
               "AT",
            };
        final String[] Gambier = new String[] {
               "Waktu Gambier",
               "GT",
               "Gambier Summer Time",
               "GST",
               "Gambier Time",
               "GT",
            };
        final String[] Galapagos = new String[] {
               "Waktu Galapagos",
               "GT",
               "Galapagos Summer Time",
               "GST",
               "Galapagos Time",
               "GT",
            };
        final String[] Macquarie = new String[] {
               "Waktu Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waktu Baku Hawaii-Aleutian",
               "HAST",
               "Waktu Terang Hawaii-Aleutian",
               "HADT",
               "Waktu Hawaii-Aleutian",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "Waktu Standar Tengah Australia",
               "ACST",
               "Waktu Terang Tengah Australia",
               "ACDT",
               "Waktu Tengah Australia",
               "CAT",
            };
        final String[] America_Pacific = new String[] {
               "Waktu Baku Pasifik",
               "PST",
               "Waktu Terang Hari Pasifik",
               "PDT",
               "Waktu Pasifik",
               "PT",
            };
        final String[] Europe_Western = new String[] {
               "Waktu Standar Eropa Barat",
               "WEST",
               "Waktu Musim Panas Eropa Barat",
               "WEST",
               "Waktu Eropa Barat",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "Waktu Standar Cape Verde",
               "CVST",
               "Waktu Musim Panas Cape Verde",
               "CVST",
               "Waktu Cape Verde",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "Waktu Kep. Norfolk",
               "NIT",
               "Norfolk Islands Summer Time",
               "NIST",
               "Norfolk Islands Time",
               "NIT",
            };
        final String[] Rothera = new String[] {
               "Waktu Rothera",
               "RT",
               "Rothera Summer Time",
               "RST",
               "Rothera Time",
               "RT",
            };
        final String[] Azerbaijan = new String[] {
               "Waktu Standar Azerbaijan",
               "AST",
               "Waktu Musim Panas Azerbaijan",
               "AST",
               "Waktu Azerbaijan",
               "AT",
            };
        final String[] Mawson = new String[] {
               "Waktu Mawson",
               "MT",
               "Mawson Summer Time",
               "MST",
               "Mawson Time",
               "MT",
            };
        final String[] Davis = new String[] {
               "Waktu Davis",
               "DT",
               "Davis Summer Time",
               "DST",
               "Davis Time",
               "DT",
            };
        final String[] Africa_Western = new String[] {
               "Waktu Standar Afrika Barat",
               "WAST",
               "Waktu Musim Panas Afrika Barat",
               "WAST",
               "Waktu Afrika Barat",
               "WAT",
            };
        final String[] GMT = new String[] {
               "Waktu Tengah Greenwich",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] French_Southern = new String[] {
               "Waktu Wilayah Selatan dan Antarktika Prancis",
               "FSAT",
               "French Southern and Antarctic Summer Time",
               "FSAST",
               "French Southern and Antarctic Time",
               "FSAT",
            };
        final String[] South_Georgia = new String[] {
               "Waktu Georgia Selatan",
               "SGT",
               "South Georgia Summer Time",
               "SGST",
               "South Georgia Time",
               "SGT",
            };
        final String[] New_Caledonia = new String[] {
               "Waktu Standar Kaledonia Baru",
               "NCST",
               "Waktu Musim Panas Kaledonia Baru",
               "NCST",
               "Waktu Kaledonia Baru",
               "NCT",
            };
        final String[] Volgograd = new String[] {
               "Waktu Standar Volgograd",
               "VST",
               "Waktu Musim Panas Volgograd",
               "VST",
               "Waktu Volgograd",
               "VT",
            };
        final String[] Brunei = new String[] {
               "Waktu Brunei Darussalam",
               "BDT",
               "Brunei Darussalam Summer Time",
               "BDST",
               "Brunei Darussalam Time",
               "BDT",
            };
        final String[] Easter = new String[] {
               "Waktu Standar Pulau Paskah",
               "EIST",
               "Waktu Musim Panas Pulau Paskah",
               "EIST",
               "Waktu Pulau Paskah",
               "EIT",
            };
        final String[] DumontDUrville = new String[] {
               "Waktu Dumont-d'Urville",
               "DT",
               "Dumont-d\u2019Urville Summer Time",
               "DST",
               "Dumont-d\u2019Urville Time",
               "DT",
            };
        final String[] Bangladesh = new String[] {
               "Waktu Standar Bangladesh",
               "BST",
               "Waktu Musim Panas Bangladesh",
               "BST",
               "Waktu Bangladesh",
               "BT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waktu Indonesia Timur",
               "WIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Australia_Western = new String[] {
               "Waktu Standar Barat Australia",
               "AWST",
               "Waktu Terang Barat Australia",
               "AWDT",
               "Waktu Australia Barat",
               "WAT",
            };
        final String[] Indonesia_Western = new String[] {
               "Waktu Indonesia Barat",
               "WIB",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Waktu Standar Timur Australia",
               "AEST",
               "Waktu Terang Timur Australia",
               "AEDT",
               "Waktu Timur Australia",
               "EAT",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waktu Kep. Gilbert",
               "GIT",
               "Gilbert Islands Summer Time",
               "GIST",
               "Gilbert Islands Time",
               "GIT",
            };
        final String[] America_Mountain = new String[] {
               "Waktu Baku Pegunungan",
               "MST",
               "Waktu Terang Hari Pegunungan",
               "MDT",
               "Waktu Pegunungan",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "Waktu Marquesas",
               "MT",
               "Marquesas Summer Time",
               "MST",
               "Marquesas Time",
               "MT",
            };
        final String[] Arabian = new String[] {
               "Waktu Standar Arab",
               "AST",
               "Waktu Terang Arab",
               "ADT",
               "Waktu Arab",
               "AT",
            };
        final String[] Alaska = new String[] {
               "Waktu Standar Alaska",
               "AKST",
               "Waktu Terang Alaska",
               "AKDT",
               "Waktu Alaska",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "Waktu Standar Vladivostok",
               "VST",
               "Waktu Musim Panas Vladivostok",
               "VST",
               "Waktu Vladivostok",
               "VT",
            };
        final String[] Chamorro = new String[] {
               "Waktu Chamorro",
               "CST",
               "Chamorro Daylight Time",
               "CDT",
               "Chamorro Time",
               "CT",
            };
        final String[] Irkutsk = new String[] {
               "Waktu Standar Irkutsk",
               "IST",
               "Waktu Musim Panas Irkutsk",
               "IST",
               "Waktu Irkutsk",
               "IT",
            };
        final String[] Noronha = new String[] {
               "Waktu Standar Fernando de Noronha",
               "FNST",
               "Waktu Musim Panas Fernando de Noronha",
               "FNST",
               "Waktu Fernando de Noronha",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "Waktu Standar Choibalsan",
               "CST",
               "Waktu Musim Panas Choibalsan",
               "CST",
               "Waktu Choibalsan",
               "CT",
            };
        final String[] Brasilia = new String[] {
               "Waktu Standar Brasilia",
               "BST",
               "Waktu Musim Panas Brasilia",
               "BST",
               "Waktu Brasilia",
               "BT",
            };
        final String[] China = new String[] {
               "Waktu Standar China",
               "CST",
               "Waktu Terang China",
               "CDT",
               "Waktu China",
               "CT",
            };
        final String[] Armenia = new String[] {
               "Waktu Standar Armenia",
               "AST",
               "Waktu Musim Panas Armenia",
               "AST",
               "Waktu Armenia",
               "AT",
            };
        final String[] Cook = new String[] {
               "Waktu Standar Kep. Cook",
               "CIST",
               "Waktu Tengah Musim Panas Kep. Cook",
               "CIHST",
               "Waktu Kep. Cook",
               "CIT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London", GMT },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Asia/Kashgar", China },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Amazon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", GMT },
            { "Africa/Windhoek", Africa_Western },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Africa/Asmera", Africa_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Africa/Bamako", GMT },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Djibouti", Africa_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Europe/Samara", Moscow },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "America/Mazatlan", America_Mountain },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin", GMT },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Africa/Lome", GMT },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", America_Mountain },
            { "America/Cancun", America_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", America_Pacific },
            { "America/Cambridge_Bay", America_Mountain },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Asia/Urumqi", China },
            { "Europe/Volgograd", Volgograd },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Kamchatka", Magadan },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "America/Montreal", America_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Thimphu", Bhutan },
            { "Europe/Bratislava", Europe_Central },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
